/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject.agent;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Action
extends AbstractSchema {
    public static final Integer PASS = 0;
    public static final Integer DROP = 1;
    public static final Integer ASK = 2;
    public static final Integer DENY = 3;
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private Boolean alert;
    private Boolean logEvent;
    private Boolean logRawTraffic;
    private Integer packetProcess;
    private Boolean enableConfirmOnceButton;
    private Boolean notification;
    private Boolean enableNotificationOnceButton;

    public Action() {
        this.nameSpace = "agent";
    }

    @Override
    public String getObjectTypeName() {
        return "Action";
    }

    public Boolean getDefEnable() {
        return Boolean.TRUE;
    }

    public Boolean getOptEnable() {
        return this.enable;
    }

    public void setOptEnable(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enable = value;
    }

    public Boolean getDefAlert() {
        return Boolean.FALSE;
    }

    public Boolean getOptAlert() {
        return this.alert;
    }

    public void setOptAlert(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.alert = value;
    }

    public Boolean getDefLogEvent() {
        return Boolean.FALSE;
    }

    public Boolean getOptLogEvent() {
        return this.logEvent;
    }

    public void setOptLogEvent(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.logEvent = value;
    }

    public Boolean getDefLogRawTraffic() {
        return Boolean.FALSE;
    }

    public Boolean getOptLogRawTraffic() {
        return this.logRawTraffic;
    }

    public void setOptLogRawTraffic(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.logRawTraffic = value;
    }

    public Integer getOptPacketProcess() {
        return this.packetProcess;
    }

    public String getOptPacketProcessValue() throws ValidationException {
        if (this.packetProcess == null) {
            return null;
        }
        String s = null;
        switch (this.packetProcess) {
            case 0: {
                s = "PASS";
                break;
            }
            case 1: {
                s = "DROP";
                break;
            }
            case 2: {
                s = "ASK";
                break;
            }
            case 3: {
                s = "DENY";
                break;
            }
            default: {
                throw new ValidationException("Action/PacketProcess: invalid attribute value:" + this.packetProcess + "!");
            }
        }
        return s;
    }

    public void setOptPacketProcess(Integer value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.packetProcess = value;
    }

    public void setOptPacketProcessValue(String value) throws ValidationException {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        if (value == null) {
            this.packetProcess = null;
            return;
        }
        if ("PASS".equals(value)) {
            this.packetProcess = PASS;
        } else if ("DROP".equals(value)) {
            this.packetProcess = DROP;
        } else if ("ASK".equals(value)) {
            this.packetProcess = ASK;
        } else if ("DENY".equals(value)) {
            this.packetProcess = DENY;
        } else {
            throw new ValidationException("Action/PacketProcess: invalid attribute value:" + value + "!");
        }
    }

    public Boolean getDefEnableConfirmOnceButton() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnableConfirmOnceButton() {
        return this.enableConfirmOnceButton;
    }

    public void setOptEnableConfirmOnceButton(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enableConfirmOnceButton = value;
    }

    public Boolean getDefNotification() {
        return Boolean.FALSE;
    }

    public Boolean getOptNotification() {
        return this.notification;
    }

    public void setOptNotification(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.notification = value;
    }

    public Boolean getDefEnableNotificationOnceButton() {
        return Boolean.FALSE;
    }

    public Boolean getOptEnableNotificationOnceButton() {
        return this.enableNotificationOnceButton;
    }

    public void setOptEnableNotificationOnceButton(Boolean value) {
        if (this.isReadonly()) {
            throw new Error("The schema object is got by readonly, can't be changed!");
        }
        this.enableNotificationOnceButton = value;
    }

    @Override
    public int getObjectType() {
        return 328074;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
    }

    @Override
    public void putTextContent(String tContent) throws SAXException {
    }

    @Override
    public void initByAttributes(Attributes attris) throws SAXException {
        try {
            String value = attris.getValue("Enable");
            if (value != null) {
                this.enable = "1".equals(value);
            }
            if ((value = attris.getValue("Alert")) != null) {
                this.alert = "1".equals(value);
            }
            if ((value = attris.getValue("LogEvent")) != null) {
                this.logEvent = "1".equals(value);
            }
            if ((value = attris.getValue("LogRawTraffic")) != null) {
                this.logRawTraffic = "1".equals(value);
            }
            if ((value = attris.getValue("PacketProcess")) != null) {
                this.setOptPacketProcessValue(value);
            }
            if ((value = attris.getValue("EnableConfirmOnceButton")) != null) {
                this.enableConfirmOnceButton = "1".equals(value);
            }
            if ((value = attris.getValue("Notification")) != null) {
                this.notification = "1".equals(value);
            }
            if ((value = attris.getValue("EnableNotificationOnceButton")) != null) {
                this.enableNotificationOnceButton = "1".equals(value);
            }
        }
        catch (RuntimeException e) {
            throw new SAXException(e);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"Action".equals(element.getNodeName())) {
            throw new ValidationException("Action: can't import element(" + element.getNodeName() + ")!");
        }
        String value = XMLHelper.getAttribute(element, "Enable");
        if (value != null) {
            this.enable = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Alert")) != null) {
            this.alert = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LogEvent")) != null) {
            this.logEvent = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "LogRawTraffic")) != null) {
            this.logRawTraffic = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "PacketProcess")) != null) {
            this.setOptPacketProcessValue(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnableConfirmOnceButton")) != null) {
            this.enableConfirmOnceButton = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "Notification")) != null) {
            this.notification = "1".equals(value);
        }
        if ((value = XMLHelper.getAttribute(element, "EnableNotificationOnceButton")) != null) {
            this.enableNotificationOnceButton = "1".equals(value);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        this.validate();
        Element element = doc.createElement("Action");
        if (this.enable != null) {
            element.setAttribute("Enable", this.enable != false ? "1" : "0");
        }
        if (this.alert != null) {
            element.setAttribute("Alert", this.alert != false ? "1" : "0");
        }
        if (this.logEvent != null) {
            element.setAttribute("LogEvent", this.logEvent != false ? "1" : "0");
        }
        if (this.logRawTraffic != null) {
            element.setAttribute("LogRawTraffic", this.logRawTraffic != false ? "1" : "0");
        }
        if (this.packetProcess != null) {
            element.setAttribute("PacketProcess", this.getOptPacketProcessValue());
        }
        if (this.enableConfirmOnceButton != null) {
            element.setAttribute("EnableConfirmOnceButton", this.enableConfirmOnceButton != false ? "1" : "0");
        }
        if (this.notification != null) {
            element.setAttribute("Notification", this.notification != false ? "1" : "0");
        }
        if (this.enableNotificationOnceButton != null) {
            element.setAttribute("EnableNotificationOnceButton", this.enableNotificationOnceButton != false ? "1" : "0");
        }
        Vector<AbstractSchema> v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            Transportable t = v.get(i);
            element.appendChild(t.exportToElement(doc));
        }
        return element;
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            this.validate();
            StringBuffer strAttrs = new StringBuffer("<Action ");
            if (this.enable != null) {
                strAttrs.append("Enable=").append(this.enable != false ? "\"1\" " : "\"0\" ");
            }
            if (this.alert != null) {
                strAttrs.append("Alert=").append(this.alert != false ? "\"1\" " : "\"0\" ");
            }
            if (this.logEvent != null) {
                strAttrs.append("LogEvent=").append(this.logEvent != false ? "\"1\" " : "\"0\" ");
            }
            if (this.logRawTraffic != null) {
                strAttrs.append("LogRawTraffic=").append(this.logRawTraffic != false ? "\"1\" " : "\"0\" ");
            }
            if (this.packetProcess != null) {
                strAttrs.append("PacketProcess=\"").append(this.getOptPacketProcessValue()).append("\" ");
            }
            if (this.enableConfirmOnceButton != null) {
                strAttrs.append("EnableConfirmOnceButton=").append(this.enableConfirmOnceButton != false ? "\"1\" " : "\"0\" ");
            }
            if (this.notification != null) {
                strAttrs.append("Notification=").append(this.notification != false ? "\"1\" " : "\"0\" ");
            }
            if (this.enableNotificationOnceButton != null) {
                strAttrs.append("EnableNotificationOnceButton=").append(this.enableNotificationOnceButton != false ? "\"1\" " : "\"0\" ");
            }
            if (this.nameSpace != null && this.nameSpace.trim().length() > 0) {
                strAttrs.append("NameSpace=\"").append(this.nameSpace).append("\" ");
            }
            os_for_xml_generating.write(strAttrs.toString().trim().getBytes("UTF-8"));
            boolean closed = false;
            Vector<AbstractSchema> v = this.getChildren();
            int cNum = v.size();
            if (cNum > 0) {
                os_for_xml_generating.write(62);
                closed = true;
                for (int i = 0; i < v.size(); ++i) {
                    Transportable t = v.get(i);
                    t.doSerialize(os_for_xml_generating);
                }
            }
            if (!closed) {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("</Action>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

