/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.SchemaContentHandler;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLHelper {
    private static final int POOL_SIZE = 20;
    private static final SAXParserPool SAXPOOL = SAXParserPool.getIntance();
    private static final DOMParserPool DOMPOOL = DOMParserPool.getIntance();
    private static final String XGE_FEATURE = "http://xml.org/sax/features/external-general-entities";
    private static final String DISALLOW_DOC_TYPE_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";

    public static Document newDocument() {
        DocumentBuilder db = null;
        Document ret = null;
        try {
            db = DOMPOOL.newDocumentBuilder();
            if (db != null) {
                ret = db.newDocument();
                DOMPOOL.recycleDOMParser(db);
            }
        }
        catch (ParserConfigurationException e) {
            LoggerUtilities.logException(e);
        }
        return ret;
    }

    public static Document parse(InputStream is) throws IOException, SAXException {
        return XMLHelper.parse(is, null);
    }

    public static Document parse(InputStream is, String encoding) throws IOException, SAXException {
        DocumentBuilder db = null;
        Document ret = null;
        try {
            db = DOMPOOL.newDocumentBuilder();
            if (db != null) {
                ret = StringUtilities.isEmpty(encoding) ? db.parse(is) : db.parse(new InputSource(new BufferedReader(new InputStreamReader(is, encoding))));
                DOMPOOL.recycleDOMParser(db);
            }
        }
        catch (ParserConfigurationException e) {
            LoggerUtilities.logException(e);
        }
        return ret;
    }

    public static Document parse(String xmlString) throws IOException, SAXException {
        return XMLHelper.parse(new ByteArrayInputStream(xmlString.getBytes("UTF-8")));
    }

    public static AbstractSchema parseSAX(InputStream is) throws SAXException, IOException, ValidationException {
        return XMLHelper.parseSAX(is, false);
    }

    public static AbstractSchema parseSAX(InputStream is, boolean isReadonly) throws SAXException, IOException, ValidationException {
        SAXParser sp = null;
        try {
            sp = SAXPOOL.getSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        AbstractSchema returnValue = null;
        if (sp != null) {
            SchemaContentHandler contentHandler = new SchemaContentHandler();
            try {
                sp.parse(is, (DefaultHandler)contentHandler);
                sp.reset();
            }
            catch (SAXException sax) {
                throw new ValidationException(sax.getMessage());
            }
            returnValue = contentHandler.getAbstractSchema().getSchema();
            if (returnValue != null && isReadonly) {
                returnValue.setReadonly();
            }
        }
        return returnValue;
    }

    public static String getXmlDataFromDocument(Document document) {
        String xmlString = null;
        try {
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            XMLHelper.transformDocumentToXML(document, result);
            xmlString = writer.toString();
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return xmlString;
    }

    public static Transformer transformDocumentToXML(Document document, Result result) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(document);
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer xformer = factory.newTransformer();
        xformer.setOutputProperty("indent", "yes");
        xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        xformer.transform(source, result);
        return xformer;
    }

    public static byte[] getXmlBytesDataFromDocument(Document document) throws IOException, SAXException {
        byte[] xmlBytes = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            XMLHelper.transformDocumentToXML(document, result);
            xmlBytes = out.toByteArray();
        }
        catch (TransformerException e) {
            LoggerUtilities.logException(e);
        }
        return xmlBytes;
    }

    public static ArrayList<Element> getChildElementByName(Element e, String name) {
        NodeList nl = e.getChildNodes();
        ArrayList<Element> v = new ArrayList<Element>();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !name.equals(node.getNodeName())) continue;
            v.add((Element)node);
        }
        return v;
    }

    public static Element getFirstChildElement(Element e) {
        Element child = null;
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            child = (Element)node;
            break;
        }
        return child;
    }

    public static Element getFirstChildElement(Element e, String nodeName) {
        Element child = null;
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase(nodeName)) continue;
            child = (Element)node;
            break;
        }
        return child;
    }

    public static Element getNextMatchingSibling(Node e, String nodeName) {
        Element match = null;
        if (e != null) {
            Node node = e.getNextSibling();
            match = node != null && node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase(nodeName) ? (Element)node : XMLHelper.getNextMatchingSibling(node, nodeName);
        }
        return match;
    }

    public static Node getTextNode(Element e) {
        Node textNode = null;
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 3) continue;
            textNode = node;
            break;
        }
        return textNode;
    }

    public static String getCDATASection(Element e) {
        Object cdataString = null;
        Object str = null;
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 4) continue;
            str = str == null ? ((CDATASection)node).getData() : (String)str + ((CDATASection)node).getData();
            if (i < nl.getLength() - 1 && nl.item(i + 1).getNodeType() == 4) continue;
            cdataString = str;
            break;
        }
        return cdataString;
    }

    public static String getAttribute(Element e, String name) {
        String attributeString = null;
        NamedNodeMap nodeMap = e.getAttributes();
        Node node = nodeMap.getNamedItem(name);
        if (node != null) {
            attributeString = node.getNodeValue();
        }
        return attributeString;
    }

    public static void serialize(Document doc, OutputStream os) throws IOException {
        XMLHelper.serialize(doc, os, false);
    }

    public static void serialize(Document doc, OutputStream os, boolean omitXmlDeclaration) throws IOException {
        try {
            StreamResult result = new StreamResult(os);
            Transformer xformer = XMLHelper.transformDocumentToXML(doc, result);
            xformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (TransformerException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static void serialize(OutputStream os, AbstractSchema schemaObject, boolean omitXmlDeclaration) throws IOException, ValidationException {
        if (!omitXmlDeclaration) {
            os.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes("UTF-8"));
        }
        schemaObject.doSerialize(os);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Element cloneElement(Document doc, Element src) {
        Element e = doc.createElement(src.getNodeName());
        NamedNodeMap nodeMap = src.getAttributes();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            Node attr = nodeMap.item(i);
            e.setAttribute(attr.getNodeName(), attr.getNodeValue());
        }
        NodeList nl = src.getChildNodes();
        Object cdata = "";
        int i = 0;
        while (true) {
            block10: {
                void var8_9;
                if (i >= nl.getLength()) {
                    return e;
                }
                Node node = nl.item(i);
                Object var8_10 = null;
                switch (node.getNodeType()) {
                    case 4: {
                        cdata = (String)cdata + ((CDATASection)node).getData();
                        if (i >= nl.getLength() - 1 || nl.item(i + 1).getNodeType() != 4) {
                            CDATASection cDATASection = doc.createCDATASection((String)cdata);
                            cdata = "";
                            break;
                        }
                        break block10;
                    }
                    case 8: {
                        Comment comment = doc.createComment(node.getNodeValue());
                        break;
                    }
                    case 3: {
                        Text text = doc.createTextNode(node.getNodeValue());
                        break;
                    }
                    case 1: {
                        Element element = XMLHelper.cloneElement(doc, (Element)node);
                    }
                }
                e.appendChild((Node)var8_9);
            }
            ++i;
        }
    }

    public static String normalizeChars(String src) {
        String normalizedString = null;
        if (src != null) {
            char[] chars = src.toCharArray();
            boolean changed = false;
            for (int i = 0; i < chars.length; ++i) {
                if (StringUtilities.isXMLCharValid(chars[i])) continue;
                chars[i] = 32;
                changed = true;
            }
            normalizedString = changed ? new String(chars) : src;
        }
        return normalizedString;
    }

    public static void trimXML(String xml) throws SAXException, IOException {
        if (!StringUtilities.isEmpty(xml)) {
            Document document = XMLHelper.parse(new ByteArrayInputStream(xml.trim().getBytes("UTF-8")));
            XMLHelper.trimWhiteSpace(document.getDocumentElement());
        }
    }

    private static void trimWhiteSpace(Node node) {
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                child.setTextContent(child.getTextContent().trim());
            }
            XMLHelper.trimWhiteSpace(child);
        }
    }

    private static class SAXParserPool {
        private static SAXParserPool instance = new SAXParserPool();
        private final Queue<ResetableSAXParser> pool = new ConcurrentLinkedQueue<ResetableSAXParser>();
        protected SAXParserFactory spf = SAXParserFactory.newInstance();
        private int curSize = 0;

        private SAXParserPool() {
            try {
                this.spf.setFeature(XMLHelper.XGE_FEATURE, false);
                this.spf.setFeature(XMLHelper.DISALLOW_DOC_TYPE_FEATURE, true);
            }
            catch (SAXNotRecognizedException e) {
                LoggerUtilities.logException(e);
            }
            catch (SAXNotSupportedException e) {
                LoggerUtilities.logException(e);
            }
            catch (ParserConfigurationException e) {
                LoggerUtilities.logException(e);
            }
        }

        public static SAXParserPool getIntance() {
            return instance;
        }

        public synchronized SAXParser getSAXParser() throws ParserConfigurationException, SAXException {
            ResetableSAXParser ps = null;
            if (this.curSize <= 0) {
                ps = new ResetableSAXParser(this.spf.newSAXParser(), instance);
            } else {
                --this.curSize;
                ps = this.pool.poll();
            }
            return ps;
        }

        public synchronized void recycleSAXParser(ResetableSAXParser parser) {
            if (this.curSize < 20) {
                this.pool.offer(parser);
                ++this.curSize;
            }
        }
    }

    private static class ResetableSAXParser
    extends SAXParser {
        private static boolean isResetSupport = true;
        SAXParserPool owner;
        SAXParser parserProxy;

        public ResetableSAXParser(SAXParser p, SAXParserPool owner) {
            this.parserProxy = p;
            this.owner = owner;
        }

        @Override
        public void reset() {
            if (isResetSupport) {
                try {
                    this.parserProxy.reset();
                    this.owner.recycleSAXParser(this);
                }
                catch (UnsupportedOperationException uoe) {
                    isResetSupport = false;
                }
            }
        }

        @Override
        public Parser getParser() throws SAXException {
            return this.parserProxy.getParser();
        }

        @Override
        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return this.parserProxy.getProperty(name);
        }

        @Override
        public XMLReader getXMLReader() throws SAXException {
            return this.parserProxy.getXMLReader();
        }

        @Override
        public boolean isNamespaceAware() {
            return this.parserProxy.isNamespaceAware();
        }

        @Override
        public boolean isValidating() {
            return this.parserProxy.isValidating();
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
            this.parserProxy.setProperty(name, value);
        }
    }

    private static class DOMParserPool {
        private static DOMParserPool instance = new DOMParserPool();
        private static boolean isResetSupported = true;
        private final Queue<DocumentBuilder> pool = new ConcurrentLinkedQueue<DocumentBuilder>();
        protected DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        private int curSize = 0;

        private DOMParserPool() {
            try {
                this.fac.setFeature(XMLHelper.XGE_FEATURE, false);
                this.fac.setFeature(XMLHelper.DISALLOW_DOC_TYPE_FEATURE, true);
            }
            catch (ParserConfigurationException e) {
                LoggerUtilities.logException(e);
            }
        }

        public static DOMParserPool getIntance() {
            return instance;
        }

        public synchronized DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
            DocumentBuilder ps = null;
            if (this.curSize <= 0) {
                ps = this.fac.newDocumentBuilder();
            } else {
                --this.curSize;
                ps = this.pool.poll();
            }
            return ps;
        }

        public synchronized void recycleDOMParser(DocumentBuilder parser) {
            if (isResetSupported && parser != null) {
                try {
                    parser.reset();
                }
                catch (UnsupportedOperationException e) {
                    isResetSupported = false;
                }
                if (this.curSize < 20) {
                    this.pool.offer(parser);
                    ++this.curSize;
                }
            }
        }
    }
}

