/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.hi.library.HiObjectManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SafeSimpleDateFormat;
import com.sygate.scm.util.SymantecMessageDigest;
import com.sygate.scm.util.Utility;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class Util {
    private static final SafeSimpleDateFormat timeStampSsdf = new SafeSimpleDateFormat("MM/dd/yyyy HH:mm:ss SSS", "GMT");

    public static String formatTimeStamp(long timeStamp) {
        Date date = new Date(timeStamp);
        return ((SimpleDateFormat)timeStampSsdf.get()).format(date);
    }

    public static long getLastestT(ConfigObject cObj) {
        return Util.getLastestT(cObj, -1L);
    }

    public static long getLastestT(ConfigObject cObj, long thisT) {
        long newT = cObj.getT();
        if (thisT > newT) {
            newT = thisT;
        }
        if (cObj instanceof UnknownContent) {
            UnknownContent unknown = (UnknownContent)cObj;
            try {
                ConfigObject subObj = (ConfigObject)AbstractSchema.readXML(unknown.getContent());
                newT = Util.getLastestT(subObj, newT);
            }
            catch (SAXException e) {
                LoggerUtilities.logException(e);
            }
            catch (IOException e) {
                LoggerUtilities.logException(e);
            }
            catch (ValidationException e) {
                LoggerUtilities.logException(e);
            }
        } else {
            for (AbstractSchema o : cObj.getChildren()) {
                ConfigObject newObj = (ConfigObject)o;
                newT = Util.getLastestT(newObj, newT);
            }
        }
        return newT;
    }

    public static Object[] getLastestTDebug(ConfigObject cObj, long thisT, String thisTagName) {
        Object[] ret = new Object[2];
        long newT = cObj.getT();
        String newTagName = cObj.getObjectTypeName();
        if (thisT > newT) {
            newT = thisT;
            newTagName = thisTagName;
        }
        ret[0] = newT;
        ret[1] = newTagName;
        if (cObj instanceof UnknownContent) {
            UnknownContent unknown = (UnknownContent)cObj;
            try {
                ConfigObject subObj = (ConfigObject)AbstractSchema.readXML(unknown.getContent());
                ret = Util.getLastestTDebug(subObj, newT, newTagName);
            }
            catch (SAXException e) {
                LoggerUtilities.logException(e);
            }
            catch (IOException e) {
                LoggerUtilities.logException(e);
            }
            catch (ValidationException e) {
                LoggerUtilities.logException(e);
            }
        } else {
            for (AbstractSchema o : cObj.getChildren()) {
                ConfigObject newObj = (ConfigObject)o;
                ret = Util.getLastestTDebug(newObj, newT, newTagName);
            }
        }
        return ret;
    }

    public static String getChecksum(List<?> configObjList) {
        try {
            MessageDigest md = SymantecMessageDigest.getInstance();
            for (Object o : configObjList) {
                ConfigObject cObj = (ConfigObject)o;
                md.update(cObj.getBytes());
            }
            byte[] checksum = md.digest();
            return Utility.toHexString(checksum);
        }
        catch (ValidationException | IOException | NoSuchAlgorithmException | NoSuchProviderException e) {
            LoggerUtilities.logException(e);
            return null;
        }
    }

    public static String getObjReferenceNameOfHITemplate(String platform) {
        String refName = "DownloadedHiReqTemplateLibrary";
        if (platform.equalsIgnoreCase("Mac")) {
            refName = "DownloadedHiReqTemplateLibrary_Mac";
        }
        return refName;
    }

    static {
        AbstractSchema.registerObjectManager("hi", new HiObjectManager());
    }
}

