/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.AdminContext;
import com.sygate.scm.common.configobject.schema.CompanyInformation;
import com.sygate.scm.common.configobject.schema.Database;
import com.sygate.scm.common.configobject.schema.DatabaseArray;
import com.sygate.scm.common.configobject.schema.DirectoryServer;
import com.sygate.scm.common.configobject.schema.DirectoryServerIntegration;
import com.sygate.scm.common.configobject.schema.EnforcerGroup;
import com.sygate.scm.common.configobject.schema.EnforcerGroupTree;
import com.sygate.scm.common.configobject.schema.LuDownloadedContent;
import com.sygate.scm.common.configobject.schema.LuDownloadedContentArray;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SemDomainArray;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SemSiteArray;
import com.sygate.scm.common.configobject.schema.ServerArray;
import com.sygate.scm.common.configobject.schema.SysAdministratorArray;
import com.sygate.scm.util.CollectionUtils;
import com.sygate.scm.util.StringUtilities;
import java.util.ArrayList;
import java.util.List;

public class SchemaHelper {
    private SchemaHelper() {
    }

    public static SemAdministrator getSystemAdminById(SysAdministratorArray sysAdminArray, String guid) {
        if (sysAdminArray == null || StringUtilities.isEmpty(guid)) {
            throw new IllegalArgumentException("The parameters cannot be null!");
        }
        for (int i = 0; i < sysAdminArray.getSemAdministratorCount(); ++i) {
            SemAdministrator admin = sysAdminArray.getSemAdministrator(i);
            if (!guid.equals(admin.getId())) continue;
            return admin;
        }
        return null;
    }

    public static SemAdministrator getSystemAdmin(SysAdministratorArray rootAdminArray, String name) {
        return SchemaHelper.getSystemAdmin(rootAdminArray, name, true);
    }

    public static SemAdministrator getSystemAdmin(SysAdministratorArray rootAdminArray, String name, boolean ignoreCase) {
        if (rootAdminArray == null || StringUtilities.isEmpty(name)) {
            throw new IllegalArgumentException("The parameters cannot be null!");
        }
        for (int index = 0; index < rootAdminArray.getSemAdministratorCount(); ++index) {
            boolean matchResult;
            SemAdministrator admin = rootAdminArray.getSemAdministrator(index);
            boolean bl = matchResult = ignoreCase ? admin.getName().equalsIgnoreCase(name) : admin.getName().equals(name);
            if (!matchResult) continue;
            return admin;
        }
        return null;
    }

    public static SemAdministrator getDomainLimitedAdmin(List<AdminContext> adminContexts, String adminName) {
        return SchemaHelper.getDomainLimitedAdmin(adminContexts, adminName, true);
    }

    public static SemAdministrator getDomainLimitedAdmin(List<AdminContext> adminContexts, String adminName, boolean ignoreCase) {
        AdminContext context = SchemaHelper.getAdminContext(adminContexts, adminName, ignoreCase);
        return context == null ? null : context.getSemAdministrator();
    }

    public static SemAdministrator getDomainLimitedAdminById(List<AdminContext> adminContexts, String targetAdminId) {
        AdminContext context = SchemaHelper.getAdminContextById(adminContexts, targetAdminId);
        return context == null ? null : context.getSemAdministrator();
    }

    public static String getCompanyName(SemConfigRoot root) {
        if (root == null) {
            throw new IllegalArgumentException("The parameters cannot be null!");
        }
        String companyName = null;
        CompanyInformation info = root.getOptCompanyInformation();
        if (info != null) {
            companyName = info.getOptCompanyName();
        }
        return companyName == null ? "" : companyName.trim();
    }

    public static List<SemAdministrator> getAllSysAdmin(SysAdministratorArray adminArray) {
        ArrayList<SemAdministrator> result = new ArrayList<SemAdministrator>();
        if (adminArray != null) {
            for (int i = 0; i < adminArray.getSemAdministratorCount(); ++i) {
                if (adminArray.getSemAdministrator(i) == null) continue;
                result.add(adminArray.getSemAdministrator(i));
            }
        }
        return result;
    }

    public static List<SemAdministrator> getAllSysAdmin(SysAdministratorArray adminArray, String name) {
        ArrayList<SemAdministrator> result = new ArrayList<SemAdministrator>();
        if (adminArray != null && !StringUtilities.isEmpty(name)) {
            for (int i = 0; i < adminArray.getSemAdministratorCount(); ++i) {
                if (adminArray.getSemAdministrator(i) == null || !adminArray.getSemAdministrator(i).getName().equalsIgnoreCase(name)) continue;
                result.add(adminArray.getSemAdministrator(i));
            }
        }
        return result;
    }

    public static List<String> getAllSysAdminEmail(SysAdministratorArray rootAdminArray) {
        ArrayList<String> result = new ArrayList<String>();
        SchemaHelper.extractEmailAddress(SchemaHelper.getAllSysAdmin(rootAdminArray), result);
        return result;
    }

    private static void extractEmailAddress(List<SemAdministrator> admins, List<String> result) {
        for (SemAdministrator admin : admins) {
            String emailAddr = admin.getOptEmailAddress();
            if (StringUtilities.isEmpty(emailAddr)) continue;
            result.add(emailAddr);
        }
    }

    public static List<SemAdministrator> getAllNonSystemAdmin(List<AdminContext> adminContexts) {
        ArrayList<SemAdministrator> result = new ArrayList<SemAdministrator>();
        if (adminContexts != null) {
            for (AdminContext context : adminContexts) {
                if (context == null) continue;
                result.add(context.getSemAdministrator());
            }
        }
        return result;
    }

    public static List<String> getAllNonSystemAdminEmail(List<AdminContext> adminContexts) {
        ArrayList<String> result = new ArrayList<String>();
        SchemaHelper.extractEmailAddress(SchemaHelper.getAllNonSystemAdmin(adminContexts), result);
        return result;
    }

    public static AdminContext getAdminContextById(List<AdminContext> adminContexts, String adminId) {
        if (adminContexts == null || adminId == null) {
            throw new IllegalArgumentException("The parameters cannot be null!");
        }
        for (AdminContext context : adminContexts) {
            if (context == null || !adminId.equals(context.getSemAdministrator().getId())) continue;
            return context;
        }
        return null;
    }

    public static AdminContext getAdminContext(List<AdminContext> adminContexts, String adminName) {
        return SchemaHelper.getAdminContext(adminContexts, adminName, true);
    }

    public static AdminContext getAdminContext(List<AdminContext> adminContexts, String adminName, boolean ignoreCase) {
        if (adminContexts == null || adminName == null) {
            throw new IllegalArgumentException("The parameters cannot be null!");
        }
        for (AdminContext context : adminContexts) {
            boolean matchResult;
            if (context == null || !(matchResult = ignoreCase ? adminName.equalsIgnoreCase(context.getSemAdministrator().getName()) : adminName.equals(context.getSemAdministrator().getName()))) continue;
            return context;
        }
        return null;
    }

    public static String getSiteId(SemServer server) {
        SemSite semSite;
        ServerArray serverArray;
        String result = "";
        if (server != null && (serverArray = (ServerArray)server.getParent()) != null && (semSite = (SemSite)serverArray.getParent()) != null) {
            return semSite.getId();
        }
        return result;
    }

    public static String getSiteId(Database database) {
        SemSite semSite;
        DatabaseArray databaseArray;
        String result = "";
        if (database != null && (databaseArray = (DatabaseArray)database.getParent()) != null && (semSite = (SemSite)databaseArray.getParent()) != null) {
            return semSite.getId();
        }
        return result;
    }

    public static String getSiteId(EnforcerGroup enforcer) {
        String result = "";
        if (enforcer != null) {
            SemSite semSite;
            AbstractSchema parent;
            for (parent = enforcer; !(parent instanceof EnforcerGroupTree) && parent != null; parent = parent.getParent()) {
            }
            EnforcerGroupTree egt = (EnforcerGroupTree)parent;
            if (egt != null && (semSite = (SemSite)egt.getParent()) != null) {
                return semSite.getId();
            }
        }
        return result;
    }

    public static List<DirectoryServer> getAllDirectoryServer(SemServer server) {
        DirectoryServerIntegration dsi;
        ArrayList<DirectoryServer> result = new ArrayList<DirectoryServer>();
        if (server != null && (dsi = server.getOptDirectoryServerIntegration()) != null && dsi.getDirectoryServer() != null) {
            for (DirectoryServer ds : dsi.getDirectoryServer()) {
                result.add(ds);
            }
        }
        return result;
    }

    public static List<String> getAllDomainId(SemConfigRoot root) {
        SemDomainArray domainArray;
        ArrayList<String> result = new ArrayList<String>();
        if (root != null && (domainArray = root.getSemDomainArray()) != null && domainArray.getObjReference() != null) {
            for (ObjReference ref : domainArray.getObjReference()) {
                result.add(ref.getTargetId());
            }
        }
        return result;
    }

    public static List<String> getAllServerId(SemConfigRoot root) {
        SemSiteArray siteArray;
        ArrayList<String> result = new ArrayList<String>();
        if (root != null && (siteArray = root.getSemSiteArray()) != null && siteArray.getObjReference() != null) {
            for (ObjReference ref : siteArray.getObjReference()) {
                result.add(ref.getTargetId());
            }
        }
        return result;
    }

    public static DirectoryServer getDirectoryServer(List<DirectoryServer> servers, String serverId) {
        if (CollectionUtils.isNullOrEmpty(servers) || StringUtilities.isEmpty(serverId)) {
            return null;
        }
        for (DirectoryServer server : servers) {
            if (server == null || !serverId.equals(server.getOptGuid())) continue;
            return server;
        }
        return null;
    }

    public static String getDirectoryServerName(SemAdministrator admin) {
        if (admin != null && admin.getOptDirectoryAuthentication() != null) {
            return admin.getOptDirectoryAuthentication().getOptServer();
        }
        return "";
    }

    public static String getClientGroupTreeId(SemDomain domain) {
        if (domain != null && domain.getObjReference() != null) {
            return domain.getObjReference().getTargetId();
        }
        return "";
    }

    public static Database getDatabase(SemSite site) {
        if (site != null && site.getDatabaseArray() != null) {
            return site.getDatabaseArray().getDatabase();
        }
        return null;
    }

    public static SemSite getSemSiteByName(List<SemSite> sites, String siteName) {
        if (CollectionUtils.isNullOrEmpty(sites) || StringUtilities.isEmpty(siteName)) {
            return null;
        }
        for (SemSite site : sites) {
            if (!siteName.equals(site.getName())) continue;
            return site;
        }
        return null;
    }

    public static List<String> getClientMonikerList(LuDownloadedContentArray luContentArray) {
        if (luContentArray == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (LuDownloadedContent luContent : luContentArray.getLuDownloadedContent()) {
            if (luContent == null || luContent.getOptClientMoniker() == null) continue;
            result.add(luContent.getOptClientMoniker());
        }
        return result;
    }
}

