/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.AbstractSchemaContainer;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.OutdatedAbstractSchema;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.SchemaContentHandler;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.util.GUID;
import java.io.UnsupportedEncodingException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SchemaContainerHandler
extends SchemaContentHandler {
    protected SchemaContainerHandler(SchemaContainer container, Attributes attributes) {
        AbstractSchemaContainer asCon = new AbstractSchemaContainer(container);
        this.schemaStack.add(asCon);
        this.rootSchema = asCon;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.UNKNOWN_CONTENT_DEALING) {
            this.ucHandler.handleUnknowContent(qName, attributes);
            return;
        }
        if (this.containerHandler != null) {
            this.containerHandler.startElement(uri, localName, qName, attributes);
            return;
        }
        if (qName.equals("Metadata")) {
            AbstractSchema obj = ((AbstractSchemaContainer)this.schemaStack.lastElement()).getSchema();
            if (!(obj instanceof OutdatedAbstractSchema)) {
                if (!(obj instanceof TopLevelObject)) {
                    throw new SAXException("A top level object is required to add an metadata element, " + obj + " is not a top level object.");
                }
                MetadataAttributes metadata = new MetadataAttributes();
                metadata.setChecksum(attributes.getValue("ChechSum"));
                String ownerId = attributes.getValue("Owner");
                if (ownerId != null) {
                    metadata.setOwner(new GUID(ownerId));
                }
                ((TopLevelObject)obj).setMetadataAttributes(metadata);
            }
            return;
        }
        AbstractSchema obj = null;
        if ("SchemaContainer".equals(qName)) {
            obj = new SchemaContainer();
            this.containerHandler = new SchemaContainerHandler((SchemaContainer)obj, attributes);
        } else {
            obj = this.startObject(qName, attributes, true);
            if (obj == null) {
                return;
            }
        }
        if (!this.schemaStack.isEmpty()) {
            ((AbstractSchemaContainer)this.schemaStack.lastElement()).getSchema().placeSonObject(obj);
            if (obj instanceof ConfigObject) {
                this.schemaStack.add(new AbstractSchemaContainer(obj, attributes.getValue("_v"), attributes.getValue("_t")));
            } else {
                this.schemaStack.add(new AbstractSchemaContainer(obj));
            }
        } else {
            AbstractSchemaContainer acCon = null;
            if (obj instanceof ConfigObject) {
                acCon = new AbstractSchemaContainer(obj, attributes.getValue("_v"), attributes.getValue("_t"));
                this.schemaStack.add(acCon);
            } else {
                acCon = new AbstractSchemaContainer(obj);
                this.schemaStack.add(acCon);
            }
            this.rootSchema = acCon;
            this.rootSchema.getSchema().nameSpace = this.nameSpace;
        }
    }

    public boolean endElementEXT(String uri, String localName, String qName) throws SAXException {
        if (this.UNKNOWN_CONTENT_DEALING) {
            if (this.ucHandler.handleUnknowContent(qName, true)) {
                this.UNKNOWN_CONTENT_DEALING = false;
                AbstractSchemaContainer acCon = (AbstractSchemaContainer)this.schemaStack.lastElement();
                AbstractSchema obj = acCon.getSchema();
                String cName = obj.getClass().getSimpleName();
                if (!cName.equals(qName)) {
                    throw new SAXException("Invalid XML structure: " + qName);
                }
                try {
                    ((UnknownContent)obj).setConent(this.ucHandler.content.getBytes("UTF-8"));
                    this.ucHandler = null;
                }
                catch (UnsupportedEncodingException e) {
                    throw new SAXException(e);
                }
                this.schemaStack.remove(acCon);
                this.UNKNOWN_CONTENT_DEALING = false;
            }
            return false;
        }
        if (this.containerHandler != null) {
            if (this.containerHandler.endElementEXT(uri, localName, qName)) {
                AbstractSchemaContainer asCon = this.containerHandler.getAbstractSchema();
                AbstractSchema obj = asCon.getSchema();
                if (obj instanceof ConfigObject) {
                    ((ConfigObject)obj).readElement(asCon.getV(), asCon.getT());
                }
                this.schemaStack.remove(asCon);
                this.containerHandler = null;
                if (this.schemaStack.size() < 1) {
                    throw new SAXException("Invalid XML structure: " + qName);
                }
                asCon = (AbstractSchemaContainer)this.schemaStack.lastElement();
                obj = asCon.getSchema();
                if (!(obj instanceof SchemaContainer)) {
                    throw new SAXException("Invalid XML structure: " + qName);
                }
                this.schemaStack.remove(asCon);
            }
            return false;
        }
        if (qName.equals("Metadata")) {
            return false;
        }
        if (this.schemaStack.size() < 1) {
            throw new SAXException("Invalid XML structure: " + qName);
        }
        AbstractSchemaContainer acCon = (AbstractSchemaContainer)this.schemaStack.lastElement();
        AbstractSchema obj = acCon.getSchema();
        String cName = obj.getClass().getSimpleName();
        if (!cName.equals(qName)) {
            if (obj instanceof OutdatedAbstractSchema) {
                this.schemaStack.remove(acCon);
                return false;
            }
            throw new SAXException("Invalid XML structure: " + qName);
        }
        obj.checkIntegrity();
        if (obj instanceof ConfigObject) {
            ((ConfigObject)obj).readElement(acCon.getV(), acCon.getT());
        }
        this.schemaStack.remove(acCon);
        return qName.equals("SchemaContainer");
    }

    public void onCharacters(String value) throws SAXException {
        if (this.UNKNOWN_CONTENT_DEALING && this.ucHandler != null) {
            this.ucHandler.handleUnknowContent(value, false);
            return;
        }
        if (this.containerHandler != null) {
            this.containerHandler.onCharacters(value);
            return;
        }
        ((AbstractSchemaContainer)this.schemaStack.lastElement()).getSchema().putTextContent(value);
    }
}

