/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.util.ConfigObjectUtils;
import com.sygate.scm.util.GUID;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SchemaContainer
extends AbstractSchema {
    private static final long serialVersionUID = 3969159282821482972L;
    private ArrayList<AbstractSchema> childList;

    public SchemaContainer() {
        this.nameSpace = "";
        this.childList = new ArrayList();
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public int getObjectType() {
        return 0;
    }

    @Override
    public String getObjectTypeName() {
        return "SchemaContainer";
    }

    @Override
    public void addChild(AbstractSchema value) {
        this.childList.add(value);
        value.setParent(this);
    }

    @Override
    public void addChild(int index, AbstractSchema value) {
        this.childList.add(index, value);
        value.setParent(this);
    }

    @Override
    public void setChild(AbstractSchema value) {
        this.childList.set(0, value);
        value.setParent(this);
    }

    @Override
    public void setChild(int index, AbstractSchema value) {
        this.childList.set(index, value);
        value.setParent(this);
    }

    @Override
    public Vector<AbstractSchema> getChildren() {
        Vector<AbstractSchema> v = new Vector<AbstractSchema>();
        v.addAll(this.childList);
        return v;
    }

    @Override
    public void removeChild(AbstractSchema value) {
        this.childList.remove(value);
    }

    public boolean isChildRequired() {
        return false;
    }

    @Override
    public void importFromElement(Element element) throws ValidationException {
        if (!"SchemaContainer".equals(element.getNodeName())) {
            throw new ValidationException("SchemaContainer: can't import element(" + element.getNodeName() + ")!");
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            ArrayList<Element> list;
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            String ns = ((Element)node).getAttribute("NameSpace");
            AbstractSchema obj = AbstractSchema.getObjectByName(node.getNodeName(), ns);
            if (obj == null) continue;
            obj.importFromElement((Element)node);
            this.addChild(obj);
            if (!(obj instanceof TopLevelObject) || (list = XMLHelper.getChildElementByName((Element)node, "Metadata")).size() <= 0) continue;
            Element e = list.get(0);
            MetadataAttributes metadata = new MetadataAttributes();
            metadata.setChecksum(e.getAttribute("ChechSum"));
            String ownerId = XMLHelper.getAttribute(e, "Owner");
            if (ownerId != null) {
                metadata.setOwner(new GUID(ownerId));
            }
            ((TopLevelObject)obj).setMetadataAttributes(metadata);
        }
    }

    @Override
    public Element exportToElement(Document doc) throws ValidationException {
        Element element = doc.createElement("SchemaContainer");
        for (int i = 0; i < this.childList.size(); ++i) {
            MetadataAttributes metadata;
            AbstractSchema schema = this.childList.get(i);
            Element e = schema.exportToElement(doc);
            e.setAttribute("NameSpace", schema.nameSpace);
            element.appendChild(e);
            if (!(schema instanceof TopLevelObject) || (metadata = ((TopLevelObject)schema).getMetadataAttributes()) == null) continue;
            Element metadataElement = doc.createElement("Metadata");
            if (metadata.getChecksum() != null) {
                metadataElement.setAttribute("ChechSum", metadata.getChecksum());
            }
            if (metadata.getOwner() != null) {
                metadataElement.setAttribute("Owner", metadata.getOwner().getStringRepresentation());
            }
            e.appendChild(metadataElement);
        }
        return element;
    }

    @Override
    public void initByAttributes(Attributes attributes) throws SAXException {
    }

    @Override
    public void placeSonObject(AbstractSchema sonObject) throws SAXException {
        this.addChild(sonObject);
    }

    @Override
    public void checkIntegrity() throws SAXException {
    }

    @Override
    public void putTextContent(String content) throws SAXException {
    }

    @Override
    public void doSerialize(OutputStream os_for_xml_generating) throws ValidationException {
        try {
            os_for_xml_generating.write("<SchemaContainer NameSpace=\"\"".getBytes("UTF-8"));
            if (this.childList.size() > 0) {
                os_for_xml_generating.write(62);
                for (int i = 0; i < this.childList.size(); ++i) {
                    AbstractSchema schema = this.childList.get(i);
                    schema.doSerialize(os_for_xml_generating, schema instanceof TopLevelObject);
                }
                os_for_xml_generating.write("</SchemaContainer>".getBytes("UTF-8"));
            } else {
                os_for_xml_generating.write("/>".getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    @Override
    public void setReadonly() {
        super.setReadonly();
        if (this.childList.size() > 0) {
            for (int i = 0; i < this.childList.size(); ++i) {
                AbstractSchema schema = this.childList.get(i);
                schema.setReadonly();
            }
        }
    }

    @Override
    public Object clone() {
        SchemaContainer container = (SchemaContainer)super.clone();
        container.childList = new ArrayList();
        for (AbstractSchema schema : this.childList) {
            container.childList.add((AbstractSchema)schema.clone());
        }
        return container;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SchemaContainer) || !super.equals(obj)) {
            return false;
        }
        SchemaContainer obj2 = (SchemaContainer)obj;
        return ConfigObjectUtils.isEqual(obj2.childList, this.childList);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

