/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ExportedPackage {
    String type;
    String formatVersion;

    public ExportedPackage(String type, String fVersion) {
        this.type = type;
        this.formatVersion = fVersion;
    }

    public void writeXML(SchemaContainer configObject, OutputStream os) throws IOException, ValidationException {
        Document doc = this.getDocument(configObject);
        XMLHelper.serialize(doc, os);
    }

    public String getType() {
        return this.type;
    }

    private Document getDocument(SchemaContainer configObject) throws ValidationException {
        Document doc = XMLHelper.newDocument();
        Element root = this.exportToElement(doc, configObject);
        doc.appendChild(root);
        return doc;
    }

    private Element exportToElement(Document doc, AbstractSchema cObj) throws ValidationException {
        Element root = doc.createElement("ExportedPackage");
        root.setAttribute("Type", this.type);
        root.setAttribute("FormatVersion", this.formatVersion);
        root.setAttribute("LastModifiedTime", "" + TimeUtil.getServerTime());
        Element subElemt = cObj.exportToElement(doc);
        root.appendChild(subElemt);
        return root;
    }

    public SchemaContainer readXML(InputStream is) throws IOException, SAXException, ValidationException {
        Document doc = XMLHelper.parse(is);
        return this.readXML(doc);
    }

    private SchemaContainer readXML(Document doc) throws ValidationException {
        Element e = doc.getDocumentElement();
        String objectTypeName = e.getNodeName();
        if (objectTypeName == null || objectTypeName.length() == 0) {
            throw new ValidationException("Invalid node name!");
        }
        String type = e.getAttribute("Type");
        if (type == null || type.length() == 0 || !type.equals(this.type)) {
            throw new ValidationException("Invalid Type! The valid Type should be:" + this.type);
        }
        String format = e.getAttribute("FormatVersion");
        if (format == null || format.length() == 0 || !format.equals(this.formatVersion)) {
            throw new ValidationException("Invalid FormatVersion! The valid FormatVersion should be:" + this.formatVersion);
        }
        Element subElemt = XMLHelper.getFirstChildElement(e);
        if (subElemt != null) {
            SchemaContainer sc = new SchemaContainer();
            sc.importFromElement(subElemt);
            return sc;
        }
        throw new ValidationException("No Valid Element under ExportedPackage!");
    }
}

