/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.util.GUIDGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public abstract class ConfigObject
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private static final String _I = "_i";
    private static final String _T = "_t";
    private static final String _D = "_d";
    private static final String _V = "_v";
    private static GUIDGenerator guidGenerator = new GUIDGenerator();
    private String _i;
    private long _t;
    private boolean _d;
    private long _v;
    protected ArrayList<ObsoleteItem> obsoleteItems = new ArrayList();
    private transient boolean dirty;

    public void init() {
        this._i = guidGenerator.getGUIDString();
        this._t = TimeUtil.getServerTime();
        this._v = 1L;
        this._d = false;
        this.setDirty();
    }

    public String getI() {
        return this._i;
    }

    public void setI(String value) {
        this.setDirty();
        this._i = value;
    }

    public long getT() {
        return this._t;
    }

    public void setT(long value) {
        this.setDirty();
        this._t = value;
    }

    public boolean getD() {
        return this._d;
    }

    public void setD(boolean value) {
        this.setDirty();
        this._d = value;
    }

    public long getV() {
        return this._v;
    }

    public void setV(long value) {
        this.setDirty();
        this._v = value;
    }

    public long getLastModifyTime() {
        return 0L;
    }

    public boolean isDirty() {
        if (this.dirty || this.children == null) {
            return this.dirty;
        }
        Iterator iter = this.children.keySet().iterator();
        while (iter.hasNext()) {
            ChildGroup obj = (ChildGroup)this.children.get(iter.next());
            for (int i = 0; i < obj.size(); ++i) {
                ConfigObject child = (ConfigObject)obj.get(i);
                if (!child.isDirty()) continue;
                return true;
            }
        }
        return false;
    }

    public void setDirty() {
        ++this._v;
        this._t = TimeUtil.getServerTime();
        this.dirty = true;
    }

    public void setClean() {
        this.dirty = false;
        if (this.children == null) {
            return;
        }
        for (ChildGroup obj : this.children.values()) {
            Vector configObjects = (Vector)Cast.cast(obj);
            for (ConfigObject child : configObjects) {
                child.setClean();
            }
        }
    }

    protected void setClean(boolean recursive) {
        this.dirty = false;
    }

    protected void addObsoleteItem(ObsoleteItem value) {
        this.setDirty();
        this.obsoleteItems.add(value);
    }

    protected void addObsoleteItem(int index, ObsoleteItem value) {
        this.setDirty();
        this.obsoleteItems.add(index, value);
    }

    public void removeObsoleteItem(ObsoleteItem value) {
        this.setDirty();
        this.obsoleteItems.remove(value);
    }

    public int getObsoleteItemCount() {
        return this.obsoleteItems.size();
    }

    public ObsoleteItem[] getObsoleteItem() {
        return this.obsoleteItems.toArray(new ObsoleteItem[this.obsoleteItems.size()]);
    }

    public ObsoleteItem getObsoleteItem(int index) {
        return this.obsoleteItems.get(index);
    }

    public boolean isDeleted() {
        return this.getD();
    }

    public void markForDelete() {
        this.setD(true);
    }

    @Override
    public void removeChild(AbstractSchema value) {
        super.removeChild(value);
        ObsoleteItem item = new ObsoleteItem(((ConfigObject)value).getI());
        item.setDeletedT(TimeUtil.getServerTime());
        this.addObsoleteItem(item);
    }

    @Override
    public void addChild(AbstractSchema value) {
        super.addChild(value);
        this.setDirty();
        if (this.obsoleteItems.contains(new ObsoleteItem(((ConfigObject)value).getI()))) {
            ((ConfigObject)value).setI(guidGenerator.getGUIDString());
        }
    }

    @Override
    public void addChild(int index, AbstractSchema value) {
        super.addChild(index, value);
        this.setDirty();
        if (this.obsoleteItems.contains(new ObsoleteItem(((ConfigObject)value).getI()))) {
            ((ConfigObject)value).setI(guidGenerator.getGUIDString());
        }
    }

    @Override
    public void setChild(AbstractSchema value) {
        super.setChild(value);
        this.setDirty();
        if (this.obsoleteItems.contains(new ObsoleteItem(((ConfigObject)value).getI()))) {
            ((ConfigObject)value).setI(guidGenerator.getGUIDString());
        }
    }

    @Override
    public void setChild(int index, AbstractSchema value) {
        super.setChild(index, value);
        this.setDirty();
        if (this.obsoleteItems.contains(new ObsoleteItem(((ConfigObject)value).getI()))) {
            ((ConfigObject)value).setI(guidGenerator.getGUIDString());
        }
    }

    public TopLevelObject getTopLevelObject() {
        AbstractSchema p;
        AbstractSchema obj = this;
        while (!(obj instanceof TopLevelObject) && (p = obj.getParent()) != null) {
            obj = p;
        }
        if (obj instanceof TopLevelObject) {
            return (TopLevelObject)obj;
        }
        return null;
    }

    public ConfigObject findChild(String _i) {
        if (_i.equals(this._i)) {
            return this;
        }
        Vector v = (Vector)Cast.cast(this.getChildren());
        for (ConfigObject obj : v) {
            ConfigObject child = obj.findChild(_i);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.obsoleteItems.clear();
    }

    @Override
    public void copyChild(AbstractSchema schema) {
        super.copyChild(schema);
        this.obsoleteItems = ((ConfigObject)schema).obsoleteItems;
    }

    protected void readElement(Element element) throws ValidationException {
        this._i = XMLHelper.getAttribute(element, _I);
        if (this._i == null) {
            throw new ValidationException(this.getObjectTypeName() + "/_i: attribute is required!");
        }
        String value = XMLHelper.getAttribute(element, _T);
        if (value != null) {
            try {
                this._t = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException(this.getObjectTypeName() + "/_t: invalid attribute value:" + value + "!");
            }
        }
        if ((value = XMLHelper.getAttribute(element, _D)) != null) {
            this._d = Boolean.valueOf(value);
        }
        if ((value = XMLHelper.getAttribute(element, _V)) != null) {
            try {
                this._v = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException(this.getObjectTypeName() + "/_v: invalid attribute value:" + value + "!");
            }
        }
    }

    protected void readElement(Attributes attris) throws ValidationException {
        this._i = attris.getValue(_I);
        if (this._i == null) {
            throw new ValidationException(this.getObjectTypeName() + "/_i: attribute is required!");
        }
        String value = attris.getValue(_T);
        if (value != null) {
            try {
                this._t = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException(this.getObjectTypeName() + "/_t: invalid attribute value:" + value + "!");
            }
        }
        if ((value = attris.getValue(_D)) != null) {
            this._d = Boolean.valueOf(value);
        }
        if ((value = attris.getValue(_V)) != null) {
            try {
                this._v = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException(this.getObjectTypeName() + "/_v: invalid attribute value:" + value + "!");
            }
        }
    }

    protected void readElement(String _ia, boolean _da, long _ta, long _va) {
        this._i = _ia;
        this._v = _va;
        this._t = _ta;
        this._d = _da;
    }

    public void readElement(long _va, long _ta) {
        this._v = _va;
        this._t = _ta;
    }

    protected void updateElement(Element element) {
        element.setAttribute(_I, this._i);
        element.setAttribute(_T, "" + this._t);
        element.setAttribute(_D, "" + this._d);
        element.setAttribute(_V, "" + this._v);
    }

    public MetadataAttributes getMetadataAttributes() {
        return null;
    }

    @Override
    public Object clone() {
        ConfigObject obj = (ConfigObject)super.clone();
        obj.obsoleteItems = new ArrayList();
        for (ObsoleteItem item : this.obsoleteItems) {
            obj.obsoleteItems.add((ObsoleteItem)item.clone());
        }
        return obj;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ConfigObject) || !super.equals(obj)) {
            return false;
        }
        ConfigObject obj2 = (ConfigObject)obj;
        if (this._i != null && !this._i.equals(obj2._i) || this._i == null && obj2._i != null) {
            return false;
        }
        if (this._t != obj2._t) {
            return false;
        }
        if (this._d != obj2._d) {
            return false;
        }
        if (this._v != obj2._v) {
            return false;
        }
        if (this.dirty != obj2.dirty) {
            return false;
        }
        return this.obsoleteItems.equals(obj2.obsoleteItems);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this._i.hashCode();
    }
}

