/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject;

import com.sygate.scm.common.configobject.Transportable;
import java.util.Vector;

public class ChildGroup
extends Vector<Transportable>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private final int min;
    private final int max;

    public ChildGroup(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public boolean isOptional() {
        return this.min == 0 && this.max == 1;
    }

    public int getMinOccurs() {
        return this.min;
    }

    public int getMaxOccurs() {
        return this.max;
    }

    public void addChild(Transportable obj) {
        if (this.max > 1) {
            this.add(obj);
        } else {
            this.setChild(obj);
        }
    }

    public void addChild(int index, Transportable obj) {
        if (this.max <= 1) {
            throw new IllegalArgumentException("Not supported!");
        }
        this.add(index, obj);
    }

    public void setChild(Transportable obj) {
        if (this.size() > 0) {
            this.set(0, obj);
        } else {
            this.add(obj);
        }
    }

    public void setChild(int index, Transportable obj) {
        if (this.max <= 1) {
            throw new IllegalArgumentException("Not supported!");
        }
        this.set(index, obj);
    }

    public void removeChild(Transportable obj) {
        this.remove(obj);
    }

    public void removeChild() {
        this.clear();
    }

    @Override
    public Object clone() {
        ChildGroup group = (ChildGroup)super.clone();
        group.clear();
        for (Transportable obj : this) {
            group.add((Transportable)obj.clone());
        }
        return group;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ChildGroup) || !super.equals(obj)) {
            return false;
        }
        ChildGroup cg = (ChildGroup)obj;
        if (this.min != cg.min) {
            return false;
        }
        return this.max == cg.max;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

