/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.TopLevelObject;

public class CachedObject {
    private TopLevelObject obj;
    private long lastAccessTime;

    public CachedObject(TopLevelObject obj) {
        this(obj, true);
    }

    public CachedObject(TopLevelObject obj, boolean cloneIt) {
        this.setTopLevelObj(obj, cloneIt);
    }

    protected void access() {
        this.lastAccessTime = TimeUtil.getServerTime();
    }

    public void setTopLevelObj(TopLevelObject obj) {
        this.setTopLevelObj(obj, true);
    }

    public void setTopLevelObj(TopLevelObject obj, boolean cloneIt) {
        this.obj = cloneIt ? (TopLevelObject)obj.clone() : obj;
        this.access();
    }

    public String getId() {
        return this.obj.getId();
    }

    public TopLevelObject getTopLevelObject() {
        return this.getTopLevelObject(false);
    }

    public TopLevelObject getTopLevelObject(boolean forUpdate) {
        this.access();
        if (forUpdate) {
            TopLevelObject ret = (TopLevelObject)this.obj.clone();
            return ret;
        }
        return this.obj;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public boolean isPoisoned() {
        return this.obj.isDirty();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CachedObject) {
            return this.getId().equals(((CachedObject)object).getId());
        }
        return false;
    }

    protected void setReadOnly(boolean bReadOnly) {
        this.obj.setReadonly(bReadOnly, true);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "Id=" + this.getId() + ",Idle = " + (System.currentTimeMillis() - this.getLastAccessTime()) + ",Obj=" + this.obj;
    }
}

