/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.configobject;

import com.sygate.scm.common.configobject.ChildGroup;
import com.sygate.scm.common.configobject.ObjectManager;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.Transportable;
import com.sygate.scm.common.configobject.UnrecognizedTypeException;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.agent.AgentObjectManager;
import com.sygate.scm.common.configobject.report.ReportObjectManager;
import com.sygate.scm.common.configobject.rpc.RpcObjectManager;
import com.sygate.scm.common.configobject.schema.SchemaObjectManager;
import com.sygate.scm.common.configobject.table.TableObjectManager;
import com.sygate.scm.hi.library.HiObjectManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractSchema
implements Transportable,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final HashMap<String, ObjectManager> nameMap = new HashMap();
    protected LinkedHashMap<Integer, ChildGroup> children = new LinkedHashMap();
    protected String nameSpace;
    private AbstractSchema parent;
    private boolean isReadonly = false;

    public Document getDocument() throws IOException, ValidationException {
        Document doc = XMLHelper.newDocument();
        Element root = this.exportToElement(doc);
        root.setAttribute("NameSpace", this.nameSpace);
        doc.appendChild(root);
        return doc;
    }

    public void writeXML(OutputStream os) throws IOException, ValidationException {
        Document doc = this.getDocument();
        XMLHelper.serialize(doc, os);
    }

    public byte[] getBytes() throws IOException, ValidationException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.writeXMLSAX(bos);
        bos.close();
        return bos.toByteArray();
    }

    public void writeXMLSAX(OutputStream os) throws IOException, ValidationException {
        XMLHelper.serialize(os, this, false);
    }

    public String getString() throws IOException, ValidationException {
        return new String(this.getBytes(), "UTF-8");
    }

    public static AbstractSchema readXML(Document doc) throws SAXException, IOException, ValidationException {
        Element e = doc.getDocumentElement();
        String objectTypeName = e.getNodeName();
        if (objectTypeName == null || objectTypeName.length() == 0) {
            throw new ValidationException("Invalid node name: " + objectTypeName);
        }
        if ("SchemaContainer".equals(objectTypeName)) {
            SchemaContainer container = new SchemaContainer();
            container.importFromElement(e);
            return container;
        }
        String nameSpace = e.getAttribute("NameSpace");
        if (nameSpace == null || nameSpace.length() == 0) {
            throw new ValidationException("Invalid NameSpace: " + nameSpace);
        }
        ObjectManager manager = nameMap.get(nameSpace);
        if (manager == null) {
            throw new ValidationException("Invalid NameSpace (no object manager available): " + nameSpace);
        }
        AbstractSchema obj = manager.getObjectByName(objectTypeName, false);
        if (obj == null) {
            throw new UnrecognizedTypeException(objectTypeName);
        }
        obj.importFromElement(e);
        return obj;
    }

    public static String checkXMLContent(String content) {
        return StringUtilities.to_xml_entities(content);
    }

    public static AbstractSchema readXMLDOM(InputStream is) throws SAXException, IOException, ValidationException {
        Document doc = XMLHelper.parse(is);
        return AbstractSchema.readXML(doc);
    }

    public static AbstractSchema readXMLDOM(byte[] buf) throws SAXException, IOException, ValidationException {
        return AbstractSchema.readXMLDOM(new ByteArrayInputStream(buf));
    }

    public static AbstractSchema readXMLDOM(String str) throws SAXException, IOException, ValidationException {
        return AbstractSchema.readXMLDOM(str.getBytes("UTF-8"));
    }

    public static AbstractSchema readXML(InputStream is) throws SAXException, IOException, ValidationException {
        return XMLHelper.parseSAX(is);
    }

    public static AbstractSchema readXML(InputStream is, boolean isReadonly) throws SAXException, IOException, ValidationException {
        return XMLHelper.parseSAX(is, isReadonly);
    }

    public static AbstractSchema readXML(byte[] buf) throws SAXException, IOException, ValidationException {
        return AbstractSchema.readXML(new ByteArrayInputStream(buf));
    }

    public static AbstractSchema readXML(byte[] buf, boolean isReadonly) throws SAXException, IOException, ValidationException {
        return AbstractSchema.readXML(new ByteArrayInputStream(buf), isReadonly);
    }

    public static AbstractSchema readXML(String str) throws SAXException, IOException, ValidationException {
        try {
            return AbstractSchema.readXML(str.getBytes("UTF-8"));
        }
        catch (ValidationException ve) {
            LoggerUtilities.logException(ve);
            String validXml = AbstractSchema.stripNonValidXMLCharacters(str);
            AbstractSchema schema = null;
            try {
                schema = AbstractSchema.readXML(validXml.getBytes("UTF-8"));
            }
            catch (ValidationException saxE) {
                throw new ValidationException("SAXException " + saxE.getMessage() + " for string text: " + validXml);
            }
            return schema;
        }
    }

    public static AbstractSchema readXML(String str, boolean isReadonly) throws SAXException, IOException, ValidationException {
        return AbstractSchema.readXML(str.getBytes("UTF-8"), isReadonly);
    }

    public static AbstractSchema readXML(String str, boolean isReadOnly, boolean bypassParseException) throws SAXException, IOException, ValidationException {
        AbstractSchema schema = null;
        try {
            schema = AbstractSchema.readXML(str.getBytes("UTF-8"), isReadOnly);
        }
        catch (ValidationException ve) {
            if (bypassParseException) {
                String validXml = AbstractSchema.stripNonValidXMLCharacters(str);
                schema = AbstractSchema.readXML(validXml.getBytes("UTF-8"), isReadOnly);
            }
            throw ve;
        }
        return schema;
    }

    public static ObjectManager getObjectManager(String nameSpace) {
        return nameMap.get(nameSpace);
    }

    public static Hashtable<String, String> getAttributes(Attributes attributes) {
        Hashtable<String, String> attris = new Hashtable<String, String>();
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (name == null || value == null) continue;
            attris.put(name, value);
        }
        return attris;
    }

    public void setParent(AbstractSchema parent) {
        this.parent = parent;
    }

    public AbstractSchema getParent() {
        return this.parent;
    }

    public void addChild(AbstractSchema value) {
        ChildGroup childGroup = this.children.get(value.getObjectType());
        childGroup.addChild(value);
        value.setParent(this);
    }

    public void addChild(int index, AbstractSchema value) {
        ChildGroup childGroup = this.children.get(value.getObjectType());
        childGroup.addChild(index, value);
        value.setParent(this);
    }

    public void setChild(AbstractSchema value) {
        ChildGroup childGroup = this.children.get(value.getObjectType());
        childGroup.setChild(value);
        value.setParent(this);
    }

    public void setChild(int index, AbstractSchema value) {
        ChildGroup childGroup = this.children.get(value.getObjectType());
        childGroup.setChild(index, value);
        value.setParent(this);
    }

    public Vector<AbstractSchema> getChildren() {
        Vector<AbstractSchema> v = new Vector<AbstractSchema>();
        Iterator<Integer> i = this.children.keySet().iterator();
        while (i.hasNext()) {
            ChildGroup obj = this.children.get(i.next());
            for (Transportable child : obj) {
                v.add((AbstractSchema)child);
            }
        }
        return v;
    }

    public Vector<AbstractSchema> getChildren(int objectType) {
        Vector<AbstractSchema> v = new Vector<AbstractSchema>();
        ChildGroup obj = this.children.get(objectType);
        if (obj != null) {
            for (Transportable child : obj) {
                v.add((AbstractSchema)child);
            }
        }
        return v;
    }

    public void removeChild(AbstractSchema value) {
        ChildGroup childGroup = this.children.get(value.getObjectType());
        childGroup.removeChild(value);
    }

    public boolean getChildOptional(int childObjectType) {
        ChildGroup childGroup = this.children.get(childObjectType);
        if (childGroup == null) {
            throw new IllegalArgumentException("ObjectType is not supported for this object!");
        }
        return childGroup.isOptional();
    }

    public int getChildMinOccurs(int childObjectType) {
        ChildGroup childGroup = this.children.get(childObjectType);
        if (childGroup == null) {
            throw new IllegalArgumentException("ObjectType is not supported for this object!");
        }
        return childGroup.getMinOccurs();
    }

    public int getChildMaxOccurs(int childObjectType) {
        ChildGroup childGroup = this.children.get(childObjectType);
        if (childGroup == null) {
            throw new IllegalArgumentException("ObjectType is not supported for this object!");
        }
        return childGroup.getMaxOccurs();
    }

    public abstract int getObjectType();

    public abstract String getObjectTypeName();

    public abstract void validate() throws ValidationException;

    public static AbstractSchema getObjectByName(String objectTypeName, String nameSpace) {
        if (objectTypeName == null || objectTypeName.length() == 0) {
            return null;
        }
        if ("SchemaContainer".equals(objectTypeName)) {
            return new SchemaContainer();
        }
        if (nameSpace == null || nameSpace.length() == 0) {
            return null;
        }
        ObjectManager manager = nameMap.get(nameSpace);
        if (manager == null) {
            return null;
        }
        return manager.getObjectByName(objectTypeName, true);
    }

    public static void registerObjectManager(String nameSpace, ObjectManager manager) {
        nameMap.put(nameSpace, manager);
    }

    public void clear() {
        Iterator<Integer> i = this.children.keySet().iterator();
        while (i.hasNext()) {
            ChildGroup obj = this.children.get(i.next());
            obj.clear();
        }
    }

    @Override
    public void doSerialize(OutputStream os, boolean appendMetadata) throws ValidationException {
        this.doSerialize(os);
    }

    public void copyChild(AbstractSchema schema) {
        this.children = schema.children;
    }

    public boolean isReadonly() {
        return this.isReadonly;
    }

    @Override
    public void setReadonly() {
        this.isReadonly = true;
    }

    public void setReadonly(boolean bReadOnly, boolean recursive) {
        this.isReadonly = bReadOnly;
        if (recursive) {
            for (AbstractSchema child : this.getChildren()) {
                child.setReadonly(bReadOnly, recursive);
            }
        }
    }

    public static String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (!StringUtilities.isEmpty(in)) {
            int current;
            for (int position = 0; position < in.length(); position += Character.charCount(current)) {
                current = in.codePointAt(position);
                if (!(current == 9 || current == 10 || current == 13 || current >= 32 && current <= 55295 || current >= 57344 && current <= 65533) && (current < 65536 || current > 0x10FFFF)) continue;
                out.append(Character.toChars(current));
            }
        }
        return out.toString();
    }

    @Override
    public Object clone() {
        try {
            AbstractSchema schema = (AbstractSchema)super.clone();
            schema.isReadonly = false;
            schema.parent = null;
            schema.children = new LinkedHashMap();
            for (Map.Entry<Integer, ChildGroup> entry : this.children.entrySet()) {
                ChildGroup obj = entry.getValue();
                Integer key = entry.getKey();
                schema.children.put(key, (ChildGroup)obj.clone());
                for (Object child : schema.children.get(key)) {
                    if (!(child instanceof AbstractSchema)) continue;
                    ((AbstractSchema)child).setParent(schema);
                }
            }
            return schema;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AbstractSchema)) {
            return false;
        }
        AbstractSchema obj2 = (AbstractSchema)obj;
        if (this.nameSpace != null && !this.nameSpace.equals(obj2.nameSpace) || this.nameSpace == null && obj2.nameSpace != null) {
            return false;
        }
        return this.children.equals(obj2.children);
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (Exception e) {
            System.out.print(super.toString());
            return "";
        }
    }

    public boolean hasSameValues(AbstractSchema schemaTarget) {
        boolean result = false;
        String regexDecimal = "\\p{Digit}+";
        String regexHexadecimal = "\\p{XDigit}+";
        String regexT = "_t=\"" + regexDecimal + "\"";
        String regexV = "_v=\"" + regexDecimal + "\"";
        String regexObsoleteItem = "<ObsoleteItem DeletedI=\"" + regexHexadecimal + "\" DeletedT=\"" + regexDecimal + "\"/>";
        try {
            String schemaStrLocal = this.getString();
            String schemaStrTarget = schemaTarget.getString();
            schemaStrLocal = schemaStrLocal.replaceAll(regexT, "");
            schemaStrLocal = schemaStrLocal.replaceAll(regexV, "");
            schemaStrLocal = schemaStrLocal.replaceAll(regexObsoleteItem, "");
            schemaStrTarget = schemaStrTarget.replaceAll(regexT, "");
            schemaStrTarget = schemaStrTarget.replaceAll(regexV, "");
            schemaStrTarget = schemaStrTarget.replaceAll(regexObsoleteItem, "");
            result = schemaStrLocal.equals(schemaStrTarget);
        }
        catch (IOException e) {
            LoggerUtilities.logException(e);
            System.out.print("Exception to compare schema difference, schema 1: " + this.toString() + ", schema 2: " + schemaTarget.toString());
        }
        catch (ValidationException e) {
            LoggerUtilities.logException(e);
            System.out.print("Exception to compare schema difference, schema 1: " + this.toString() + ", schema 2: " + schemaTarget.toString());
        }
        return result;
    }

    static {
        AbstractSchema.registerObjectManager("rpc", new RpcObjectManager());
        AbstractSchema.registerObjectManager("schema", new SchemaObjectManager());
        AbstractSchema.registerObjectManager("table", new TableObjectManager());
        AbstractSchema.registerObjectManager("agent", new AgentObjectManager());
        AbstractSchema.registerObjectManager("report", new ReportObjectManager());
        AbstractSchema.registerObjectManager("hi", new HiObjectManager());
    }
}

