/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.communicate;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;

public class TimeoutSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory m_originalFactory;
    private int m_socketTimeout = 0;
    private Socket m_socket = null;

    public int getTimeout() {
        return this.m_socketTimeout;
    }

    public void setTimeout(int timeout) {
        this.m_socketTimeout = timeout;
    }

    public Socket getSocket() {
        return this.m_socket;
    }

    public SSLSocketFactory getOriginalFactory() {
        return this.m_originalFactory;
    }

    public TimeoutSSLSocketFactory(SSLSocketFactory originalFactory, int socketTimeout) {
        this.m_originalFactory = originalFactory;
        this.m_socketTimeout = socketTimeout;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.m_originalFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.m_originalFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        Socket socket = this.m_originalFactory.createSocket(s, host, port, autoClose);
        socket.setSoTimeout(this.m_socketTimeout);
        this.m_socket = socket;
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.m_originalFactory.createSocket(host, port);
        socket.setSoTimeout(this.m_socketTimeout);
        this.m_socket = socket;
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.m_originalFactory.createSocket(host, port, localHost, localPort);
        socket.setSoTimeout(this.m_socketTimeout);
        this.m_socket = socket;
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.m_originalFactory.createSocket(host, port);
        socket.setSoTimeout(this.m_socketTimeout);
        this.m_socket = socket;
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.m_originalFactory.createSocket(address, port, localAddress, localPort);
        socket.setSoTimeout(this.m_socketTimeout);
        this.m_socket = socket;
        return socket;
    }
}

