/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.communicate;

import com.sygate.scm.common.exception.SmartCardRuntimeError;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.SmartCardPinHandler;
import com.sygate.scm.common.util.CertificateUtil;
import com.sygate.scm.util.RunCommandHandler;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.AuthProvider;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SmartCardPkcsKeyStore {
    static boolean smartCardActive = false;
    static boolean afterSmartCardLogin = false;
    static Map<KeyManagerFactory, KeyStore> keyStoreCached = null;
    static X509Certificate[] clientAuthCertCached = null;
    static final String KEY_MANAGER_FACTORY_ALGORITHM = "NewSunX509";
    static final String KEY_MANAGER_FACTORY_ALGORITHM_PKIX = "PKIX";
    static final String SLOT = "0";
    static final String OPENSC_PKCS11_DLL = "opensc-pkcs11.dll";
    static final String PROVIDER_SUNPKCS11 = "SunPKCS11";
    static final String PROVIDER_SUN_JSSE = "SunJSSE";
    static final String PROVIDER_BC_JSSE = "BCJSSE";
    static final String PROVIDER_BCFKS = "BCFKS";
    public static final String OPENSC_DEFAULT_PROVIDER_NAME = "PKCS#11";
    static Provider pkcs11Provider;
    static String pkcs11Library;
    static Logger logger;
    static String openscLibFileName;
    static final String LIBRARY_PATH = "libraryPath";
    static final String OPENSC_LIBRARY_PATH = "OpenScPkcs11Library";
    static final List<String> SIGNATURE_CN_NAMES_TRUSTED;

    static boolean preparePkcs11DriverLibrary(PKCS11_DRIVERS driver) throws IOException {
        if (PKCS11_DRIVERS.OPENSC == driver) {
            SmartCardPkcsKeyStore.cleanupExtractedFiles(OPENSC_PKCS11_DLL, Utility.getTempDir());
            logger.log(Level.INFO, "SmartCard >> preparePkcs11Driver>> Initializing PKCS 11 libraries...");
            if (SmartCardPkcsKeyStore.isPkcs11LibraryLoaded()) {
                logger.log(Level.INFO, "SmartCard >> preparePkcs11Driver>> Found and will use existing library {0} which was extracted and locked by current console thread!", pkcs11Library);
            } else {
                String openScFilePath = SmartCardPkcsKeyStore.buildResourceInTargetDirectoryOrTempDirectory("com.sygate.scm.console.ConsoleMain", OPENSC_PKCS11_DLL, Utility.getTempDir());
                pkcs11Library = openScFilePath + File.separator + openscLibFileName;
                logger.log(Level.INFO, "SmartCard >> preparePkcs11Driver>> Loaded PKCS 11 library name: {0}", pkcs11Library);
            }
        }
        return Path.of(driver.getLibraryPath(), new String[0]).toFile().exists();
    }

    static boolean isPkcs11LibraryLoaded() {
        return !StringUtilities.isEmpty(pkcs11Library) && Files.exists(Path.of(pkcs11Library, new String[0]), new LinkOption[0]);
    }

    static void cleanupExtractedFiles(String defaultFileName, String targetDir) {
        File[] openscLibFiles = new File(targetDir).listFiles((dir, name) -> name.startsWith(defaultFileName));
        Arrays.stream(Optional.ofNullable(openscLibFiles).orElse(new File[0])).forEach(file -> logger.log(Level.FINE, "SmartCard >> cleanupExtractedFiles>> Purge file: {0}, result: {1}", new Object[]{file.getAbsolutePath(), Utility.deleteFile(file)}));
    }

    static synchronized void setExtractedFileName(String defaultFileName, String targetDir) throws IOException {
        SmartCardPkcsKeyStore.cleanupExtractedFiles(defaultFileName, targetDir);
        Path targetFile = Path.of(targetDir, defaultFileName);
        int num = 0;
        while (targetFile.toFile().exists()) {
            targetFile = Path.of(targetDir, defaultFileName + num++);
        }
        boolean ret = targetFile.toFile().createNewFile();
        logger.log(Level.INFO, "SmartCard >> setExtractedFileName>> targetFile: {0}, file created: {1}", new Object[]{targetFile, ret});
        openscLibFileName = targetFile.toFile().getName();
    }

    static String buildResourceInTargetDirectoryOrTempDirectory(String className, String fileName, String targetDir) throws IOException {
        Class<?> resourceClass;
        try {
            resourceClass = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        logger.log(Level.INFO, "SmartCard >> buildResourceInTargetDirectoryOrTempDirectory>> resourceClass is: {0}", resourceClass);
        try (InputStream in = SmartCardPkcsKeyStore.getResourceFile(resourceClass, fileName);){
            if (in == null) {
                throw new IOException("Failed to extract file " + fileName);
            }
            SmartCardPkcsKeyStore.setExtractedFileName(fileName, targetDir);
            logger.log(Level.INFO, "SmartCard >> buildResourceInTargetDirectoryOrTempDirectory>> result extractedFileName: {0}", openscLibFileName);
            String targetFileName = targetDir + File.separator + openscLibFileName;
            Files.copy(in, Path.of(targetFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        return targetDir;
    }

    static InputStream getResourceFile(Class<?> resourceClass, String fileName) {
        return resourceClass.getResourceAsStream(fileName);
    }

    public static synchronized void resetClientAuthCertCached() {
        clientAuthCertCached = null;
    }

    public static synchronized Map<KeyManagerFactory, KeyStore> getPkcs11KeyStore() throws GeneralSecurityException {
        if (keyStoreCached == null) {
            throw new GeneralSecurityException("Pkcs11 Key Store is not loaded yet!");
        }
        return new HashMap<KeyManagerFactory, KeyStore>(keyStoreCached);
    }

    public static synchronized Map<KeyManagerFactory, KeyStore> loadPkcs11KeyStore(PKCS11_DRIVERS driver, SmartCardPinHandler smartCardPinHandler) throws IOException, GeneralSecurityException {
        logger.log(Level.INFO, "SmartCard >> loadPkcs11KeyStore>> by driver: {0}", (Object)driver);
        KeyStore keyStore = null;
        if (!SmartCardPkcsKeyStore.preparePkcs11DriverLibrary(driver)) {
            logger.log(Level.WARNING, "SmartCard >> loadPkcs11KeyStore>> driver library {0} does not exists! ", driver.getLibraryPath());
            keyStoreCached = new HashMap<KeyManagerFactory, KeyStore>();
            return new HashMap<KeyManagerFactory, KeyStore>();
        }
        SmartCardPkcsKeyStore.configPkcs11Driver(driver);
        KeyStore.Builder builder = SmartCardPkcsKeyStore.getKeyStoreBuilder(smartCardPinHandler);
        KeyManagerFactory factory = SmartCardPkcsKeyStore.getKeyManagerFactory(builder);
        SmartCardPkcsKeyStore.setSmartCardActive(true);
        try {
            logger.log(Level.INFO, "SmartCard >> loadPkcs11KeyStore>> Building SunPKCS11 keystore...");
            keyStore = builder.getKeyStore();
            logger.log(Level.INFO, "SmartCard >> loadPkcs11KeyStore>> KeyManagerFactory provider: {0}, Algorithm: {1}, KeyStore provider: {2}", new Object[]{factory.getProvider(), factory.getAlgorithm(), keyStore.getProvider()});
        }
        catch (KeyStoreException ke) {
            logger.log(Level.SEVERE, "SmartCard >> loadPkcs11KeyStore>> Failed to load key store with error: {0}, check if your card is locked!", ke.getMessage());
            SmartCardPkcsKeyStore.checkKeyStoreException(ke);
        }
        return SmartCardPkcsKeyStore.cacheAndGetKeyStore(factory, keyStore, smartCardPinHandler.getPassword());
    }

    static void configPkcs11Driver(PKCS11_DRIVERS driver) throws KeyStoreException {
        String configString = driver.getConfigStr();
        logger.log(Level.INFO, "SmartCard >> configPkcs11Driver>> Loaded PKCS 11 configString: {0}", configString);
        SmartCardPkcsKeyStore.verifyDriverSignature(driver.getLibraryPath());
        logger.log(Level.INFO, "SmartCard >> configPkcs11Driver>> Getting SunPKCS11 provider...");
        pkcs11Provider = Security.getProvider(PROVIDER_SUNPKCS11);
        if (null == pkcs11Provider) {
            throw new KeyStoreException("PKCS11 provider not found");
        }
        pkcs11Provider = pkcs11Provider.configure(configString);
    }

    static void checkKeyStoreException(KeyStoreException exc) throws KeyStoreException {
        for (Throwable cause = exc.getCause(); cause != null; cause = cause.getCause()) {
            if (cause.getMessage() == null || !cause.getMessage().trim().equalsIgnoreCase("-99")) continue;
            logger.log(Level.INFO, "SmartCard >> checkKeyStoreException>> SmartCard pin input was canceled!");
            throw new CancellationException("Enter smart card PIN operation was canceled by user");
        }
        throw exc;
    }

    static KeyStore.Builder getKeyStoreBuilder(SmartCardPinHandler smartCardPinHandler) {
        KeyStore.CallbackHandlerProtection protection = new KeyStore.CallbackHandlerProtection(smartCardPinHandler);
        KeyStore.Builder builder = KeyStore.Builder.newInstance("PKCS11", pkcs11Provider, protection);
        if (!SmartCardPkcsKeyStore.isFipsEnabled()) {
            SmartCardPkcsKeyStore.addSunPKCS11PKCSProvider();
        }
        return builder;
    }

    static void addSunPKCS11PKCSProvider() {
        Security.addProvider(pkcs11Provider);
    }

    static KeyManagerFactory getKeyManagerFactory(KeyStore.Builder builder) throws GeneralSecurityException {
        boolean isFipsEnabled = SmartCardPkcsKeyStore.isFipsEnabled();
        KeyManagerFactory keyManager = isFipsEnabled ? KeyManagerFactory.getInstance(KEY_MANAGER_FACTORY_ALGORITHM_PKIX, Security.getProvider(PROVIDER_BC_JSSE)) : KeyManagerFactory.getInstance(KEY_MANAGER_FACTORY_ALGORITHM, Security.getProvider(PROVIDER_SUN_JSSE));
        keyManager.init(new KeyStoreBuilderParameters(builder));
        logger.log(Level.INFO, "SmartCard >> getKeyManagerFactory>> Created KeyManagerFactory, isFipsEnabled: {0}, Provider: {1}, Algorithm: {2}", new Object[]{isFipsEnabled, keyManager.getProvider(), keyManager.getAlgorithm()});
        return keyManager;
    }

    static Map<KeyManagerFactory, KeyStore> cacheAndGetKeyStore(KeyManagerFactory factory, KeyStore keyStore, char[] password) throws IOException, GeneralSecurityException {
        KeyStore resultKeyStore = keyStore;
        if (SmartCardPkcsKeyStore.isFipsEnabled()) {
            logger.log(Level.INFO, "SmartCard >> cacheAndGetKeyStore>> FIPS is enabled, changing to use BouncyCastleFipsProvider!");
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            logger.log(Level.INFO, "SmartCard >> CertificateFactory Provider: {0}", certFactory.getProvider());
            resultKeyStore = SmartCardPkcsKeyStore.getKeyStore(PROVIDER_BCFKS);
            logger.log(Level.INFO, "SmartCard >> KeyStore Provider: {0}", resultKeyStore.getProvider());
            resultKeyStore.load(null, password);
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                resultKeyStore.setKeyEntry(alias, keyStore.getKey(alias, password), password, keyStore.getCertificateChain(alias));
            }
        }
        keyStoreCached = Map.of(factory, resultKeyStore);
        return Map.of(factory, resultKeyStore);
    }

    static KeyStore getKeyStore(String keyStoreType) throws KeyStoreException {
        return KeyStore.getInstance(keyStoreType);
    }

    static boolean isFipsEnabled() {
        return Boolean.parseBoolean(System.getProperty("com.symantec.crypto.fips140mode", Boolean.FALSE.toString()));
    }

    public static List<X509Certificate> getCardCertificate() throws GeneralSecurityException {
        ArrayList<X509Certificate> certsFromReader = new ArrayList<X509Certificate>();
        ArrayList certsUnknown = new ArrayList();
        ArrayList certsNoneClient = new ArrayList();
        for (KeyStore ks : SmartCardPkcsKeyStore.getPkcs11KeyStore().values()) {
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate[] certs;
                String alias = aliases.nextElement();
                for (X509Certificate cert2 : certs = Optional.ofNullable((X509Certificate[])ks.getCertificateChain(alias)).orElse(new X509Certificate[]{(X509Certificate)ks.getCertificate(alias)})) {
                    logger.log(Level.INFO, "SmartCard >> getCardCertificate >> alias: {0}, SerialNumber: {1}, IssuerDN: {2}, SubjectDN: {3}, ExtendedKeyUsage: {4}", new Object[]{alias, cert2.getSerialNumber(), cert2.getIssuerDN(), cert2.getSubjectDN(), cert2.getExtendedKeyUsage()});
                    Optional.ofNullable(cert2.getExtendedKeyUsage()).ifPresentOrElse(keyUsage -> {
                        if (keyUsage.contains("1.3.6.1.5.5.7.3.2")) {
                            logger.log(Level.INFO, "SmartCard >> getCardCertificate >> It is a client certificate, ExtendedKeyUsage: {0}!", keyUsage);
                            certsFromReader.add(cert2);
                        } else {
                            certsNoneClient.add(cert2);
                        }
                    }, () -> certsUnknown.add(cert2));
                }
            }
        }
        if (certsFromReader.isEmpty()) {
            certsFromReader.addAll(certsUnknown.stream().limit(1L).collect(Collectors.toList()));
        }
        if (certsFromReader.isEmpty()) {
            certsFromReader.addAll(certsNoneClient.stream().limit(1L).collect(Collectors.toList()));
        }
        AtomicInteger index = new AtomicInteger();
        certsFromReader.forEach(cert -> logger.log(Level.INFO, "SmartCard >> getCardCertificate >> Result index: {0}, SerialNumber: {1}, IssuerDN: {2}, SubjectDN: {3}", new Object[]{index.getAndIncrement(), cert.getSerialNumber(), cert.getIssuerDN(), cert.getSubjectDN()}));
        return certsFromReader;
    }

    static void verifyDriverSignature(String driverLibraryPath) throws KeyStoreException {
        try {
            String powerScripts = "[Threading.Thread]::CurrentThread.CurrentUICulture = 'en-US';Get-AuthenticodeSignature -FilePath  '" + driverLibraryPath + "' | Format-list";
            logger.log(Level.INFO, "SmartCardPkcsKeyStore >> verifyDriverSignature: {0}!", powerScripts);
            String[] args = new String[]{Utility.getPowerShellPath(), powerScripts};
            RunCommandHandler handler = new RunCommandHandler(null, null, -1);
            int ret = handler.run(args, null, null, 0L);
            String strNormalOut = Optional.ofNullable(handler.getNormalOut()).orElse("");
            String formattedNormalOut = strNormalOut.replaceAll("\\s+|\"|'", "").toUpperCase(Locale.getDefault());
            logger.log(Level.INFO, "SmartCard >>  >> verifyDriverSignature, ret: {0}, NormalOut: {1}, formattedNormalOut: {2}", new Object[]{ret, strNormalOut, formattedNormalOut});
            List<String> signatureVerifyMsg = List.of("Status:Valid", "StatusMessage:Signature verified.");
            if (signatureVerifyMsg.stream().anyMatch(v -> !formattedNormalOut.contains(v.toUpperCase(Locale.getDefault()).replaceAll("\\s+", "")))) {
                throw new KeyStoreException("Failed to validate signature of " + driverLibraryPath);
            }
            if (SIGNATURE_CN_NAMES_TRUSTED.stream().noneMatch(v -> formattedNormalOut.contains("CN=" + v.toUpperCase(Locale.getDefault()).replaceAll("\\s+", "")))) {
                throw new KeyStoreException("Signature of " + driverLibraryPath + " is not trusted!");
            }
        }
        catch (IOException exc) {
            throw new KeyStoreException(exc.getMessage());
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            throw new KeyStoreException(exc.getMessage());
        }
    }

    public static synchronized boolean logOutFromSmartCard() {
        boolean successfullyLoggedOff = false;
        logger.log(Level.INFO, "SmartCard >> logOutFromSmartCard>>... ");
        SmartCardPkcsKeyStore.setSmartCardActive(false);
        try {
            if (pkcs11Provider instanceof AuthProvider) {
                AuthProvider authProvider = (AuthProvider)pkcs11Provider;
                authProvider.logout();
                successfullyLoggedOff = true;
            } else {
                logger.log(Level.SEVERE, "SmartCard >> logOutFromSmartCard>> Constructed provider is not an instance of pkcs11Provider. Current provider class: {0}", pkcs11Provider);
            }
        }
        catch (Throwable th) {
            logger.log(Level.SEVERE, "SmartCard >> logOutFromSmartCard>> Exception: {0}", th.getMessage());
        }
        finally {
            if (pkcs11Provider != null && pkcs11Provider.getName() != null) {
                try {
                    Security.removeProvider(pkcs11Provider.getName());
                }
                catch (SecurityException se) {
                    logger.log(Level.WARNING, "SmartCard >> logOutFromSmartCard>> Could not remove the PKCS 11 provider. Exception: {0}", se.getMessage());
                }
            }
        }
        keyStoreCached = null;
        return successfullyLoggedOff;
    }

    public static synchronized boolean isSmartCardActive() {
        return smartCardActive;
    }

    public static synchronized void setSmartCardActive(boolean smartCardActive) {
        SmartCardPkcsKeyStore.smartCardActive = smartCardActive;
    }

    public static synchronized boolean isAfterSmartCardLogin() {
        return afterSmartCardLogin;
    }

    public static synchronized void setAfterSmartCardLogin(boolean afterSmartCardLogin) {
        SmartCardPkcsKeyStore.afterSmartCardLogin = afterSmartCardLogin;
    }

    public static KeyManager[] getSmartCardPkcsKeyManagers(KeyManagerFactory keyStoreManagerFactory) {
        return new KeyManager[]{new SmartCardPKCSKeyManager(keyStoreManagerFactory.getKeyManagers()[0])};
    }

    static synchronized X509Certificate[] getClientAuthCertCached() {
        return clientAuthCertCached;
    }

    static synchronized void setClientAuthCertCached(X509Certificate[] clientAuthCertCached) {
        SmartCardPkcsKeyStore.clientAuthCertCached = clientAuthCertCached;
    }

    static {
        logger = Logger.getLogger(SmartCardPkcsKeyStore.class.getName());
        openscLibFileName = null;
        SIGNATURE_CN_NAMES_TRUSTED = List.of("Symantec Corporation", "Thales DIS CPL USA, Inc.", "Sectigo RSA Time Stamping Signer", "Sectigo RSA Time Stamping CA", "AAA Certificate Services", "USERTrust RSA Certification Authority", "Microsoft Root Certificate Authority", "Microsoft Windows Third Party Component CA", "Microsoft Windows Software Compatibility Publisher", "Microsoft Time-Stamp PCA", "Microsoft Time-Stamp Service", "DigiCert High Assurance", "DigiCert Assured ID Root CA", "DigiCert Trusted Root", "DigiCert Timestamp");
    }

    static class CertChooseDialog {
        static int maxLength = 50;
        private static final int DESCRIPTION_COLUMN = 50;
        private static final int MAX_SIZE_WIDTH = 250;
        private static final int MAX_SIZE_HEIGHT = 500;
        private static final ImageIcon imageIcon = new ImageIcon(CustomLookAndFeel.TITLE_LOGO_IMAGE);
        private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.common.ui.ui");
        private JFrame mainFrame;
        private List<String> aliasInMapOrdered = new ArrayList<String>();
        Map<String, JRadioButton> mapAliasRadioButton = new HashMap<String, JRadioButton>();
        Map<String, Set<JLabel>> mapAliasCertLabel = new HashMap<String, Set<JLabel>>();

        public CertChooseDialog(JFrame mainFrame, List<String> aliasInMapOrdered, Map<String, Set<String>> mapAliasCerts) {
            if (aliasInMapOrdered.size() > maxLength) {
                logger.log(Level.WARNING, "aliasInMapOrdered size is bigger than expected, only first {0} will be used!", maxLength);
            }
            this.mainFrame = mainFrame;
            ButtonGroup buttonGroup = new ButtonGroup();
            this.aliasInMapOrdered.addAll(aliasInMapOrdered.stream().limit(maxLength).collect(Collectors.toList()));
            if (this.aliasInMapOrdered.isEmpty()) {
                logger.log(Level.SEVERE, "mapAliasCerts is empty!");
                throw new SmartCardRuntimeError("mapAliasCerts is empty!");
            }
            this.aliasInMapOrdered.forEach(alias -> this.initComponents(mapAliasCerts, (String)alias, buttonGroup));
        }

        public String choose() {
            this.mapAliasRadioButton.get(this.aliasInMapOrdered.get(0)).setSelected(true);
            JPanel panel = new JPanel(new GridBagLayout());
            JScrollPane scrollPane = new JScrollPane(panel);
            scrollPane.setMaximumSize(new Dimension(250, 500));
            AtomicInteger indexY = new AtomicInteger();
            JTextArea desc = new JTextArea(MSG_RES.getString("SmartCardCertChooseDialog.desc"), 2, 50);
            desc.setEditable(false);
            desc.setLineWrap(true);
            desc.setWrapStyleWord(true);
            panel.add((Component)desc, new GridBagConstraints(0, indexY.getAndIncrement(), 1, 1, 0.0, 0.0, 16, 2, new Insets(10, 0, 10, 10), 0, 0));
            this.aliasInMapOrdered.forEach(alias -> this.addComponents(panel, indexY, (String)alias));
            Object[] option = new String[]{MSG_RES.getString("SmartCardCertChooseDialog.OK"), MSG_RES.getString("SmartCardCertChooseDialog.Cancel")};
            if (JOptionPane.showOptionDialog(this.mainFrame, scrollPane, MSG_RES.getString("SmartCardCertChooseDialog.title"), 2, 3, imageIcon, option, option[0]) != 0) {
                logger.log(Level.SEVERE, "Customer canceled the certificate selection!");
                throw new CancellationException();
            }
            String aliasSelected = this.mapAliasRadioButton.keySet().stream().filter(alias -> this.mapAliasRadioButton.get(alias).isSelected()).findFirst().orElse(null);
            logger.log(Level.SEVERE, "Customer selected alias {0}!", aliasSelected);
            return aliasSelected;
        }

        String trimAliasName(String alias) {
            String aliasTrimmed = alias;
            String[] arrAliasTmp = alias.split("[.]");
            if (arrAliasTmp.length == 3) {
                aliasTrimmed = arrAliasTmp[2];
                logger.log(Level.INFO, "trimAliasName, use trimmed alias name: {0}", aliasTrimmed);
            }
            return aliasTrimmed;
        }

        private void addComponents(JPanel panel, AtomicInteger indexY, String alias) {
            Optional.ofNullable(this.mapAliasRadioButton.get(alias)).ifPresent(button -> panel.add((Component)button, new GridBagConstraints(0, indexY.getAndIncrement(), 1, 1, 0.0, 0.0, 16, 0, new Insets(0, -2, 10, 10), 0, 0)));
            ((Set)Optional.ofNullable(this.mapAliasCertLabel.get(alias)).orElse(new HashSet())).forEach(label -> panel.add((Component)label, new GridBagConstraints(0, indexY.getAndIncrement(), 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 20, 10, 10), 0, 0)));
        }

        private void initComponents(Map<String, Set<String>> mapAliasCerts, String alias, ButtonGroup buttonGroup) {
            if (mapAliasCerts.get(alias) == null) {
                throw new SmartCardRuntimeError("mapAliasCerts does not has data for " + alias);
            }
            this.mapAliasCertLabel.computeIfAbsent(alias, k -> new HashSet());
            JRadioButton button = new JRadioButton(this.trimAliasName(alias));
            button.setPreferredSize(new Dimension(button.getPreferredSize().width + 50, button.getPreferredSize().height));
            buttonGroup.add(button);
            this.mapAliasRadioButton.put(alias, button);
            mapAliasCerts.get(alias).forEach(cn -> this.mapAliasCertLabel.get(alias).add(new JLabel((String)cn)));
        }
    }

    static class SmartCardPKCSKeyManager
    extends X509ExtendedKeyManager {
        static int useDefaultWhenAliasCountLessThan = 2;
        static boolean onlyShowClientAuthenticationCert = true;
        X509KeyManager manager;

        public SmartCardPKCSKeyManager(KeyManager manager) {
            this.manager = (X509KeyManager)manager;
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.manager.getClientAliases(keyType, issuers);
        }

        @Override
        public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
            Arrays.stream(Optional.ofNullable(issuers).orElse(new Principal[0])).forEach(issuer -> logger.log(Level.INFO, "chooseClientAlias, issuer: {0}", issuer));
            HashMap<String, Set<String>> mapAliasCerts = new HashMap<String, Set<String>>();
            ArrayList<String> aliasInMapOrdered = new ArrayList<String>();
            this.getAllAlias(keyTypes, issuers).forEach(alias -> this.updateAliasCertMap((List<String>)aliasInMapOrdered, (Map<String, Set<String>>)mapAliasCerts, (String)alias, this.getCertificateChain((String)alias)));
            return this.chooseAliasWithDialog(keyTypes, issuers, socket, mapAliasCerts, aliasInMapOrdered);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.manager.getServerAliases(keyType, issuers);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.manager.chooseServerAlias(keyType, issuers, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.manager.getCertificateChain(alias);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.manager.getPrivateKey(alias);
        }

        String chooseAliasWithDialog(String[] keyTypes, Principal[] issuers, Socket socket, Map<String, Set<String>> mapAliasCerts, List<String> aliasInMapOrdered) {
            String resultAlias;
            logger.log(Level.INFO, "chooseAliasWithDialog, mapAliasCerts size: {0}.", mapAliasCerts.size());
            if (aliasInMapOrdered.size() < useDefaultWhenAliasCountLessThan) {
                resultAlias = this.manager.chooseClientAlias(keyTypes, issuers, socket);
                logger.log(Level.INFO, "chooseAliasWithDialog, use default alias {0}:", resultAlias);
            } else {
                String matchingAliasByCache = this.getMatchingAliasByCachedCerts(aliasInMapOrdered);
                if (matchingAliasByCache != null) {
                    logger.log(Level.INFO, "chooseAliasWithDialog,  Found matching alias: {0} by cached certs.", matchingAliasByCache);
                    return matchingAliasByCache;
                }
                logger.log(Level.INFO, "chooseAliasWithDialog,  popup selection dialog.");
                resultAlias = new CertChooseDialog(new JFrame(), aliasInMapOrdered, mapAliasCerts).choose();
                X509Certificate[] certsSelected = this.getCertificateChain(resultAlias);
                List cns = Arrays.stream(Optional.ofNullable(certsSelected).orElse(new X509Certificate[0])).map(X509Certificate::getSubjectDN).collect(Collectors.toList());
                logger.log(Level.INFO, "chooseAliasWithDialog,  selected alias: {0}, certificates: {1}.", new Object[]{resultAlias, cns});
                SmartCardPkcsKeyStore.setClientAuthCertCached(certsSelected);
            }
            logger.log(Level.INFO, "chooseAliasWithDialog, Result alias is: {0}", resultAlias);
            return resultAlias;
        }

        String getMatchingAliasByCachedCerts(List<String> aliasInMapOrdered) {
            Set cachedCerts = Arrays.stream(Optional.ofNullable(SmartCardPkcsKeyStore.getClientAuthCertCached()).orElse(new X509Certificate[0])).collect(Collectors.toSet());
            logger.log(Level.INFO, "getMatchingAliasByCachedCerts >> Cached cert SubjectDN: {0}", cachedCerts.stream().map(X509Certificate::getSubjectDN).collect(Collectors.toList()));
            if (cachedCerts.isEmpty()) {
                logger.log(Level.INFO, "getMatchingAliasByCachedCerts >> cached cert list is empty!");
                return null;
            }
            String matchingAlias = aliasInMapOrdered.stream().filter(alias -> {
                Set certs = Arrays.stream(Optional.ofNullable(this.getCertificateChain((String)alias)).orElse(new X509Certificate[0])).collect(Collectors.toSet());
                boolean matching = certs.equals(cachedCerts);
                logger.log(Level.INFO, "getMatchingAliasByCachedCerts >> Checking alias: {0}, SubjectDN: {1}, Matching: {2}", new Object[]{alias, certs.stream().map(X509Certificate::getSubjectDN).collect(Collectors.toList()), matching});
                return matching;
            }).findFirst().orElse(null);
            logger.log(Level.INFO, "getMatchingAliasByCachedCerts >> matching alias is: {0}.", matchingAlias);
            return matchingAlias;
        }

        List<String> getAllAlias(String[] keyTypes, Principal[] issuers) {
            List<String> allAlias = Arrays.stream(Optional.ofNullable(keyTypes).orElse(new String[0])).map(type -> Optional.ofNullable(this.getClientAliases((String)type, issuers)).orElse(new String[0])).flatMap(Arrays::stream).distinct().collect(Collectors.toList());
            logger.log(Level.INFO, "getAllAlias, all alias: {0}", allAlias);
            return allAlias;
        }

        void updateAliasCertMap(List<String> allAliasInMapInOrder, Map<String, Set<String>> mapAliasCerts, String alias, X509Certificate[] certs) {
            logger.log(Level.INFO, "updateAliasCertMap, alias name: {0}", alias);
            Arrays.asList(Optional.ofNullable(certs).orElse(new X509Certificate[0])).stream().filter(this::filterAlias).forEach(cert -> {
                mapAliasCerts.putIfAbsent(alias, new HashSet());
                ((Set)mapAliasCerts.get(alias)).add(this.getFormattedCertInfo((X509Certificate)cert));
                if (!allAliasInMapInOrder.contains(alias)) {
                    allAliasInMapInOrder.add(alias);
                }
            });
        }

        String getFormattedCertInfo(X509Certificate cert) {
            return String.format("%s [%s]", CertificateUtil.getCNofSubjectDN(cert), cert.getSerialNumber().toString(16));
        }

        boolean filterAlias(X509Certificate cert) {
            return onlyShowClientAuthenticationCert ? CertificateUtil.isClientAuthenticationCert(cert) : true;
        }
    }

    public static enum PKCS11_DRIVERS {
        OPENSC("--name = PKCS#11\nlibrary = libraryPath\n slotListIndex = 0 \n showInfo = true \n attributes = compatibility \nattributes(*,*,*)=\n{\nCKA_TOKEN=true\nCKA_LOCAL=true\n}", "OpenScPkcs11Library"),
        SAFE_NET_IDPRIME("--name = SafeNet\nlibrary = libraryPath\n slot = 0", System.getenv("WINDIR") + File.separator + "system32" + File.separator + "eTPKCS11.dll");

        private String configStr;
        private String libraryPath;

        private PKCS11_DRIVERS(String configStr, String libraryPath) {
            this.configStr = configStr;
            this.libraryPath = libraryPath;
        }

        public String getConfigStr() {
            return this.configStr.replace(SmartCardPkcsKeyStore.LIBRARY_PATH, this.libraryPath).replace(SmartCardPkcsKeyStore.OPENSC_LIBRARY_PATH, pkcs11Library);
        }

        public String getLibraryPath() {
            return this.libraryPath.replace(SmartCardPkcsKeyStore.OPENSC_LIBRARY_PATH, pkcs11Library);
        }
    }
}

