/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.communicate;

import com.sygate.scm.common.action.ResponseCode;
import com.sygate.scm.common.communicate.CommunicationException;
import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ResponseObject {
    private String checksum;
    private String ownerId;
    private String content;
    private String errorMessage;
    private ResponseCode responseCode;
    private String transactionID;
    private String serverTime;
    private String consoleTimeout;
    private String errorMessageShow;
    private int retryIntervalSeconds;
    private boolean isEnabledPolling;

    public ResponseObject(Document document) {
        if (document != null) {
            NodeList contentChildren;
            Element contentElement;
            NodeList nodes;
            Element main = document.getDocumentElement();
            String responseCodeAsString = main.getAttribute("ResponseCode");
            String seconds = main.getAttribute("RetryIntervalSeconds");
            String enabled = main.getAttribute("EnablePolling");
            if (!StringUtilities.isEmpty(enabled)) {
                try {
                    this.isEnabledPolling = Boolean.parseBoolean(enabled);
                }
                catch (Exception e) {
                    this.isEnabledPolling = false;
                }
            }
            if (!StringUtilities.isEmpty(seconds)) {
                try {
                    this.retryIntervalSeconds = Integer.parseInt(seconds);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            int responseCodeAsInt = -1;
            try {
                responseCodeAsInt = Integer.parseInt(responseCodeAsString);
                this.responseCode = new ResponseCode(responseCodeAsInt);
            }
            catch (Exception nfe) {
                this.responseCode = new ResponseCode(0x10010001);
            }
            this.errorMessage = main.getAttribute("ErrorMessage");
            try {
                this.errorMessageShow = main.getAttribute("ErrorMessageShow");
            }
            catch (Exception nfe) {
                // empty catch block
            }
            this.checksum = main.getAttribute("Checksum");
            this.ownerId = main.getAttribute("OwnerID");
            this.transactionID = main.getAttribute("TransactionID");
            this.serverTime = main.getAttribute("ServerTime");
            this.consoleTimeout = main.getAttribute("ConsoleTimeOut");
            if (main.hasChildNodes() && (nodes = main.getElementsByTagName("Content")).getLength() > 0 && (contentElement = (Element)nodes.item(0)).hasChildNodes() && (contentChildren = contentElement.getChildNodes()).item(0) instanceof Text) {
                Text contentText = (Text)contentChildren.item(0);
                this.content = contentText.getNodeValue();
            }
        }
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getContent() {
        return this.content;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean getErrorMessageShow() {
        if (this.errorMessageShow == null) {
            return true;
        }
        return Boolean.valueOf(this.errorMessageShow);
    }

    public ResponseCode getResponseCode() {
        return this.responseCode;
    }

    public String getConsoleTimeout() {
        return this.consoleTimeout;
    }

    public String getTransactionID() {
        return this.transactionID;
    }

    public boolean hasError() {
        return this.responseCode.hasErrors();
    }

    public boolean hasErrorMessage() {
        return !StringUtilities.isEmpty(this.errorMessage);
    }

    public AbstractSchema getConfigObjectForElement() throws CommunicationException {
        try {
            if (this.content == null) {
                return null;
            }
            AbstractSchema schema = AbstractSchema.readXML(this.content.trim());
            if (schema instanceof TopLevelObject) {
                MetadataAttributes metadata = new MetadataAttributes(this.checksum);
                if (this.ownerId != null && this.ownerId.length() > 0) {
                    metadata.setOwner(new GUID(this.ownerId));
                }
                ((TopLevelObject)schema).setMetadataAttributes(metadata);
            }
            return schema;
        }
        catch (Exception ex) {
            throw new CommunicationException(ex);
        }
    }

    public String getServerTime() {
        return this.serverTime;
    }

    public int getRetryIntervalSeconds() {
        return this.retryIntervalSeconds;
    }

    public boolean isEnabledPolling() {
        return this.isEnabledPolling;
    }
}

