/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.communicate;

import com.sygate.scm.common.communicate.Communicator;
import com.sygate.scm.common.communicate.SmartCardPkcsKeyStore;
import com.sygate.scm.common.ui.CertificateDlg;
import com.sygate.scm.util.LoggerUtilities;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.JFrame;

public class CustomSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory factory;
    private X509Certificate[] trustedCerts;
    protected boolean smartCardAuth;
    protected boolean popup;
    protected X509Certificate serverCertificate;
    protected String hostName = null;

    public CustomSSLSocketFactory(X509Certificate[] trustedCerts, boolean popup) {
        this(trustedCerts, popup, false, false);
    }

    public CustomSSLSocketFactory(X509Certificate[] trustedCerts, boolean popup, boolean isSmartCardBasedAuth, boolean isAjaxSwingRunning) {
        this.trustedCerts = trustedCerts == null ? null : (X509Certificate[])trustedCerts.clone();
        this.setPopup(popup);
        this.setSmartCardAuth(isSmartCardBasedAuth);
        System.out.println("CustomSSLSocketFactory> Is trustedCerts null ? : " + (trustedCerts == null) + ", popup: " + popup + ", isSmartCardAuth: " + this.smartCardAuth);
        try {
            this.factory = this.isSmartCardAuth() && !isAjaxSwingRunning ? this.createCustomSocketFactoryForCertAuth(trustedCerts) : this.createCustomSocketFactoryForNonCertAuth();
        }
        catch (CancellationException ce) {
            throw ce;
        }
        catch (Throwable ex) {
            System.err.println("CustomSSLSocketFactory> Error While creating custom factory using " + (isSmartCardBasedAuth ? "smartCard." : "own certificate.") + " Exception: " + ex.getMessage());
            LoggerUtilities.logException(ex);
            throw new RuntimeException("Error While creating custom factory using " + (isSmartCardBasedAuth ? "smartCard." : "own certificate."), ex);
        }
    }

    private SSLSocketFactory createCustomSocketFactoryForCertAuth(X509Certificate[] trustedCerts) throws GeneralSecurityException, IOException {
        Map<KeyManagerFactory, KeyStore> keyStore1 = SmartCardPkcsKeyStore.getPkcs11KeyStore();
        if (keyStore1 == null) {
            throw new IOException("Error while loading keystore from smart card. Make sure you smart card is connected to the system.");
        }
        Map.Entry<KeyManagerFactory, KeyStore> keyStoreEntry = keyStore1.entrySet().iterator().next();
        KeyStore keyStore = keyStoreEntry.getValue();
        System.out.println("CustomSSLSocketFactory> createCustomSocketFactoryForCertAuth>> Key store is retrieved from smart card.");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        System.out.println("CustomSSLSocketFactory> createCustomSocketFactoryForCertAuth>> Smartcard keystore  is set to new TrustManagerFactory.");
        SSLContext sslContext = Communicator.getSecureContext();
        System.out.println("CustomSSLSocketFactory> createCustomSocketFactoryForCertAuth>> SSLContext is created.");
        TrustManager[] tma = new TrustManager[]{this.createPivTrustManager(tmf)};
        sslContext.init(SmartCardPkcsKeyStore.getSmartCardPkcsKeyManagers(keyStoreEntry.getKey()), tma, new SecureRandom());
        System.out.println("CustomSSLSocketFactory> createCustomSocketFactoryForCertAuth>> SSLContext is initialized using smart card keystore.");
        return sslContext.getSocketFactory();
    }

    private X509TrustManager createPivTrustManager(TrustManagerFactory pivTmf) {
        X509TrustManager defaultTm = null;
        try {
            TrustManagerFactory trustManagerFactory1 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory1.init((KeyStore)null);
            for (TrustManager tm : trustManagerFactory1.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                defaultTm = (X509TrustManager)tm;
                break;
            }
        }
        catch (Throwable th) {
            System.out.println("CustomSSLSocketFactory> createPivTrustManager>> Unable to retrieve JVMs default X509TrustManager. Exception: " + th.getMessage());
            LoggerUtilities.logException(th);
        }
        X509TrustManager pivTm = null;
        for (TrustManager tm : pivTmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            pivTm = (X509TrustManager)tm;
            break;
        }
        System.out.println("CustomSSLSocketFactory> createPivTrustManager>> pivTm: " + pivTm);
        final X509TrustManager finalDefaultTm = defaultTm;
        final X509TrustManager finalPivTm = pivTm;
        X509TrustManager customTm = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                X509Certificate[] defaultIssuers = null;
                try {
                    System.out.println("CustomSSLSocketFactory> getAcceptedIssuers>> ");
                    defaultIssuers = finalDefaultTm.getAcceptedIssuers();
                    X509Certificate[] pivIssuers = finalPivTm.getAcceptedIssuers();
                    if (defaultIssuers == null || defaultIssuers.length == 0) {
                        System.out.println("CustomSSLSocketFactory> getAcceptedIssuers>> defaultIssuers is null or empty. \n pivIssuers length: " + (String)(pivIssuers == null ? " pivIssuers is null." : "" + pivIssuers.length));
                        return pivIssuers;
                    }
                    System.out.println("CustomSSLSocketFactory> getAcceptedIssuers>> defaultIssuers size: " + defaultIssuers.length);
                    if (pivIssuers == null || pivIssuers.length == 0) {
                        System.out.println("CustomSSLSocketFactory> getAcceptedIssuers>> pivIssuers is null or empty.\n defaultIssuers length: " + defaultIssuers.length);
                        return defaultIssuers;
                    }
                    System.out.println("CustomSSLSocketFactory> getAcceptedIssuers>> pivIssuers size: " + pivIssuers.length);
                    Stream<X509Certificate> streamDefaultIssuers = Arrays.stream(defaultIssuers);
                    Stream<X509Certificate> streamPivIssuers = Arrays.stream(pivIssuers);
                    X509Certificate[] customIssuers = (X509Certificate[])Stream.concat(streamDefaultIssuers, streamPivIssuers).toArray(X509Certificate[]::new);
                    System.out.println("CustomSSLSocketFactory> getAcceptedIssuers>> totalIssuers: " + (String)(customIssuers == null ? "0" : "" + customIssuers.length));
                    if (customIssuers != null) {
                        // empty if block
                    }
                    return customIssuers;
                }
                catch (Throwable ex) {
                    System.out.println("CustomSSLSocketFactory> createPivTrustManager>> Failed to create PIV specific custom X509Certificates. Exception: " + ex.getMessage());
                    LoggerUtilities.logException(ex);
                    return defaultIssuers;
                }
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                block4: {
                    try {
                        finalPivTm.checkServerTrusted(chain, authType);
                    }
                    catch (CertificateException ce1) {
                        try {
                            finalDefaultTm.checkServerTrusted(chain, authType);
                        }
                        catch (CertificateException ce2) {
                            boolean isValid = CustomSSLSocketFactory.this.checkCertificateChain(chain, authType);
                            System.out.println("CustomSSLSocketFactory> checkServerTrusted>> Is certificate valid ? " + isValid);
                            if (isValid) break block4;
                            throw new CertificateException("Got untrusted certificate chain.");
                        }
                    }
                }
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                try {
                    finalPivTm.checkClientTrusted(chain, authType);
                }
                catch (CertificateException ce1) {
                    System.out.println("CustomSSLSocketFactory> checkClientTrusted>> Given client certificate chain is not found in PIV X509TrustManager.\n Exception: " + ce1.getMessage());
                    try {
                        finalDefaultTm.checkClientTrusted(chain, authType);
                    }
                    catch (CertificateException ce2) {
                        System.out.println("CustomSSLSocketFactory> checkClientTrusted>> Given client certificate chain is not found in default(JVMs) X509TrustManager.\n Exception: " + ce1.getMessage());
                    }
                }
            }
        };
        return customTm;
    }

    private boolean checkCertificateChain(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain != null && chain.length > 0) {
            this.serverCertificate = chain[0];
        }
        try {
            boolean isTrusted = this.checkAll();
            if (isTrusted) {
                System.out.println("CustomSSLSocketFactory> checkCertificateChain>> Trusted certificate chain!");
                return true;
            }
        }
        catch (CertificateException ce3) {
            System.out.println("CustomSSLSocketFactory> checkCertificateChain>> Certificate verification failed. Exception: " + ce3.getMessage());
            LoggerUtilities.logException(ce3);
        }
        return false;
    }

    private boolean checkAll() throws CertificateException {
        boolean istrusted = false;
        istrusted = this.isInTrustedChain();
        if (!istrusted) {
            istrusted = this.popupDialog();
        }
        return istrusted;
    }

    protected boolean isInTrustedChain() {
        System.out.println("CustomSSLSocketFactory> isInTrustedChain>> Has trustedCerts: " + (this.trustedCerts == null) + ", has serverCertificate: " + (this.serverCertificate == null));
        if (this.trustedCerts != null && this.serverCertificate != null) {
            for (int i = 0; i < this.trustedCerts.length; ++i) {
                try {
                    if (this.trustedCerts[i] != null && this.trustedCerts[i].equals(this.serverCertificate)) {
                        return true;
                    }
                    System.out.println("CustomSSLSocketFactory> isInTrustedChain>> Given serverCertificate is not present in trusted certificates. \n serverCertificate: " + this.serverCertificate);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("CustomSSLSocketFactory> isInTrustedChain>> Error while verifying server certificate. Exception: " + ex.getMessage());
                    LoggerUtilities.logException(ex);
                }
            }
        }
        return false;
    }

    public boolean popupDialog() {
        if (this.isPopup()) {
            CertificateDlg dlg = new CertificateDlg(new JFrame(), this.serverCertificate, null);
            if (dlg.isOk()) {
                System.out.println("CustomSSLSocketFactory> popupDialog>> Customer opted to trust the Certificate.");
                dlg.dispose();
                return true;
            }
            System.out.println("CustomSSLSocketFactory> popupDialog>> Customer did not opt to trust the Certificate.");
            dlg.dispose();
            this.serverCertificate = null;
        }
        return false;
    }

    public boolean isPopup() {
        return this.popup;
    }

    public void setPopup(boolean popup) {
        this.popup = popup;
    }

    public boolean isSmartCardAuth() {
        return this.smartCardAuth;
    }

    public void setSmartCardAuth(boolean smartCardAuth) {
        this.smartCardAuth = smartCardAuth;
    }

    public void setTrustedChain(X509Certificate[] setTrustedChain) {
        System.out.println("CustomSSLSocketFactory> setTrustedChain>> trustedCerts valid: " + (this.trustedCerts == null));
        this.trustedCerts = this.trustedCerts == null ? null : (X509Certificate[])this.trustedCerts.clone();
    }

    public X509Certificate getServerCertificate() {
        return this.serverCertificate;
    }

    public void setTrustedCert(X509Certificate cert) {
        System.out.println("CustomSSLSocketFactory> setTrustedCert>> Adding new cert to trustedCerts: " + (this.trustedCerts == null));
        if (this.trustedCerts == null) {
            this.trustedCerts = new X509Certificate[1];
            this.trustedCerts[0] = cert;
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    private SSLSocketFactory createCustomSocketFactoryForNonCertAuth() throws NoSuchAlgorithmException, KeyManagementException {
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                boolean isTrusted;
                if (chain != null && chain.length > 0) {
                    CustomSSLSocketFactory.this.serverCertificate = chain[0];
                }
                if (isTrusted = CustomSSLSocketFactory.this.checkAll()) {
                    return;
                }
                throw new CertificateException("Got untrusted certificate chain.");
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        TrustManager[] tma = new TrustManager[]{tm};
        SSLContext sslContext = Communicator.getSecureContext();
        sslContext.init(null, tma, new SecureRandom());
        return sslContext.getSocketFactory();
    }

    @Override
    public Socket createSocket(Socket cs, String host, int port, boolean autoClose) throws IOException {
        this.hostName = host;
        return this.factory.createSocket(cs, host, port, autoClose);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        this.hostName = host;
        return this.factory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        this.hostName = host.getHostName();
        return this.factory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        this.hostName = host;
        return this.factory.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        this.hostName = address.getHostName();
        return this.factory.createSocket(address, port, localAddress, localPort);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

