/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.communicate;

import com.sygate.scm.common.communicate.CommunicationException;
import com.sygate.scm.common.communicate.CommunicatorFactory;
import com.sygate.scm.common.communicate.ResponseObject;
import com.sygate.scm.common.communicate.SSLCommunicatorFactory;
import com.sygate.scm.common.communicate.TimeoutSSLSocketFactory;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.ProxyServerConfig;
import com.sygate.scm.common.monitor.MonitorAgent;
import com.sygate.scm.common.valueobject.ProxySettingsVO;
import com.sygate.scm.util.Base64Util;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CRLException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.bouncycastle.jsse.util.URLConnectionUtil;
import org.bouncycastle.tls.TlsFatalAlert;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Communicator {
    static final String KEYWORD_CANCEL_EXCEPTION = "Caused by: java.util.concurrent.CancellationException";
    private AtomicReference<String> myEventId = new AtomicReference();
    private static Object LOCK_TO_CREATE_CONNECTION = new Object();
    private static CommunicatorFactory m_Factory = null;
    private static final String JSESSIONID = "jsessionid";
    private static Logger logger = Logger.getLogger(Communicator.class.getName());
    private SSLSocketFactory sf;
    private boolean disableHostnameValidation = false;
    private String tomcatCookieValue = null;
    private boolean isTomcatLogin = false;
    public static final int DEFAULT_HTTP_CONNECTION_TIME_OUT = 30000;
    public static final String SERVER_HOME = "catalina.home";
    public static final String SOCKET_WRITE_ERROR = "Software caused connection abort: socket write error";
    private static final String JKS_TRUSTSTORE_PATH = System.getProperties().getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
    private static final String JKS_TRUSTSTORE_PASSWORD = "changeit";
    public static final String KEYSTORE = System.getProperty("catalina.home") + File.separator + "etc" + File.separator + "keystore.jks";
    public static final String STRORE_PASSWD_FILE = System.getProperty("catalina.home") + File.separator + "conf" + File.separator + "server.xml";
    public static final int SO_TIMEOUT_SSL_SOCKET_DEFAULT = 3600000;
    public static final int SO_TIMEOUT_READ_DEFAULT = 600000;
    public static final int SO_TIMEOUT_READ_NOLIMIT = 0;
    public static final SSLSocketFactory TRUST_ALL_FACTORY = Communicator.createTrustAllFactory();
    private static final String FIPS_MODE_PROPERTY = "com.symantec.crypto.fips140mode";
    private static String fipsMode = System.getProperty("com.symantec.crypto.fips140mode");

    public static SSLContext getSecureContext() throws NoSuchAlgorithmException {
        SSLContext context = null;
        try {
            context = SSLContext.getInstance("TLS");
            String msg = MessageFormat.format("Communicator.getSecureContext >>  fipsMode={0}, Provider={1}, ProviderInfo={2}", fipsMode, context.getProvider(), context.getProvider().getInfo());
            logger.log(Level.FINEST, msg);
            return context;
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.SEVERE, "Communicator.getSSLContext >> Failed to create SSL context.", ex);
            throw ex;
        }
    }

    public Communicator(SSLSocketFactory sf) {
        this.setSSLSocketFactory(sf);
    }

    public Communicator() {
    }

    public static void initCookieHandler() {
        CookieHandler cookieHandler = CookieHandler.getDefault();
        if (cookieHandler != null) {
            boolean cookieHandlerInstanceofCookieManager = cookieHandler instanceof CookieManager;
            if (cookieHandlerInstanceofCookieManager) {
                ((CookieManager)cookieHandler).getCookieStore().removeAll();
            } else {
                cookieHandler = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
                CookieHandler.setDefault(cookieHandler);
            }
        }
    }

    public static void setDefaultSSLSocketFactory(SSLSocketFactory sf) {
        HttpsURLConnection.setDefaultSSLSocketFactory(TRUST_ALL_FACTORY);
        if (m_Factory == null) {
            Communicator.setCommunicatorFactory(new SSLCommunicatorFactory(sf));
        } else if (m_Factory instanceof SSLCommunicatorFactory) {
            ((SSLCommunicatorFactory)m_Factory).setSSLSocketFactory(sf);
        }
    }

    public static SSLSocketFactory getTimeoutSSLSocketFactory(SSLSocketFactory sf) {
        String timeout = System.getProperty("scm.console.socket.read.timeout");
        int timeOut = 3600000;
        if (timeout != null && timeout.length() > 0) {
            try {
                timeOut = Integer.parseInt(timeout);
                timeOut *= 60000;
            }
            catch (Throwable ex) {
                timeOut = 3600000;
            }
            TimeoutSSLSocketFactory sfTimeout = new TimeoutSSLSocketFactory(sf, timeOut);
            return sfTimeout;
        }
        return sf;
    }

    public String getTomcatCookie() {
        return this.tomcatCookieValue;
    }

    public void setTomcatLogin(boolean isTomcatLogin) {
        this.isTomcatLogin = isTomcatLogin;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sf;
    }

    public static SSLSocketFactory createTrustAllFactory() {
        try {
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            TrustManager[] tma = new TrustManager[]{tm};
            SSLContext sslContext = Communicator.getSecureContext();
            sslContext.init(null, tma, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
            return null;
        }
    }

    public void setSSLSocketFactory(SSLSocketFactory ssf) {
        this.sf = ssf;
    }

    public void setDisableHostnameValidation(boolean disableHostnameValidation) {
        this.disableHostnameValidation = disableHostnameValidation;
    }

    public static void printProxy() {
        String key = "http.proxySet";
        String value = System.getProperty(key);
        if (value == null) {
            value = "<unknown>";
        }
        if ((value = System.getProperty(key = "http.proxyHost")) == null) {
            value = "<unknown>";
        }
        if ((value = System.getProperty(key = "http.proxyPort")) == null) {
            value = "<unknown>";
        }
        if ((value = System.getProperty(key = "http.nonProxyHosts")) == null) {
            value = "<unknown>";
        }
        if ((value = System.getProperty(key = "https.proxySet")) == null) {
            value = "<unknown>";
        }
        if ((value = System.getProperty(key = "https.proxyHost")) == null) {
            value = "<unknown>";
        }
        if ((value = System.getProperty(key = "https.proxyPort")) == null) {
            value = "<unknown>";
        }
        if ((value = System.getProperty(key = "https.nonProxyHosts")) == null) {
            value = "<unknown>";
        }
    }

    public static void setProxy(String ip, int port) {
        Communicator.setProxy(ip, port, false);
        Communicator.setProxy(ip, port, true);
        Communicator.printProxy();
    }

    public static void setProxy(String ip, int port, boolean secured) {
        System.setProperty(secured ? "https.proxySet" : "http.proxySet", "true");
        System.setProperty(secured ? "https.proxyHost" : "http.proxyHost", ip);
        System.setProperty(secured ? "https.proxyPort" : "http.proxyPort", "" + port);
        Communicator.addNonProxyHost("localhost", secured);
    }

    public static void addNonProxyHosts(String[] exclusiveHosts) {
        if (exclusiveHosts == null || exclusiveHosts.length < 1) {
            return;
        }
        for (String exclusiveHost : exclusiveHosts) {
            if (exclusiveHost == null || exclusiveHost.length() < 1) continue;
            Communicator.addNonProxyHost(exclusiveHost, false);
            Communicator.addNonProxyHost(exclusiveHost, true);
        }
    }

    public static void addNonProxyHost(String exclusiveHost) {
        Communicator.addNonProxyHost(exclusiveHost, false);
        Communicator.addNonProxyHost(exclusiveHost, true);
    }

    public static void addNonProxyHost(String exclusiveHost, boolean secured) {
        if (exclusiveHost == null || exclusiveHost.length() < 1) {
            return;
        }
        String separator = "|";
        String key = secured ? "https.nonProxyHosts" : "http.nonProxyHosts";
        Object hosts = System.getProperty(key);
        if (hosts == null || ((String)hosts).length() < 1) {
            hosts = exclusiveHost;
        } else {
            StringTokenizer token = new StringTokenizer((String)hosts, separator);
            while (token.hasMoreElements()) {
                String host = (String)token.nextElement();
                if (host == null || host.length() < 1 || !host.equalsIgnoreCase(exclusiveHost)) continue;
                return;
            }
            hosts = (String)hosts + separator + exclusiveHost;
        }
        System.setProperty(key, (String)hosts);
    }

    public static void disableProxy() {
        Communicator.disableProxy(false);
        Communicator.disableProxy(true);
        Communicator.printProxy();
    }

    public static void disableProxy(boolean secured) {
        Properties props = System.getProperties();
        props.setProperty(secured ? "https.proxySet" : "http.proxySet", "false");
        props.remove(secured ? "https.proxyHost" : "http.proxyHost");
        props.remove(secured ? "https.proxyPort" : "http.proxyPort");
        props.remove(secured ? "https.nonProxyHosts" : "http.nonProxyHosts");
        System.setProperties(props);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document sendRequest(Hashtable<String, String> session, String url) throws CommunicationException {
        Document document;
        InputStream stream = null;
        try {
            HttpURLConnection conn = this.openConnection(new URL(url));
            conn.setDoOutput(true);
            conn.setRequestMethod("GET");
            if (Utility.isSignatureRequired(url)) {
                Hashtable<String, Object> tempTable = new Hashtable<String, Object>();
                this.convertUrlToHashtable(url, tempTable);
                if (this.getSessionId() != null) {
                    tempTable.put(JSESSIONID.toLowerCase(), this.getSessionId());
                }
                String signatureString = Utility.createRequestSignature(tempTable);
                this.setCookies(session, conn, "REQUESTSIG", signatureString);
            } else {
                this.setCookies(session, conn);
            }
            if (conn.getResponseCode() != 200) {
                throw new Exception("HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage() + ", URL: " + url);
            }
            Communicator.extractCookies(session, conn);
            stream = conn.getInputStream();
            Document document2 = this.getDocumentFromInputStream(stream);
            String eventId = MonitorAgent.getInstance().startEvent("RequestToServer", url);
            MonitorAgent.getInstance().stopEvent(eventId);
            document = document2;
        }
        catch (UnknownHostException uhe) {
            try {
                throw new CommunicationException(0x10020000, 160, uhe);
                catch (IOException ex) {
                    throw new CommunicationException(-2147352576, 3, ex);
                }
                catch (CommunicationException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new CommunicationException(ex);
                }
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(stream);
                throw throwable;
            }
        }
        IOUtilities.closeInputStream(stream);
        return document;
    }

    public void sendRequestAndCheckResponse(Hashtable<String, String> session, String url) throws CommunicationException {
        try {
            HttpURLConnection conn = this.openConnection(new URL(url));
            conn.setDoOutput(true);
            conn.setRequestMethod("GET");
            if (conn.getResponseCode() != 200) {
                throw new Exception("HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage() + ", URL: " + url);
            }
            String eventId = MonitorAgent.getInstance().startEvent("RequestToServer", url);
            MonitorAgent.getInstance().stopEvent(eventId);
        }
        catch (UnknownHostException uhe) {
            throw new CommunicationException(0x10020000, 160, uhe);
        }
        catch (IOException ex) {
            throw new CommunicationException(-2147352576, 3, ex);
        }
        catch (CommunicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommunicationException(ex);
        }
    }

    public InputStream postRequest(Hashtable<String, String> session, String url) throws CommunicationException {
        return this.getPostInputStream(session, url, null);
    }

    public Document postRequest(Hashtable<String, String> session, String url, byte[] data) throws CommunicationException {
        return this.postRequestWithProxy(session, url, data, null);
    }

    public Document postRequestWithProxy(Hashtable<String, String> session, String url, byte[] data, ProxySettingsVO proxySettings) throws CommunicationException {
        return this.postRequestWithProxy(session, url, data, proxySettings, 0);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document postRequestWithProxy(Hashtable<String, String> session, String url, byte[] data, ProxySettingsVO proxySettings, int soReadTimeout) throws CommunicationException {
        Document document;
        InputStream stream = null;
        try {
            Document document2;
            stream = this.getPostInputStreamWithProxy(session, url, data, proxySettings, soReadTimeout);
            document = document2 = this.getDocumentFromInputStream(stream);
        }
        catch (CommunicationException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new CommunicationException(ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(stream);
                throw throwable;
            }
        }
        IOUtilities.closeInputStream(stream);
        return document;
    }

    public InputStream getPostInputStream(Hashtable<String, String> session, String url, byte[] data) throws CommunicationException {
        return this.getPostInputStreamWithProxy(session, url, data, null);
    }

    public InputStream getPostInputStreamWithProxy(Hashtable<String, String> session, String url, byte[] data, ProxySettingsVO proxySettings) throws CommunicationException {
        return this.getPostInputStreamWithProxy(session, url, data, proxySettings, 0);
    }

    public InputStream getPostInputStreamWithProxy(Hashtable<String, String> session, String url, byte[] data, ProxySettingsVO proxySettings, int soReadTimeout) throws CommunicationException {
        try {
            this.myEventId.set(MonitorAgent.getInstance().startEvent("RequestToServer", url + "&& data = " + String.valueOf(data)));
            Proxy proxy = Proxy.NO_PROXY;
            if (proxySettings != null && proxySettings.isEnabled()) {
                InetSocketAddress addr = new InetSocketAddress(proxySettings.getHttpsAddress(), proxySettings.getHttpsPort());
                proxy = new Proxy(Proxy.Type.HTTP, addr);
            }
            HttpURLConnection conn = this.openConnection(new URL(url), proxy);
            if (soReadTimeout > 0) {
                conn.setConnectTimeout(soReadTimeout);
                conn.setReadTimeout(soReadTimeout);
            }
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            if (Utility.isSignatureRequired(url)) {
                Hashtable<String, Object> tempTable = new Hashtable<String, Object>();
                this.convertUrlToHashtable(url, tempTable);
                if (this.getSessionId() != null) {
                    tempTable.put(JSESSIONID.toLowerCase(), this.getSessionId());
                }
                if (data != null && data.length > 0) {
                    char[] dataChar = Utility.byteToChar(data);
                    String dataString = new String(dataChar);
                    this.addDataStringToHashtable(dataString, tempTable);
                }
                String signatureString = Utility.createRequestSignature(tempTable);
                this.setCookies(session, conn, "REQUESTSIG", signatureString);
            } else {
                this.setCookies(session, conn);
            }
            if (data != null) {
                long begin = System.currentTimeMillis();
                OutputStream os = conn.getOutputStream();
                long secondsCost = (System.currentTimeMillis() - begin) / 1000L;
                os.write(data);
                secondsCost = (System.currentTimeMillis() - begin) / 1000L;
                logger.log(Level.INFO, "getPostInputStreamWithProxy>> Do POST HttpURLConnection getOutputStream and write data cost seconds: " + secondsCost);
                os.close();
            }
            long begin = System.currentTimeMillis();
            if (conn.getResponseCode() != 200) {
                throw new Exception("HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage() + ", URL: " + url);
            }
            long secondsCost = (System.currentTimeMillis() - begin) / 1000L;
            logger.log(Level.INFO, "getPostInputStreamWithProxy>> Do POST HttpURLConnection getResponseCode cost seconds: " + secondsCost);
            String cookies = Communicator.extractCookies(session, conn);
            if (cookies != null && this.isTomcatLogin && this.tomcatCookieValue == null) {
                this.tomcatCookieValue = cookies;
                this.isTomcatLogin = false;
            }
            MonitorAgent.getInstance().stopEvent(this.myEventId.get());
            begin = System.currentTimeMillis();
            InputStream inStream = conn.getInputStream();
            secondsCost = (System.currentTimeMillis() - begin) / 1000L;
            logger.log(Level.INFO, "getPostInputStreamWithProxy>> Do POST HttpURLConnection getInputStream cost seconds: " + secondsCost);
            return inStream;
        }
        catch (SSLHandshakeException | TlsFatalAlert ex) {
            if (ex.getCause() instanceof CertificateException) {
                throw new CommunicationException(311492608, 250, ex);
            }
            throw new CommunicationException(ex);
        }
        catch (UnknownHostException uhe) {
            throw new CommunicationException(0x10020000, 160, uhe);
        }
        catch (IOException ex) {
            if (SOCKET_WRITE_ERROR.equalsIgnoreCase(ex.getMessage()) || null != ex.getCause() && SOCKET_WRITE_ERROR.equalsIgnoreCase(ex.getCause().getMessage())) {
                throw new CommunicationException(-67108864, 261, ex);
            }
            throw new CommunicationException(-2147352576, 3, ex);
        }
        catch (CommunicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommunicationException(ex);
        }
    }

    public String postRequestWithProxy(String url, Hashtable<String, Object> parameterTable, ProxySettingsVO proxySettings, int httpTimeOut) throws CommunicationException {
        return this.getPostRequestWithProxy(url, parameterTable, proxySettings, "POST", null, httpTimeOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPostRequestWithProxy(String url, Hashtable<String, Object> parameterTable, ProxySettingsVO proxySettings, String httpMethod, String bearerToken, int httpTimeOut) throws CommunicationException {
        StringBuilder response = new StringBuilder();
        HttpURLConnection conn = null;
        try {
            block24: {
                parameterTable = parameterTable == null ? new Hashtable<String, Object>() : parameterTable;
                this.myEventId.set(MonitorAgent.getInstance().startEvent("RequestToServer", url + "&& data = " + Arrays.toString(parameterTable.entrySet().toArray())));
                Proxy proxy = Proxy.NO_PROXY;
                if (proxySettings != null && proxySettings.isEnabled()) {
                    InetSocketAddress addr = new InetSocketAddress(proxySettings.getHttpsAddress(), proxySettings.getHttpsPort());
                    proxy = new Proxy(Proxy.Type.HTTP, addr);
                }
                conn = this.openConnection(new URL(url), proxy);
                conn.setConnectTimeout(httpTimeOut);
                conn.setReadTimeout(httpTimeOut);
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setUseCaches(false);
                conn.setAllowUserInteraction(false);
                conn.setRequestProperty("Content-Type", "application/json; charset=utf8");
                conn.setRequestProperty("Accept", "application/json");
                if (bearerToken != null && bearerToken.trim().length() > 0) {
                    conn.setRequestProperty("Authorization", "Bearer " + bearerToken);
                }
                conn.setRequestMethod(httpMethod);
                if (Utility.isSignatureRequired(url)) {
                    String signatureValue = Utility.createRequestSignature(parameterTable);
                    conn.setRequestProperty("signature", signatureValue);
                }
                OutputStream outputStream = null;
                try {
                    outputStream = conn.getOutputStream();
                    int payLoadSize = parameterTable.size();
                    if (payLoadSize > 0) {
                        outputStream.write("{".getBytes("UTF-8"));
                        for (Map.Entry<String, Object> entry : parameterTable.entrySet()) {
                            String encodedKey = URLEncoder.encode(entry.getKey(), "UTF-8");
                            outputStream.write(("\"" + encodedKey + "\":").getBytes("UTF-8"));
                            String value = entry.getValue().toString();
                            outputStream.write(("\"" + URLEncoder.encode(value, "UTF-8") + "\"").getBytes("UTF-8"));
                            if (--payLoadSize <= 0) continue;
                            outputStream.write(",".getBytes("UTF-8"));
                        }
                        outputStream.write("}".getBytes("UTF-8"));
                        break block24;
                    }
                    throw new Exception("Empty payload fo REST API login payload: " + parameterTable);
                }
                finally {
                    IOUtilities.closeOutputStream(outputStream);
                }
            }
            if (conn.getResponseCode() != 200) {
                throw new Exception("HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage() + ", URL: " + url);
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            catch (Throwable throwable) {
                IOUtilities.closeReader(reader);
                throw throwable;
            }
            IOUtilities.closeReader(reader);
        }
        catch (SSLHandshakeException ex) {
            throw new CommunicationException(ex);
        }
        catch (UnknownHostException uhe) {
            throw new CommunicationException(0x10020000, 160, uhe);
        }
        catch (IOException ex) {
            if (SOCKET_WRITE_ERROR.equalsIgnoreCase(ex.getMessage()) || null != ex.getCause() && SOCKET_WRITE_ERROR.equalsIgnoreCase(ex.getCause().getMessage())) {
                throw new CommunicationException(-67108864, 261, ex);
            }
            throw new CommunicationException(-2147352576, 3, ex);
        }
        catch (CommunicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommunicationException(ex);
        }
        finally {
            if (this.myEventId.get() != null) {
                MonitorAgent.getInstance().stopEvent(this.myEventId.get());
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return response.toString();
    }

    public Document sendRequest(Hashtable<String, String> session, String url, String keyName, byte[] buf) throws CommunicationException {
        try {
            MimeMultipart multiPart = this.generateMimeMultipart(keyName, buf);
            Hashtable<String, Object> contentTable = new Hashtable<String, Object>();
            contentTable.put(keyName.toLowerCase(), new String(buf, "UTF-8"));
            return this.sendRequest(session, url, (Multipart)multiPart, contentTable);
        }
        catch (CommunicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommunicationException(ex);
        }
    }

    public Document sendRequest(Hashtable<String, String> session, String url, Hashtable<String, byte[]> byteArrayBodyParts) throws CommunicationException {
        try {
            MimeMultipart multiPart = new MimeMultipart("form-data");
            Enumeration<String> keys = byteArrayBodyParts.keys();
            Hashtable<String, Object> contentTable = new Hashtable<String, Object>();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                byte[] buffer = byteArrayBodyParts.get(key);
                contentTable.put(key.toLowerCase(), new String(buffer, "UTF-8"));
                MimeBodyPart bodyPart = new MimeBodyPart(new InternetHeaders(), buffer);
                bodyPart.addHeader("Content-Disposition", "form-data; name=\"" + key + "\"");
                bodyPart.addHeader("Content-Type", "application/binary");
                multiPart.addBodyPart((BodyPart)bodyPart);
            }
            return this.sendRequest(session, url, (Multipart)multiPart, contentTable);
        }
        catch (CommunicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommunicationException(ex);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Document sendRequest(Hashtable<String, String> session, String url, Multipart multiPart, Hashtable<String, Object> contentTable) throws CommunicationException {
        Document document;
        OutputStream os = null;
        InputStream stream = null;
        try {
            this.myEventId.set(MonitorAgent.getInstance().startEvent("RequestToServer", url));
            HttpURLConnection conn = this.openConnection(new URL(url));
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("content-type", multiPart.getContentType());
            if (Utility.isSignatureRequired(url)) {
                Hashtable<String, Object> tempTable = new Hashtable<String, Object>();
                this.convertUrlToHashtable(url, tempTable);
                if (this.getSessionId() != null) {
                    tempTable.put(JSESSIONID.toLowerCase(), this.getSessionId());
                }
                tempTable.putAll(contentTable);
                String signatureString = Utility.createRequestSignature(tempTable);
                this.setCookies(session, conn, "REQUESTSIG", signatureString);
            } else {
                this.setCookies(session, conn);
            }
            os = conn.getOutputStream();
            multiPart.writeTo(os);
            os.flush();
            if (conn.getResponseCode() != 200) {
                throw new Exception("HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage() + ", URL: " + url);
            }
            Communicator.extractCookies(session, conn);
            stream = conn.getInputStream();
            Document document2 = this.getDocumentFromInputStream(stream);
            MonitorAgent.getInstance().stopEvent(this.myEventId.get());
            document = document2;
        }
        catch (UnknownHostException uhe) {
            try {
                System.out.println("sendRequest>> UnknownHostException: " + uhe.getMessage());
                LoggerUtilities.logException(uhe);
                throw new CommunicationException(0x10020000, 160, uhe);
                catch (IOException ex) {
                    LoggerUtilities.logException(ex);
                    if (Utility.checkException(ex, KEYWORD_CANCEL_EXCEPTION)) {
                        throw new CommunicationException(-16777216, 295);
                    }
                    throw new CommunicationException(-2147352576, 3, ex);
                }
                catch (CommunicationException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    System.out.println("sendRequest>> Exception: " + ex.getMessage());
                    LoggerUtilities.logException(ex);
                    throw new CommunicationException(ex);
                }
            }
            catch (Throwable throwable) {
                IOUtilities.closeOutputStream(os);
                IOUtilities.closeInputStream(stream);
                throw throwable;
            }
        }
        IOUtilities.closeOutputStream(os);
        IOUtilities.closeInputStream(stream);
        return document;
    }

    private String getCookies(Hashtable<String, ?> ht) {
        StringBuffer cookie = new StringBuffer();
        boolean isFirstCookie = true;
        Enumeration<String> enumeration = ht.keys();
        while (enumeration.hasMoreElements()) {
            String value = enumeration.nextElement();
            if (isFirstCookie) {
                isFirstCookie = false;
            } else {
                cookie.append("; ");
            }
            cookie.append(value);
        }
        return cookie.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDocumentFromInputStream(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        Document document;
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(is);
            document = XMLHelper.parse(bis);
        }
        catch (Throwable throwable) {
            IOUtilities.closeInputStream(bis);
            throw throwable;
        }
        IOUtilities.closeInputStream(bis);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getRequestInputStreamWithProxy(Hashtable<String, String> session, String url, String proxyServerAddress, int proxyServerPort) throws CommunicationException {
        Object object = LOCK_TO_CREATE_CONNECTION;
        synchronized (object) {
            Proxy proxy = null;
            if (proxyServerAddress != null && proxyServerAddress.length() > 0 && proxyServerPort >= 0) {
                InetSocketAddress addr = new InetSocketAddress(proxyServerAddress, proxyServerPort);
                proxy = new Proxy(Proxy.Type.HTTP, addr);
            }
            InputStream input = this.getRequestInputStream(session, url, proxy, null, null, null);
            return input;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getRequestInputStreamWithAuthProxy(Hashtable<String, String> session, String url, String proxyServerAddress, int proxyServerPort, String proxyServerUser, String proxyServerPwd, Integer proxyType, Authenticator authenticator, int soReadTimeout) throws CommunicationException {
        Object object = LOCK_TO_CREATE_CONNECTION;
        synchronized (object) {
            Proxy proxy = null;
            if (proxyServerAddress != null && proxyServerAddress.length() > 0 && proxyServerPort >= 0) {
                InetSocketAddress addr = new InetSocketAddress(proxyServerAddress, proxyServerPort);
                proxy = new Proxy(Proxy.Type.HTTP, addr);
            }
            Authenticator.setDefault(authenticator);
            String type = ProxyServerConfig.NTLM.equals(proxyType) ? "NTLM " : "BASIC ";
            InputStream input = this.getRequestInputStream(session, url, proxy, proxyServerUser, proxyServerPwd, type, soReadTimeout);
            Authenticator.setDefault(null);
            return input;
        }
    }

    private InputStream getRequestInputStream(Hashtable<String, String> session, String url, Proxy proxy, String proxyUser, String proxyPwd, String proxyType) throws CommunicationException {
        return this.getRequestInputStream(session, url, proxy, proxyUser, proxyPwd, proxyType, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getRequestInputStream(Hashtable<String, String> session, String url, Proxy proxy, String proxyUser, String proxyPwd, String proxyType, int soReadTimeout) throws CommunicationException {
        if (proxy == null) {
            return this.getRequestInputStream(session, url, soReadTimeout);
        }
        InputStream is = null;
        Object object = LOCK_TO_CREATE_CONNECTION;
        synchronized (object) {
            try {
                HttpURLConnection conn = this.openConnectionForGetRequest(url, soReadTimeout, proxyUser, proxyPwd, proxyType);
                if (Utility.isSignatureRequired(url)) {
                    Hashtable<String, Object> tempTable = new Hashtable<String, Object>();
                    this.convertUrlToHashtable(url, tempTable);
                    if (this.getSessionId() != null) {
                        tempTable.put(JSESSIONID.toLowerCase(), this.getSessionId());
                    }
                    String signatureString = Utility.createRequestSignature(tempTable);
                    this.setCookies(session, conn, "REQUESTSIG", signatureString);
                } else {
                    this.setCookies(session, conn);
                }
                this.verifyGetResponse(conn, url);
                Communicator.extractCookies(session, conn);
                InputStream inputStream = conn.getInputStream();
                return inputStream;
            }
            catch (UnknownHostException uhe) {
                throw new CommunicationException(0x10020000, 160, uhe);
            }
            catch (IOException ex) {
                throw new CommunicationException(-2147352576, 3, ex);
            }
            catch (CommunicationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CommunicationException(ex);
            }
            finally {
                IOUtilities.closeInputStream(is);
            }
        }
    }

    public HttpURLConnection getConnectionWithAuthProxy(Hashtable<String, String> session, String url, String proxyServerAddress, int proxyServerPort, String proxyServerUser, String proxyServerPwd, Integer proxyType, Authenticator authenticator) throws CommunicationException {
        Proxy proxy = null;
        if (proxyServerAddress != null && proxyServerAddress.length() > 0 && proxyServerPort >= 0) {
            InetSocketAddress addr = new InetSocketAddress(proxyServerAddress, proxyServerPort);
            proxy = new Proxy(Proxy.Type.HTTP, addr);
        }
        Authenticator.setDefault(authenticator);
        String type = ProxyServerConfig.NTLM.equals(proxyType) ? "NTLM " : "BASIC ";
        HttpURLConnection conn = this.getConnectionWithAuthProxy(session, url, proxy, proxyServerUser, proxyServerPwd, type);
        Authenticator.setDefault(null);
        return conn;
    }

    private HttpURLConnection getConnectionWithAuthProxy(Hashtable<String, String> session, String url, Proxy proxy, String proxyUser, String proxyPwd, String proxyType) throws CommunicationException {
        try {
            if (proxy == null) {
                return this.openConnection(new URL(url));
            }
            HttpURLConnection conn = this.openConnection(new URL(url), proxy);
            if (proxyUser != null && proxyPwd != null) {
                conn.setRequestProperty("Proxy-Authorization", proxyType + Base64Util.encodeString((proxyUser + ":" + proxyPwd).getBytes(Charset.defaultCharset())));
                conn.setRequestProperty("Pragma", "no-cache");
            }
            return conn;
        }
        catch (UnknownHostException uhe) {
            throw new CommunicationException(0x10020000, 160, uhe);
        }
        catch (IOException ex) {
            throw new CommunicationException(-2147352576, 3, ex);
        }
        catch (Exception ex) {
            throw new CommunicationException(ex);
        }
    }

    @Deprecated
    public InputStream getRequestInputStream(Hashtable<String, String> session, String url) throws CommunicationException {
        return this.getRequestInputStream(session, url, 0);
    }

    private HttpURLConnection openConnectionForGetRequest(String url, int soReadTimeout, String proxyUser, String proxyPwd, String proxyType) throws IOException {
        HttpURLConnection conn = this.openConnection(new URL(url));
        if (soReadTimeout > 0) {
            conn.setReadTimeout(soReadTimeout);
        }
        if (proxyUser != null && proxyPwd != null) {
            conn.setRequestProperty("Proxy-Authorization", proxyType + Base64Util.encodeString((proxyUser + ":" + proxyPwd).getBytes(Charset.defaultCharset())));
            conn.setRequestProperty("Pragma", "no-cache");
        }
        conn.setRequestMethod("GET");
        return conn;
    }

    private void verifyGetResponse(HttpURLConnection conn, String url) throws IOException, CommunicationException, ParserConfigurationException, SAXException {
        if (conn.getResponseCode() != 200) {
            if (conn.getResponseCode() == 444) {
                InputStream is = conn.getErrorStream();
                if (is != null) {
                    Document document = this.getDocumentFromInputStream(is);
                    ResponseObject respObj = new ResponseObject(document);
                    throw new CommunicationException(respObj.getResponseCode().getReturnCode() & 0xFFFF0000, respObj.getResponseCode().getReturnCode() & 0xFFFF);
                }
                throw new IOException("HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage() + ", URL: " + url);
            }
            throw new IOException("HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage() + ", URL: " + url);
        }
    }

    private boolean exceptionCausedByInvalidCert(Exception ex) {
        Throwable cause = ex.getCause();
        return cause instanceof CertificateException || cause instanceof CertPathBuilderException || cause instanceof CertPathValidatorException || cause instanceof CRLException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getRequestInputStreamImpl(Hashtable<String, String> session, String url, int soReadTimeout) throws CommunicationException {
        InputStream is = null;
        Object object = LOCK_TO_CREATE_CONNECTION;
        synchronized (object) {
            try {
                HttpURLConnection conn = this.openConnectionForGetRequest(url, soReadTimeout, null, null, null);
                if (Utility.isSignatureRequired(url)) {
                    Hashtable<String, Object> tempTable = new Hashtable<String, Object>();
                    this.convertUrlToHashtable(url, tempTable);
                    if (this.getSessionId() != null) {
                        tempTable.put(JSESSIONID.toLowerCase(), this.getSessionId());
                    }
                    String signatureString = Utility.createRequestSignature(tempTable);
                    this.setCookies(session, conn, "REQUESTSIG", signatureString);
                } else {
                    this.setCookies(session, conn);
                }
                this.verifyGetResponse(conn, url);
                Communicator.extractCookies(session, conn);
                InputStream inputStream = conn.getInputStream();
                return inputStream;
            }
            catch (UnknownHostException uhe) {
                throw new CommunicationException(0x10020000, 160, uhe);
            }
            catch (IOException ex) {
                if (this.exceptionCausedByInvalidCert(ex)) {
                    throw new CommunicationException(311427072, 247, ex);
                }
                throw new CommunicationException(-2147352576, 3, ex);
            }
            catch (CommunicationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CommunicationException(ex);
            }
            finally {
                IOUtilities.closeInputStream(is);
            }
        }
    }

    public InputStream getRequestInputStream(Hashtable<String, String> session, String url, int soReadTimeout) throws CommunicationException {
        return this.getRequestInputStreamImpl(session, url, soReadTimeout);
    }

    public InputStream getResponse(Hashtable<String, String> session, String url, int readTimeoutInMillSec) throws CommunicationException, NoSuchAlgorithmException {
        HttpURLConnection connection = null;
        if (readTimeoutInMillSec == 0) {
            throw new CommunicationException(-535429120, 11);
        }
        try {
            connection = this.openConnection(new URL(url));
            connection.setRequestMethod("GET");
            if (Utility.isSignatureRequired(url)) {
                Hashtable<String, Object> tempTable = new Hashtable<String, Object>();
                this.convertUrlToHashtable(url, tempTable);
                if (this.getSessionId() != null) {
                    tempTable.put(JSESSIONID.toLowerCase(), this.getSessionId());
                }
                String signatureString = Utility.createRequestSignature(tempTable);
                this.setCookies(session, connection, "REQUESTSIG", signatureString);
            } else {
                this.setCookies(session, connection);
            }
            connection.setReadTimeout(readTimeoutInMillSec);
            return this.getResponse(session, url, connection);
        }
        catch (UnknownHostException uhe) {
            throw new CommunicationException(0x10020000, 160, uhe);
        }
        catch (IOException ex) {
            throw new CommunicationException(-2147352576, 3, ex);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document sendFileRequest(String destinationFilePath, Hashtable<String, String> session, String loggedInURL, String urlParamStr, boolean forReplication, int replicationSocketTimeout) throws CommunicationException {
        ResponseObject respObj;
        String url;
        ResponseObject document;
        OutputStream bos;
        OutputStream fos;
        InputStream bis;
        InputStream stream;
        InputStream is;
        HttpURLConnection conn;
        SSLSocketFactory oldFactory;
        block24: {
            Object tempTable;
            oldFactory = null;
            conn = null;
            is = null;
            stream = null;
            bis = null;
            fos = null;
            bos = null;
            document = null;
            url = loggedInURL + urlParamStr;
            conn = this.openConnection(new URL(url));
            if (forReplication && conn instanceof HttpsURLConnection) {
                oldFactory = ((HttpsURLConnection)conn).getSSLSocketFactory();
                ((HttpsURLConnection)conn).setSSLSocketFactory(new TimeoutSSLSocketFactory(oldFactory, replicationSocketTimeout));
            }
            conn.setDoOutput(true);
            conn.setRequestMethod("GET");
            if (Utility.isSignatureRequired(url)) {
                tempTable = new Hashtable<String, Object>();
                this.convertUrlToHashtable(url, (Hashtable<String, Object>)tempTable);
                if (this.getSessionId() != null) {
                    ((Hashtable)tempTable).put((String)JSESSIONID.toLowerCase(), (Object)this.getSessionId());
                }
                String signatureString = Utility.createRequestSignature(tempTable);
                this.setCookies(session, conn, "REQUESTSIG", signatureString);
            } else {
                this.setCookies(session, conn);
            }
            if (conn.getResponseCode() != 202) break block24;
            tempTable = this.getDocumentFromInputStream(conn.getInputStream());
            try {
                if (oldFactory != null) {
                    ((HttpsURLConnection)conn).setSSLSocketFactory(oldFactory);
                }
            }
            catch (Throwable ex) {
                LoggerUtilities.logException(ex);
            }
            IOUtilities.closeInputStream(is);
            IOUtilities.closeOutputStream(bos);
            IOUtilities.closeOutputStream(fos);
            IOUtilities.closeInputStream(bis);
            IOUtilities.closeInputStream(stream);
            return tempTable;
        }
        if (conn.getResponseCode() != 200) {
            if (conn.getResponseCode() == 444 && (is = conn.getErrorStream()) != null) {
                respObj = new ResponseObject(this.getDocumentFromInputStream(is));
                throw new CommunicationException(respObj.getResponseCode().getReturnCode() & 0xFFFF0000, respObj.getResponseCode().getReturnCode() & 0xFFFF);
            }
            throw new Exception("HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage() + ", URL: " + url);
        }
        respObj = document;
        try {
            if (oldFactory != null) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(oldFactory);
            }
        }
        catch (Throwable ex) {
            LoggerUtilities.logException(ex);
        }
        IOUtilities.closeInputStream(is);
        IOUtilities.closeOutputStream(bos);
        IOUtilities.closeOutputStream(fos);
        IOUtilities.closeInputStream(bis);
        IOUtilities.closeInputStream(stream);
        return respObj;
        catch (UnknownHostException uhe) {
            try {
                throw new CommunicationException(0x10020000, 160, uhe);
                catch (IOException ex) {
                    if (ex instanceof SocketTimeoutException) {
                        throw new CommunicationException(-805240832, 130, ex);
                    }
                    throw new CommunicationException(-2147352576, 3, ex);
                }
                catch (CommunicationException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new CommunicationException(ex);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oldFactory != null) {
                        ((HttpsURLConnection)conn).setSSLSocketFactory(oldFactory);
                    }
                }
                catch (Throwable ex) {
                    LoggerUtilities.logException(ex);
                }
                IOUtilities.closeInputStream(is);
                IOUtilities.closeOutputStream(bos);
                IOUtilities.closeOutputStream(fos);
                IOUtilities.closeInputStream(bis);
                IOUtilities.closeInputStream(stream);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document sendRequestedDocument(String destinationFilePath, Hashtable<String, String> session, String loggedInURL, String urlParamStr, int replicationSocketTimeout) throws CommunicationException {
        BufferedOutputStream bos;
        FileOutputStream fos;
        BufferedInputStream bis;
        InputStream stream;
        InputStream is;
        HttpURLConnection conn;
        SSLSocketFactory oldFactory;
        block22: {
            int count;
            oldFactory = null;
            conn = null;
            is = null;
            stream = null;
            bis = null;
            fos = null;
            bos = null;
            String url = loggedInURL + urlParamStr;
            conn = this.openConnection(new URL(url));
            if (conn instanceof HttpsURLConnection) {
                oldFactory = ((HttpsURLConnection)conn).getSSLSocketFactory();
                ((HttpsURLConnection)conn).setSSLSocketFactory(new TimeoutSSLSocketFactory(oldFactory, replicationSocketTimeout));
            }
            conn.setDoOutput(true);
            conn.setRequestMethod("GET");
            if (Utility.isSignatureRequired(url)) {
                Hashtable<String, Object> tempTable = new Hashtable<String, Object>();
                this.convertUrlToHashtable(url, tempTable);
                if (this.getSessionId() != null) {
                    tempTable.put(JSESSIONID.toLowerCase(), this.getSessionId());
                }
                String signatureString = Utility.createRequestSignature(tempTable);
                this.setCookies(session, conn, "REQUESTSIG", signatureString);
            } else {
                this.setCookies(session, conn);
            }
            Communicator.extractCookies(session, conn);
            int buffer = 2048;
            byte[] data = new byte[2048];
            stream = conn.getInputStream();
            if (conn.getContentType() == null || !conn.getContentType().equalsIgnoreCase("application/binary")) break block22;
            bis = new BufferedInputStream(stream);
            fos = new FileOutputStream(destinationFilePath);
            bos = new BufferedOutputStream(fos);
            while ((count = bis.read(data, 0, 2048)) != -1) {
                bos.write(data, 0, count);
            }
            bos.flush();
            Document document = null;
            try {
                if (oldFactory != null) {
                    ((HttpsURLConnection)conn).setSSLSocketFactory(oldFactory);
                }
            }
            catch (Throwable ex) {
                LoggerUtilities.logException(ex);
            }
            IOUtilities.closeInputStream(is);
            IOUtilities.closeOutputStream(bos);
            IOUtilities.closeOutputStream(fos);
            IOUtilities.closeInputStream(bis);
            IOUtilities.closeInputStream(stream);
            return document;
        }
        Document document = this.getDocumentFromInputStream(stream);
        try {
            if (oldFactory != null) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(oldFactory);
            }
        }
        catch (Throwable ex) {
            LoggerUtilities.logException(ex);
        }
        IOUtilities.closeInputStream(is);
        IOUtilities.closeOutputStream(bos);
        IOUtilities.closeOutputStream(fos);
        IOUtilities.closeInputStream(bis);
        IOUtilities.closeInputStream(stream);
        return document;
        catch (UnknownHostException uhe) {
            try {
                throw new CommunicationException(0x10020000, 160, uhe);
                catch (IOException ex) {
                    if (ex instanceof SocketTimeoutException) {
                        throw new CommunicationException(-805240832, 130, ex);
                    }
                    throw new CommunicationException(-2147352576, 3, ex);
                }
                catch (Exception ex) {
                    throw new CommunicationException(ex);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oldFactory != null) {
                        ((HttpsURLConnection)conn).setSSLSocketFactory(oldFactory);
                    }
                }
                catch (Throwable ex) {
                    LoggerUtilities.logException(ex);
                }
                IOUtilities.closeInputStream(is);
                IOUtilities.closeOutputStream(bos);
                IOUtilities.closeOutputStream(fos);
                IOUtilities.closeInputStream(bis);
                IOUtilities.closeInputStream(stream);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document sendFileRequest(String destinationFilePath, Hashtable<String, String> session, String url, boolean forReplication, String keyName, byte[] buf, HashMap<String, String> map, int replicationSocketTimeout) throws CommunicationException {
        Document document;
        BufferedOutputStream bos;
        FileOutputStream fos;
        BufferedInputStream bis;
        InputStream stream;
        OutputStream os;
        InputStream is;
        HttpURLConnection conn;
        SSLSocketFactory oldFactory;
        block33: {
            int count;
            block32: {
                Object tempTable;
                oldFactory = null;
                conn = null;
                is = null;
                os = null;
                stream = null;
                bis = null;
                fos = null;
                bos = null;
                conn = this.openConnection(new URL(url));
                if (forReplication && conn instanceof HttpsURLConnection) {
                    oldFactory = ((HttpsURLConnection)conn).getSSLSocketFactory();
                    ((HttpsURLConnection)conn).setSSLSocketFactory(new TimeoutSSLSocketFactory(oldFactory, replicationSocketTimeout));
                }
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                MimeMultipart multiPart = this.generateMimeMultipart(keyName, buf);
                conn.setRequestProperty("content-type", multiPart.getContentType());
                if (Utility.isSignatureRequired(url)) {
                    tempTable = new Hashtable<String, Object>();
                    this.convertUrlToHashtable(url, (Hashtable<String, Object>)tempTable);
                    if (this.getSessionId() != null) {
                        ((Hashtable)tempTable).put((String)JSESSIONID.toLowerCase(), (Object)this.getSessionId());
                    }
                    ((Hashtable)tempTable).put((String)keyName.toLowerCase(), (Object)new String(buf, "UTF-8"));
                    String signatureString = Utility.createRequestSignature(tempTable);
                    this.setCookies(session, conn, "REQUESTSIG", signatureString);
                } else {
                    this.setCookies(session, conn);
                }
                os = conn.getOutputStream();
                multiPart.writeTo(os);
                os.flush();
                if (conn.getResponseCode() != 202) break block32;
                tempTable = this.getDocumentFromInputStream(conn.getInputStream());
                try {
                    if (oldFactory != null) {
                        ((HttpsURLConnection)conn).setSSLSocketFactory(oldFactory);
                    }
                }
                catch (Throwable ex) {
                    LoggerUtilities.logException(ex);
                }
                IOUtilities.closeInputStream(is);
                IOUtilities.closeOutputStream(os);
                IOUtilities.closeOutputStream(bos);
                IOUtilities.closeOutputStream(fos);
                IOUtilities.closeInputStream(bis);
                IOUtilities.closeInputStream(stream);
                return tempTable;
            }
            if (conn.getResponseCode() != 200) {
                if (conn.getResponseCode() == 444 && (is = conn.getErrorStream()) != null) {
                    Document document2 = this.getDocumentFromInputStream(is);
                    ResponseObject respObj = new ResponseObject(document2);
                    throw new CommunicationException(respObj.getResponseCode().getReturnCode() & 0xFFFF0000, respObj.getResponseCode().getReturnCode() & 0xFFFF);
                }
                throw new Exception("HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage() + ", URL: " + url);
            }
            Communicator.extractCookies(session, conn);
            if (map != null) {
                long contentLength = conn.getContentLength();
                long diskSpaceSevere = Long.parseLong(map.get("diskSpaceSevere"));
                long diskSpaceWarning = Long.parseLong(map.get("diskSpaceWarning"));
                long remainingSpace = Utility.getUsableSpace(destinationFilePath) - contentLength;
                if (remainingSpace < diskSpaceSevere) {
                    map.put("level", "severe");
                    throw new Exception("There is not enough disk space on data folder! Content length is " + contentLength);
                }
                if (remainingSpace < diskSpaceWarning) {
                    map.put("level", "warning");
                }
            }
            int buffer = 2048;
            byte[] data = new byte[2048];
            stream = conn.getInputStream();
            if (conn.getContentType() == null || !conn.getContentType().equalsIgnoreCase("application/binary")) break block33;
            bis = new BufferedInputStream(stream);
            fos = new FileOutputStream(destinationFilePath);
            bos = new BufferedOutputStream(fos);
            while ((count = bis.read(data, 0, 2048)) != -1) {
                bos.write(data, 0, count);
            }
            bos.flush();
            Document document3 = null;
            try {
                if (oldFactory != null) {
                    ((HttpsURLConnection)conn).setSSLSocketFactory(oldFactory);
                }
            }
            catch (Throwable ex) {
                LoggerUtilities.logException(ex);
            }
            IOUtilities.closeInputStream(is);
            IOUtilities.closeOutputStream(os);
            IOUtilities.closeOutputStream(bos);
            IOUtilities.closeOutputStream(fos);
            IOUtilities.closeInputStream(bis);
            IOUtilities.closeInputStream(stream);
            return document3;
        }
        Document document4 = document = this.getDocumentFromInputStream(stream);
        try {
            if (oldFactory != null) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(oldFactory);
            }
        }
        catch (Throwable ex) {
            LoggerUtilities.logException(ex);
        }
        IOUtilities.closeInputStream(is);
        IOUtilities.closeOutputStream(os);
        IOUtilities.closeOutputStream(bos);
        IOUtilities.closeOutputStream(fos);
        IOUtilities.closeInputStream(bis);
        IOUtilities.closeInputStream(stream);
        return document4;
        catch (UnknownHostException uhe) {
            try {
                throw new CommunicationException(0x10020000, 160, uhe);
                catch (IOException ex) {
                    if (ex instanceof SocketTimeoutException) {
                        throw new CommunicationException(-805240832, 130, ex);
                    }
                    throw new CommunicationException(-2147352576, 3, ex);
                }
                catch (CommunicationException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new CommunicationException(ex);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oldFactory != null) {
                        ((HttpsURLConnection)conn).setSSLSocketFactory(oldFactory);
                    }
                }
                catch (Throwable ex) {
                    LoggerUtilities.logException(ex);
                }
                IOUtilities.closeInputStream(is);
                IOUtilities.closeOutputStream(os);
                IOUtilities.closeOutputStream(bos);
                IOUtilities.closeOutputStream(fos);
                IOUtilities.closeInputStream(bis);
                IOUtilities.closeInputStream(stream);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document sendRequestUploadFile(Hashtable<String, String> session, String url, File file) throws CommunicationException {
        HttpURLConnection conn = null;
        InputStream stream = null;
        Document document = null;
        try {
            conn = this.openConnection(new URL(url));
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setFixedLengthStreamingMode(file.length());
            logger.info("Communicator >> sendRequestUploadFile: file length: " + file.length());
            conn.setRequestProperty("content-type", "BinaryFile");
            conn.setRequestProperty("file-name", file.getName());
            if (Utility.isSignatureRequired(url)) {
                Hashtable<String, Object> tempTable = new Hashtable<String, Object>();
                this.convertUrlToHashtable(url, tempTable);
                if (this.getSessionId() != null) {
                    tempTable.put(JSESSIONID.toLowerCase(), this.getSessionId());
                }
                String signatureString = Utility.createRequestSignature(tempTable);
                this.setCookies(session, conn, "REQUESTSIG", signatureString);
            } else {
                this.setCookies(session, conn);
            }
            try (OutputStream os = conn.getOutputStream();
                 FileInputStream fis = new FileInputStream(file);
                 BufferedInputStream bis = new BufferedInputStream(fis);){
                byte[] buf = new byte[1024];
                int read = 0;
                long totalWritten = 0L;
                while ((read = bis.read(buf, 0, 1024)) > 0) {
                    os.write(buf, 0, read);
                    totalWritten += (long)read;
                }
                logger.info("Communicator >> sendRequestUploadFile: totalWritten length: " + totalWritten);
                if (totalWritten != file.length()) {
                    logger.severe("Communicator >> sendRequestUploadFile, Error: the total written length does not match file size!");
                }
            }
            if (conn.getResponseCode() != 200) {
                if (conn.getResponseCode() != 369360896) throw new Exception("HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage() + ", URL: " + url);
                throw new CommunicationException(369360896, 99);
            }
            Communicator.extractCookies(session, conn);
            stream = conn.getInputStream();
            document = this.getDocumentFromInputStream(stream);
        }
        catch (UnknownHostException uhe) {
            try {
                throw new CommunicationException(0x10020000, 160, uhe);
                catch (IOException ex) {
                    throw new CommunicationException(-2147352576, 3, ex);
                }
                catch (CommunicationException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new CommunicationException(ex);
                }
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(stream);
                throw throwable;
            }
        }
        IOUtilities.closeInputStream(stream);
        return document;
    }

    public MimeMultipart generateMimeMultipart(String keyName, byte[] buf) throws CommunicationException {
        try {
            MimeMultipart multiPart = new MimeMultipart("form-data");
            MimeBodyPart bodyPart = new MimeBodyPart(new InternetHeaders(), buf);
            bodyPart.addHeader("Content-Disposition", "form-data; name=\"" + keyName + "\"");
            bodyPart.addHeader("Content-Type", "application/binary");
            multiPart.addBodyPart((BodyPart)bodyPart);
            return multiPart;
        }
        catch (Throwable ex) {
            throw new CommunicationException(ex);
        }
    }

    public InputStream getRequestInputStream(Hashtable<String, String> session, String url, String keyName, byte[] buf) throws CommunicationException {
        MimeMultipart multiPart = this.generateMimeMultipart(keyName, buf);
        Hashtable<String, Object> contentTable = new Hashtable<String, Object>();
        try {
            contentTable.put(keyName.toLowerCase(), new String(buf, "UTF-8"));
        }
        catch (UnsupportedEncodingException ue) {
            LoggerUtilities.logException(ue);
        }
        return this.getRequestInputStream(session, url, (Multipart)multiPart, contentTable);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getRequestInputStream(Hashtable<String, String> session, String url, Multipart multiPart, Hashtable<String, Object> contentTable) throws CommunicationException {
        InputStream is = null;
        OutputStream os = null;
        Object object = LOCK_TO_CREATE_CONNECTION;
        synchronized (object) {
            InputStream inputStream;
            try {
                HttpURLConnection conn = this.openConnection(new URL(url));
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("content-type", multiPart.getContentType());
                if (Utility.isSignatureRequired(url)) {
                    Hashtable<String, Object> tempTable = new Hashtable<String, Object>();
                    this.convertUrlToHashtable(url, tempTable);
                    if (this.getSessionId() != null) {
                        tempTable.put(JSESSIONID.toLowerCase(), this.getSessionId());
                    }
                    tempTable.putAll(contentTable);
                    String signatureString = Utility.createRequestSignature(tempTable);
                    this.setCookies(session, conn, "REQUESTSIG", signatureString);
                } else {
                    this.setCookies(session, conn);
                }
                os = conn.getOutputStream();
                multiPart.writeTo(os);
                os.flush();
                if (conn.getResponseCode() != 200) {
                    if (conn.getResponseCode() != 444) {
                        throw new Exception("HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage() + ", URL: " + url);
                    }
                    is = conn.getErrorStream();
                    if (is != null) {
                        Document document = this.getDocumentFromInputStream(is);
                        ResponseObject respObj = new ResponseObject(document);
                        throw new CommunicationException(respObj.getResponseCode().getReturnCode(), 1);
                    }
                    throw new Exception("HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage() + ", URL: " + url);
                }
                Communicator.extractCookies(session, conn);
                inputStream = conn.getInputStream();
            }
            catch (CommunicationException ex) {
                try {
                    throw ex;
                    catch (UnknownHostException uhe) {
                        throw new CommunicationException(0x10020000, 160, uhe);
                    }
                    catch (IOException ex2) {
                        throw new CommunicationException(-2147352576, 3, ex2);
                    }
                    catch (Exception ex3) {
                        throw new CommunicationException(ex3);
                    }
                }
                catch (Throwable throwable) {
                    IOUtilities.closeInputStream(is);
                    IOUtilities.closeOutputStream(os);
                    throw throwable;
                }
            }
            IOUtilities.closeInputStream(is);
            IOUtilities.closeOutputStream(os);
            return inputStream;
        }
    }

    HttpURLConnection openConnection(URL url) throws IOException {
        this.doThreadCheck();
        HttpURLConnection conn = (HttpURLConnection)new URLConnectionUtil(this.sf).openConnection(url);
        if (conn instanceof HttpsURLConnection && this.disableHostnameValidation) {
            ((HttpsURLConnection)conn).setHostnameVerifier((hostname, session) -> true);
        }
        return conn;
    }

    HttpURLConnection openConnection(URL url, Proxy proxy) throws IOException {
        this.doThreadCheck();
        HttpURLConnection conn = (HttpURLConnection)new URLConnectionUtil(this.sf).openConnection(url, proxy);
        if (conn instanceof HttpsURLConnection && this.disableHostnameValidation) {
            ((HttpsURLConnection)conn).setHostnameVerifier((hostname, session) -> true);
        }
        return conn;
    }

    private void doThreadCheck() {
        if (Boolean.getBoolean("scm.common.communicator.do_thread_check") && SwingUtilities.isEventDispatchThread()) {
            IllegalArgumentException ex = new IllegalArgumentException("Don't do server calls on the EventQueue thread");
            LoggerUtilities.logException(ex);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getResponse(Hashtable<String, String> session, String url, HttpURLConnection conn) throws CommunicationException {
        InputStream document2222222;
        InputStream errorStream = null;
        try {
            if (conn.getResponseCode() < 200 || conn.getResponseCode() > 299) {
                if (conn.getResponseCode() != 444) {
                    throw new Exception("HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage() + ", URL: " + url);
                }
                errorStream = conn.getErrorStream();
                if (errorStream != null) {
                    Document document2222222 = this.getDocumentFromInputStream(errorStream);
                    ResponseObject respObj = new ResponseObject(document2222222);
                    throw new CommunicationException(respObj.getResponseCode().getReturnCode() & 0xFFFF0000, respObj.getResponseCode().getReturnCode() & 0xFFFF);
                }
                throw new Exception("HTTP " + conn.getResponseCode() + " " + conn.getResponseMessage() + ", URL: " + url);
            }
            Communicator.extractCookies(session, conn);
            document2222222 = conn.getInputStream();
        }
        catch (UnknownHostException uhe) {
            try {
                throw new CommunicationException(0x10020000, 160, uhe);
                catch (SocketTimeoutException ex) {
                    throw new CommunicationException(-805240832, 130, ex);
                }
                catch (IOException ex) {
                    throw new CommunicationException(-2147352576, 3, ex);
                }
                catch (CommunicationException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new CommunicationException(ex);
                }
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(errorStream);
                throw throwable;
            }
        }
        IOUtilities.closeInputStream(errorStream);
        return document2222222;
    }

    public static synchronized void setCommunicatorFactory(CommunicatorFactory factory) {
        m_Factory = factory;
    }

    public static synchronized Communicator createInstance() {
        if (m_Factory != null) {
            return m_Factory.createCommunicator();
        }
        return new Communicator();
    }

    private String setCookies(Hashtable<String, String> session, HttpURLConnection conn, String signatureKey, String signature) {
        Object cookie = null;
        String consoleUseCase = System.getProperty("consoleusecase");
        cookie = this.getCookies(session);
        cookie = (String)cookie + "; " + signatureKey + "=" + signature;
        if (consoleUseCase != null) {
            cookie = (String)cookie + "; consoleusecase=" + consoleUseCase;
        }
        conn.setRequestProperty("cookie", (String)cookie);
        return cookie;
    }

    private String setCookies(Hashtable<String, String> session, HttpURLConnection conn) {
        String cookie = this.getCookies(session);
        if (CookieHandler.getDefault() == null) {
            conn.setRequestProperty("cookie", cookie);
        }
        return cookie;
    }

    private static String extractCookies(Hashtable<String, String> session, HttpURLConnection conn) {
        String strCookie = null;
        CookieHandler handler = CookieHandler.getDefault();
        URI uri = null;
        CookieManager manager = null;
        try {
            URL url = conn.getURL();
            uri = url.toURI();
        }
        catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, "extractCookies>> Exception while reading url/uri. Exception: " + ex.getMessage());
        }
        try {
            if (handler instanceof CookieManager) {
                manager = (CookieManager)handler;
            }
            if (manager != null) {
                CookieStore cookieJar = manager.getCookieStore();
                List<HttpCookie> cookies = cookieJar.get(uri);
                if (cookies != null && cookies.size() > 0) {
                    for (HttpCookie cookie : cookies) {
                        strCookie = cookie.toString();
                        Communicator.updateSession(session, strCookie);
                    }
                }
            } else if (handler != null) {
                Map<String, List<String>> requestProperties = conn.getHeaderFields();
                Map<String, List<String>> maplist = handler.get(uri, requestProperties);
                if (maplist.size() > 0) {
                    for (Map.Entry<String, List<String>> entry : maplist.entrySet()) {
                        Iterator<String> iterator = entry.getValue().iterator();
                        while (iterator.hasNext()) {
                            String value;
                            strCookie = value = iterator.next();
                            Communicator.updateSession(session, strCookie);
                        }
                    }
                }
            } else {
                int index = 0;
                String value = null;
                while ((value = conn.getHeaderField(index)) != null) {
                    if ("Set-Cookie".equals(conn.getHeaderFieldKey(index)) || "Set-Cookie2".equals(conn.getHeaderFieldKey(index))) {
                        strCookie = value.substring(0, value.indexOf(";"));
                        Communicator.updateSession(session, strCookie);
                    }
                    ++index;
                }
            }
        }
        catch (IOException | IllegalArgumentException ex) {
            LoggerUtilities.logException(ex);
        }
        return strCookie;
    }

    private static void updateSession(Hashtable<String, String> session, String cookie) {
        if (!StringUtilities.isEmpty(cookie) && session != null) {
            boolean jsessionIdFound = false;
            if (cookie.startsWith("JSESSIONID")) {
                Enumeration<String> keys = session.keys();
                while (keys.hasMoreElements()) {
                    String value = keys.nextElement();
                    if (StringUtilities.isEmpty(value) || !value.startsWith("JSESSIONID")) continue;
                    jsessionIdFound = true;
                    if (value.equals(cookie)) break;
                    logger.log(Level.SEVERE, "updateSession>> Received jsession id from cookie that does not belong to this session.");
                    break;
                }
            }
            if (!jsessionIdFound) {
                session.put(cookie, "");
            }
        }
    }

    private void convertUrlToHashtable(String url, Hashtable<String, Object> testTable) throws UnsupportedEncodingException {
        if (url.indexOf(63) > 0) {
            String params = url.substring(url.indexOf(63) + 1);
            StringTokenizer tokens = new StringTokenizer(params, "&");
            while (tokens.hasMoreTokens()) {
                String nextToken = tokens.nextToken();
                this.populateHashTable(nextToken, testTable);
            }
        }
    }

    private void addDataStringToHashtable(String dataString, Hashtable<String, Object> testTable) throws UnsupportedEncodingException {
        if (dataString.indexOf(38) > 0) {
            StringTokenizer tokens = new StringTokenizer(dataString, "&");
            while (tokens.hasMoreTokens()) {
                String nextToken = tokens.nextToken();
                this.populateHashTable(nextToken, testTable);
            }
        } else {
            this.populateHashTable(dataString, testTable);
        }
    }

    private void populateHashTable(String dataString, Hashtable<String, Object> testTable) throws UnsupportedEncodingException {
        String key;
        if (dataString.indexOf("=") != -1 && !StringUtilities.isEmpty(key = dataString.substring(0, dataString.indexOf(61)))) {
            String value = dataString.substring(dataString.indexOf(61) + 1);
            if (!StringUtilities.isEmpty(value)) {
                value = URLDecoder.decode(value, "UTF-8");
            }
            testTable.put(key.toLowerCase(Locale.ENGLISH), value);
        }
    }

    private String getSessionId() {
        return System.getProperty("SESSION_ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory getDefaultSocketFactoryForFipsMode() {
        FileInputStream fs = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            fs = new FileInputStream(JKS_TRUSTSTORE_PATH);
            keyStore.load(fs, JKS_TRUSTSTORE_PASSWORD.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sslContext = Communicator.getSecureContext();
            sslContext.init(null, tmf.getTrustManagers(), new SecureRandom());
            SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
            return sSLSocketFactory;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Communicator.getDefaultSocketFactoryForFipsMode >> Failed to create SSL context.", ex);
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Communicator.getDefaultSocketFactoryForFipsMode >> Failed to close FileInputSteam", ex);
                }
            }
        }
        return null;
    }

    public static SSLSocketFactory getBasicSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = Communicator.getSecureContext();
        sslContext.init(null, null, new SecureRandom());
        return sslContext.getSocketFactory();
    }
}

