/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.communicate;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.ErrorCodeException;
import com.sygate.scm.util.ErrorMsg;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.UnknownHostException;

public class CommunicationException
extends Exception
implements ErrorCodeException {
    private static final long serialVersionUID = 5526806902483525429L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String GEH = "com.sygate.scm.common.log.log";
    private int errorCode;
    private int msgId;
    private Throwable t;

    public CommunicationException(int errorCode, int msgId) {
        this.errorCode = errorCode;
        this.msgId = msgId;
    }

    public CommunicationException(int errorCode, int msgId, Throwable t) {
        this.errorCode = errorCode;
        this.msgId = msgId;
        this.t = t;
    }

    public CommunicationException(Throwable t) {
        this.errorCode = 0x10010000;
        this.msgId = 1;
        this.t = t;
    }

    @Override
    public String getMessage() {
        return this.getMessageWithErrorCode();
    }

    @Override
    public String getMessageWithErrorCode() {
        String msg = this.getMessageById() + " " + MSGRES.getString(GEH, "CommunicationException.errorcode") + " 0x" + Integer.toHexString(this.errorCode);
        return msg;
    }

    @Override
    public String getMessageWithoutErrorCode() {
        return this.getMessageById();
    }

    public String getMessageById() {
        if (this.t != null && this.t instanceof UnknownHostException) {
            if (this.msgId != 160) {
                this.errorCode = 0x10020000;
                this.msgId = 160;
            }
            return ErrorMsg.getFormattedMessage(this.msgId, this.t.getMessage());
        }
        return ErrorMsg.getMessage(this.msgId);
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    public int getMessageId() {
        return this.msgId;
    }

    @Override
    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public void printStackTrace() {
        if (this.t != null) {
            this.t.printStackTrace();
        }
        super.printStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.t != null) {
            this.t.printStackTrace(s);
        }
        super.printStackTrace(s);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (this.t != null) {
            this.t.printStackTrace(s);
        }
        super.printStackTrace(s);
    }

    public Throwable getThrown() {
        return this.t;
    }
}

