/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.action;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.util.DateUtilities;
import com.sygate.scm.util.Utility;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class ReportQueryString {
    private final SimpleDateFormat FMT = new SimpleDateFormat("yyyy-MM-dd h aa");
    private String reportType;
    private long reportTime;
    private String subType;
    private String dataType;
    private long startTime;
    private int scale;
    private String targetType;
    private ArrayList<String> targetValues;

    public ReportQueryString() {
    }

    public ReportQueryString(String reportType) {
        this(reportType, 0L, null, null, 0L, 0, null, null);
    }

    public ReportQueryString(String reportType, long reportTime) {
        this(reportType, reportTime, null, null, 0L, 0, null, null);
    }

    public ReportQueryString(String reportType, long reportTime, String subType, String dataType, long startTime, int scale) {
        this(reportType, reportTime, subType, dataType, startTime, scale, null, null);
    }

    public ReportQueryString(String reportType, long reportTime, String subType, String dataType, long startTime, int scale, String targetType, ArrayList<String> targetValues) {
        this.reportType = reportType;
        this.reportTime = reportTime;
        this.subType = subType;
        this.dataType = dataType;
        this.startTime = startTime;
        this.scale = scale;
        this.targetType = targetType;
        this.targetValues = targetValues;
    }

    public void setQueryString(String str) {
        if (str == null) {
            return;
        }
        this.reportType = this.parseQueryString(str, "ReportType");
        String s = this.parseQueryString(str, "ReportTime");
        this.reportTime = s == null ? 0L : Long.parseLong(s);
        this.subType = this.parseQueryString(str, "SubType");
        this.dataType = this.parseQueryString(str, "DataType");
        s = this.parseQueryString(str, "StartTime");
        this.startTime = s == null ? 0L : Long.parseLong(s);
        s = this.parseQueryString(str, "Scale");
        this.scale = s == null ? 0 : Integer.parseInt(s);
        this.targetType = this.parseQueryString(str, "TargetType");
    }

    private String parseQueryString(String queryStr, String key) {
        int pos1 = queryStr.indexOf(key + "=");
        if (pos1 >= 0) {
            int pos2 = queryStr.indexOf("&", pos1);
            if (pos2 >= 0) {
                return queryStr.substring(pos1 + key.length() + 1, pos2);
            }
            return queryStr.substring(pos1 + key.length() + 1);
        }
        return null;
    }

    public String getQueryString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ReportType");
        buf.append("=");
        buf.append(this.reportType);
        if (this.reportTime > 0L) {
            buf.append("&");
            buf.append("ReportTime");
            buf.append("=");
            buf.append(this.reportTime);
        }
        if (this.subType != null) {
            buf.append("&");
            buf.append("SubType");
            buf.append("=");
            buf.append(this.subType);
            buf.append("&");
            buf.append("DataType");
            buf.append("=");
            buf.append(this.dataType);
            if (this.startTime > 0L) {
                buf.append("&");
                buf.append("StartTime");
                buf.append("=");
                buf.append(this.startTime);
                buf.append("&");
                buf.append("Scale");
                buf.append("=");
                buf.append(this.scale);
            }
            if (this.targetType != null) {
                buf.append("&");
                buf.append("TargetType");
                buf.append("=");
                buf.append(this.targetType);
            }
            if (this.targetValues != null) {
                for (int i = 0; i < this.targetValues.size(); ++i) {
                    buf.append("&");
                    buf.append("TargetValue");
                    buf.append("=");
                    buf.append(this.targetValues.get(i));
                }
            }
        }
        return buf.toString();
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportTime(long reportTime) {
        this.reportTime = reportTime;
    }

    public long getReportTime() {
        Date d = DateUtilities.truncate(new Date(this.reportTime), 10);
        return d.getTime();
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getScale() {
        return this.scale;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetValues(ArrayList<String> targetValues) {
        this.targetValues = targetValues;
    }

    public ArrayList<String> getTargetValues() {
        return this.targetValues;
    }

    public String getReportTimeString() {
        Calendar cal = Utility.getCalendarInstance();
        if (this.reportTime == 0L) {
            this.reportTime = TimeUtil.getServerTime();
        }
        cal.setTime(DateUtilities.truncate(new Date(this.reportTime), 10));
        return this.FMT.format(cal.getTime());
    }

    public String getNextReportQueryString(int hours) {
        long currentRportTime = this.reportTime;
        this.reportTime = this.getNextReportTime(hours);
        String str = this.getQueryString();
        this.reportTime = currentRportTime;
        return str;
    }

    public long getNextReportTime(int hours) {
        Calendar cal = Utility.getCalendarInstance();
        if (this.reportTime > 0L) {
            cal.setTime(new Date(this.reportTime));
        }
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(10, hours);
        return cal.getTime().getTime();
    }
}

