/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.acl;

import com.sygate.scm.common.acl.BasicPermission;
import com.sygate.scm.common.configobject.SchemaHelper;
import com.sygate.scm.common.configobject.schema.Database;
import com.sygate.scm.common.configobject.schema.EnforcerGroup;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.util.StringUtilities;

public class SitePermission
extends BasicPermission {
    static final String SEPM_DATABASE = "sepmdatabase";
    static final String SEPM_SERVER = "sepmserver";
    static final String SEPM_ENFORCER = "sepmenforcer";

    public SitePermission(SemSite site, BasicPermission.AccessAction action) {
        if (site == null || StringUtilities.isEmpty(site.getId())) {
            throw new IllegalArgumentException("The ConfigObject or its Id cannot be null!");
        }
        this.init(SitePermission.buildPathName(site.getId()), action);
    }

    public SitePermission(SemServer server, BasicPermission.AccessAction action) {
        if (server == null || StringUtilities.isEmpty(server.getId())) {
            throw new IllegalArgumentException("The ConfigObject or its Id cannot be null!");
        }
        String siteId = SchemaHelper.getSiteId(server);
        SitePermission.checkSiteId(siteId);
        this.init(SitePermission.buildPathName(siteId, SEPM_SERVER, server.getId()), action);
    }

    public SitePermission(Database database, BasicPermission.AccessAction action) {
        if (database == null || StringUtilities.isEmpty(database.getId())) {
            throw new IllegalArgumentException("The ConfigObject or its Id cannot be null!");
        }
        String siteId = SchemaHelper.getSiteId(database);
        SitePermission.checkSiteId(siteId);
        this.init(SitePermission.buildPathName(siteId, SEPM_DATABASE), action);
    }

    public SitePermission(EnforcerGroup enforcer, BasicPermission.AccessAction action) {
        if (enforcer == null || StringUtilities.isEmpty(enforcer.getId())) {
            throw new IllegalArgumentException("The ConfigObject or its Id cannot be null!");
        }
        String siteId = SchemaHelper.getSiteId(enforcer);
        SitePermission.checkSiteId(siteId);
        this.init(SitePermission.buildPathName(siteId, SEPM_ENFORCER, enforcer.getId()), action);
    }

    SitePermission(BasicPermission.AccessAction action, String ... ids) {
        this.init(SitePermission.buildPathName(ids), action);
    }

    private static void checkSiteId(String siteId) {
        if (StringUtilities.isEmpty(siteId)) {
            throw new IllegalArgumentException("The site Id cannot be null!");
        }
    }
}

