/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.acl;

import com.sygate.scm.common.acl.AdminPrivilege;
import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.configobject.schema.SemAdminPrivilege;
import com.sygate.scm.common.configobject.schema.SemClientGroupTree;
import com.sygate.scm.common.configobject.schema.SitePrivilegeSet;
import java.io.Serializable;
import java.util.List;

public class PrivilegeContext
implements Serializable {
    private static final long serialVersionUID = -7990252891319867967L;
    private AdminPrivilege adminPrivilege;
    private SemClientGroupTree clientGroupTree;
    private List<String> availableSiteIds;
    private boolean isSBProduct = false;
    private boolean canBypassCheckForSite = false;
    private static final PrivilegeContext EMPTY_CONTEXT = new PrivilegeContext(null);

    public static PrivilegeContext newInstance(SemAdminPrivilege semPrivilege) {
        return new PrivilegeContext(semPrivilege);
    }

    public static PrivilegeContext newInstance(SemAdminPrivilege semPrivilege, List<String> siteList) {
        return new PrivilegeContext(semPrivilege, siteList);
    }

    public static PrivilegeContext newInstance(SemAdminPrivilege semPrivilege, List<String> siteList, boolean isSBProduct, SemClientGroupTree clientGroupTree) {
        return new PrivilegeContext(semPrivilege, siteList, isSBProduct, clientGroupTree);
    }

    public static PrivilegeContext newInstance(SemAdminPrivilege semPrivilege, SemClientGroupTree clientGroupTree) {
        return new PrivilegeContext(semPrivilege, clientGroupTree);
    }

    public static PrivilegeContext newInstance(SitePrivilegeSet sitePrivilegeSet) {
        if (sitePrivilegeSet == null) {
            throw new IllegalArgumentException("The parameter SitePrivilegeSet cannot be null!");
        }
        SemAdminPrivilege semPrivilege = new SemAdminPrivilege();
        AdminPrivilege.grantTypeOfLimitedAdminPrivilege(semPrivilege);
        AdminPrivilege.newInstance(semPrivilege).addPermission(AuthorizationManager.TopLevelPermission.MANAGE_SITES);
        semPrivilege.setOptSitePrivilegeSet((SitePrivilegeSet)sitePrivilegeSet.clone());
        PrivilegeContext context = new PrivilegeContext(semPrivilege);
        context.setBypassCheckForSite(true);
        return context;
    }

    public static PrivilegeContext newNull() {
        return EMPTY_CONTEXT;
    }

    private PrivilegeContext(SemAdminPrivilege adminPrivilege) {
        this.adminPrivilege = AdminPrivilege.newInstance(adminPrivilege);
    }

    private PrivilegeContext(SemAdminPrivilege adminPrivilege, List<String> siteList) {
        this(adminPrivilege, null, false, null);
    }

    private PrivilegeContext(SemAdminPrivilege adminPrivilege, List<String> availableSiteIds, boolean isSBProduct, SemClientGroupTree clientGroupTree) {
        this.adminPrivilege = AdminPrivilege.newInstance(adminPrivilege);
        this.availableSiteIds = availableSiteIds;
        this.isSBProduct = isSBProduct;
        this.clientGroupTree = clientGroupTree;
    }

    private PrivilegeContext(SemAdminPrivilege adminPrivilege, SemClientGroupTree clientGroupTree) {
        this.adminPrivilege = AdminPrivilege.newInstance(adminPrivilege);
        this.clientGroupTree = clientGroupTree;
    }

    public AdminPrivilege getAdminPrivilege() {
        return this.adminPrivilege;
    }

    public SemClientGroupTree getClientGroupTree() {
        return this.clientGroupTree;
    }

    public List<String> getAvailableSiteIds() {
        return this.availableSiteIds;
    }

    boolean isSBProduct() {
        return this.isSBProduct;
    }

    public boolean canBypassCheckForSite() {
        return this.canBypassCheckForSite;
    }

    public void setBypassCheckForSite(boolean bypassCheckForSiteId) {
        this.canBypassCheckForSite = bypassCheckForSiteId;
    }
}

