/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.acl;

import com.sygate.scm.common.acl.AdminPrivilege;
import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.BasicPermission;
import com.sygate.scm.common.acl.GroupPermission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.schema.AllowedClientGroup;
import com.sygate.scm.common.configobject.schema.SemAdminPrivilege;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemClientGroupTree;
import com.sygate.scm.util.IntegerRange;
import com.sygate.scm.util.IntegerSet;
import java.security.AccessControlException;
import java.util.List;

class LimitedAdminPrivilege
extends AdminPrivilege {
    private static final long serialVersionUID = -608763853976385450L;
    private transient GroupPermission.GroupPermissionPair groupPermissionPair;

    protected LimitedAdminPrivilege(SemAdminPrivilege privilege) {
        super(privilege);
        if (privilege == null) {
            throw new IllegalArgumentException("The parameter SemAdminPrivilege cannot be null!");
        }
    }

    @Override
    protected boolean hasOneGroupFullAccessRight() {
        if (!this.checkPermission(null, AuthorizationManager.TopLevelPermission.MANAGE_GROUPS)) {
            return false;
        }
        AllowedClientGroup listAllowedGroups = this.getAllowedClientGroup();
        return listAllowedGroups != null && listAllowedGroups.getGroupIdCount() > 0;
    }

    @Override
    protected boolean isAllGroupNoAccess() {
        return !(this.getAllowedClientGroup() != null && this.getAllowedClientGroup().getGroupIdCount() != 0 || this.getReadOnlyClientGroup() != null && this.getReadOnlyClientGroup().getGroupIdCount() != 0 || this.getDisallowedClientGroup() == null && this.getDisallowedClientGroup().getGroupIdCount() <= 0);
    }

    @Override
    protected boolean checkPermission(PrivilegeContext context, AuthorizationManager.TopLevelPermission permissionKey) {
        if (AuthorizationManager.TopLevelPermission.RUN_COMMANDS == permissionKey) {
            return this.hasExecuteCommandRights();
        }
        if (AuthorizationManager.TopLevelPermission.MANAGE_SITES == permissionKey && context != null) {
            return this.isPaneAllowed(permissionKey.getValue()) && this.hasOneAvailableSiteAllowed(context.getAvailableSiteIds(), context.canBypassCheckForSite());
        }
        return this.isPaneAllowed(permissionKey.getValue());
    }

    @Override
    protected boolean checkSubPermission(AuthorizationManager.PackagePermission permission) {
        Integer packagePrivilege;
        if (permission == null) {
            return false;
        }
        Integer n = packagePrivilege = this.getPackagePrivilege() == null ? this.semPrivilege.getDefPackagePrivilege() : this.getPackagePrivilege();
        if (permission == AuthorizationManager.PackagePermission.READ_ONLY) {
            return packagePrivilege.equals(SemAdminPrivilege.FULL_ACCESS) || packagePrivilege.equals(SemAdminPrivilege.READ_ONLY);
        }
        if (permission == AuthorizationManager.PackagePermission.FULL_ACCESS) {
            return packagePrivilege.equals(SemAdminPrivilege.FULL_ACCESS);
        }
        return false;
    }

    @Override
    protected boolean checkSubPermission(AuthorizationManager.PolicyPermission permission) {
        if (permission == null) {
            return false;
        }
        return !this.getDisallowedFeatureIntegerSet().contains(permission.getValue(), 16);
    }

    @Override
    protected boolean checkSubPermission(AuthorizationManager.CommandPermission permission) {
        if (permission == null) {
            return false;
        }
        if (permission == AuthorizationManager.CommandPermission.UPDATE_CONTENT_SCAN) {
            return this.checkSubPermission(AuthorizationManager.CommandPermission.SCAN) && this.checkSubPermission(AuthorizationManager.CommandPermission.UPDATE_CONTENT);
        }
        return !this.getDisallowedCommandSet().contains(permission.getValue(), 16);
    }

    @Override
    protected boolean checkSubPermission(PrivilegeContext context, GroupPermission target) {
        return this.getGroupPermissionPair(context.getClientGroupTree()).checkPermission(target);
    }

    @Override
    protected boolean addPermission(AuthorizationManager.TopLevelPermission permissionKey) {
        if (AuthorizationManager.TopLevelPermission.RUN_COMMANDS == permissionKey) {
            throw new AccessControlException("The RUN_COMMAND permission can't be added this way!");
        }
        return this.addPermission(permissionKey.getValue());
    }

    @Override
    protected boolean addSubPermission(AuthorizationManager.PackagePermission permission) {
        if (permission == null) {
            return false;
        }
        this.semPrivilege.setOptPackagePrivilege(permission.getValue());
        return true;
    }

    @Override
    protected boolean addSubPermission(AuthorizationManager.PolicyPermission permission) {
        IntegerSet set = this.getDisallowedFeatureIntegerSet();
        if (set.contains(permission.getValue(), 16)) {
            set.delete(new IntegerRange(permission.getValue(), 16));
            this.semPrivilege.setOptDisallowedFeature(set.toString());
            return true;
        }
        return false;
    }

    @Override
    protected boolean removePermission(AuthorizationManager.TopLevelPermission permissionKey) {
        return this.removePermission(permissionKey.getValue());
    }

    @Override
    protected boolean removeSubPermission(AuthorizationManager.PolicyPermission permission) {
        IntegerSet set = this.getDisallowedFeatureIntegerSet();
        if (!set.contains(permission.getValue(), 16)) {
            set.add(new IntegerRange(permission.getValue(), 16));
            this.semPrivilege.setOptDisallowedFeature(set.toString());
            return true;
        }
        return false;
    }

    @Override
    public boolean hasExecuteCommandRights() {
        for (AuthorizationManager.CommandPermission commandPermission : AuthorizationManager.CommandPermission.values()) {
            if (!this.checkSubPermission(commandPermission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer getPackagePrivilege() {
        return this.semPrivilege.getOptPackagePrivilege();
    }

    protected GroupPermission.GroupPermissionPair getGroupPermissionPair(SemClientGroupTree clientGroupTree) {
        if (clientGroupTree == null) {
            return new GroupPermission.GroupPermissionPair();
        }
        if (this.groupPermissionPair == null) {
            this.groupPermissionPair = new GroupPermission.GroupPermissionPair();
            List<String> fullAccessGroups = this.getAllowedClientGroupList();
            List<String> readOnlyGroups = this.getReadOnlyClientGroupList();
            List<String> noAccessGroups = this.getDisallowedClientGroupList();
            this.initGroupPermissions(clientGroupTree.getSemClientGroup(), this.groupPermissionPair, fullAccessGroups, readOnlyGroups, noAccessGroups);
        }
        return this.groupPermissionPair;
    }

    protected void initGroupPermissions(SemClientGroup clientGroup, GroupPermission.GroupPermissionPair result, List<String> fullAccessGroups, List<String> readOnlyGroups, List<String> noAccessGroups) {
        if (fullAccessGroups != null && fullAccessGroups.contains(clientGroup.getId())) {
            result.addAllowedPermission(new GroupPermission(clientGroup, BasicPermission.AccessAction.FULL_ACCESS));
        } else if (readOnlyGroups != null && readOnlyGroups.contains(clientGroup.getId())) {
            result.addAllowedPermission(new GroupPermission(clientGroup, BasicPermission.AccessAction.READ_ONLY));
        } else if (noAccessGroups != null && noAccessGroups.contains(clientGroup.getId())) {
            result.addDeniedPermission(new GroupPermission(clientGroup, BasicPermission.AccessAction.NO_ACCESS));
        }
        for (SemClientGroup child : clientGroup.getSemClientGroup()) {
            this.initGroupPermissions(child, result, fullAccessGroups, readOnlyGroups, noAccessGroups);
        }
    }

    @Override
    public boolean hasAccessRightToGroup(String groupId, boolean isParentAccessible, boolean excludeReadOnly) {
        int i;
        List<String> listAllowed = this.getAllowedClientGroupList();
        List<String> listDisallowed = this.getDisallowedClientGroupList();
        List<String> listReadOnly = this.getReadOnlyClientGroupList();
        if (listAllowed != null) {
            for (i = 0; i < listAllowed.size(); ++i) {
                if (!groupId.equals(listAllowed.get(i))) continue;
                return true;
            }
        }
        if (listDisallowed != null) {
            for (i = 0; i < listDisallowed.size(); ++i) {
                if (!groupId.equals(listDisallowed.get(i))) continue;
                return false;
            }
        }
        if (listReadOnly != null) {
            for (i = 0; i < listReadOnly.size(); ++i) {
                if (!groupId.equals(listReadOnly.get(i))) continue;
                return !excludeReadOnly;
            }
        }
        return isParentAccessible;
    }

    @Override
    public boolean hasAccessRightToGroup(String groupId, boolean isParentAccessible) {
        return this.hasAccessRightToGroup(groupId, isParentAccessible, false);
    }
}

