/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.acl;

import com.sygate.scm.common.acl.BasicPermission;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.util.CollectionUtils;
import com.sygate.scm.util.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupPermission
extends BasicPermission {
    public GroupPermission(SemClientGroup group, BasicPermission.AccessAction action) {
        if (group == null || StringUtilities.isEmpty(group.getId())) {
            throw new IllegalArgumentException("The ConfigObject or its Id cannot be null!");
        }
        this.init(GroupPermission.buildPathName(this.getGroupHierarchyPath(group)), action);
    }

    GroupPermission(BasicPermission.AccessAction action, String ... ids) {
        this.init(GroupPermission.buildPathName(ids), action);
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof GroupPermission)) {
            return false;
        }
        GroupPermission that = (GroupPermission)p;
        return this.pathname.equals(that.pathname) && this.impliesAccess(that);
    }

    private String[] getGroupHierarchyPath(SemClientGroup group) {
        ArrayList<String> result = new ArrayList<String>();
        this.buildGroupHierarchyPath(group, result);
        Object[] pathIds = result.toArray(new String[0]);
        CollectionUtils.reverseArray(pathIds);
        return pathIds;
    }

    private void buildGroupHierarchyPath(SemClientGroup group, List<String> result) {
        result.add(group.getId());
        if (group.getParent() instanceof SemClientGroup) {
            this.buildGroupHierarchyPath((SemClientGroup)group.getParent(), result);
        }
    }

    boolean isRootGroup() {
        return this.pathname.equals(GroupPermission.buildPathName(GroupPermission.getParentPathNames(this.pathname)));
    }

    static class GroupPermissionPair {
        Map<String, GroupPermission> allowedPermissions = new HashMap<String, GroupPermission>();
        Map<String, GroupPermission> deniedPermissions = new HashMap<String, GroupPermission>();

        GroupPermissionPair() {
            this(null, null);
        }

        GroupPermissionPair(Map<String, GroupPermission> allowedPermissions, Map<String, GroupPermission> deniedPermissions) {
            this.init(deniedPermissions, this.deniedPermissions);
            this.init(allowedPermissions, this.allowedPermissions);
        }

        void init(Map<String, GroupPermission> from, Map<String, GroupPermission> to) {
            if (from != null) {
                to.putAll(from);
            }
        }

        boolean checkPermission(GroupPermission target) {
            if (this.deniedPermissions.isEmpty() && this.allowedPermissions.isEmpty()) {
                return false;
            }
            GroupPermission dp = this.deniedPermissions.get(target.pathname);
            if (dp != null) {
                return target.isDeniedPermission();
            }
            GroupPermission ap = this.allowedPermissions.get(target.pathname);
            if (ap != null) {
                return ap.implies(target);
            }
            if (target.isRootGroup()) {
                return false;
            }
            return this.checkPermission(new GroupPermission(target.getAction(), BasicPermission.getParentPathNames(target.pathname)));
        }

        void addDeniedPermission(GroupPermission p) {
            if (p != null) {
                this.deniedPermissions.put(p.pathname, p);
            }
        }

        void addAllowedPermission(GroupPermission p) {
            if (p != null) {
                this.allowedPermissions.put(p.pathname, p);
            }
        }

        void clear() {
            this.allowedPermissions.clear();
            this.deniedPermissions.clear();
        }

        Map<String, GroupPermission> getAllowedPermissions() {
            return this.allowedPermissions;
        }

        Map<String, GroupPermission> getDeniedPermissions() {
            return this.deniedPermissions;
        }
    }
}

