/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.acl;

import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.util.StringUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class BasicPermission
implements Permission {
    protected static final String SEPARATOR = "/";
    protected static final int READ = 1;
    protected static final int WRITE = 2;
    protected static final int ALL = 3;
    protected static final int NONE = 4132;
    protected transient int access;
    protected transient AccessAction action;
    protected transient String pathname;

    public boolean implies(Permission p) {
        if (!(p instanceof BasicPermission)) {
            return false;
        }
        BasicPermission that = (BasicPermission)p;
        return this.impliesAccess(that) && this.impliesIgnoreAccess(that);
    }

    protected boolean impliesAccess(BasicPermission that) {
        if (this.isDeniedPermission()) {
            return this.access == that.access;
        }
        return (this.access & that.access) == that.access;
    }

    protected boolean impliesIgnoreAccess(BasicPermission that) {
        return that.pathname.startsWith(this.pathname);
    }

    protected void init(String pathname, AccessAction action) {
        this.pathname = pathname;
        this.action = action;
        this.access = BasicPermission.getAccess(action);
    }

    static int getAccess(AccessAction action) {
        int result = 4132;
        switch (action) {
            case NO_ACCESS: {
                break;
            }
            case READ_ONLY: {
                result = 1;
                break;
            }
            case FULL_ACCESS: {
                result = 3;
                break;
            }
        }
        return result;
    }

    protected static String[] getParentPathNames(String pathname) {
        if (StringUtilities.isEmpty(pathname)) {
            return new String[]{""};
        }
        List<String> result = new ArrayList<String>();
        for (String pathEntry : pathname.split(SEPARATOR)) {
            if (StringUtilities.isEmpty(pathEntry)) continue;
            result.add(pathEntry);
        }
        if (result.size() > 1) {
            result = result.subList(0, result.size() - 1);
        }
        return result.toArray(new String[0]);
    }

    static String buildPathName(String ... ids) {
        StringBuilder builder = new StringBuilder(SEPARATOR);
        for (String id : ids) {
            builder.append(id);
            builder.append(SEPARATOR);
        }
        return builder.toString();
    }

    public boolean isDeniedPermission() {
        return this.access == 4132;
    }

    public AccessAction getAction() {
        return this.action;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BasicPermission)) {
            return false;
        }
        BasicPermission that = (BasicPermission)obj;
        return this.access == that.access && this.pathname.equals(that.pathname);
    }

    public int hashCode() {
        return this.pathname.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Pathname: ");
        builder.append(this.pathname);
        builder.append(" Access: ");
        builder.append(this.access);
        return builder.toString();
    }

    static class PermissionsPair {
        Set<BasicPermission> deniedPermissions = new HashSet<BasicPermission>();
        Set<BasicPermission> allowedPermissions = new HashSet<BasicPermission>();

        PermissionsPair() {
            this(null, null);
        }

        PermissionsPair(Set<BasicPermission> deniedPermissions, Set<BasicPermission> allowedPermissions) {
            this.init(deniedPermissions, this.deniedPermissions);
            this.init(allowedPermissions, this.allowedPermissions);
        }

        void init(Set<BasicPermission> from, Set<BasicPermission> to) {
            if (from != null) {
                for (BasicPermission p : from) {
                    to.add(p);
                }
            }
        }

        boolean checkPermission(BasicPermission target) {
            for (BasicPermission p : this.getDeniedPermissions()) {
                if (!p.implies(target)) continue;
                return target.isDeniedPermission();
            }
            if (!target.isDeniedPermission()) {
                for (BasicPermission p : this.getAllowedPermissions()) {
                    if (!p.implies(target)) continue;
                    return true;
                }
            }
            return false;
        }

        void addDeniedPermission(BasicPermission p) {
            this.deniedPermissions.add(p);
        }

        void addAllowedPermission(BasicPermission p) {
            this.allowedPermissions.add(p);
        }

        Set<BasicPermission> getDeniedPermissions() {
            return this.deniedPermissions;
        }

        Set<BasicPermission> getAllowedPermissions() {
            return this.allowedPermissions;
        }
    }

    public static enum AccessAction {
        NO_ACCESS,
        READ_ONLY,
        FULL_ACCESS;


        public static AccessAction valueOf(int i) {
            switch (i) {
                case 1: {
                    return NO_ACCESS;
                }
                case 2: {
                    return READ_ONLY;
                }
                case 0: {
                    return FULL_ACCESS;
                }
            }
            return null;
        }
    }
}

