/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.acl;

import com.sygate.scm.common.acl.AdminPrivilege;
import com.sygate.scm.common.acl.GroupPermission;
import com.sygate.scm.common.acl.GroupPolicyPermission;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.acl.SitePermission;
import com.sygate.scm.common.configobject.schema.SemAdminPrivilege;

public class AuthorizationManager {
    private static final AuthorizationManager SINGLETON = new AuthorizationManager();

    private AuthorizationManager() {
    }

    public static AuthorizationManager getInstance() {
        return SINGLETON;
    }

    public boolean checkPermission(PrivilegeContext context, Permission permission) {
        if (context == null || permission == null) {
            return false;
        }
        if (permission instanceof TopLevelPermission) {
            return context.getAdminPrivilege().checkPermission(context, (TopLevelPermission)permission);
        }
        if (permission instanceof PackagePermission) {
            return this.checkSubPermission(context, (PackagePermission)permission);
        }
        if (permission instanceof PolicyPermission) {
            return this.checkSubPermission(context, (PolicyPermission)permission);
        }
        if (permission instanceof GroupPolicyPermission) {
            return this.checkSubPermission(context, (GroupPolicyPermission)permission);
        }
        if (permission instanceof CommandPermission) {
            return this.checkSubPermission(context, (CommandPermission)permission);
        }
        if (permission instanceof SitePermission) {
            return this.checkSubPermission(context, (SitePermission)permission);
        }
        if (permission instanceof GroupPermission) {
            return this.checkSubPermission(context, (GroupPermission)permission);
        }
        if (permission instanceof SpecialPermission) {
            return context.getAdminPrivilege().checkPermission(context, (SpecialPermission)permission);
        }
        throw new UnsupportedOperationException("The type of Permission is not supported: " + permission);
    }

    public boolean addPermission(PrivilegeContext context, Permission permission) {
        if (context == null || permission == null) {
            return false;
        }
        if (permission instanceof TopLevelPermission) {
            return this.addPermission(context, (TopLevelPermission)permission);
        }
        if (permission instanceof PackagePermission) {
            return this.addSubPermission(context, (PackagePermission)permission);
        }
        if (permission instanceof PolicyPermission) {
            return this.addSubPermission(context, (PolicyPermission)permission);
        }
        throw new UnsupportedOperationException("The type of Permission is not supported: " + permission);
    }

    protected boolean addPermission(PrivilegeContext context, TopLevelPermission permission) {
        AdminPrivilege adminPrivilege = context.getAdminPrivilege();
        if (adminPrivilege.checkPermission(context, permission)) {
            return false;
        }
        return adminPrivilege.addPermission(permission);
    }

    public boolean removePermission(PrivilegeContext context, Permission permission) {
        if (context == null || permission == null) {
            return false;
        }
        AdminPrivilege adminPrivilege = context.getAdminPrivilege();
        if (permission instanceof TopLevelPermission) {
            return this.removePermission(adminPrivilege, (TopLevelPermission)permission);
        }
        if (permission instanceof PolicyPermission) {
            return this.removeSubPermission(adminPrivilege, (PolicyPermission)permission);
        }
        throw new UnsupportedOperationException("The type of Permission is not supported: " + permission);
    }

    protected boolean removePermission(AdminPrivilege adminPrivilege, TopLevelPermission permission) {
        if (adminPrivilege == null || !adminPrivilege.checkPermission(null, permission)) {
            return false;
        }
        return adminPrivilege.removePermission(permission);
    }

    protected boolean checkSubPermission(PrivilegeContext context, PackagePermission permission) {
        if (context.isSBProduct()) {
            return true;
        }
        AdminPrivilege adminPrivilege = context.getAdminPrivilege();
        if (adminPrivilege == null || permission == null || !adminPrivilege.checkPermission(null, TopLevelPermission.MANAGE_PACKAGES)) {
            return false;
        }
        return adminPrivilege.checkSubPermission(permission);
    }

    protected boolean checkSubPermission(PrivilegeContext context, PolicyPermission permission) {
        AdminPrivilege adminPrivilege = context.getAdminPrivilege();
        if (adminPrivilege == null || permission == null || !adminPrivilege.checkPermission(null, TopLevelPermission.MANAGE_POLICIES)) {
            return false;
        }
        return adminPrivilege.checkSubPermission(permission);
    }

    protected boolean checkSubPermission(PrivilegeContext context, GroupPolicyPermission permission) {
        AdminPrivilege adminPrivilege = context.getAdminPrivilege();
        if (adminPrivilege == null || permission == null || !adminPrivilege.checkPermission(null, TopLevelPermission.MANAGE_POLICIES)) {
            return false;
        }
        return adminPrivilege.checkSubPermission(context, permission);
    }

    protected boolean checkSubPermission(PrivilegeContext context, CommandPermission permission) {
        AdminPrivilege adminPrivilege = context.getAdminPrivilege();
        if (adminPrivilege == null || permission == null) {
            return false;
        }
        return adminPrivilege.checkSubPermission(permission);
    }

    protected boolean checkSubPermission(PrivilegeContext context, SitePermission permission) {
        AdminPrivilege adminPrivilege = context.getAdminPrivilege();
        if (adminPrivilege == null || permission == null || !adminPrivilege.checkPermission(context, TopLevelPermission.MANAGE_SITES)) {
            return false;
        }
        return adminPrivilege.checkSubPermission(context, permission);
    }

    protected boolean checkSubPermission(PrivilegeContext context, GroupPermission permission) {
        AdminPrivilege adminPrivilege = context.getAdminPrivilege();
        if (adminPrivilege == null || permission == null || !adminPrivilege.checkPermission(context, TopLevelPermission.MANAGE_GROUPS)) {
            return false;
        }
        return adminPrivilege.checkSubPermission(context, permission);
    }

    protected boolean addSubPermission(PrivilegeContext context, PackagePermission permission) {
        AdminPrivilege adminPrivilege = context.getAdminPrivilege();
        if (permission == null) {
            return false;
        }
        return adminPrivilege.addSubPermission(permission);
    }

    protected boolean addSubPermission(PrivilegeContext context, PolicyPermission permission) {
        AdminPrivilege adminPrivilege = context.getAdminPrivilege();
        if (adminPrivilege == null || permission == null || this.checkSubPermission(context, permission)) {
            return false;
        }
        return adminPrivilege.addSubPermission(permission);
    }

    protected boolean removeSubPermission(AdminPrivilege adminPrivilege, PolicyPermission permission) {
        if (adminPrivilege == null || permission == null || !adminPrivilege.checkPermission(null, TopLevelPermission.MANAGE_POLICIES)) {
            return false;
        }
        return adminPrivilege.removeSubPermission(permission);
    }

    public static enum SpecialPermission implements Permission
    {
        ONE_GROUP_FULL_ACCESS,
        ALL_GROUP_NO_ACCESS;

    }

    public static enum CommandPermission implements Permission
    {
        SCAN("0xF1"),
        UPDATE_CONTENT("0xF2"),
        UPDATE_CONTENT_SCAN("0xF3"),
        POWER_ERASER_SCAN("0xF10"),
        RESTART_COMPUTER("0xF4"),
        ENABLE_AUTOPROTECT("0xF5"),
        ENABLE_FIREWALL("0xF6"),
        DISABLE_FIREWALL("0xF7"),
        ENABLE_DOWNLOAD_ADVISOR("0xF9"),
        DISABLE_DOWNLOAD_ADVISOR("0xFA"),
        DELETE_FROM_QUARANTINE("0xF8"),
        DISABLE_AUTOPROTECT("0xF11"),
        COLLECT_CHECKSUM("0xF12");

        private String privilegeValue;

        private CommandPermission(String privilegeValue) {
            this.privilegeValue = privilegeValue;
        }

        public String getValue() {
            return this.privilegeValue;
        }
    }

    public static enum PolicyPermission implements Permission
    {
        EDIT_SHARED_POLICIES("0x21"),
        ANTIVIRUS_AND_ANTISPYWARE("0x22"),
        FIREWALL("0x23"),
        INTRUSION_PREVENTION("0x24"),
        APPLICATION_AND_DEVICE_CONTROL("0x25"),
        LIVEUPDATE("0x26"),
        CENTRALIZED_EXCEPTIONS("0x27"),
        HOST_INTEGRITY("0x28");

        private String privilegeValue;

        private PolicyPermission(String privilegeValue) {
            this.privilegeValue = privilegeValue;
        }

        public String getValue() {
            return this.privilegeValue;
        }
    }

    public static enum PackagePermission implements Permission
    {
        READ_ONLY(SemAdminPrivilege.READ_ONLY),
        FULL_ACCESS(SemAdminPrivilege.FULL_ACCESS);

        private int value;

        private PackagePermission(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum TopLevelPermission implements Permission
    {
        MANAGE_POLICIES("0x20"),
        MANAGE_GROUPS("0x30"),
        MANAGE_PACKAGES("0x60"),
        MANAGE_SITES("0x40"),
        RUN_COMMANDS("RUN_COMMANDS"),
        VIEW_REPORTS("0x10");

        private String privilegeValue;

        private TopLevelPermission(String privilegeValue) {
            this.privilegeValue = privilegeValue;
        }

        public String getValue() {
            return this.privilegeValue;
        }
    }
}

