/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.acl;

import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.BasicPermission;
import com.sygate.scm.common.acl.DomainAdminPrivilege;
import com.sygate.scm.common.acl.GroupPermission;
import com.sygate.scm.common.acl.GroupPolicyPermission;
import com.sygate.scm.common.acl.LimitedAdminPrivilege;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.acl.SitePermission;
import com.sygate.scm.common.acl.SysAdminPrivilege;
import com.sygate.scm.common.configobject.schema.AllowedClientGroup;
import com.sygate.scm.common.configobject.schema.DatabasePrivilege;
import com.sygate.scm.common.configobject.schema.DisallowedClientGroup;
import com.sygate.scm.common.configobject.schema.EnforcerGroupPrivilege;
import com.sygate.scm.common.configobject.schema.EnforcerGroupPrivilegeSet;
import com.sygate.scm.common.configobject.schema.GroupId;
import com.sygate.scm.common.configobject.schema.PrivilegeValue;
import com.sygate.scm.common.configobject.schema.ReadOnlyClientGroup;
import com.sygate.scm.common.configobject.schema.SemAdminPrivilege;
import com.sygate.scm.common.configobject.schema.ServerPrivilege;
import com.sygate.scm.common.configobject.schema.ServerPrivilegeSet;
import com.sygate.scm.common.configobject.schema.SitePrivilege;
import com.sygate.scm.common.configobject.schema.SitePrivilegeSet;
import com.sygate.scm.util.BadFormatException;
import com.sygate.scm.util.CollectionUtils;
import com.sygate.scm.util.IntegerRange;
import com.sygate.scm.util.IntegerSet;
import com.sygate.scm.util.StringUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AdminPrivilege
implements Serializable {
    private static final long serialVersionUID = -554980058960144474L;
    protected SemAdminPrivilege semPrivilege;
    private static final Logger logger = Logger.getLogger(AdminPrivilege.class.getName());

    protected AdminPrivilege(SemAdminPrivilege privilege) {
        this.semPrivilege = privilege;
    }

    public static AdminPrivilege newInstance(SemAdminPrivilege privilege) {
        if (privilege == null) {
            return SysAdminPrivilege.getInstance();
        }
        if (AdminPrivilege.isDomainAdminPrivilege(privilege)) {
            return new DomainAdminPrivilege(privilege);
        }
        return new LimitedAdminPrivilege(privilege);
    }

    public static AdminPrivilege newDomainAdminPrivilege() {
        return new DomainAdminPrivilege(AdminPrivilege.createDomainAdminPrivilege());
    }

    public static AdminPrivilege newLimitedAdminPrivilege() {
        return new LimitedAdminPrivilege(AdminPrivilege.createLimitedAdminPrivilege());
    }

    public static SemAdminPrivilege createDomainAdminPrivilege() {
        SemAdminPrivilege priv = new SemAdminPrivilege();
        IntegerSet set = new IntegerSet();
        set.add("0x50", 16);
        priv.setOptAllowedPane(set.toString());
        GroupId groupId = new GroupId();
        AllowedClientGroup allowedClientGroup = new AllowedClientGroup();
        allowedClientGroup.addGroupId(groupId);
        priv.setAllowedClientGroup(allowedClientGroup);
        return priv;
    }

    public static SemAdminPrivilege createLimitedAdminPrivilege() {
        SemAdminPrivilege priv = new SemAdminPrivilege();
        GroupId groupId = new GroupId();
        AllowedClientGroup allowedClientGroup = new AllowedClientGroup();
        allowedClientGroup.addGroupId(groupId);
        priv.setAllowedClientGroup(allowedClientGroup);
        return priv;
    }

    public SemAdminPrivilege getSemAdminPrivilege() {
        return this.semPrivilege;
    }

    protected static IntegerSet createIntegerSet(String setString) {
        IntegerSet is = new IntegerSet();
        if (StringUtilities.isEmpty(setString)) {
            return is;
        }
        try {
            is.init(setString);
        }
        catch (BadFormatException e) {
            try {
                is.init(setString, 16);
            }
            catch (BadFormatException ex) {
                logger.log(Level.WARNING, e.getMessage(), e);
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return is;
    }

    public static boolean isDomainAdminPrivilege(SemAdminPrivilege privilege) {
        if (privilege == null) {
            return false;
        }
        if (privilege.getOptAllowedPane() == null) {
            return true;
        }
        return AdminPrivilege.isPaneAllowed(privilege, "0x50");
    }

    public static void grantTypeOfLimitedAdminPrivilege(SemAdminPrivilege privilege) {
        if (privilege != null && privilege.getOptAllowedPane() == null) {
            privilege.setOptAllowedPane("");
        }
    }

    protected static boolean isPaneAllowed(SemAdminPrivilege semPrivilege, String rightsString) {
        if (StringUtilities.isEmpty(rightsString)) {
            return false;
        }
        return AdminPrivilege.getAllowedPaneIntegerSet(semPrivilege).contains(rightsString, 16);
    }

    protected static IntegerSet getAllowedPaneIntegerSet(SemAdminPrivilege semPrivilege) {
        String strPanes = null;
        if (semPrivilege != null) {
            strPanes = semPrivilege.getOptAllowedPane();
        }
        return AdminPrivilege.createIntegerSet(strPanes);
    }

    protected boolean checkPermission(PrivilegeContext context, AuthorizationManager.TopLevelPermission permissionKey) {
        return true;
    }

    protected boolean checkSubPermission(AuthorizationManager.PackagePermission permission) {
        return true;
    }

    protected boolean checkSubPermission(AuthorizationManager.PolicyPermission permission) {
        return true;
    }

    protected boolean checkSubPermission(PrivilegeContext context, GroupPolicyPermission permission) {
        if (permission.getMode() == GroupPolicyPermission.GroupPolicyMode.INHERIT) {
            return false;
        }
        if (permission.getGroup() == null) {
            return true;
        }
        return this.checkSubPermission(context, new GroupPermission(permission.getGroup(), BasicPermission.AccessAction.FULL_ACCESS));
    }

    protected boolean checkSubPermission(AuthorizationManager.CommandPermission permission) {
        return true;
    }

    protected boolean checkSubPermission(PrivilegeContext context, SitePermission target) {
        return this.getSitePermissions().checkPermission(target);
    }

    protected boolean checkSubPermission(PrivilegeContext context, GroupPermission target) {
        return !target.isDeniedPermission();
    }

    protected boolean checkPermission(PrivilegeContext context, AuthorizationManager.SpecialPermission target) {
        if (target == AuthorizationManager.SpecialPermission.ONE_GROUP_FULL_ACCESS) {
            return this.checkPermission(context, AuthorizationManager.TopLevelPermission.MANAGE_GROUPS) && this.hasOneGroupFullAccessRight();
        }
        if (target == AuthorizationManager.SpecialPermission.ALL_GROUP_NO_ACCESS) {
            return !this.checkPermission(context, AuthorizationManager.TopLevelPermission.MANAGE_GROUPS) || this.isAllGroupNoAccess();
        }
        return false;
    }

    protected boolean addPermission(AuthorizationManager.TopLevelPermission permissionKey) {
        return false;
    }

    protected boolean addSubPermission(AuthorizationManager.PackagePermission permissionKey) {
        return false;
    }

    protected boolean addSubPermission(AuthorizationManager.PolicyPermission permissionKey) {
        return false;
    }

    protected boolean removePermission(AuthorizationManager.TopLevelPermission permissionKey) {
        return false;
    }

    protected boolean removeSubPermission(AuthorizationManager.PolicyPermission permissionKey) {
        return false;
    }

    protected boolean addPermission(String rightString) {
        if (StringUtilities.isEmpty(rightString)) {
            return false;
        }
        IntegerSet set = AdminPrivilege.createIntegerSet(this.getAllowedPane());
        set.add(rightString, 16);
        this.setAllowedPane(set.toString());
        return true;
    }

    protected boolean removePermission(String rightString) {
        if (StringUtilities.isEmpty(rightString)) {
            return false;
        }
        IntegerSet set = AdminPrivilege.createIntegerSet(this.getAllowedPane());
        set.delete(new IntegerRange(rightString, 16));
        this.setAllowedPane(set.toString());
        return true;
    }

    protected String getAllowedPane() {
        return this.semPrivilege.getOptAllowedPane();
    }

    public boolean isDomainAdminPrivilege() {
        return AdminPrivilege.isDomainAdminPrivilege(this.semPrivilege);
    }

    protected boolean isPaneAllowed(String rightsString) {
        return AdminPrivilege.isPaneAllowed(this.semPrivilege, rightsString);
    }

    @Deprecated
    public IntegerSet getAllowedPaneIntegerSet() {
        return AdminPrivilege.getAllowedPaneIntegerSet(this.semPrivilege);
    }

    @Deprecated
    public void setAllowedPane(String pane) {
        this.semPrivilege.setOptAllowedPane(pane);
    }

    public SitePrivilegeSet getSitePrivilegeSet() {
        if (this.semPrivilege == null) {
            return null;
        }
        return this.semPrivilege.getOptSitePrivilegeSet();
    }

    public String getAllowedLegacyDomain() {
        return this.semPrivilege.getOptAllowedLegacyDomain();
    }

    public void setAllowedLegacyDomain(String wildcard) {
        this.semPrivilege.setOptAllowedLegacyDomain(wildcard);
    }

    public String getAllowedLegacyGroup() {
        return this.semPrivilege.getOptAllowedLegacyGroup();
    }

    public void setAllowedLegacyGroup(String wildcard) {
        this.semPrivilege.setOptAllowedLegacyGroup(wildcard);
    }

    public String getAllowedLegacyServer() {
        return this.semPrivilege.getOptAllowedLegacyServer();
    }

    public void setAllowedLegacyServer(String wildcard) {
        this.semPrivilege.setOptAllowedLegacyServer(wildcard);
    }

    public String getAllowedComputer() {
        return this.semPrivilege.getOptAllowedComputer();
    }

    public void setAllowedComputer(String wildcard) {
        this.semPrivilege.setOptAllowedComputer(wildcard);
    }

    public String getAllowedIP() {
        return this.semPrivilege.getOptAllowedIP();
    }

    public void setAllowedIP(String wildcard) {
        this.semPrivilege.setOptAllowedIP(wildcard);
    }

    public String getDisallowedFeature() {
        return this.semPrivilege.getOptDisallowedFeature();
    }

    public void setDisallowedFeature(String feature) {
        this.semPrivilege.setOptDisallowedFeature(feature);
    }

    public IntegerSet getDisallowedPaneIntegerSet() {
        return this.getDisallowedFeatureIntegerSet();
    }

    protected IntegerSet getDisallowedFeatureIntegerSet() {
        String strPanes = null;
        if (this.hasPrivilege()) {
            strPanes = this.semPrivilege.getOptDisallowedFeature();
        }
        return AdminPrivilege.createIntegerSet(strPanes);
    }

    public void setOptDisallowedCommand(String value) {
        this.semPrivilege.setOptDisallowedCommand(value);
    }

    public Integer getPackagePrivilege() {
        return SemAdminPrivilege.FULL_ACCESS;
    }

    protected boolean hasOneGroupFullAccessRight() {
        return true;
    }

    protected boolean isAllGroupNoAccess() {
        return false;
    }

    protected AllowedClientGroup getAllowedClientGroup() {
        return this.semPrivilege == null ? null : this.semPrivilege.getAllowedClientGroup();
    }

    protected DisallowedClientGroup getDisallowedClientGroup() {
        return this.semPrivilege == null ? null : this.semPrivilege.getOptDisallowedClientGroup();
    }

    protected ReadOnlyClientGroup getReadOnlyClientGroup() {
        return this.semPrivilege == null ? null : this.semPrivilege.getOptReadOnlyClientGroup();
    }

    public SitePrivilege getSitePrivilegeById(String siteId) {
        SitePrivilege site = null;
        if (siteId == null) {
            return site;
        }
        SitePrivilegeSet siteSet = this.getSitePrivilegeSet();
        if (siteSet == null) {
            return site;
        }
        for (SitePrivilege temp : siteSet.getSitePrivilege()) {
            if (temp == null || !temp.getRefSiteId().equals(siteId)) continue;
            site = temp;
            break;
        }
        return site;
    }

    public boolean hasPrivilege() {
        return this.semPrivilege != null;
    }

    public void setAllowedClientGroupList(List<String> fullAccessList) {
        if (!this.hasPrivilege()) {
            return;
        }
        AllowedClientGroup clientGroup = this.semPrivilege.getAllowedClientGroup();
        if (clientGroup == null) {
            clientGroup = new AllowedClientGroup();
            this.semPrivilege.setAllowedClientGroup(clientGroup);
        } else {
            for (GroupId gid : clientGroup.getGroupId()) {
                if (gid == null) continue;
                gid.getParent().removeChild(gid);
                clientGroup.removeGroupId(gid);
            }
        }
        for (int i = 0; i < fullAccessList.size(); ++i) {
            String group = fullAccessList.get(i);
            GroupId groupId = new GroupId();
            groupId.setOptContent(group);
            clientGroup.addGroupId(groupId);
        }
    }

    public void setDisallowedClientGroupList(List<String> noAccessList) {
        if (!this.hasPrivilege()) {
            return;
        }
        DisallowedClientGroup clientGroup = this.semPrivilege.getOptDisallowedClientGroup();
        if (clientGroup == null) {
            clientGroup = new DisallowedClientGroup();
            this.semPrivilege.setOptDisallowedClientGroup(clientGroup);
        } else {
            for (GroupId gid : clientGroup.getGroupId()) {
                if (gid == null) continue;
                gid.getParent().removeChild(gid);
                clientGroup.removeGroupId(gid);
            }
        }
        for (int i = 0; i < noAccessList.size(); ++i) {
            String group = noAccessList.get(i);
            GroupId groupId = new GroupId();
            groupId.setOptContent(group);
            clientGroup.addGroupId(groupId);
        }
    }

    public void setReadOnlyClientGroupList(List<String> readOnlyAccessList) {
        if (!this.hasPrivilege()) {
            return;
        }
        ReadOnlyClientGroup clientGroup = this.semPrivilege.getOptReadOnlyClientGroup();
        if (clientGroup == null) {
            clientGroup = new ReadOnlyClientGroup();
            this.semPrivilege.setOptReadOnlyClientGroup(clientGroup);
        } else {
            for (GroupId gid : clientGroup.getGroupId()) {
                if (gid == null) continue;
                gid.getParent().removeChild(gid);
                clientGroup.removeGroupId(gid);
            }
        }
        for (int i = 0; i < readOnlyAccessList.size(); ++i) {
            String group = readOnlyAccessList.get(i);
            GroupId groupId = new GroupId();
            groupId.setOptContent(group);
            clientGroup.addGroupId(groupId);
        }
    }

    public List<String> getAllowedClientGroupList() {
        if (!this.hasPrivilege()) {
            return null;
        }
        if (!this.checkPermission(null, AuthorizationManager.TopLevelPermission.MANAGE_GROUPS)) {
            return null;
        }
        AllowedClientGroup groups = this.semPrivilege.getAllowedClientGroup();
        if (groups == null) {
            return new ArrayList<String>(0);
        }
        int count = groups.getGroupIdCount();
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String gid_str;
            GroupId gid = groups.getGroupId(i);
            if (gid == null || (gid_str = gid.getOptContent()) == null || gid_str.length() == 0) continue;
            list.add(gid_str);
        }
        return list;
    }

    public List<String> getDisallowedClientGroupList() {
        if (!this.hasPrivilege()) {
            return null;
        }
        if (!this.checkPermission(null, AuthorizationManager.TopLevelPermission.MANAGE_GROUPS)) {
            return null;
        }
        DisallowedClientGroup groups = this.semPrivilege.getOptDisallowedClientGroup();
        if (groups == null) {
            return new ArrayList<String>(0);
        }
        int count = groups.getGroupIdCount();
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String gid_str;
            GroupId gid = groups.getGroupId(i);
            if (gid == null || (gid_str = gid.getOptContent()) == null || gid_str.length() == 0) continue;
            list.add(gid_str);
        }
        return list;
    }

    public List<String> getReadOnlyClientGroupList() {
        if (!this.hasPrivilege()) {
            return null;
        }
        if (!this.checkPermission(null, AuthorizationManager.TopLevelPermission.MANAGE_GROUPS)) {
            return null;
        }
        ReadOnlyClientGroup groups = this.semPrivilege.getOptReadOnlyClientGroup();
        if (groups == null) {
            return new ArrayList<String>(0);
        }
        int count = groups.getGroupIdCount();
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String gid_str;
            GroupId gid = groups.getGroupId(i);
            if (gid == null || (gid_str = gid.getOptContent()) == null || gid_str.length() == 0) continue;
            list.add(gid_str);
        }
        return list;
    }

    public boolean hasAccessRightToGroup(String groupId, boolean isParentAccessible) {
        return true;
    }

    public boolean hasAccessRightToGroup(String groupId, boolean isParentAccessible, boolean excludeReadOnly) {
        return true;
    }

    public boolean hasExecuteCommandRights() {
        return true;
    }

    @Deprecated
    public IntegerSet getDisallowedCommandSet() {
        String strCommands = null;
        if (this.hasPrivilege()) {
            strCommands = this.semPrivilege.getOptDisallowedCommand();
        }
        return AdminPrivilege.createIntegerSet(strCommands);
    }

    protected boolean hasOneAvailableSiteAllowed(List<String> availableSiteIds, boolean canBypassCheck) {
        SitePrivilegeSet sitePrivilegeSet = this.getSitePrivilegeSet();
        if (sitePrivilegeSet == null) {
            return false;
        }
        if (sitePrivilegeSet.getSitePrivilegeCount() == 0) {
            return false;
        }
        if (canBypassCheck) {
            return true;
        }
        return CollectionUtils.hasIntersection(this.getAllowedSiteIds(sitePrivilegeSet), availableSiteIds);
    }

    private List<String> getAllowedSiteIds(SitePrivilegeSet sitePrivilegeSet) {
        ArrayList<String> allowedSiteIds = new ArrayList<String>();
        for (SitePrivilege site : sitePrivilegeSet.getSitePrivilege()) {
            SitePrivilege sitePrivilege;
            PrivilegeValue value;
            if (site == null || (value = (sitePrivilege = site).getOptPrivilegeValue()) == null || value.getOptPrivilege() == 1) continue;
            allowedSiteIds.add(sitePrivilege.getRefSiteId());
        }
        return allowedSiteIds;
    }

    protected BasicPermission.PermissionsPair getSitePermissions() {
        BasicPermission.PermissionsPair result = new BasicPermission.PermissionsPair();
        if (this.semPrivilege == null || this.semPrivilege.getOptSitePrivilegeSet() == null) {
            return result;
        }
        for (SitePrivilege obj : this.semPrivilege.getOptSitePrivilegeSet().getSitePrivilege()) {
            SitePrivilege sitePrivilege = obj;
            if (sitePrivilege == null) continue;
            this.initSitePermission(sitePrivilege, result);
            this.initServerPermission(sitePrivilege, result);
            this.initDatabasePermission(sitePrivilege, result);
            this.initEnforcerPermission(sitePrivilege, result);
        }
        return result;
    }

    private void initSitePermission(SitePrivilege sitePrivilege, BasicPermission.PermissionsPair permissions) {
        Integer value;
        if (sitePrivilege.getOptPrivilegeValue() != null && (value = sitePrivilege.getOptPrivilegeValue().getOptPrivilege()) != null) {
            switch (value) {
                case 1: {
                    permissions.addDeniedPermission(new SitePermission(BasicPermission.AccessAction.valueOf(value), sitePrivilege.getRefSiteId()));
                    break;
                }
                case 0: {
                    permissions.addAllowedPermission(new SitePermission(BasicPermission.AccessAction.valueOf(value), sitePrivilege.getRefSiteId()));
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("The privilege value is inconsistant!");
                }
            }
        }
    }

    private void initServerPermission(SitePrivilege sitePrivilege, BasicPermission.PermissionsPair permissions) {
        ServerPrivilegeSet privilegeSet = sitePrivilege.getOptServerPrivilegeSet();
        if (privilegeSet != null) {
            Integer value;
            if (privilegeSet.getOptPrivilegeValue() != null && (value = privilegeSet.getOptPrivilegeValue().getOptPrivilege()) != null) {
                this.initPermissions(permissions, value, sitePrivilege.getRefSiteId(), "sepmserver");
                return;
            }
            for (ServerPrivilege obj : privilegeSet.getServerPrivilege()) {
                ServerPrivilege serverPrivilege = obj;
                if (serverPrivilege.getOptPrivilegeValue() == null) continue;
                Integer value2 = serverPrivilege.getOptPrivilegeValue().getOptPrivilege();
                this.initPermissions(permissions, value2, sitePrivilege.getRefSiteId(), "sepmserver", serverPrivilege.getRefServerId());
            }
        }
    }

    private void initDatabasePermission(SitePrivilege sitePrivilege, BasicPermission.PermissionsPair permissions) {
        DatabasePrivilege dbPrivilege;
        if (sitePrivilege.getOptDatabasePrivilege() != null && (dbPrivilege = sitePrivilege.getOptDatabasePrivilege()) != null && dbPrivilege.getOptPrivilegeValue() != null) {
            Integer value = dbPrivilege.getOptPrivilegeValue().getOptPrivilege();
            this.initPermissions(permissions, value, sitePrivilege.getRefSiteId(), "sepmdatabase");
        }
    }

    private void initEnforcerPermission(SitePrivilege sitePrivilege, BasicPermission.PermissionsPair permissions) {
        EnforcerGroupPrivilegeSet privilegeSet = sitePrivilege.getOptEnforcerGroupPrivilegeSet();
        if (privilegeSet != null) {
            Integer value;
            if (privilegeSet.getOptPrivilegeValue() != null && (value = privilegeSet.getOptPrivilegeValue().getOptPrivilege()) != null) {
                this.initPermissions(permissions, value, sitePrivilege.getRefSiteId(), "sepmenforcer");
                return;
            }
            for (EnforcerGroupPrivilege obj : privilegeSet.getEnforcerGroupPrivilege()) {
                EnforcerGroupPrivilege enforcerPrivilege = obj;
                if (enforcerPrivilege.getOptPrivilegeValue() == null) continue;
                Integer value2 = enforcerPrivilege.getOptPrivilegeValue().getOptPrivilege();
                this.initPermissions(permissions, value2, sitePrivilege.getRefSiteId(), "sepmenforcer", enforcerPrivilege.getRefEnforcerGroupId());
            }
        }
    }

    private void initPermissions(BasicPermission.PermissionsPair p, Integer value, String ... ids) {
        if (value != null) {
            switch (value) {
                case 1: {
                    p.addDeniedPermission(new SitePermission(BasicPermission.AccessAction.valueOf(value), ids));
                    break;
                }
                case 2: {
                    p.addAllowedPermission(new SitePermission(BasicPermission.AccessAction.valueOf(value), ids));
                    break;
                }
                case 0: {
                    p.addAllowedPermission(new SitePermission(BasicPermission.AccessAction.valueOf(value), ids));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("The privilege value is inconsistant!");
                }
            }
        }
    }
}

