/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.common.acl;

import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.BasicPermission;
import com.sygate.scm.common.acl.GroupPermission;
import com.sygate.scm.common.acl.GroupPolicyPermission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.acl.SitePermission;
import com.sygate.scm.common.configobject.SchemaHelper;
import com.sygate.scm.common.configobject.schema.EnforcerGroup;
import com.sygate.scm.common.configobject.schema.PrivilegeValue;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SitePrivilegeSet;
import java.util.Set;

public class AdminACLUtils {
    private AdminACLUtils() {
    }

    public static boolean hasAllFullAccessPermission(PrivilegeContext context, SemClientGroup group, Set<String> groupIds) {
        AuthorizationManager manager;
        if (context == null || group == null || groupIds == null || groupIds.isEmpty()) {
            return false;
        }
        if (groupIds.contains(group.getId()) && !(manager = AuthorizationManager.getInstance()).checkPermission(context, new GroupPermission(group, BasicPermission.AccessAction.FULL_ACCESS))) {
            return false;
        }
        for (SemClientGroup child : group.getSemClientGroup()) {
            if (AdminACLUtils.hasAllFullAccessPermission(context, child, groupIds)) continue;
            return false;
        }
        return true;
    }

    public static PrivilegeValue getPrivilegeValue(SitePrivilegeSet privilegeSet, SemServer server) {
        PrivilegeContext context;
        PrivilegeValue result = new PrivilegeValue();
        AuthorizationManager manager = AuthorizationManager.getInstance();
        if (manager.checkPermission(context = PrivilegeContext.newInstance(privilegeSet), new SitePermission(server, BasicPermission.AccessAction.FULL_ACCESS))) {
            result.setOptPrivilege(0);
        } else if (manager.checkPermission(context, new SitePermission(server, BasicPermission.AccessAction.READ_ONLY))) {
            result.setOptPrivilege(2);
        } else {
            result.setOptPrivilege(1);
        }
        return result;
    }

    public static PrivilegeValue getPrivilegeValue(SitePrivilegeSet privilegeSet, EnforcerGroup enforcer) {
        PrivilegeContext context;
        PrivilegeValue result = new PrivilegeValue();
        AuthorizationManager manager = AuthorizationManager.getInstance();
        if (manager.checkPermission(context = PrivilegeContext.newInstance(privilegeSet), new SitePermission(enforcer, BasicPermission.AccessAction.FULL_ACCESS))) {
            result.setOptPrivilege(0);
        } else if (manager.checkPermission(context, new SitePermission(enforcer, BasicPermission.AccessAction.READ_ONLY))) {
            result.setOptPrivilege(2);
        } else {
            result.setOptPrivilege(1);
        }
        return result;
    }

    public static boolean isAccessDenied(SitePrivilegeSet privilegeSet, SemServer server) {
        AuthorizationManager manager = AuthorizationManager.getInstance();
        PrivilegeContext context = PrivilegeContext.newInstance(privilegeSet);
        return manager.checkPermission(context, new SitePermission(server, BasicPermission.AccessAction.NO_ACCESS));
    }

    public static boolean isAccessDenied(SitePrivilegeSet privilegeSet, EnforcerGroup enforcer) {
        AuthorizationManager manager = AuthorizationManager.getInstance();
        PrivilegeContext context = PrivilegeContext.newInstance(privilegeSet);
        return manager.checkPermission(context, new SitePermission(enforcer, BasicPermission.AccessAction.NO_ACCESS));
    }

    public static boolean isSharedPolicyReadOnly(PrivilegeContext context) {
        AuthorizationManager manager = AuthorizationManager.getInstance();
        return !manager.checkPermission(context, AuthorizationManager.PolicyPermission.EDIT_SHARED_POLICIES);
    }

    public static boolean isNonSharedPolicyReadOnly(PrivilegeContext context, SemClientGroup group, GroupPolicyPermission.GroupPolicyMode mode) {
        GroupPolicyPermission permission;
        AuthorizationManager manager = AuthorizationManager.getInstance();
        return !manager.checkPermission(context, permission = new GroupPolicyPermission(group, mode));
    }

    public static boolean checkSiteFullAccessPermission(PrivilegeContext context, SemSite site) {
        SitePermission sitePermission = new SitePermission(site, BasicPermission.AccessAction.FULL_ACCESS);
        return AuthorizationManager.getInstance().checkPermission(context, sitePermission);
    }

    public static boolean checkDbFullAccessPermission(PrivilegeContext context, SemSite site) {
        return AdminACLUtils.checkDbPermission(context, site, BasicPermission.AccessAction.FULL_ACCESS);
    }

    public static boolean checkDbReadOnlyPermission(PrivilegeContext context, SemSite site) {
        return AdminACLUtils.checkDbPermission(context, site, BasicPermission.AccessAction.READ_ONLY);
    }

    static boolean checkDbPermission(PrivilegeContext context, SemSite site, BasicPermission.AccessAction access) {
        SitePermission dbPermission = new SitePermission(SchemaHelper.getDatabase(site), access);
        return AuthorizationManager.getInstance().checkPermission(context, dbPermission);
    }
}

