/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.core.util;

import com.creamtec.ajaxswing.v4.utils.FontUtils;
import com.creamtec.core.TraceMgr;
import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FontCalibration
extends Canvas {
    private static final String FONT_CALIBRATION_PROPERTIES = System.getProperty("ajaxswing.home") + File.separator + "conf" + File.separator + "fontsForCalibration.properties";
    private static final String STANDARD_STRING = "Existing Package Deployment";
    private static final String CAPITAL_STRING = "[COMMON_DESKTOPDIRECTORY];[COMMON_APPDATA];";
    private StringBuilder generatedHTML = new StringBuilder();
    private int left = 5;
    private int top = 0;

    public FontCalibration() {
        this.generatedHTML.append("<div id=\"fontCalibrationDiv\">");
        HashMap<String, HashSet<Integer>> fontPropertiesMap = this.readFile(FONT_CALIBRATION_PROPERTIES);
        boolean i = false;
        for (Map.Entry<String, HashSet<Integer>> fontProperties : fontPropertiesMap.entrySet()) {
            for (Integer fontSize : fontProperties.getValue()) {
                Font font = new Font(fontProperties.getKey(), 0, fontSize);
                this.generateLabelDivs(font, false);
                this.generateLabelDivs(font, true);
            }
        }
        this.generatedHTML.append("</div>");
    }

    public void generateLabelDivs(Font font, boolean isCapital) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        String text = null;
        this.generatedHTML.append("<div class=\"JLabel ");
        if (isCapital) {
            this.generatedHTML.append("capital");
            text = CAPITAL_STRING;
        } else {
            this.generatedHTML.append("standard");
            text = STANDARD_STRING;
        }
        this.generatedHTML.append("\">");
        this.generatedHTML.append("<div class=\"htmlString\" style=\"position:absolute;left:");
        this.generatedHTML.append(this.left);
        this.generatedHTML.append("px;top:");
        this.generatedHTML.append(this.top);
        this.generatedHTML.append("px;width:");
        this.generatedHTML.append(fontMetrics.stringWidth(text));
        this.top += fontMetrics.getHeight();
        this.generatedHTML.append("px;white-space:nowrap;text-align:left;color:#333333;");
        this.generatedHTML.append(FontUtils.generateFontStyleString(font));
        this.generatedHTML.append("\">");
        this.generatedHTML.append(text);
        this.generatedHTML.append("</div>\n</div>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, HashSet<Integer>> readFile(String file) {
        BufferedReader reader = null;
        HashMap<String, HashSet<Integer>> fonts = new HashMap<String, HashSet<Integer>>();
        TraceMgr.trace("Reading properties from " + file, 5);
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                TraceMgr.trace("Adding font " + line, 5);
                this.addToFontsMap(line, fonts);
            }
        }
        catch (IOException e) {
            TraceMgr.trace("Error while reading properties from " + file, e, 5);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                TraceMgr.trace("Error while closing resources", e, 5);
            }
        }
        return fonts;
    }

    private void addToFontsMap(String line, HashMap<String, HashSet<Integer>> fonts) {
        String[] keyValue = line.split(",");
        String fontName = keyValue[0].trim();
        if (!fonts.containsKey(fontName)) {
            fonts.put(fontName, new HashSet());
        }
        fonts.get(fontName).addAll(this.getFontSizes(keyValue[1].trim()));
    }

    private Set<Integer> getFontSizes(String fontSizes) {
        HashSet<Integer> sizes = new HashSet<Integer>();
        if (fontSizes.contains("-")) {
            String[] sizeRange = fontSizes.split("-");
            int rangeFrom = Integer.parseInt(sizeRange[0]);
            int rangeTo = Integer.parseInt(sizeRange[1]);
            for (int i = rangeFrom; i <= rangeTo; ++i) {
                sizes.add(i);
            }
        } else {
            sizes.add(Integer.parseInt(fontSizes));
        }
        return sizes;
    }

    public String getGeneratedHTML() {
        return this.generatedHTML.toString();
    }
}

