/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.core;

import com.creamtec.core.TraceMgr;
import java.io.File;
import java.io.InputStream;

public class Utilities {
    public static final String CREAMTEC_ROOT = "com.creamtec.home";
    private static String rootDir = null;

    private Utilities() {
    }

    public static String getRootDir() {
        if (rootDir == null) {
            rootDir = System.getProperty(CREAMTEC_ROOT);
        }
        return rootDir;
    }

    public static String getConfDir() {
        String rootDir = Utilities.getRootDir();
        if (rootDir == null) {
            return "conf";
        }
        return rootDir + File.separatorChar + "conf";
    }

    public static String getFullPath(String fileName) {
        Object fullPath = Utilities.getRootDir();
        if (fullPath == null) {
            return fileName;
        }
        fullPath = (String)fullPath + File.separatorChar;
        fullPath = (String)fullPath + fileName;
        return fullPath;
    }

    public static String getConfFullPath(String fileName) {
        return Utilities.getConfDir() + File.separatorChar + fileName;
    }

    public static void setRootDir(String dir) {
        rootDir = dir;
    }

    public static void execProcess(String[] cmdParams, boolean wait) throws Exception {
        TraceMgr.trace(Utilities.class, "execProcess, executing: " + cmdParams, 4);
        Process process = Runtime.getRuntime().exec(cmdParams);
        TraceMgr.trace(Utilities.class, "execProcess, command executed: " + cmdParams, 4);
        Utilities.execProcessImpl(process, wait);
    }

    public static void execProcess(String cmdLine, boolean wait) throws Exception {
        TraceMgr.trace(Utilities.class, "execProcess, executing: " + cmdLine, 4);
        Process process = Runtime.getRuntime().exec(cmdLine);
        TraceMgr.trace(Utilities.class, "execProcess, command executed: " + cmdLine, 4);
        Utilities.execProcessImpl(process, wait);
    }

    public static void execProcessImpl(final Process process, boolean wait) throws Exception {
        final InputStream iStream = process.getInputStream();
        final InputStream eStream = process.getErrorStream();
        new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        try {
                            process.exitValue();
                        }
                        catch (Exception exception) {
                            int ch;
                            while (iStream.available() > 0 && (ch = iStream.read()) != -1) {
                                System.out.print((char)ch);
                            }
                            while (eStream.available() > 0 && (ch = eStream.read()) != -1) {
                                System.out.print((char)ch);
                            }
                            Thread.sleep(1000L);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("Finished reading output");
            }
        }.start();
        if (wait) {
            TraceMgr.trace(Utilities.class, "execProcess, waiting for the process...");
            process.waitFor();
        }
        TraceMgr.trace(Utilities.class, "execProcess, Success");
    }

    public static Exception wrapThrowable(Throwable x) {
        if (x instanceof Exception) {
            return (Exception)x;
        }
        return new RuntimeException(x);
    }
}

