/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.core;

import com.creamtec.core.TraceMgr;
import java.util.Properties;

public class StringUtilities {
    public static String replaceParameters(String text, Properties params) throws IllegalArgumentException {
        if (text == null) {
            return null;
        }
        int i = 0;
        StringBuffer output = new StringBuffer(text.length());
        block5: while (i < text.length()) {
            boolean startWithAmp = false;
            switch (text.charAt(i)) {
                case '$': {
                    if (++i < text.length() && text.charAt(i) == '{') {
                        startWithAmp = true;
                    } else {
                        output.append('$');
                        continue block5;
                    }
                }
                case '{': {
                    if (i < text.length() - 1 && text.charAt(i + 1) == '{') {
                        if (startWithAmp) {
                            output.append("$");
                        }
                        output.append('{');
                        i += 2;
                        continue block5;
                    }
                    int paramEnd = text.indexOf(125, i);
                    if (paramEnd == -1) {
                        throw new IllegalArgumentException("No matching closing } found for parameter started at position " + i);
                    }
                    String param = text.substring(i + 1, paramEnd);
                    String value = params.getProperty(param);
                    if (value == null) {
                        throw new IllegalArgumentException("No value found for parameter " + param);
                    }
                    if (!startWithAmp) {
                        TraceMgr.trace("Use ${key} syntax instead of {key} for parameter " + param + ". Format {key} is deprecated and will be deleted in futures releases. Key - " + param, 3);
                    }
                    output.append(value);
                    i = paramEnd + 1;
                    continue block5;
                }
                case '}': {
                    if (i < text.length() - 1 && text.charAt(i + 1) == '}') {
                        output.append('}');
                        i += 2;
                        continue block5;
                    }
                    output.append(text.charAt(i));
                    ++i;
                    continue block5;
                }
            }
            output.append(text.charAt(i));
            ++i;
        }
        return output.toString();
    }

    public static StringBuilder appendToLazyBuffer(StringBuilder buffer, char ch, int initialLength) {
        if (buffer == null) {
            buffer = new StringBuilder(initialLength);
        }
        buffer.append(ch);
        return buffer;
    }

    public static StringBuilder appendToLazyBuffer(StringBuilder buffer, String string, int initialLength) {
        if (buffer == null) {
            buffer = new StringBuilder(initialLength);
        }
        buffer.append(string);
        return buffer;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

