/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.core;

import com.creamtec.ajaxswing.gui.VersionHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassPatcher {
    public static String rootDir = System.getProperty("com.creamtec.home");

    public static void main(String[] args) throws Exception {
        VersionHelper.init(false);
        VersionHelper.checkJdkVersion();
        if (VersionHelper.CURRENT_JDK_VERSION.startsWith("1.5")) {
            ClassPatcher.patchClass("java.awt.Component", new String[]{"getTreeLock", "getFont"});
        } else {
            ClassPatcher.patchClass("java.awt.Component", new String[]{"getTreeLock", "getFont", "isRequestFocusAccepted"});
        }
        ClassPatcher.patchClass("javax.swing.JComponent", new String[]{"paint", "paintChildren"});
        ClassPatcher.patchClass("javax.swing.UIManager", new String[]{"setLookAndFeel"});
        ClassPatcher.patchClass("javax.swing.MenuSelectionManager", new String[]{"defaultManager"});
        ClassPatcher.patchClass("java.awt.GraphicsEnvironment", new String[]{"isHeadless", "checkHeadless"});
        ClassPatcher.patchClass("java.awt.AWTEvent", new String[]{"setSource"});
        ClassPatcher.patchClass("java.awt.MouseInfo", new String[]{"getPointerInfo"});
        ClassPatcher.patchClass("java.awt.KeyboardFocusManager", new String[]{"getCurrentKeyboardFocusManager", "setCurrentKeyboardFocusManager"});
        ClassPatcher.patchClass("java.awt.AWTEvent$1", new String[0]);
        ClassPatcher.patchClass("java.awt.AWTEvent$2", new String[0]);
        ClassPatcher.patchClass("javax.swing.JTable", new String[]{"prepareRenderer", "prepareEditor"});
        ClassPatcher.patchClass("javax.swing.table.DefaultTableCellRenderer", new String[]{"getTableCellRendererComponent"});
        ClassPatcher.patchClass("javax.swing.plaf.basic.BasicTableHeaderUI", new String[]{"getHeaderRenderer"});
        ClassPatcher.patchClass("javax.swing.plaf.basic.BasicPopupMenuUI", new String[]{"installListeners"});
        ClassPatcher.patchClass("javax.swing.plaf.basic.BasicPopupMenuUI$MouseGrabber", new String[]{"uninstall"});
        ClassPatcher.patchClass("javax.swing.plaf.metal.MetalComboBoxIcon", new String[]{"paintIcon"});
        ClassPatcher.patchClass("sun.font.ExtendedTextSourceLabel", new String[]{"handleDraw"});
    }

    private static void patchClass(String className, String[] methodNames) throws Exception {
        String zipFileName = rootDir + "/lib/boot/ajsJava.jar";
        ZipFile zipFile = new ZipFile(zipFileName);
        InputStream inputStream = ClassPatcher.getPatchInputStream(className, zipFile);
        if (inputStream == null && methodNames.length == 0) {
            return;
        }
        ClassNode patchClass = new ClassNode();
        ClassReader patchReader = new ClassReader(inputStream);
        patchReader.accept((ClassVisitor)patchClass, 0);
        ClassNode targetClass = new ClassNode();
        ClassReader reader = new ClassReader(className);
        reader.accept((ClassVisitor)targetClass, 0);
        for (int i = 0; i < methodNames.length; ++i) {
            ClassPatcher.patchMethods(patchClass, targetClass, methodNames[i]);
        }
        ClassWriter writer = new ClassWriter(reader, 0);
        targetClass.accept((ClassVisitor)writer);
        ClassPatcher.updateZipFile(zipFileName, className, writer);
    }

    private static InputStream getPatchInputStream(String className, ZipFile patchZipFile) throws IOException {
        String patchEntryName = className.replace('.', '/') + ".class";
        ZipEntry patchEntry = patchZipFile.getEntry(patchEntryName);
        if (patchEntry == null) {
            return null;
        }
        InputStream inputStream = patchZipFile.getInputStream(patchEntry);
        return inputStream;
    }

    private static void patchMethods(ClassNode patchClass, ClassNode targetClass, String methodName) {
        List patchMethodIndex = ClassPatcher.findMethodIndex(patchClass, methodName);
        List targetMethodIndex = ClassPatcher.findMethodIndex(targetClass, methodName);
        if (patchMethodIndex.isEmpty() || targetMethodIndex.isEmpty()) {
            throw new IllegalArgumentException("Class " + patchClass.name + " does not have method " + methodName);
        }
        if (patchMethodIndex.size() == targetMethodIndex.size()) {
            for (int i = 0; i < patchMethodIndex.size(); ++i) {
                MethodNode patchMethod = (MethodNode)patchClass.methods.get((Integer)patchMethodIndex.get(i));
                targetClass.methods.set((Integer)targetMethodIndex.get(i), patchMethod);
            }
        }
    }

    private static List findMethodIndex(ClassNode patchClass, String methodName) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < patchClass.methods.size(); ++i) {
            MethodNode method = (MethodNode)patchClass.methods.get(i);
            if (!methodName.equals(method.name)) continue;
            System.out.println("Class - " + patchClass.name + ", method - " + method.name);
            indexes.add(i);
        }
        return indexes;
    }

    private static String getSimpleClassName(String className) {
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            className = className.substring(lastDot + 1);
        }
        return className;
    }

    private static void updateZipFile(String zipFileName, String className, ClassWriter writer) throws Exception {
        File bootDir;
        String[] dirs = className.split("\\.");
        File dir = bootDir = new File(rootDir + "/lib/boot");
        for (int i = 0; i < dirs.length - 1; ++i) {
            if ((dir = new File(dir, dirs[i])).exists() || dir.mkdir()) continue;
            throw new RuntimeException("Failed to create subdirectory " + dir);
        }
        String simpleClassName = ClassPatcher.getSimpleClassName(className);
        File classFile = new File(dir, simpleClassName + ".class");
        System.out.println("Writing patched file to " + classFile.getAbsolutePath());
        byte[] bytes = writer.toByteArray();
        FileOutputStream fileWriter = new FileOutputStream(classFile);
        fileWriter.write(bytes);
        fileWriter.close();
    }
}

