/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.core;

import com.creamtec.core.TraceMgr;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class AppProperties
extends Properties {
    private static final long serialVersionUID = 599352569124903942L;
    protected String fileName;
    protected String appName;

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public AppProperties(String fileName) {
        this(fileName, true);
    }

    public AppProperties(String fileName, boolean trace) {
        if (trace) {
            TraceMgr.trace(this, "Constructor, fileName = " + fileName);
        }
        this.fileName = fileName;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            this.load(fis);
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    TraceMgr.trace("Failed to close input stream", e);
                }
            }
        }
    }

    public AppProperties(Properties defaults) throws Exception {
        super(defaults);
    }

    public AppProperties() {
    }

    public boolean getBooleanProperty(String key, boolean defValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defValue;
        }
        return value.equalsIgnoreCase("true");
    }

    public void setBooleanProperty(String key, boolean value) {
        this.setProperty(key, value ? "true" : "false");
    }

    public int getIntProperty(String key, int defValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defValue;
        }
        return Integer.parseInt(value);
    }

    public void setIntProperty(String key, int value) {
        this.setProperty(key, String.valueOf(value));
    }

    public String getFileName() {
        return this.fileName;
    }
}

