/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.v4.utils;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class FontUtils {
    private static final Properties FONT_CONFIG = FontUtils.getFontConfig();

    public static String generateFontStyleString(Font font) {
        StringBuilder result = new StringBuilder();
        result.append(";font-family:");
        result.append(FontUtils.getFontName(font));
        result.append(";font-size:");
        result.append(font.getSize());
        result.append("px");
        result.append(";font-weight:");
        result.append(font.isBold() ? "bold" : "normal");
        if (font.isItalic()) {
            result.append(";font-style:italic");
        }
        return result.toString();
    }

    private static Properties getFontConfig() {
        Properties properties;
        FileInputStream jreFontConfigInputStream = null;
        try {
            Properties jreFontProperties = new Properties();
            jreFontConfigInputStream = FontUtils.getJREFontConfigInputStream();
            jreFontProperties.load(jreFontConfigInputStream);
            properties = FontUtils.filterAndTransform(jreFontProperties);
        }
        catch (Exception e) {
            Properties properties2;
            try {
                properties2 = FontUtils.getAJSFontConfig();
            }
            catch (Throwable throwable) {
                FontUtils.closeQuietly(jreFontConfigInputStream);
                throw throwable;
            }
            FontUtils.closeQuietly(jreFontConfigInputStream);
            return properties2;
        }
        FontUtils.closeQuietly(jreFontConfigInputStream);
        return properties;
    }

    private static FileInputStream getJREFontConfigInputStream() throws IOException {
        return new FileInputStream(System.getenv("JAVA_HOME") + File.separator + "lib" + File.separator + "fontconfig.properties.src");
    }

    private static FileInputStream getAJSFontConfigInputStream() throws FileNotFoundException {
        return new FileInputStream(System.getenv("AJAXSWING_HOME") + File.separator + "conf" + File.separator + "fontconfig.properties");
    }

    private static Properties filterAndTransform(Properties properties) {
        Properties filteredAndTransformed = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!entry.getKey().toString().contains("plain.alphabetic")) continue;
            filteredAndTransformed.put(FontUtils.transformKey(entry), entry.getValue().toString());
        }
        return filteredAndTransformed;
    }

    private static String transformKey(Map.Entry<Object, Object> entry) {
        return entry.getKey().toString().replace(".plain.alphabetic", "");
    }

    public static String getFontName(Font font) {
        String fontName = font.getName().toLowerCase().replace(" ", "");
        if (FONT_CONFIG.containsKey(fontName)) {
            return FONT_CONFIG.getProperty(fontName);
        }
        return fontName;
    }

    private static Properties getAJSFontConfig() {
        FileInputStream ajsFontConfigInputStream = null;
        try {
            ajsFontConfigInputStream = FontUtils.getAJSFontConfigInputStream();
            Properties ajsFontProperties = new Properties();
            ajsFontProperties.load(ajsFontConfigInputStream);
            Properties properties = ajsFontProperties;
            return properties;
        }
        catch (IOException e) {
            Properties properties = FontUtils.getDefaultFontConfig();
            return properties;
        }
        finally {
            FontUtils.closeQuietly(ajsFontConfigInputStream);
        }
    }

    private static Properties getDefaultFontConfig() {
        Properties properties = new Properties();
        properties.setProperty("serif", "Times New Roman");
        properties.setProperty("sansserif", "Arial");
        properties.setProperty("monospaced", "Courier New");
        properties.setProperty("dialog", "Arial");
        properties.setProperty("dialoginput", "Courier New");
        return properties;
    }

    private static void closeQuietly(FileInputStream fileInputStream) {
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

