/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.servlet;

import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.AjaxSwingPropertiesManager;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.ClientAgentRemote;
import com.creamtec.ajaxswing.servlet.AppDescBase;
import com.creamtec.ajaxswing.servlet.SessionListener;
import com.creamtec.ajaxswing.servlet.SessionManager;
import com.creamtec.core.AppProperties;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.util.HashMap;
import java.util.Iterator;

public abstract class AppDesc
extends AppDescBase
implements SessionListener {
    public String appName;
    public boolean inProcess = true;
    public String tempDirPath;
    protected AppProperties props;
    public HashMap agents = new HashMap();
    protected SessionManager sessionManager;
    protected ClientAgent infantAgent;

    public AppDesc(String appName) throws Exception {
        AppDesc.initLicense();
        try {
            this.props = AjaxSwingPropertiesManager.getInstance().getAppProperties(appName);
        }
        catch (Exception x) {
            AjaxSwingPropertiesManager.init(Utilities.getConfDir());
            this.props = AjaxSwingPropertiesManager.getInstance().getAppProperties(appName);
        }
        this.appName = appName;
        this.inProcess = this.props.getBooleanProperty("router.inProcess", true);
        long sessionTimeout = this.props.getIntProperty("router.sessionTimeout", 300);
        this.sessionManager = new SessionManager(sessionTimeout);
    }

    public boolean isInProcess() {
        return this.inProcess;
    }

    public AppProperties getProps() {
        return this.props;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void addAgent(Object session, ClientAgentRemote agent) throws AjaxSwingException {
        TraceMgr.trace((Object)this, "Add agent", 6);
        if (this.getAgentsCount() >= CONNECTIONS_LIMIT) {
            throw new AjaxSwingException("The maximum allowed number of concurrent clients has been reached. Please contact CreamTec at <A HREF=\"http://creamtec.com\">http://creamtec.com</A> to upgrade your edition of AjaxSwing", false);
        }
        this.agents.put(session, agent);
        this.sessionManager.addSession(session, this, agent);
    }

    public ClientAgentRemote getAgent(Object session) {
        return (ClientAgentRemote)this.agents.get(session);
    }

    public Object getSession(ClientAgentRemote agent) {
        for (Object session : this.agents.keySet()) {
            if (this.getAgent(session) != agent) continue;
            return session;
        }
        return null;
    }

    public void removeAgent(Object session) {
        TraceMgr.trace((Object)this, "Remove agent", 6);
        this.agents.remove(session);
        this.sessionManager.removeSession(session);
    }

    public Iterator getAgents() {
        return this.agents.values().iterator();
    }

    public int getAgentsCount() {
        return this.agents.size();
    }

    public String getAppName() {
        return this.appName;
    }

    public String getTempDirPath() {
        return this.tempDirPath;
    }
}

