/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.rendering;

import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.rendering.DocumentRenderer;
import com.creamtec.core.TraceMgr;

public class DocumentRendererFactory {
    protected static DocumentRendererFactory instance;

    public static DocumentRendererFactory getInstance() {
        if (instance == null) {
            DocumentRendererFactory.init();
        }
        return instance;
    }

    protected static synchronized void init() {
        if (instance == null) {
            instance = new DocumentRendererFactory();
        }
    }

    public DocumentRenderer createDocumentRenderer(ClientAgent agent) throws Exception {
        String rendererClassName = agent.getProps().getProperty("document.renderer");
        TraceMgr.trace(this, "Loading document renderer " + rendererClassName);
        Class<?> rendererClass = agent.getClassLoader().loadClass(rendererClassName);
        Object renderer = rendererClass.newInstance();
        if (!(renderer instanceof DocumentRenderer)) {
            throw new AjaxSwingException("Error: document renderer " + rendererClassName + " needs to implement DocumentRenderer interface");
        }
        return (DocumentRenderer)renderer;
    }
}

