/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.rendering;

import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.gui.peer.ClientAgentBase;
import com.creamtec.ajaxswing.gui.peer.LicenseManagerDup;
import com.creamtec.ajaxswing.rendering.Document;
import com.creamtec.ajaxswing.rendering.DocumentRenderer;
import com.creamtec.ajaxswing.v4.render.ComponentRenderer;
import com.creamtec.ajaxswing.v4.render.TemplateRenderer;
import com.creamtec.core.AppProperties;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public abstract class AbstractDocumentRenderer
implements DocumentRenderer {
    public static boolean LIMIT_MODE = true;
    private static boolean licenseVerified = false;
    protected ComponentRenderer defaultComponentRenderer;
    private static boolean dummyField1 = true;
    private static boolean dummyField2 = false;
    protected Hashtable componentRenderersMap = new Hashtable();
    protected int inflateWidth;
    protected int inflateHeight;

    public AbstractDocumentRenderer() {
        TraceMgr.trace(this, "constructor");
        if (!licenseVerified) {
            licenseVerified = true;
            AppProperties licenseProps = ClientAgentBase.initLicense(false);
            LicenseManagerDup.initInstance(licenseProps);
        }
        this.initRenderers();
    }

    protected void renderWindow(Document page, Window window) throws Exception {
    }

    public abstract Document createDocument() throws Exception;

    @Override
    public abstract Document renderDocument(ClientAgent var1, List<Window> var2) throws Exception;

    public void initializeDocument(Document document) {
        TraceMgr.trace((Object)this, "Initializing the document...", 6);
        for (ComponentRenderer renderer : this.componentRenderersMap.values()) {
            try {
                renderer.initialize();
            }
            catch (Throwable x) {
                TraceMgr.trace((Object)this, "Component renderer initializeDocument() failed for " + renderer.getClass().getName(), 1);
                throw new RuntimeException(x);
            }
        }
    }

    public ComponentRenderer getComponentRenderer(String className) {
        return (ComponentRenderer)this.componentRenderersMap.get(className);
    }

    public ComponentRenderer getComponentRenderer(Object component) {
        Class<?> cls;
        ComponentRenderer renderer = null;
        for (cls = component.getClass(); cls != Object.class && (renderer = this.getComponentRenderer(cls.getName())) == null; cls = cls.getSuperclass()) {
        }
        if (renderer == null) {
            renderer = this.defaultComponentRenderer;
        }
        if (cls != component.getClass()) {
            this.componentRenderersMap.put(component.getClass().getName(), renderer);
        }
        return renderer;
    }

    private void initRenderers() {
        TraceMgr.trace((Object)this, "Initializing custom renderers...", 6);
        ClientAgent agent = ClientAgent.getCurrentInstance();
        if (agent != null) {
            Enumeration<Object> keys = agent.getProps().keys();
            int customRenderersCount = 0;
            if (!agent.getProps().containsKey("renderer.java.awt.Component")) {
                agent.getProps().put("renderer.java.awt.Component", "com.creamtec.ajaxswing.v4.render.DefaultComponentProcessor");
            }
            if (!agent.getProps().containsKey("org.jfree.chart.ChartPanel")) {
                agent.getProps().put("renderer.org.jfree.chart.ChartPanel", "com.creamtec.ajaxswing.v4.render.SnapshotRenderer");
            }
            if (!agent.getProps().containsKey("renderer.javax.swing.JFileChooser")) {
                agent.getProps().put("renderer.javax.swing.JFileChooser", "com.creamtec.ajaxswing.v4.render.DefaultJFileChooserProcessor");
            }
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith("renderer.")) continue;
                String rendererClassName = agent.getProps().getProperty(key);
                TraceMgr.trace((Object)this, "Loading custom renderer " + rendererClassName + " for class " + key.substring(7), 6);
                rendererClassName = rendererClassName.trim();
                if (!rendererClassName.startsWith("com.creamtec.") && ++customRenderersCount > 1 && LIMIT_MODE) continue;
                try {
                    Class<?> rendererClass = agent.getClassLoader().loadClass(rendererClassName);
                    Object renderer = rendererClass.newInstance();
                    if (!(renderer instanceof ComponentRenderer)) {
                        throw new AjaxSwingException("Error: Custom renderer " + rendererClassName + " does not implement interface ComponentRenderer");
                    }
                    this.componentRenderersMap.put(key.substring(9), renderer);
                    TraceMgr.trace((Object)this, "Sucessfully registered renderer", 6);
                }
                catch (Throwable x) {
                    TraceMgr.trace((Object)this, "Failed to load custom renderer " + rendererClassName, x);
                }
            }
            try {
                this.initTemplateRenderers("default-component", agent);
                this.initTemplateRenderers("custom-component", agent);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            TraceMgr.trace((Object)this, "*** Warning: failed to determine the agent to load custom renderers", 3);
        }
    }

    protected void initTemplateRenderers(String subdirName, ClientAgent agent) throws Exception {
        String dirName = Utilities.getConfFullPath("templates" + File.separator + subdirName);
        File customComponentsDir = new File(dirName);
        TraceMgr.trace((Object)this, "Loading template renderers from " + customComponentsDir.getAbsolutePath(), 4);
        File[] files = customComponentsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".html");
            }
        });
        Class<?> rendererClass = agent.getClassLoader().loadClass("com.creamtec.ajaxswing.v4.render.TemplateRendererImpl");
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile()) continue;
            if (i > 1 && LIMIT_MODE) break;
            TemplateRenderer renderer = (TemplateRenderer)rendererClass.newInstance();
            renderer.setTemplateName(subdirName + File.separator + files[i].getName());
            String className = files[i].getName();
            if (className.endsWith(".html")) {
                className = className.substring(0, className.length() - 5);
            }
            if (!this.componentRenderersMap.containsKey(className)) {
                this.componentRenderersMap.put(className, renderer);
            }
            TraceMgr.trace((Object)this, "Initialized template renderer for custom component " + className, 6);
        }
    }

    public void redirectoToStandardPage(ClientAgent agent, int status, Throwable x) throws Exception {
    }
}

