/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.rendering;

import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.rendering.AbstractDocumentRenderer;
import com.creamtec.ajaxswing.rendering.Document;
import com.creamtec.ajaxswing.rendering.RenderContext;
import com.creamtec.core.TraceMgr;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;

public abstract class AbstractDocument
extends Observable
implements Document {
    private String title = "";
    protected String docsURL;
    protected String themeDocsURL;
    private String themeName;
    protected RenderContext context = new RenderContext();
    private Map props = new HashMap();
    private ClientAgent agent;
    private boolean partialUpdateAllowed;
    private String redirectURL;
    private AbstractDocumentRenderer documentRenderer;

    public void reset(boolean complete) {
        this.redirectURL = null;
    }

    public void setClientAgent(ClientAgent agent) {
        this.agent = agent;
        this.setDocumentRenderer(agent.getPageRenderer());
        this.reset(true);
    }

    public RenderContext getRenderContext() {
        return this.context;
    }

    public Map getProps() {
        return this.props;
    }

    public String getThemeName() {
        if (this.themeName == null) {
            this.themeName = this.getClientAgent().getProps().getProperty("html.theme", "AjaxSwing");
        }
        return this.themeName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ClientAgent getClientAgent() {
        return this.agent;
    }

    @Override
    public void beforeRender() {
        if (TraceMgr.getCutoffLevel() > 5) {
            TraceMgr.trace((Object)this, "beforeRender, blocked windows size = " + this.getRenderContext().blockedWindows.size(), 6);
        }
        this.getRenderContext().reset();
    }

    @Override
    public void afterRender() {
        TraceMgr.trace((Object)this, "afterRender", 6);
        this.getRenderContext().errorMessage = null;
        this.getRenderContext().errorMessageTitle = null;
        this.getRenderContext().errorMessageAutoRefreshText = null;
        this.getRenderContext().errorRefreshTime = 0;
    }

    public void setPartialUpdateAllowed(boolean partialUpdateAllowed) {
        if (TraceMgr.getCutoffLevel() >= 6) {
            TraceMgr.trace(this, "setPartialUpdateAllowed = " + partialUpdateAllowed);
        }
        this.partialUpdateAllowed = partialUpdateAllowed;
    }

    public boolean isPartialUpdateAllowed() {
        return this.partialUpdateAllowed;
    }

    public void setRedirectURL(String url) {
        if (TraceMgr.getCutoffLevel() >= 6) {
            TraceMgr.trace(this, "setRedirectURL to " + url);
        }
        this.redirectURL = url;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public String getDocsURL() {
        if (this.docsURL == null) {
            this.docsURL = this.getClientAgent().getProps().getProperty("html.docsURL");
            if (this.docsURL == null) {
                this.docsURL = this.getClientAgent().getInitData().serverURL;
            }
        }
        return this.docsURL;
    }

    public String getThemeDocsURL() {
        if (this.themeDocsURL == null) {
            this.themeDocsURL = this.getDocsURL() + "/" + this.getThemeName() + "_docs";
        }
        return this.themeDocsURL;
    }

    public abstract int getNextComponentNameIndex(Object var1);

    public AbstractDocumentRenderer getDocumentRenderer() {
        return this.documentRenderer;
    }

    public void setDocumentRenderer(AbstractDocumentRenderer documentRenderer) {
        this.documentRenderer = documentRenderer;
    }

    public void setComponentDirty(Component component, boolean dirty) {
    }
}

