/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui.peer;

import com.creamtec.ajaxswing.core.AjaxSwingSecurityManager;
import com.creamtec.ajaxswing.core.LicenseHelper;
import com.creamtec.ajaxswing.rendering.AbstractDocumentRenderer;
import com.creamtec.ajaxswing.servlet.AppDesc;
import com.creamtec.core.AppProperties;
import com.creamtec.core.TraceMgr;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public final class LicenseManagerDup {
    private static LicenseManagerDup instance;
    private List licensedHosts = new ArrayList();
    private AppProperties props;
    public static String DATE_FORMAT;

    public static LicenseManagerDup getInstance() {
        return instance;
    }

    public static void initInstance(AppProperties props) {
        instance = new LicenseManagerDup(props);
    }

    private LicenseManagerDup(AppProperties props) {
        this.init(props);
        LicenseHelper.submitUsage(props);
    }

    private void init(AppProperties props) {
        if (props == null) {
            this.enableStdEdition();
            return;
        }
        this.props = props;
        String licenseString = props.getProperty("lic");
        if (licenseString == null) {
            this.enableStdEdition();
            return;
        }
        try {
            int versionId;
            TraceMgr.trace(this, "Reading lic...");
            StringTokenizer tokenizer = new StringTokenizer(licenseString, "-");
            String checkSum = tokenizer.nextToken();
            int code = Integer.parseInt(checkSum);
            int firstDash = licenseString.indexOf(45);
            String body = licenseString.substring(firstDash + 1);
            if (Math.abs(body.hashCode()) != code) {
                throw new Exception("code");
            }
            String misc = tokenizer.nextToken();
            int edition = misc.charAt(0) - 48;
            int maxCon = Integer.parseInt(misc.substring(1, 4));
            if (maxCon == 0) {
                maxCon = Integer.MAX_VALUE;
            }
            if ((versionId = Integer.parseInt(misc.substring(5, 7))) < 47 || versionId == 96) {
                TraceMgr.trace((Object)this, "Your license is not valid for this version of AjaxSwing", 1);
                this.enableStdEdition();
                return;
            }
            AjaxSwingSecurityManager.MONITOR = Integer.parseInt(misc.substring(7)) % 2 != 0;
            String expDate = tokenizer.nextToken();
            if (this.licenseExpired(expDate)) {
                this.enableStdEdition();
                return;
            }
            while (tokenizer.hasMoreTokens()) {
                this.licensedHosts.add(tokenizer.nextToken());
            }
            if (edition != AjaxSwingSecurityManager.EDITION_UNL && !this.isHostEnabled()) {
                this.enableStdEdition();
                return;
            }
            AppDesc.CONNECTIONS_LIMIT = maxCon;
            AjaxSwingSecurityManager.CONNECTIONS_LIMIT = maxCon;
            if (edition == AjaxSwingSecurityManager.EDITION_PRO) {
                this.enableProEdition();
            } else if (edition == AjaxSwingSecurityManager.EDITION_ENT) {
                this.enableEntEdition();
            } else if (edition == AjaxSwingSecurityManager.EDITION_UNL) {
                this.enableUnlEdition();
            } else {
                this.enableStdEdition();
            }
        }
        catch (Throwable x) {
            x.printStackTrace();
            this.enableStdEdition();
        }
    }

    private void enableProEdition() {
        TraceMgr.trace(this, "Initializing pr");
        AjaxSwingSecurityManager.LIMIT_MODE = false;
        AbstractDocumentRenderer.LIMIT_MODE = false;
        AppDesc.APPS_LIMIT = Integer.MAX_VALUE;
        AjaxSwingSecurityManager.EDITION_TYPE = AjaxSwingSecurityManager.EDITION_PRO;
    }

    private void enableEntEdition() {
        TraceMgr.trace(this, "Initializing en");
        AjaxSwingSecurityManager.LIMIT_MODE = false;
        AbstractDocumentRenderer.LIMIT_MODE = false;
        AppDesc.APPS_LIMIT = Integer.MAX_VALUE;
        AjaxSwingSecurityManager.EDITION_TYPE = AjaxSwingSecurityManager.EDITION_ENT;
    }

    private void enableUnlEdition() {
        TraceMgr.trace(this, "Initializing un");
        AjaxSwingSecurityManager.LIMIT_MODE = false;
        AbstractDocumentRenderer.LIMIT_MODE = false;
        AppDesc.APPS_LIMIT = Integer.MAX_VALUE;
        AjaxSwingSecurityManager.EDITION_TYPE = AjaxSwingSecurityManager.EDITION_UNL;
    }

    private void enableStdEdition() {
        AjaxSwingSecurityManager.LIMIT_MODE = true;
        AbstractDocumentRenderer.LIMIT_MODE = true;
        AppDesc.APPS_LIMIT = 3;
        AjaxSwingSecurityManager.EDITION_TYPE = AjaxSwingSecurityManager.EDITION_STD;
        AppDesc.CONNECTIONS_LIMIT = 5;
        AjaxSwingSecurityManager.CONNECTIONS_LIMIT = 5;
    }

    private boolean licenseExpired(String expDateString) throws Exception {
        expDateString = this.decodeString(expDateString, '-');
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        Date expDate = format.parse(expDateString);
        GregorianCalendar expCalendar = new GregorianCalendar(Locale.US);
        expCalendar.setTime(expDate);
        if (Calendar.getInstance(Locale.US).after(expCalendar)) {
            TraceMgr.trace("AjaxSwing License has expired", 1);
            return true;
        }
        return false;
    }

    private boolean isHostEnabled() {
        String hostCode = "" + Math.abs(this.props.get("localhost.name").hashCode());
        if (this.licensedHosts.contains(hostCode)) {
            return true;
        }
        hostCode = "" + Math.abs(this.props.get("localhost.address").hashCode());
        if (this.licensedHosts.contains(hostCode)) {
            return true;
        }
        TraceMgr.trace("Host is not licensed", 1);
        return false;
    }

    private String decodeString(String input, char delimChar) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch != '0') {
                if (ch != 'a') {
                    buffer.append((char)(ch - '\u0001'));
                    continue;
                }
                buffer.append('9');
                continue;
            }
            buffer.append(delimChar);
        }
        return buffer.toString();
    }

    static {
        DATE_FORMAT = "yyyy-MM-dd";
    }
}

