/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui.peer;

import com.creamtec.ajaxswing.gui.peer.AjaxSwingComponentPeer;
import java.awt.Dimension;
import java.awt.List;
import java.awt.peer.ListPeer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;

public class AjaxSwingListPeer
extends AjaxSwingComponentPeer
implements ListPeer {
    JList list = (JList)this.getDelegateComponent();
    DefaultListModel model;

    public AjaxSwingListPeer(List target) {
        super(target);
        this.setMultipleMode(target.isMultipleMode());
        String[] items = target.getItems();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                this.model.addElement(items[i]);
            }
        }
    }

    @Override
    public JComponent createDelegate() {
        this.model = new DefaultListModel();
        return new JList(this.model);
    }

    @Override
    public int[] getSelectedIndexes() {
        return this.list.getSelectedIndices();
    }

    @Override
    public void add(String item, int index) {
        this.addItem(item, index);
    }

    @Override
    public void delItems(int start, int end) {
        this.model.removeRange(start, end);
    }

    @Override
    public void removeAll() {
        this.list.removeAll();
    }

    @Override
    public void select(int index) {
        this.list.setSelectionInterval(index, index);
    }

    @Override
    public void deselect(int index) {
        this.list.removeSelectionInterval(index, index);
    }

    @Override
    public void setMultipleMode(boolean multiple) {
        if (multiple) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
    }

    @Override
    public void makeVisible(int index) {
    }

    public void addItem(String item, int index) {
        if (index == -1) {
            this.model.addElement(index);
        } else {
            this.model.add(index, item);
        }
    }

    public void clear() {
        this.removeAll();
    }

    public void setMultipleSelections(boolean v) {
        this.setMultipleMode(v);
    }

    public Dimension preferredSize(int rows) {
        return this.getPreferredSize(rows);
    }

    public Dimension minimumSize(int rows) {
        return this.getMinimumSize(rows);
    }

    @Override
    public Dimension getPreferredSize(int rows) {
        this.list.setVisibleRowCount(rows);
        return this.list.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize(int rows) {
        this.list.setVisibleRowCount(rows);
        return this.list.getMinimumSize();
    }

    public void clearSelection() {
        this.list.clearSelection();
    }

    @Override
    public boolean isFocusable() {
        return true;
    }
}

