/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui.peer;

import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.gui.AjaxSwingUIManager;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingWindowPeer;
import com.creamtec.core.TraceMgr;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.peer.FramePeer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class AjaxSwingFramePeer
extends AjaxSwingWindowPeer
implements FramePeer {
    private int state;
    private boolean undecorate = false;

    public AjaxSwingFramePeer(Frame frame) {
        super(frame);
        ClientAgent agent;
        if (frame.getTitle() != null) {
            this.setTitle(frame.getTitle());
        }
        this.setResizable(frame.isResizable());
        this.setState(frame.getExtendedState());
        Image image = frame.getIconImage();
        if (image != null) {
            this.setIconImage(image);
        }
        if ((agent = ClientAgent.getCurrentInstance()) != null && AjaxSwingUIManager.undecorateFirstFrame) {
            List windows = agent.getUIManager().getWindows();
            windows = windows == null ? new ArrayList() : windows;
            boolean skip = false;
            for (int i = 0; i < windows.size(); ++i) {
                if (!(windows.get(i) instanceof Frame) || !((Frame)windows.get(i)).isUndecorated() || windows.get(i) == frame) continue;
                skip = true;
                break;
            }
            if (!skip) {
                JRootPane rootPane = SwingUtilities.getRootPane(frame);
                if (rootPane != null) {
                    rootPane.setWindowDecorationStyle(0);
                }
                frame.setUndecorated(true);
                frame.setExtendedState(6);
                agent.getUIManager().maximizeFrame(frame);
                this.undecorate = true;
            }
        }
        if (this.target instanceof JFrame) {
            JFrame jFrame = (JFrame)this.target;
            JRootPane rootPane = jFrame.getRootPane();
            if (jFrame.isUndecorated() && AjaxSwingUIManager.LFInstalled) {
                rootPane.setWindowDecorationStyle(0);
            } else if (rootPane != null && AjaxSwingUIManager.LFInstalled && rootPane.getWindowDecorationStyle() != 1) {
                rootPane.setWindowDecorationStyle(1);
            }
        }
    }

    @Override
    public void show() {
        Frame frame = (Frame)this.getTarget();
        if (this.undecorate) {
            frame.setExtendedState(6);
        }
        if ((frame.getExtendedState() & 6) == 6) {
            TraceMgr.trace(this, "Maximizing frame");
            ClientAgent agent = ClientAgent.getCurrentInstance();
            if (agent != null) {
                agent.getUIManager().maximizeFrame(frame);
            }
        }
        super.show();
    }

    @Override
    public void setTitle(String title) {
    }

    public void setIconImage(Image im) {
    }

    @Override
    public void setMenuBar(MenuBar mb) {
    }

    @Override
    public void setResizable(boolean resizeable) {
    }

    @Override
    public void setState(int state) {
        Frame frame = (Frame)this.target;
        int oldState = frame.getState();
        this.state = state;
        WindowEvent changeStateEvent = new WindowEvent(frame, 209, oldState, state);
        this.target.dispatchEvent(changeStateEvent);
        if (state == 6) {
            ClientAgent.getCurrentInstance().getUIManager().maximizeFrame(frame);
        } else {
            ClientAgent.getCurrentInstance().getUIManager().restoreFrame(frame);
        }
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void setMaximizedBounds(Rectangle bounds) {
    }

    @Override
    public void setBoundsPrivate(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    @Override
    public Rectangle getBoundsPrivate() {
        return this.getBounds();
    }

    @Override
    public void emulateActivation(boolean activate) {
    }
}

