/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui.peer;

import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.AjaxSwingThread;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.ThreadManager;
import com.creamtec.ajaxswing.gui.AjaxSwingUIManager;
import com.creamtec.ajaxswing.gui.SchedulingEventQueue;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingWindowPeer;
import com.creamtec.core.TraceMgr;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.AwtEventHelper;
import java.awt.event.InvocationEvent;
import java.awt.peer.DialogPeer;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class AjaxSwingDialogPeer
extends AjaxSwingWindowPeer
implements DialogPeer {
    public AjaxSwingDialogPeer(Dialog target) {
        super(target);
        if (target instanceof JDialog) {
            JDialog jDialog = (JDialog)target;
            JRootPane rootPane = jDialog.getRootPane();
            if (AjaxSwingUIManager.LFInstalled && (rootPane.getWindowDecorationStyle() == 5 || rootPane.getWindowDecorationStyle() == 6 || rootPane.getWindowDecorationStyle() == 4 || rootPane.getWindowDecorationStyle() == 3 || rootPane.getWindowDecorationStyle() == 8 || rootPane.getWindowDecorationStyle() == 7)) {
                rootPane.setWindowDecorationStyle(1);
            } else if (jDialog.isUndecorated() && AjaxSwingUIManager.LFInstalled) {
                rootPane.setWindowDecorationStyle(0);
            } else if (rootPane != null && AjaxSwingUIManager.LFInstalled && rootPane.getWindowDecorationStyle() != 2) {
                rootPane.setWindowDecorationStyle(1);
            }
        }
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public void setResizable(boolean resizeable) {
    }

    @Override
    public void show() {
        TraceMgr.trace(this, "show, t = " + Thread.currentThread());
        super.show();
        if (((Dialog)this.target).isModal()) {
            boolean isSaveFileChooser;
            AjaxSwingThread myThread;
            ClientAgent clientAgent = ClientAgent.getCurrentInstance();
            clientAgent.endOperation();
            clientAgent.endOperation();
            int duration = clientAgent.getProps().getIntProperty("agent.monitorAsynchronousUpdates.duration", 0);
            if (duration > 0) {
                clientAgent.setUpdateBrowser(true);
            }
            if ((myThread = this.getMyThread()) == null) {
                myThread = clientAgent.getAjaxSwingThreadGroup().getPrimeThread();
                ThreadManager.setMyThread(this, myThread);
            }
            SchedulingEventQueue eventQueue = ClientAgent.getCurrentInstance().getSchedulingEventQueue();
            boolean bl = isSaveFileChooser = this.isSaveFileChooser((Dialog)this.target) && !AjaxSwingUIManager.isServerSideBrowsingEnabled(clientAgent, (Dialog)this.target);
            if (eventQueue != null && !isSaveFileChooser) {
                eventQueue.setBlocked(true);
            }
            if (myThread != null) {
                myThread.setBlocked(true);
            }
            this.preventDeadlockOnRendering(clientAgent);
        }
    }

    private boolean isSaveFileChooser(Dialog target) {
        JFileChooser fileChooser;
        JDialog dialog;
        return target instanceof JDialog && (dialog = (JDialog)target).getContentPane().getComponentCount() > 0 && dialog.getContentPane().getComponent(0) instanceof JFileChooser && (fileChooser = (JFileChooser)dialog.getContentPane().getComponent(0)).getDialogType() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preventDeadlockOnRendering(ClientAgent clientAgent) {
        Object notifier;
        InvocationEvent invocationEvent;
        InvocationEvent event = clientAgent.getEventQueue().getTrappedInvocationEvent();
        if (Boolean.TRUE.equals(clientAgent.getSession().get("clientAgent.mainInvoke"))) {
            return;
        }
        if (event != null && AwtEventHelper.getInvocationEventNotifier((InvocationEvent)(invocationEvent = event)) != null && (notifier = AwtEventHelper.getInvocationEventNotifier((InvocationEvent)invocationEvent)) != null) {
            TraceMgr.trace((Object)this, "WARNING: Illegal state: application can NOT display modal dialogs during rendering phase", 2);
            Thread.dumpStack();
            clientAgent.setException(new AjaxSwingException("Illegal state: application can NOT display modal dialogs during rendering phase"));
            Object object = notifier;
            synchronized (object) {
                notifier.notifyAll();
            }
        }
    }

    @Override
    public void hide() {
        TraceMgr.trace(this, "hide, t = " + Thread.currentThread());
        AjaxSwingThread thread = this.getMyThread();
        super.hide();
        if (((Dialog)this.target).isModal()) {
            if (thread != null) {
                thread.setBlocked(false);
            }
            final SchedulingEventQueue eventQueue = ClientAgent.getCurrentInstance().getSchedulingEventQueue();
            boolean isSaveFileChooser = this.isSaveFileChooser((Dialog)this.target);
            if (eventQueue != null && !isSaveFileChooser) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        eventQueue.setBlocked(true);
                    }
                });
            }
        }
        TraceMgr.trace(this, "hide() return...");
    }

    @Override
    public void blockWindows(List<Window> windows) {
    }
}

