/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui;

import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.NameUtils;
import com.creamtec.ajaxswing.core.NativeEmulator;
import com.creamtec.ajaxswing.gui.AjaxSwingInternalFrameListener;
import com.creamtec.ajaxswing.v4.utils.ComponentUtils;
import com.creamtec.core.TraceMgr;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class AjaxSwingUIManager {
    ClientAgent agent;
    AjaxSwingInternalFrameListener internalFrameListener;
    private List windows = new ArrayList();
    public static boolean LFInstalled = false;
    public static boolean undecorateFirstFrame = true;
    protected int endOperationEventCode = 0;
    protected String endOperationWindowTitle = null;
    public static String[] JAVA_PACKAGE_NAMES = new String[]{"java.", "javax.", "sun."};
    public static final int END_OPERATION_NONE = 0;
    public static final int END_OPERATION_NEXT_WINDOW = 1;
    public static final int END_OPERATION_NEW_WINDOW = 2;
    public static final int END_OPERATION_TITLED_WINDOW = 3;

    public AjaxSwingUIManager(ClientAgent agent) throws Exception {
        TraceMgr.trace(this, "constructor");
        this.agent = agent;
        this.internalFrameListener = new AjaxSwingInternalFrameListener(agent);
        if (!agent.getProps().getBooleanProperty("agent.undecorateFirstFrame", true)) {
            undecorateFirstFrame = false;
        }
    }

    public void init() throws Exception {
        if (!this.agent.getProps().getBooleanProperty("agent.allowLFChange", false) && !LFInstalled) {
            this.installLFTrap();
        }
    }

    public Window getWindowInFocus() throws Exception {
        if (this.windows.size() == 0) {
            return null;
        }
        return (Window)this.windows.get(this.windows.size() - 1);
    }

    public List getTopWindows() throws Exception {
        if (this.windows.size() == 0) {
            return new ArrayList();
        }
        ArrayList<Window> topWindows = new ArrayList<Window>(this.windows.size());
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            Window window = (Window)this.windows.get(i);
            topWindows.add(0, window);
            if (window instanceof Frame && (((Frame)window).getExtendedState() & 6) == 6) break;
        }
        return topWindows;
    }

    public List getWindows() {
        return this.windows;
    }

    public void resizeWindows() throws Exception {
        List windows = this.getWindows();
        for (int i = 0; i < windows.size(); ++i) {
            Frame frame;
            Window window = (Window)windows.get(i);
            if (!(window instanceof Frame) || ((frame = (Frame)window).getExtendedState() & 6) == 0) continue;
            this.maximizeFrame(frame);
        }
    }

    public void maximizeFrame(Frame frame) {
        if (frame instanceof JFrame) {
            ((JFrame)frame).getRootPane().putClientProperty("ajaxswingNormalBounds", frame.getBounds());
        }
        Rectangle bounds = frame.getBounds();
        Dimension maxSize = this.agent.getMaximumWindowSize(frame);
        if ((frame.getExtendedState() & 2) != 0) {
            bounds.x = 0;
            bounds.width = maxSize.width;
        }
        if ((frame.getExtendedState() & 4) != 0) {
            bounds.y = 0;
            bounds.height = maxSize.height;
        }
        if (TraceMgr.getCutoffLevel() > 5) {
            TraceMgr.trace(this, "Maximizing the frame to " + bounds);
        }
        frame.setBounds(bounds);
    }

    public void restoreFrame(Frame frame) {
        if (frame instanceof JFrame) {
            Rectangle bounds = (Rectangle)((JFrame)frame).getRootPane().getClientProperty("ajaxswingNormalBounds");
            if (TraceMgr.getCutoffLevel() > 5) {
                TraceMgr.trace(this, "Restore the frame to " + bounds);
            }
            if (bounds != null) {
                frame.setBounds(bounds);
            }
        }
    }

    public void showWindow(Window window) {
        TraceMgr.trace(this, "showWindow, class = " + window.getClass() + ", total = " + this.windows.size());
        if (this.windows.contains(window)) {
            this.windows.remove(window);
        }
        try {
            NativeEmulator.emulateWindowFocus(window, this.getWindowInFocus());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.windows.add(window);
        try {
            if (this.agent.isOperationActive()) {
                if (this.endOperationEventCode == 1 || this.endOperationEventCode == 2) {
                    this.agent.endOperation();
                } else if (this.endOperationEventCode == 3) {
                    String windowTitle = ComponentUtils.getWindowTitle(window);
                    windowTitle = NameUtils.titleToKey(windowTitle);
                    TraceMgr.trace((Object)this, "Shown window title is " + windowTitle, 6);
                    if (windowTitle.indexOf(this.endOperationWindowTitle) != -1) {
                        this.agent.endOperation();
                    }
                }
            }
        }
        catch (Throwable x) {
            TraceMgr.trace((Object)this, "Failed to end operation", x);
        }
        this.centerWindowIfNeeded(window);
        if (!this.agent.isRequestActive()) {
            this.agent.setUpdateBrowser(true);
        }
    }

    public void centerWindowIfNeeded(Container window) {
        if (window instanceof JDialog && this.agent.getProps().getBooleanProperty("agent.centerWindows", false)) {
            if (((JDialog)window).isModal()) {
                ((JDialog)window).setLocationRelativeTo(null);
            }
            Rectangle bounds = window.getBounds();
            int width = 800;
            int height = 600;
            if (this.agent.getInitData() == null) {
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                width = dim.width;
                height = dim.height;
            } else {
                width = this.agent.getInitData().clientWidth;
                height = this.agent.getInitData().clientHeight;
            }
            int x = bounds.x;
            int y = bounds.y;
            x = x < 0 ? 0 : x;
            int n = y = y < 0 ? 0 : y;
            if (bounds.y > 0 && bounds.y + bounds.height > height) {
                y = height - bounds.height - 4;
            }
            if (bounds.x > 0 && bounds.x + bounds.width > width) {
                x = width - bounds.width - 4;
            }
            x = x < 0 ? 0 : x;
            int n2 = y = y < 0 ? 0 : y;
            if (bounds.x != 0 || bounds.y != 0) {
                window.setLocation(x, y);
            }
        }
    }

    public void hideWindow(Window window) {
        TraceMgr.trace(this, "hideWindow, class = " + window.getClass() + ", total = " + this.windows.size());
        if (!this.windows.contains(window)) {
            TraceMgr.trace((Object)this, "hideWindow internal error, passed window is not registered with the UIManager", 5);
        } else {
            this.windows.remove(window);
        }
        try {
            NativeEmulator.emulateWindowFocus(this.getWindowInFocus(), window);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (ClientAgent.getCurrentInstance().isOperationActive() && this.endOperationEventCode == 1) {
                ClientAgent.getCurrentInstance().endOperation();
            }
        }
        catch (Throwable x) {
            TraceMgr.trace((Object)this, "Failed to end operation", x);
        }
        if (!this.agent.isRequestActive()) {
            this.agent.setUpdateBrowser(true);
        }
    }

    public void windowToFront(Window window) {
        TraceMgr.trace(this, "windowToFront, class = " + window.getClass());
        if (this.windows.contains(window)) {
            this.windows.remove(window);
        }
        this.windows.add(window);
        if (!this.agent.isRequestActive()) {
            this.agent.setUpdateBrowser(true);
        }
    }

    public void windowToBack(Window window) {
        TraceMgr.trace(this, "windowToBack, class = " + window.getClass());
        if (this.windows.contains(window)) {
            this.windows.remove(window);
        }
        this.windows.add(0, window);
        if (!this.agent.isRequestActive()) {
            this.agent.setUpdateBrowser(true);
        }
    }

    public void closeWindow(Window window) {
        WindowEvent event = new WindowEvent(window, 201);
        window.dispatchEvent(event);
        if (!this.agent.isRequestActive()) {
            this.agent.setUpdateBrowser(true);
        }
    }

    public void shutdown() {
        TraceMgr.trace(this, "shutdown, total windows = " + this.windows.size());
        Object[] windowsCopy = this.windows.toArray();
        for (int i = windowsCopy.length - 1; i >= 0; --i) {
            ((Window)windowsCopy[i]).dispose();
        }
        TraceMgr.trace(this, "shutdown complete");
    }

    public void setEndOperationEvent(int eventCode) {
        this.endOperationEventCode = eventCode;
    }

    public void setEndOperationWindowTitle(String windowTitle) {
        this.endOperationWindowTitle = windowTitle;
    }

    public synchronized void installLFTrap() throws Exception {
        if (!LFInstalled) {
            TraceMgr.trace(this, "installLFTrap");
            LFInstalled = true;
            UIManager.setLookAndFeel("com.creamtec.ajaxswing.laf.AjaxSwingLookAndFeel");
        }
    }

    public static boolean isServerSideBrowsingEnabled(ClientAgent agent, Container cont) {
        JFileChooser fileChooser = (JFileChooser)ComponentUtils.findChildOfClass(cont, JFileChooser.class);
        if (fileChooser == null && cont instanceof JFileChooser) {
            fileChooser = (JFileChooser)cont;
        }
        if (fileChooser != null) {
            String dialogType = fileChooser.getDialogType() == 0 ? "openOnClient" : "saveOnClient";
            String value = agent.getComponentProperty(cont, dialogType);
            if (value == null) {
                value = agent.getComponentProperty(fileChooser, dialogType);
            }
            if (value != null) {
                return "false".equalsIgnoreCase(value);
            }
            return false;
        }
        return false;
    }

    public static boolean shouldRenderStandardFileOpenDialog(ClientAgent agent, Container cont) {
        JFileChooser fileChooser = (JFileChooser)ComponentUtils.findChildOfClass(cont, JFileChooser.class);
        boolean isOpen = false;
        if (fileChooser != null && fileChooser.getDialogType() == 0) {
            isOpen = true;
        }
        if (fileChooser != null && isOpen) {
            String value = agent.getComponentProperty(cont, "browseClient");
            if (value == null) {
                value = agent.getComponentProperty(fileChooser, "browseClient");
            }
            if (value != null) {
                return "true".equalsIgnoreCase(value);
            }
            return true;
        }
        return false;
    }

    public void preRenderWindows() throws Exception {
        this.checkAndRefreshFileChooser();
    }

    public String getWindowInFocusTitle() {
        String title = null;
        try {
            Window window = this.getWindowInFocus();
            if (window instanceof Dialog) {
                title = ((Dialog)window).getTitle();
            }
            if (window instanceof Frame) {
                title = ((Frame)window).getTitle();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return title;
    }

    protected void checkAndRefreshFileChooser() throws Exception {
        Window window = null;
        try {
            window = this.getWindowInFocus();
            if (window == null) {
                return;
            }
        }
        catch (Exception x) {
            return;
        }
        JFileChooser chooser = (JFileChooser)ComponentUtils.findChildOfClass(window, JFileChooser.class);
        if (TraceMgr.getCutoffLevel() >= 9 && window != null) {
            TraceMgr.trace((Object)this, "Window " + window.getClass().getName() + " has parent file chooser " + chooser, 9);
        }
        if (chooser != null && chooser.getCurrentDirectory() != null) {
            this.refreshFileChooser(chooser);
        }
    }

    protected void refreshFileChooser(JFileChooser chooser) throws Exception {
        FileChooserUI chooserUI = chooser.getUI();
        if (chooserUI instanceof BasicFileChooserUI) {
            int startThreadCount = this.agent.getAjaxSwingThreadGroup().activeCount();
            TraceMgr.trace("Before directory scan the number of threads in a group = " + startThreadCount, 9);
            chooser.rescanCurrentDirectory();
            for (int waitAttempts = 20; this.agent.getAjaxSwingThreadGroup().activeCount() > startThreadCount && waitAttempts > 0; --waitAttempts) {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            TraceMgr.trace("After directory scan the number of threads in a group = " + this.agent.getAjaxSwingThreadGroup().activeCount(), 9);
        }
    }

    public static boolean hasCustomClasses(Object[] list) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            String className = list[i].getClass().getName();
            if (!AjaxSwingUIManager.isCustomClass(className)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCustomClass(String className) {
        boolean customPackage = true;
        if ("javax.swing.plaf.metal.MetalFileChooserUI$DirectoryComboBoxRenderer".equals(className)) {
            return true;
        }
        for (int c = 0; c < JAVA_PACKAGE_NAMES.length; ++c) {
            if (!className.startsWith(JAVA_PACKAGE_NAMES[c])) continue;
            customPackage = false;
            break;
        }
        return customPackage;
    }

    public AjaxSwingInternalFrameListener getInternalFrameListener() {
        return this.internalFrameListener;
    }

    public void setInternalFrameListener(AjaxSwingInternalFrameListener internalFrameListener) {
        this.internalFrameListener = internalFrameListener;
    }
}

