/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui;

import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.AjaxSwingPropertiesManager;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.gui.AjaxSwingImage;
import com.creamtec.ajaxswing.gui.AjaxSwingUIManager;
import com.creamtec.ajaxswing.gui.SchedulingEventQueue;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingButtonPeer;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingCheckboxPeer;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingChoicePeer;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingDialogPeer;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingFramePeer;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingGenericPeer;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingLabelPeer;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingListPeer;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingMenuPeer;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingPanelPeer;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingScrollBarPeer;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingScrollPanePeer;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingTextAreaPeer;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingTextFieldPeer;
import com.creamtec.ajaxswing.gui.peer.AjaxSwingWindowPeer;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.AjaxSwingDragListener;
import java.awt.dnd.AjaxSwingDragSourceContextPeer;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sun.awt.AjaxSwingMouseInfoPeer;
import sun.awt.SunToolkit;
import sun.awt.image.ImageRepresentation;

public abstract class AjaxSwingToolkit
extends SunToolkit {
    private static MouseInfoPeer mouseInfoPeer = null;
    private FontPeer fontPeer = new FontPeer(){};
    private static WeakHashMap imagesFileNameMap = new WeakHashMap();
    private static WeakHashMap imagesUrlMap = new WeakHashMap();
    private static WeakHashMap iconsFileNameMap = new WeakHashMap();
    private static boolean registeredStandardImages = false;
    private GraphicsConfiguration config;

    public AjaxSwingToolkit() {
        String fontsPath;
        TraceMgr.trace(this, "constructor");
        String osName = System.getProperty("os.name");
        if ((osName.startsWith("Solaris") || osName.startsWith("SunOS")) && ((fontsPath = System.getProperty("java.awt.fonts")) == null || fontsPath.length() == 0)) {
            throw new RuntimeException("Configuration error, system property <b>java.awt.fonts<b> must be specified for this OS to point to the directory that contains fonts, for example /usr/java/jre/lib/fonts. See AjaxSwing documentation for details");
        }
        String fontsDir = System.getProperty("java.awt.fonts");
        String oldHome = System.getProperty("user.home");
        AjaxSwingProperties props = AjaxSwingPropertiesManager.getInstance().getAppProperties("default");
        boolean overrideHome = osName.startsWith("Linux");
        if (props.get("agent.useAjaxSwingFontsConfigFile") != null) {
            overrideHome = props.getBooleanProperty("agent.useAjaxSwingFontsConfigFile", false);
        }
        if (overrideHome && (fontsDir == null || fontsDir.length() == 0)) {
            throw new RuntimeException("Configuration error, system property <b>java.awt.fonts<b> must be specified for this OS to point to the directory that contains fonts, for example /usr/java/jre/lib/fonts. See AjaxSwing documentation for details");
        }
        if (overrideHome) {
            TraceMgr.trace((Object)this, "Changing user.home before font loading to " + Utilities.getRootDir(), 6);
            System.setProperty("user.home", Utilities.getRootDir());
        }
        if (!GraphicsEnvironment.isHeadless()) {
            this.config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        if (overrideHome) {
            TraceMgr.trace((Object)this, "Restoring user.home", 6);
            System.setProperty("user.home", oldHome);
        }
    }

    @Override
    public Image getImage(String fileName) {
        TraceMgr.trace((Object)this, "getImage, file = " + fileName, 8);
        Image image = super.getImage(fileName);
        AjaxSwingToolkit.registerImage(image, fileName);
        return image;
    }

    @Override
    public Image getImage(URL url) {
        TraceMgr.trace((Object)this, "getImage, URL = " + url, 8);
        Image image = super.getImage(url);
        AjaxSwingToolkit.registerImage(image, url);
        return image;
    }

    @Override
    public Image createImage(String fileName) {
        TraceMgr.trace((Object)this, "createImage, file = " + fileName, 8);
        Image image = super.createImage(fileName);
        AjaxSwingToolkit.registerImage(image, fileName);
        return image;
    }

    @Override
    public Image createImage(URL url) {
        TraceMgr.trace((Object)this, "createImage, URL = " + url, 8);
        Image image = super.createImage(url);
        AjaxSwingToolkit.registerImage(image, url);
        return image;
    }

    @Override
    public Image createImage(ImageProducer producer) {
        TraceMgr.trace((Object)this, "createImage, prod", 8);
        return new AjaxSwingImage(producer);
    }

    @Override
    public final int checkImage(Image image, int width, int height, ImageObserver observer) {
        TraceMgr.trace((Object)this, "checkImage, image = " + image, 8);
        if (!(image instanceof AjaxSwingImage)) {
            return 32;
        }
        AjaxSwingImage wimage = (AjaxSwingImage)image;
        int k = width == 0 || height == 0 ? 32 : wimage.getImageRep().check(observer);
        return wimage.check(observer) | k;
    }

    @Override
    public final boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
        TraceMgr.trace((Object)this, "prepareImage, image = " + image, 8);
        if (width == 0 || height == 0) {
            return true;
        }
        if (!(image instanceof AjaxSwingImage)) {
            return true;
        }
        AjaxSwingImage wimage = (AjaxSwingImage)image;
        if (wimage.hasError()) {
            if (observer != null) {
                observer.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imagerepresentation = wimage.getImageRep();
        return imagerepresentation.prepare(observer);
    }

    @Override
    public int getScreenResolution() {
        TraceMgr.trace((Object)this, "getScreenResolution", 10);
        return 96;
    }

    protected int getScreenWidth() {
        int width = 800;
        try {
            ClientAgent agent = ClientAgent.getCurrentInstance();
            if (agent.getInitData() != null) {
                width = agent.getInitData().clientWidth == 0 ? width : agent.getInitData().clientWidth;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TraceMgr.trace((Object)this, "getScreenWidth returning " + width, 8);
        return width;
    }

    protected int getScreenHeight() {
        int height = 600;
        try {
            ClientAgent agent = ClientAgent.getCurrentInstance();
            if (agent.getInitData() != null) {
                height = agent.getInitData().clientHeight == 0 ? height : agent.getInitData().clientHeight;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TraceMgr.trace((Object)this, "getScreenHieght returning " + height, 8);
        return height;
    }

    @Override
    public Dimension getScreenSize() {
        return new Dimension(this.getScreenWidth(), this.getScreenHeight());
    }

    @Override
    public boolean isFrameStateSupported(int state) throws HeadlessException {
        return state == 0 || state == 6 || state == 2 || state == 4;
    }

    @Override
    public ColorModel getColorModel() {
        TraceMgr.trace((Object)this, "getColorModel", 8);
        if (this.config == null) {
            return ColorModel.getRGBdefault();
        }
        return this.config.getColorModel();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        if (TraceMgr.getCutoffLevel() >= 9) {
            TraceMgr.trace(this, "getFontMetrics for " + font);
        }
        return super.getFontMetrics(font);
    }

    @Override
    public void sync() {
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String jobtitle, Properties props) {
        TraceMgr.trace((Object)this, "getPrintJob", 3);
        return null;
    }

    @Override
    public void beep() {
        TraceMgr.trace((Object)this, "BEEP", 3);
    }

    @Override
    public Clipboard getSystemClipboard() {
        TraceMgr.trace((Object)this, "getSystemClipboard", 3);
        return ClientAgent.getCurrentInstance().getClipboard();
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dge) throws InvalidDnDOperationException {
        TraceMgr.trace((Object)this, "createDragSourceContextPeer", 6);
        return new AjaxSwingDragSourceContextPeer();
    }

    public static void registerImage(Image image, String fileName) {
        imagesFileNameMap.put(image, fileName);
    }

    public static void registerImage(Image image, URL url) {
        imagesUrlMap.put(image, url.toString());
    }

    public static void registerIcon(Icon icon, String fileName) {
        if (icon != null) {
            iconsFileNameMap.put(icon, fileName);
        }
    }

    public static String getImageUrl(Image image) {
        return (String)imagesUrlMap.get(image);
    }

    public static String getImageFileName(Image image) {
        return (String)imagesFileNameMap.get(image);
    }

    public static String getIconFileName(Icon icon, Component component) {
        String name;
        if (!registeredStandardImages) {
            AjaxSwingToolkit.registerStandardImages(component);
            registeredStandardImages = true;
        }
        if ((name = (String)iconsFileNameMap.get(icon)) == null) {
            TraceMgr.trace("*** WARNING - retrying to find image for an icon, possibly L&F has been reset", 5);
            AjaxSwingToolkit.registerStandardImages(component);
            name = (String)iconsFileNameMap.get(icon);
        }
        return name;
    }

    public static void registerStandardImages(Component component) {
        System.out.println("*** Registering standard images");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("OptionPane.errorIcon", component), "java/Error.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("OptionPane.informationIcon", component), "java/Inform.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("OptionPane.warningIcon", component), "java/Warn.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("OptionPane.questionIcon", component), "java/Question.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("FileView.directoryIcon", component), "java/Directory.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("FileView.fileIcon", component), "java/File.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("FileView.computerIcon", component), "java/Computer.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("FileView.hardDriveIcon", component), "java/HardDrive.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("FileView.floppyDriveIcon", component), "java/FloppyDrive.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("FileChooser.newFolderIcon", component), "java/NewFolder.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("FileChooser.upFolderIcon", component), "java/UpFolder.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("FileChooser.homeFolderIcon", component), "java/HomeFolder.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("FileChooser.detailsViewIcon", component), "java/DetailsView.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("FileChooser.listViewIcon", component), "java/ListView.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("Tree.leafIcon", component), "java/TreeLeaf.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("Tree.expandedIcon", component), "java/TreeOpen.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("Tree.collapsedIcon", component), "java/TreeClosed.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("Tree.closedIcon", component), "java/TreeClosed.gif");
        AjaxSwingToolkit.registerIcon(AjaxSwingToolkit.getUIManagerIcon("Tree.openIcon", component), "java/TreeOpen.gif");
    }

    protected static Icon getUIManagerIcon(String key, Component component) {
        if (component != null) {
            return UIManager.getIcon(key, component.getLocale());
        }
        return UIManager.getIcon(key);
    }

    @Override
    public WindowPeer createWindow(Window target) {
        TraceMgr.trace(this, "createWindow");
        return new AjaxSwingWindowPeer(target);
    }

    @Override
    public DialogPeer createDialog(Dialog target) {
        JDialog dialog;
        TraceMgr.trace(this, "createDialog");
        if (target instanceof JDialog && (dialog = (JDialog)target).getContentPane().getComponentCount() > 0 && dialog.getContentPane().getComponent(0) instanceof JFileChooser && !AjaxSwingUIManager.isServerSideBrowsingEnabled(ClientAgent.getCurrentInstance(), target)) {
            JFileChooser fileChooser = (JFileChooser)dialog.getContentPane().getComponent(0);
            this.processSaveDialog(fileChooser);
        }
        return new AjaxSwingDialogPeer(target);
    }

    private void processSaveDialog(final JFileChooser fileChooser) {
        if (fileChooser.getDialogType() == 1) {
            TraceMgr.trace(this, "posting event to close save dialog");
            ClientAgent agent = ClientAgent.getCurrentInstance();
            final SchedulingEventQueue eventQueue = agent.getSchedulingEventQueue();
            eventQueue.setProcessingFileDownload(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    File ourTempFile;
                    int j;
                    String description;
                    int i;
                    ClientAgent agent = ClientAgent.getCurrentInstance();
                    Object fileName = "download.txt";
                    if (fileChooser.getSelectedFile() != null) {
                        fileName = fileChooser.getSelectedFile().getName();
                    } else {
                        TraceMgr.trace((Object)this, "*** WARNING: the default value for selected file in JFileChooser is null. Using the default value", 4);
                    }
                    String clientTempDir = agent.getInitData().getTempDirPath() + agent.getClientId();
                    if (!new File(clientTempDir).exists()) {
                        new File(clientTempDir).mkdir();
                    }
                    fileName = clientTempDir + File.separatorChar + (String)fileName;
                    if (null != fileChooser.getFileFilter() && !fileChooser.getFileFilter().accept(new File((String)fileName)) && (i = (description = fileChooser.getFileFilter().getDescription()).indexOf("(*.")) != -1 && (j = description.indexOf(41, i + 1)) != -1) {
                        String defExt = description.substring(i + 2, j);
                        i = ((String)fileName).lastIndexOf(46);
                        if (i != -1) {
                            fileName = ((String)fileName).substring(0, i);
                        }
                        fileName = (String)fileName + defExt;
                    }
                    if ((ourTempFile = new File((String)fileName)).exists()) {
                        ourTempFile.delete();
                    }
                    fileChooser.setSelectedFile(ourTempFile);
                    TraceMgr.trace(this, "Closing the file chooser dialog with selected file = " + (String)fileName);
                    agent.addDownloadFileName((String)fileName);
                    agent.getTempFiles().add(fileName);
                    fileChooser.approveSelection();
                    eventQueue.setProcessingFileDownload(false);
                    eventQueue.setBlocked(true);
                }
            });
        }
    }

    @Override
    public FramePeer createFrame(Frame target) {
        TraceMgr.trace(this, "createFrame");
        return new AjaxSwingFramePeer(target);
    }

    @Override
    public CanvasPeer createCanvas(Canvas target) {
        return new AjaxSwingGenericPeer(target);
    }

    @Override
    public ButtonPeer createButton(Button target) {
        return new AjaxSwingButtonPeer(target);
    }

    @Override
    public CheckboxPeer createCheckbox(Checkbox target) {
        return new AjaxSwingCheckboxPeer(target);
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem target) {
        return new AjaxSwingMenuPeer(target);
    }

    @Override
    public ChoicePeer createChoice(Choice target) {
        return new AjaxSwingChoicePeer(target);
    }

    @Override
    public FileDialogPeer createFileDialog(FileDialog parm1) {
        throw new Error("awt.FileDialog is not supported");
    }

    @Override
    public LabelPeer createLabel(Label target) {
        return new AjaxSwingLabelPeer(target);
    }

    @Override
    public ListPeer createList(List target) {
        return new AjaxSwingListPeer(target);
    }

    @Override
    public MenuPeer createMenu(Menu target) {
        return new AjaxSwingMenuPeer(target);
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar target) {
        return new AjaxSwingMenuPeer(target);
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem target) {
        return new AjaxSwingMenuPeer(target);
    }

    @Override
    public PanelPeer createPanel(Panel target) {
        return new AjaxSwingPanelPeer(target);
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu target) {
        return new AjaxSwingMenuPeer(target);
    }

    @Override
    public ScrollPanePeer createScrollPane(ScrollPane target) {
        return new AjaxSwingScrollPanePeer(target);
    }

    @Override
    public ScrollbarPeer createScrollbar(Scrollbar target) {
        return new AjaxSwingScrollBarPeer(target);
    }

    @Override
    public TextAreaPeer createTextArea(TextArea target) {
        return new AjaxSwingTextAreaPeer(target);
    }

    @Override
    public TextFieldPeer createTextField(TextField target) {
        return new AjaxSwingTextFieldPeer(target);
    }

    @Override
    public FontPeer getFontPeer(String name, int style) {
        if (TraceMgr.getCutoffLevel() > 7) {
            TraceMgr.trace((Object)this, "getFontPeer, name = " + name, 8);
        }
        return null;
    }

    public static void setDelegateToolkitClassName(String name) {
    }

    @Override
    protected EventQueue getSystemEventQueueImpl() {
        TraceMgr.trace((Object)this, "getSystemEventQueueImpl", 11);
        try {
            String[] systemThreadNames = new String[]{"inalizer", "Image Fetcher", "TimerQueue", "AWT-EventQueue-0"};
            String currentThreadName = Thread.currentThread().getName();
            for (int i = 0; i < systemThreadNames.length; ++i) {
                if (currentThreadName.indexOf(systemThreadNames[i]) == -1) continue;
                return super.getSystemEventQueueImpl();
            }
            return ClientAgent.getCurrentInstance().getEventQueue();
        }
        catch (Throwable x) {
            return super.getSystemEventQueueImpl();
        }
    }

    public boolean isUndecorated(Container window) {
        if (window instanceof Frame) {
            return ((Frame)window).isUndecorated();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).isUndecorated();
        }
        return false;
    }

    public static boolean isWindowUndecorated(Container window) {
        AjaxSwingToolkit toolkit = (AjaxSwingToolkit)Toolkit.getDefaultToolkit();
        return toolkit.isUndecorated(window);
    }

    public RobotPeer createRobot(Robot arg0, GraphicsDevice arg1) throws AWTException {
        return null;
    }

    public Map mapInputMethodHighlight(InputMethodHighlight highlight) throws HeadlessException {
        TraceMgr.trace((Object)this, "mapInputMethodHighlight", 8);
        return null;
    }

    @Override
    public InputMethodDescriptor getInputMethodAdapterDescriptor() throws AWTException {
        TraceMgr.trace((Object)this, "InputMethodDescriptor", 8);
        return null;
    }

    @Override
    protected void initializeDesktopProperties() {
        super.initializeDesktopProperties();
        super.setDesktopProperty("awt.multiClickInterval", 200);
        try {
            if (System.getProperty("os.name").indexOf("indows") != -1) {
                Method m = Class.forName("sun.awt.shell.Win32ShellFolderManager2").getDeclaredMethod("getDesktop", null);
                m.setAccessible(true);
                Object desktop = m.invoke(null, null);
                m.setAccessible(false);
                if (desktop != null) {
                    super.setDesktopProperty("Shell.shellFolderManager", "sun.awt.shell.Win32ShellFolderManager2");
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> abstractRecognizerClass, DragSource ds, Component c, int srcActions, DragGestureListener dgl) {
        T createDragGestureRecognizer = super.createDragGestureRecognizer(abstractRecognizerClass, ds, c, srcActions, dgl);
        if (createDragGestureRecognizer == null && MouseDragGestureRecognizer.class.isAssignableFrom(abstractRecognizerClass)) {
            return (T)new AjaxSwingDragListener(ds, c, srcActions, dgl);
        }
        return createDragGestureRecognizer;
    }

    @Override
    public boolean areExtraMouseButtonsEnabled() throws HeadlessException {
        return false;
    }

    @Override
    public synchronized MouseInfoPeer getMouseInfoPeer() {
        if (mouseInfoPeer == null) {
            mouseInfoPeer = new AjaxSwingMouseInfoPeer();
        }
        return mouseInfoPeer;
    }
}

