/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui;

import com.creamtec.ajaxswing.gui.AjaxSwingVolatileImage;
import com.creamtec.core.TraceMgr;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;

public class AjaxSwingGraphicsConfig
extends GraphicsConfiguration {
    GraphicsDevice screen;
    int visual;
    ColorModel RGBdefault;

    public AjaxSwingGraphicsConfig(GraphicsDevice graphicsdevice, int i) {
        TraceMgr.trace(this, "constructor, device = " + graphicsdevice);
        this.screen = graphicsdevice;
        this.visual = i;
    }

    @Override
    public BufferedImage createCompatibleImage(int w, int h) {
        TraceMgr.trace((Object)this, "createCompImage", 9);
        ColorModel colormodel = this.getColorModel();
        WritableRaster writableraster = colormodel.createCompatibleWritableRaster(w, h);
        return new BufferedImage(colormodel, writableraster, colormodel.isAlphaPremultiplied(), null);
    }

    @Override
    public BufferedImage createCompatibleImage(int w, int h, int transparency) {
        TraceMgr.trace((Object)this, "createCompImageTransparency", 9);
        switch (transparency) {
            case 1: {
                return this.createCompatibleImage(w, h);
            }
            case 2: 
            case 3: {
                ColorModel colormodel = this.getColorModel(transparency);
                WritableRaster writableraster = colormodel.createCompatibleWritableRaster(w, h);
                return new BufferedImage(colormodel, writableraster, colormodel.isAlphaPremultiplied(), null);
            }
        }
        throw new IllegalArgumentException("Unknown transparency type " + transparency);
    }

    @Override
    public ColorModel getColorModel() {
        TraceMgr.trace((Object)this, "getColorModel", 9);
        if (this.RGBdefault == null) {
            this.RGBdefault = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        }
        return this.RGBdefault;
    }

    @Override
    public ColorModel getColorModel(int i) {
        if (TraceMgr.getCutoffLevel() >= 9) {
            TraceMgr.trace((Object)this, "getColorModel, i=" + i, 9);
        }
        if (i == 1) {
            return this.getColorModel();
        }
        if (i == 2) {
            return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
        }
        if (i == 3) {
            return this.getColorModel();
        }
        return null;
    }

    @Override
    public AffineTransform getDefaultTransform() {
        TraceMgr.trace((Object)this, "getDefaultTransform", 9);
        return this.getNormalizingTransform();
    }

    @Override
    public GraphicsDevice getDevice() {
        TraceMgr.trace((Object)this, "getDevice", 9);
        return this.screen;
    }

    @Override
    public AffineTransform getNormalizingTransform() {
        TraceMgr.trace((Object)this, "getNormalizaingTransform", 9);
        double xTrans = this.getXResolution() / 72.0;
        double yTrans = this.getYResolution() / 72.0;
        return new AffineTransform(xTrans, 0.0, 0.0, yTrans, 0.0, 0.0);
    }

    private double getXResolution() {
        return 72.0;
    }

    private double getYResolution() {
        return 72.0;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
    }

    @Override
    public VolatileImage createCompatibleVolatileImage(int width, int height) {
        TraceMgr.trace((Object)this, "createCompatibleVolatileImage", 9);
        return new AjaxSwingVolatileImage(this, width, height);
    }

    @Override
    public VolatileImage createCompatibleVolatileImage(int width, int height, int transparency) {
        TraceMgr.trace((Object)this, "createCompatibleVolatileImageTransparency", 9);
        return new AjaxSwingVolatileImage(this, width, height, transparency);
    }
}

