/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.gui;

import com.creamtec.ajaxswing.core.CharacterEncoding;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Hashtable;
import sun.awt.FontConfiguration;
import sun.awt.FontDescriptor;
import sun.awt.windows.AjaxSwingWDefaultFontCharset;
import sun.font.SunFontManager;

public class AjaxSwingFontConfiguration
extends FontConfiguration {
    private boolean useCompatibilityFallbacks = "windows-1252".equals(encoding);
    private static HashMap subsetCharsetMap = new HashMap();
    private static HashMap subsetEncodingMap = new HashMap();
    private static String textInputCharset;

    public AjaxSwingFontConfiguration(SunFontManager graphicsEnvironment) {
        super(graphicsEnvironment);
        this.initTables(encoding);
    }

    public AjaxSwingFontConfiguration(SunFontManager graphicsEnvironment, boolean flag, boolean flag1) {
        super(graphicsEnvironment, flag, flag1);
    }

    @Override
    protected void initReorderMap() {
        if (encoding.equalsIgnoreCase("windows-31j")) {
            localeMap = new Hashtable();
            localeMap.put("dialoginput.plain.japanese", "MS Mincho");
            localeMap.put("dialoginput.bold.japanese", "MS Mincho");
            localeMap.put("dialoginput.italic.japanese", "MS Mincho");
            localeMap.put("dialoginput.bolditalic.japanese", "MS Mincho");
        }
        this.reorderMap = new HashMap();
        this.reorderMap.put("UTF-8.hi", "devanagari");
        this.reorderMap.put("windows-1255", "hebrew");
        this.reorderMap.put("x-windows-874", "thai");
        this.reorderMap.put("windows-31j", "japanese");
        this.reorderMap.put("x-windows-949", "korean");
        this.reorderMap.put("GBK", "chinese-ms936");
        this.reorderMap.put("GB18030", "chinese-gb18030");
        this.reorderMap.put("x-windows-950", "chinese-ms950");
        this.reorderMap.put("x-MS950-HKSCS", this.split("chinese-ms950,chinese-hkscs"));
    }

    @Override
    protected void setOsNameAndVersion() {
        super.setOsNameAndVersion();
        if (osName.startsWith("Windows")) {
            int j;
            int i = osName.indexOf(32);
            osName = i == -1 ? null : ((j = osName.indexOf(32, i + 1)) == -1 ? osName.substring(i + 1) : osName.substring(i + 1, j));
            osVersion = null;
        }
    }

    @Override
    public String getFallbackFamilyName(String s, String s1) {
        String s2;
        if (this.useCompatibilityFallbacks && (s2 = this.getCompatibilityFamilyName(s)) != null) {
            return s2;
        }
        return s1;
    }

    protected String getPlatformNameFromComponentFontName(String s) {
        return s;
    }

    @Override
    protected String makeAWTFontName(String s, String s1) {
        String s2 = (String)subsetCharsetMap.get(s1);
        if (s2 == null) {
            s2 = "DEFAULT_CHARSET";
        }
        return s + "," + s2;
    }

    @Override
    protected String getEncoding(String s, String s1) {
        String s2 = (String)subsetEncodingMap.get(s1);
        if (s2 == null) {
            s2 = "default";
        }
        return s2;
    }

    @Override
    protected Charset getDefaultFontCharset(String s) {
        return AjaxSwingWDefaultFontCharset.WDefaultFontCharset((String)s);
    }

    @Override
    public String getFaceNameFromComponentFontName(String s) {
        return this.getPlatformNameFromComponentFontName(s);
    }

    @Override
    protected String getFileNameFromComponentFontName(String s) {
        return this.getFileNameFromPlatformName(this.getPlatformNameFromComponentFontName(s));
    }

    public String getTextComponentFontName(String s, int i) {
        FontDescriptor[] afontdescriptor = this.getFontDescriptors(s, i);
        String s1 = this.findFontWithCharset(afontdescriptor, textInputCharset);
        if (s1 == null) {
            s1 = this.findFontWithCharset(afontdescriptor, "DEFAULT_CHARSET");
        }
        return s1;
    }

    private String findFontWithCharset(FontDescriptor[] afontdescriptor, String s) {
        String s1 = null;
        for (int i = 0; i < afontdescriptor.length; ++i) {
            String s2 = afontdescriptor[i].getNativeName();
            if (!s2.endsWith(s)) continue;
            s1 = s2;
        }
        return s1;
    }

    private void initTables(String s) {
        subsetCharsetMap.put("alphabetic", "ANSI_CHARSET");
        subsetCharsetMap.put("alphabetic/1252", "ANSI_CHARSET");
        subsetCharsetMap.put("alphabetic/default", "DEFAULT_CHARSET");
        subsetCharsetMap.put("arabic", "ARABIC_CHARSET");
        subsetCharsetMap.put("chinese-ms936", "GB2312_CHARSET");
        subsetCharsetMap.put("chinese-gb18030", "GB2312_CHARSET");
        subsetCharsetMap.put("chinese-ms950", "CHINESEBIG5_CHARSET");
        subsetCharsetMap.put("chinese-hkscs", "CHINESEBIG5_CHARSET");
        subsetCharsetMap.put("cyrillic", "RUSSIAN_CHARSET");
        subsetCharsetMap.put("devanagari", "DEFAULT_CHARSET");
        subsetCharsetMap.put("dingbats", "SYMBOL_CHARSET");
        subsetCharsetMap.put("greek", "GREEK_CHARSET");
        subsetCharsetMap.put("hebrew", "HEBREW_CHARSET");
        subsetCharsetMap.put("japanese", "SHIFTJIS_CHARSET");
        subsetCharsetMap.put("korean", "HANGEUL_CHARSET");
        subsetCharsetMap.put("latin", "ANSI_CHARSET");
        subsetCharsetMap.put("symbol", "SYMBOL_CHARSET");
        subsetCharsetMap.put("thai", "THAI_CHARSET");
        subsetEncodingMap.put("alphabetic", "default");
        subsetEncodingMap.put("alphabetic/1252", "sun.io.CharToByteCp1252");
        subsetEncodingMap.put("alphabetic/default", "sun.io.CharToByte" + CharacterEncoding.aliasName(s));
        subsetEncodingMap.put("arabic", "sun.io.CharToByteCp1256");
        subsetEncodingMap.put("chinese-ms936", "sun.io.CharToByteGBK");
        subsetEncodingMap.put("chinese-gb18030", "sun.io.CharToByteGB18030");
        if ("x-MS950-HKSCS".equals(s)) {
            subsetEncodingMap.put("chinese-ms950", "sun.io.CharToByteMS950_HKSCS");
        } else {
            subsetEncodingMap.put("chinese-ms950", "sun.io.CharToByteMS950");
        }
        subsetEncodingMap.put("chinese-hkscs", "sun.io.CharToByteHKSCS");
        subsetEncodingMap.put("cyrillic", "sun.io.CharToByteCp1251");
        subsetEncodingMap.put("devanagari", "sun.io.CharToByteUnicodeLittle");
        subsetEncodingMap.put("dingbats", "sun.awt.windows.CharToByteWingDings");
        subsetEncodingMap.put("greek", "sun.io.CharToByteCp1253");
        subsetEncodingMap.put("hebrew", "sun.io.CharToByteCp1255");
        subsetEncodingMap.put("japanese", "sun.io.CharToByteMS932");
        subsetEncodingMap.put("korean", "sun.io.CharToByteMS949");
        subsetEncodingMap.put("latin", "sun.io.CharToByteCp1252");
        subsetEncodingMap.put("symbol", "sun.awt.CharToByteSymbol");
        subsetEncodingMap.put("thai", "sun.io.CharToByteMS874");
        textInputCharset = "windows-1256".equals(s) ? "ARABIC_CHARSET" : ("GBK".equals(s) ? "GB2312_CHARSET" : ("GB18030".equals(s) ? "GB2312_CHARSET" : ("x-windows-950".equals(s) ? "CHINESEBIG5_CHARSET" : ("x-MS950-HKSCS".equals(s) ? "CHINESEBIG5_CHARSET" : ("windows-1251".equals(s) ? "RUSSIAN_CHARSET" : ("UTF-8".equals(s) ? "DEFAULT_CHARSET" : ("windows-1253".equals(s) ? "GREEK_CHARSET" : ("windows-1255".equals(s) ? "HEBREW_CHARSET" : ("windows-31j".equals(s) ? "SHIFTJIS_CHARSET" : ("x-windows-949".equals(s) ? "HANGEUL_CHARSET" : ("x-windows-874".equals(s) ? "THAI_CHARSET" : "DEFAULT_CHARSET")))))))))));
    }
}

