/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.core;

import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.ComponentRenamer;
import com.creamtec.ajaxswing.rendering.RenderContext;
import com.creamtec.core.StringUtilities;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import sun.swing.FilePane;

public class NameUtils {
    private static final boolean T = true;
    private static final boolean F = false;
    private static boolean[] safechars = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    public static int optimizedNames = 0;

    public static String getComponentClassName(Object obj) {
        StringBuilder buffer = new StringBuilder();
        NameUtils.appendComponentClassName(buffer, obj);
        return buffer.toString();
    }

    public static void appendComponentClassName(StringBuilder buffer, Object obj) {
        if (obj instanceof JList || obj instanceof List) {
            buffer.append("_List_");
        } else {
            String name = obj.getClass().getName();
            int lastDot = name.lastIndexOf(46);
            if (lastDot != -1) {
                name = name.substring(lastDot + 1);
            }
            if (name.indexOf(36) != -1) {
                name = name.replace('$', '_');
            }
            buffer.append(name);
        }
    }

    public static String cleanupName(String name) {
        return NameUtils.cleanupName(name, null);
    }

    public static String cleanupName(String name, String appendToName) {
        if (StringUtilities.isEmpty(name)) {
            name = "_";
            if (StringUtilities.isEmpty(appendToName)) {
                return name;
            }
        }
        StringBuilder buffer = null;
        int nameLength = name.length();
        if (Character.isDigit(name.charAt(0))) {
            buffer = StringUtilities.appendToLazyBuffer(buffer, '_', nameLength + 1);
        }
        int initialLength = name.length() + 1;
        for (int i = 0; i < nameLength; ++i) {
            char nextChar = name.charAt(i);
            if (!NameUtils.isSafeChar(nextChar)) {
                if (buffer != null) {
                    nextChar = '_';
                    buffer = StringUtilities.appendToLazyBuffer(buffer, nextChar, initialLength);
                    continue;
                }
                String substring = name.substring(0, i);
                buffer = StringUtilities.appendToLazyBuffer(buffer, substring, initialLength);
                continue;
            }
            if (buffer == null) continue;
            buffer = StringUtilities.appendToLazyBuffer(buffer, nextChar, initialLength);
        }
        if (appendToName != null) {
            buffer = StringUtilities.appendToLazyBuffer(buffer, appendToName, nameLength + 1);
        }
        if (buffer == null) {
            return name;
        }
        return buffer.toString();
    }

    public static boolean isSafeChar(char nextChar) {
        return nextChar < safechars.length && safechars[nextChar];
    }

    public static String titleToKey(String title) {
        if (title == null || title.length() == 0) {
            return "null";
        }
        return title.trim().replace(' ', '_');
    }

    public static String getComponentInputName(Object obj) {
        return NameUtils.getComponentName(obj) + "Input";
    }

    public static String getComponentName(Object obj) {
        return NameUtils.getComponentName(obj, "");
    }

    public static String getComponentName(Object obj, String namePostfix) {
        if (obj == null) {
            throw new RuntimeException("NameUtils.getComponentName() called on a null object");
        }
        if (obj instanceof JTextField && SwingUtilities.getAncestorOfClass(JFileChooser.class, (JTextField)obj) != null && SwingUtilities.getAncestorOfClass(FilePane.class, (JTextField)obj) == null) {
            return "txfFileName";
        }
        RenderContext ctx = null;
        ClientAgent agent = ClientAgent.getCurrentInstance();
        if (agent.getHTMLPage() != null) {
            ctx = agent.getHTMLPage().getRenderContext();
        }
        String name = null;
        boolean nameGenerated = false;
        if (obj instanceof JComponent && namePostfix.length() == 0) {
            name = (String)((JComponent)obj).getClientProperty("ajaxswing.name");
        }
        if (name == null) {
            name = NameUtils.generateComponentName(obj, ctx, namePostfix);
            nameGenerated = true;
        }
        if (nameGenerated && obj instanceof JComponent) {
            ((JComponent)obj).putClientProperty("ajaxswing.name", name);
        }
        return name;
    }

    private static String generateComponentName(Object obj, RenderContext ctx, String namePostfix) {
        StringBuilder buffer = new StringBuilder(40);
        if (buffer.length() == 0) {
            NameUtils.appendComponentClassName(buffer, obj);
            if (AjaxSwingProperties.humanComponentNames) {
                String text = null;
                if (obj instanceof AbstractButton) {
                    text = ((AbstractButton)obj).getText();
                } else if (obj instanceof JLabel) {
                    text = ((JLabel)obj).getText();
                } else if (obj instanceof Dialog) {
                    text = ((Dialog)obj).getTitle();
                } else if (obj instanceof Frame) {
                    text = ((Frame)obj).getTitle();
                } else if (obj instanceof JComponent) {
                    text = ((JComponent)obj).getToolTipText();
                } else if (obj instanceof Button) {
                    text = ((Button)obj).getLabel();
                } else if (obj instanceof Dialog) {
                    text = ((Dialog)obj).getTitle();
                }
                text = !StringUtilities.isEmpty(text) ? NameUtils.cleanupName(text) : "";
                buffer.append("_");
                buffer.append(text);
            }
        }
        if (ctx != null) {
            // empty if block
        }
        if (AjaxSwingProperties.humanComponentNames && obj instanceof Component) {
            Container cnt = ((Component)obj).getParent();
            String parentName = null;
            if (cnt != null) {
                parentName = NameUtils.getComponentName(cnt);
            }
            return ComponentRenamer.getComponentRenamer().renameComponent(buffer, parentName, (Component)obj);
        }
        buffer.append("_");
        buffer.append(Math.abs(obj.hashCode()));
        if (namePostfix.length() > 0) {
            buffer.append(namePostfix);
        }
        return buffer.toString();
    }

    public static String getMenuItemKeyName(String actionString) {
        int indexStart = 0;
        for (int i = 0; i < 3; ++i) {
            indexStart = actionString.indexOf(47, indexStart) + 1;
        }
        String indexString = actionString.substring(indexStart);
        indexString = indexString.replace('/', '.');
        return "menu." + indexString;
    }

    public static String getButtonKeyName(Object button) {
        String key = null;
        if (button instanceof AbstractButton) {
            key = ((AbstractButton)button).getText();
        } else if (button instanceof Button) {
            key = ((Button)button).getLabel();
        }
        if ((key == null || key.length() == 0) && button instanceof AbstractButton) {
            key = ((AbstractButton)button).getToolTipText();
        }
        key = key == null || key.length() == 0 ? "*" : key.replace(' ', '_');
        return "button." + key;
    }
}

