/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.core;

import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.ClientAgentManagerRemote;
import com.creamtec.core.TraceMgr;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;

public class ClientAgentManager
implements ClientAgentManagerRemote {
    private static Map agentsMap = new WeakHashMap();
    private static ClientAgentManager instance = null;

    public ClientAgentManager() throws Exception {
        TraceMgr.trace(this, "constructor");
    }

    public static ClientAgentManager getInstance() {
        if (instance == null) {
            try {
                instance = new ClientAgentManager();
            }
            catch (Exception x) {
                TraceMgr.trace("ClientAgentManager - Failed to instantiate ClientAgentManager", x, 1);
            }
        }
        return instance;
    }

    public static ClientAgent getMyAgent(Object obj) {
        return (ClientAgent)agentsMap.get(obj);
    }

    public static synchronized void setMyAgent(Object obj, ClientAgent agent) {
        agentsMap.put(obj, agent);
    }

    public static synchronized void clearMyAgent(Object obj) {
        agentsMap.remove(obj);
    }

    public static synchronized void stopAllAgentsThreads() {
        HashSet threadsSet = new HashSet(agentsMap.keySet());
        for (Object object : threadsSet) {
            Thread thread = null;
            if (object instanceof Thread) {
                thread = (Thread)object;
                try {
                    thread.interrupt();
                    TraceMgr.trace("Thread " + thread + " was interrupted", 3);
                }
                catch (Exception e) {
                    TraceMgr.trace("Shutting down, exception during last threads interrupting", e, 3);
                }
                ClientAgentManager.clearMyAgent(thread);
                continue;
            }
            TraceMgr.trace("AgentsMap contains not thread object " + object + " and cannot be interrupted", 6);
        }
    }
}

