/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.core;

import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.AjaxSwingPropertiesManager;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.ClientAgentRemote;
import com.creamtec.ajaxswing.core.JVMFactory;
import com.creamtec.ajaxswing.core.JVMProcessContext;
import com.creamtec.ajaxswing.servlet.AjaxSwingServlet;
import com.creamtec.core.TraceMgr;
import java.rmi.ConnectException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class ClientAgentFactory {
    protected static ClientAgentFactory instance = null;
    protected static AjaxSwingServlet servletHelper;
    protected boolean warmupJvm = false;
    protected WeakHashMap agentToJVMMap = new WeakHashMap();
    protected String factoryIndex;
    protected Map appToAgentMap = new HashMap();
    protected JVMFactory jvmFactory;

    protected ClientAgentFactory(JVMFactory jvmFactory) throws Exception {
        AjaxSwingPropertiesManager bcm = AjaxSwingPropertiesManager.getInstance();
        this.factoryIndex = "" + (int)(Math.random() * 100.0);
        if (this.factoryIndex.length() < 2) {
            this.factoryIndex = "0" + this.factoryIndex;
        }
        this.factoryIndex = "_" + this.factoryIndex + "_";
        this.jvmFactory = jvmFactory;
        AjaxSwingProperties defaultProps = AjaxSwingPropertiesManager.getInstance().getAppProperties("default");
        String thisProcessApp = null;
        HashMap propsMap = bcm.getPropertiesMap();
        for (String appName : propsMap.keySet()) {
            AjaxSwingProperties props = bcm.getAppProperties(appName);
            if (props == defaultProps) continue;
            if (!props.getBooleanProperty("router.inProcess", true)) {
                this.warmupJvm = true;
                TraceMgr.trace(this, "Adding application " + appName + " to warmup JVM list");
                this.appToAgentMap.put(appName, null);
                continue;
            }
            if (!props.getBooleanProperty("router.preloadApp", false)) continue;
            if (thisProcessApp == null) {
                TraceMgr.trace(this, "Preloading application " + appName + " into this process");
                ClientAgent agent = servletHelper.createClientAgent(appName);
                boolean waitForApp = agent.getProps().getBooleanProperty("router.preloadWaitForApp", true);
                if (waitForApp) {
                    agent.runApp(true);
                    this.shutdownAgent(agent, appName);
                    continue;
                }
                thisProcessApp = appName;
                agent.runApp(false);
                continue;
            }
            TraceMgr.trace((Object)this, "Ignored preloading application " + appName + " into this process because " + thisProcessApp + " is already preloaded", 3);
        }
        if (this.warmupJvm) {
            this.startWarmupThread();
        }
    }

    public static ClientAgentFactory getInstance() {
        return instance;
    }

    public static void init(AjaxSwingServlet servletHelper) throws Exception {
        if (ClientAgentFactory.servletHelper == null) {
            TraceMgr.trace(ClientAgentFactory.class, "Initializing...", 4);
            ClientAgentFactory.servletHelper = servletHelper;
            JVMFactory jvmFactory = ClientAgentFactory.createJvmFactory(servletHelper);
            instance = new ClientAgentFactory(jvmFactory);
        }
    }

    protected static JVMFactory createJvmFactory(AjaxSwingServlet servletHelper) throws Exception {
        AjaxSwingProperties defaultProps = AjaxSwingPropertiesManager.getInstance().getAppProperties("default");
        String jvmFactoryClassName = defaultProps.getProperty("router.jvmFactoryClass");
        JVMFactory jvmFactory = null;
        if (jvmFactoryClassName != null) {
            jvmFactoryClassName = jvmFactoryClassName.trim();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = servletHelper.getClass().getClassLoader();
            }
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            TraceMgr.trace(ClientAgentFactory.class, "Loading JVM factory class " + jvmFactoryClassName + " with class loader " + classLoader);
            Class<?> jvmFactoryClass = classLoader.loadClass(jvmFactoryClassName);
            Object factory = jvmFactoryClass.newInstance();
            if (!(factory instanceof JVMFactory)) {
                throw new AjaxSwingException("Error: Custom JVM factory " + jvmFactoryClassName + " does not extend com.creamtec.ajaxswing.core.JVMFactory");
            }
            jvmFactory = (JVMFactory)factory;
        } else {
            jvmFactory = new JVMFactory();
        }
        return jvmFactory;
    }

    protected void startWarmupThread() {
        new Thread(){

            @Override
            public void run() {
                TraceMgr.trace((Object)this, "Running warmup thread", 3);
                while (ClientAgentFactory.this.warmupJvm) {
                    Iterator apps = ClientAgentFactory.this.appToAgentMap.keySet().iterator();
                    while (apps.hasNext() && ClientAgentFactory.this.warmupJvm) {
                        String app = (String)apps.next();
                        ClientAgentRemote agent = (ClientAgentRemote)ClientAgentFactory.this.appToAgentMap.get(app);
                        try {
                            if (agent == null) {
                                agent = ClientAgentFactory.this.createNewAgent(app, null);
                                ClientAgentFactory.this.appToAgentMap.put(app, agent);
                                TraceMgr.trace(this, "Warmed up an agent for application " + app);
                                continue;
                            }
                            agent.ping();
                        }
                        catch (Throwable x) {
                            TraceMgr.trace((Object)this, "Exception while warming up client agent for applicaton " + app, x);
                            if (agent == null) continue;
                            ClientAgentFactory.this.appToAgentMap.put(app, null);
                        }
                    }
                    try {
                        if (!ClientAgentFactory.this.warmupJvm) continue;
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException x) {
                        break;
                    }
                }
                TraceMgr.trace((Object)this, "Warmup thread finished", 3);
            }
        }.start();
    }

    public void shutdown() {
        TraceMgr.trace((Object)this, "shutting down..." + this.appToAgentMap.size(), 3);
        this.warmupJvm = false;
        this.jvmFactory.shutdown();
        TraceMgr.trace((Object)this, "Shutdown complete", 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientAgentRemote createNewAgent(String appName, String locale) throws Exception {
        JVMFactory jVMFactory = this.jvmFactory;
        synchronized (jVMFactory) {
            ClientAgentRemote agent = null;
            AjaxSwingProperties props = AjaxSwingPropertiesManager.getInstance().getAppProperties(appName);
            int retireJVMAfterClients = props.getIntProperty("router.retireJVMAfterClients", 100);
            if (locale == null || retireJVMAfterClients == 1) {
                agent = (ClientAgentRemote)this.appToAgentMap.get(appName);
            }
            if (agent != null) {
                TraceMgr.trace((Object)this, "createNewAgent, using a preloaded client", 3);
                this.appToAgentMap.put(appName, null);
            } else {
                for (int i = 0; i < 10; ++i) {
                    TraceMgr.trace((Object)this, "createNewAgent, creating a new client attempt " + i, 3);
                    JVMProcessContext jvmContext = this.jvmFactory.getAvailableJVM(appName, locale);
                    try {
                        jvmContext.clientInitializing = true;
                        agent = jvmContext.jvmProcess.createClientAgent(appName);
                        ++jvmContext.clientsCount;
                        ++jvmContext.clientsExecuted;
                        this.agentToJVMMap.put(agent, jvmContext);
                        break;
                    }
                    catch (ConnectException x) {
                        ClientAgentRemote warmedUpAgent = (ClientAgentRemote)this.appToAgentMap.get(appName);
                        if (warmedUpAgent != null && this.agentToJVMMap.get(warmedUpAgent) == jvmContext) {
                            this.appToAgentMap.put(appName, null);
                        }
                        this.jvmFactory.unregisterJVM(jvmContext, appName);
                        if (i < 10) {
                            TraceMgr.trace(this, "Remote process has been shutdown. Retry...");
                            continue;
                        }
                        throw new AjaxSwingException("All remote processes have been shutdown and all reconnection attempts failed. Restart the server");
                    }
                    finally {
                        jvmContext.clientInitializing = false;
                    }
                }
            }
            return agent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAgent(ClientAgentRemote agent, String appName) {
        TraceMgr.trace((Object)this, "Shutting down client agent...", 6);
        ClientAgentRemote clientAgentRemote = agent;
        synchronized (clientAgentRemote) {
            block12: {
                try {
                    agent.shutdown();
                }
                catch (Throwable x) {
                    if (!(agent instanceof ClientAgent)) break block12;
                    TraceMgr.trace((Object)this, "Failed to shutdown client agent", x);
                }
            }
        }
        TraceMgr.trace((Object)this, "Client agent shut down, checking JVM...", 6);
        JVMProcessContext jvmContext = (JVMProcessContext)this.agentToJVMMap.get(agent);
        if (jvmContext != null) {
            JVMFactory jVMFactory = this.jvmFactory;
            synchronized (jVMFactory) {
                --jvmContext.clientsCount;
                try {
                    AjaxSwingProperties props = AjaxSwingPropertiesManager.getInstance().getAppProperties(appName);
                    int retireJVMAfterClients = props.getIntProperty("router.retireJVMAfterClients", 100);
                    if (jvmContext.clientsExecuted >= retireJVMAfterClients && jvmContext.clientsCount == 0) {
                        this.agentToJVMMap.remove(agent);
                        this.jvmFactory.shutdownJVM(jvmContext, appName);
                    }
                }
                catch (Exception x) {
                    TraceMgr.trace((Object)this, "Failed to shutdown JVM", (Throwable)x);
                }
            }
        }
    }

    public Object getLock() {
        return this.jvmFactory;
    }
}

