/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.core;

import com.creamtec.ajaxswing.core.AgentInitData;
import com.creamtec.ajaxswing.core.AgentRequestFilter;
import com.creamtec.ajaxswing.core.AjaxSwingAgentRequestFilter;
import com.creamtec.ajaxswing.core.AjaxSwingClassLoader;
import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.AjaxSwingPropertiesManager;
import com.creamtec.ajaxswing.core.AjaxSwingSecurityManager;
import com.creamtec.ajaxswing.core.AjaxSwingThread;
import com.creamtec.ajaxswing.core.AjaxSwingThreadGroup;
import com.creamtec.ajaxswing.core.ClientAgentManager;
import com.creamtec.ajaxswing.core.ClientAgentRemote;
import com.creamtec.ajaxswing.core.FastSubmitHandler;
import com.creamtec.ajaxswing.core.HttpRequestData;
import com.creamtec.ajaxswing.core.HttpResponseData;
import com.creamtec.ajaxswing.core.KeepAliveEvent;
import com.creamtec.ajaxswing.core.KeepAliveEventHandler;
import com.creamtec.ajaxswing.core.LangHelper;
import com.creamtec.ajaxswing.core.LicenseManager;
import com.creamtec.ajaxswing.core.NameUtils;
import com.creamtec.ajaxswing.core.SafeAWTHelper;
import com.creamtec.ajaxswing.core.URLParameterHandler;
import com.creamtec.ajaxswing.gui.AjaxSwingAppletFrame;
import com.creamtec.ajaxswing.gui.AjaxSwingAppletStub;
import com.creamtec.ajaxswing.gui.AjaxSwingEventQueue;
import com.creamtec.ajaxswing.gui.AjaxSwingGraphicsEnvironment;
import com.creamtec.ajaxswing.gui.AjaxSwingHeadlessGraphicsEnvironment;
import com.creamtec.ajaxswing.gui.AjaxSwingRepaintManager;
import com.creamtec.ajaxswing.gui.AjaxSwingToolkit;
import com.creamtec.ajaxswing.gui.AjaxSwingUIManager;
import com.creamtec.ajaxswing.gui.SchedulingEventQueue;
import com.creamtec.ajaxswing.gui.VersionHelper;
import com.creamtec.ajaxswing.gui.WindowUpdater;
import com.creamtec.ajaxswing.rendering.AbstractDocument;
import com.creamtec.ajaxswing.rendering.AbstractDocumentRenderer;
import com.creamtec.ajaxswing.rendering.DocumentRendererFactory;
import com.creamtec.core.AppProperties;
import com.creamtec.core.StringUtilities;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.applet.Applet;
import java.awt.AWTHelper;
import java.awt.AgentFocusManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.MenuSelectionManager;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sun.awt.AppContext;

public abstract class ClientAgent
implements ClientAgentRemote {
    protected String startClassName;
    protected String[] cmdArgs;
    protected int requestTimeout;
    protected boolean running;
    protected boolean allowExit;
    protected AjaxSwingUIManager uiManager;
    protected SchedulingEventQueue schedulingEventQueue;
    protected AjaxSwingRepaintManager repaintManager;
    protected AjaxSwingThreadGroup threadGroup;
    protected List blockedThreads = new ArrayList();
    protected int markedThreadCount;
    protected AbstractDocumentRenderer pageRenderer;
    protected WindowUpdater windowUpdater;
    protected Throwable exception;
    protected AjaxSwingProperties props;
    protected AgentInitData initData;
    protected HttpRequestData requestData;
    protected HttpResponseData responseData;
    protected AbstractDocument page;
    protected long requestId;
    protected Object requestLock = new RequestLock();
    protected Object operationLock = new OperationLock();
    protected int operationCounter;
    protected boolean requestActive;
    protected Applet applet;
    protected String appName;
    protected AppContext appContext;
    protected AjaxSwingEventQueue eventQueue;
    protected ClassLoader classLoader;
    protected boolean exited;
    protected boolean isNewWindowShown;
    protected boolean updateBrowser;
    protected int updateBrowserInterval;
    protected int savedUpdateBrowserInterval;
    protected int updateBrowserChecks;
    protected HashMap session = new HashMap();
    protected List tempFiles = new ArrayList();
    protected Clipboard clipboard = new Clipboard("System");
    protected boolean endOperationOnModalDialog = false;
    protected Hashtable paramsHandlers = null;
    protected Hashtable fastSubmitHandlers = null;
    protected List<KeepAliveEventHandler> keepAliveEventHandlers = null;
    protected String exitPage = null;
    public static boolean shuttingDown;
    protected static boolean toolkitInstalled;
    protected static boolean graphicsEnvironmentPropertiesInstalled;
    private Locale currentLocale = null;
    private String browserLocale = null;
    private String csrfToken = null;
    private Map downloadFileNames = new ConcurrentHashMap();
    protected static HashMap failedThreads;
    protected static Object initLock;
    public static ClassLoader commonClassLoader;
    protected AjaxSwingAgentRequestFilter requestFilter = new AjaxSwingAgentRequestFilter();
    protected String scriptToAppend = null;
    private String urlForOpenInNewTab = null;
    protected long sessionTimeout = -1L;
    protected KeepAliveEvent lastKeepAliveEvent = null;
    private boolean focusChangeAllowed = true;
    private KeyboardFocusManager agentFocusManager;
    private MenuSelectionManager menuSelectionManager;
    private Object mouseGrabber = null;
    private Map<String, Map<String, String>> calibrationCoefs = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> calibrationCoefsCapital = new HashMap<String, Map<String, String>>();
    protected static int TRIM;
    protected static int PARAM;
    protected static int QUOTED_PARAM;

    public ClientAgent(String agentName, String appName) throws Exception {
        if (System.getProperty("os.name").indexOf("indows") == -1) {
            // empty if block
        }
        TraceMgr.trace(this, "constructor, agent name = " + agentName + ", appName = " + appName);
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        String bootStr = "";
        for (String s : arguments) {
            if (!s.startsWith("-Xbootclasspath")) continue;
            bootStr = s;
            break;
        }
        if (!bootStr.contains("asboot.jar") || !bootStr.contains("ajsJava.jar")) {
            throw new AjaxSwingException("Initialization error, AjaxSwing classes are not found in boot class path. Use -bootclasspath parameter when running java");
        }
        Utilities.setRootDir(System.getProperty("ajaxswing.home"));
        this.initProperties(appName);
        ClientAgentManager.setMyAgent(Thread.currentThread(), this);
        if (!ClientAgent.isToolkitInstalled()) {
            this.installToolkit();
        } else {
            this.repaintManager = new AjaxSwingRepaintManager(this);
        }
        this.menuSelectionManager = new MenuSelectionManager();
        this.agentFocusManager = this.createAndInitAgentFocusManager();
        this.appName = appName;
        this.uiManager = new AjaxSwingUIManager(this);
        this.threadGroup = new AjaxSwingThreadGroup(this);
        this.getUIManager().init();
        this.windowUpdater = new WindowUpdater();
        this.windowUpdater.initCustomUpdatersAndEmulators(this);
        ClientAgentManager.clearMyAgent(Thread.currentThread());
        TraceMgr.trace(this, "Construction finished, waiting to be initialized");
        this.paramsHandlers = new Hashtable();
        this.fastSubmitHandlers = new Hashtable();
        TraceMgr.trace("Client agent was created");
        TraceMgr.trace((Object)this, String.format("CsrfToken %s, AgentFocusManager hashcode: %s, MenuSelectionManager hashcode %s", this.csrfToken, this.agentFocusManager.hashCode(), this.menuSelectionManager.hashCode()), 10);
    }

    private KeyboardFocusManager createAndInitAgentFocusManager() {
        AgentFocusManager agentFocusManager = new AgentFocusManager();
        String toolkitName = Toolkit.getDefaultToolkit().getClass().getName();
        if (!"sun.awt.X11.XToolkit".equals(toolkitName) && FocusManager.isFocusManagerEnabled()) {
            agentFocusManager.setDefaultFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        }
        agentFocusManager.addKeyEventPostProcessor(new KeyEventPostProcessor(){

            @Override
            public boolean postProcessKeyEvent(KeyEvent e) {
                Component c = e.getComponent();
                try {
                    if (!(c instanceof JComponent) || c != null && !((JComponent)c).isEnabled()) {
                        for (Class<?> class1 : JComponent.class.getDeclaredClasses()) {
                            if (!"javax.swing.JComponent$KeyboardState".equals(class1.getName())) continue;
                            Method shouldProcessMethod = class1.getDeclaredMethod("shouldProcess", KeyEvent.class);
                            shouldProcessMethod.setAccessible(true);
                            Boolean shouldProcess = (Boolean)shouldProcessMethod.invoke(null, e);
                            shouldProcessMethod.setAccessible(false);
                            if (!shouldProcess.booleanValue() || !SwingUtilities.processKeyBindings(e)) continue;
                            e.consume();
                            return true;
                        }
                    }
                }
                catch (Exception ex) {
                    TraceMgr.trace((Object)this, "Exception during javax.swing.JComponent$KeyboardState.shouldProcess invoke", 6);
                    ex.printStackTrace();
                }
                return false;
            }
        });
        return agentFocusManager;
    }

    protected ClientAgent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void initClassLoader() throws Exception {
        URL[] agentURLs = AjaxSwingClassLoader.getClassPathURLs(this.props.getProperty("agent.classPath"));
        URL[] commonURLs = AjaxSwingClassLoader.getClassPathURLs(this.props.getProperty("common.classPath"));
        if (agentURLs == null && commonURLs == null) {
            this.classLoader = this.getClass().getClassLoader();
            if (this.classLoader != null) return;
            this.classLoader = ClassLoader.getSystemClassLoader();
            return;
        }
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = this.getClass().getClassLoader();
        }
        if (commonURLs != null) {
            Class<ClientAgent> clazz = ClientAgent.class;
            // MONITORENTER : com.creamtec.ajaxswing.core.ClientAgent.class
            if (commonClassLoader == null) {
                commonClassLoader = new URLClassLoader(commonURLs, parent);
            }
            // MONITOREXIT : clazz
            this.classLoader = parent = commonClassLoader;
        }
        if (agentURLs == null) return;
        this.classLoader = new AjaxSwingClassLoader(agentURLs, parent);
    }

    @Override
    public void init(AgentInitData data, HttpRequestData requestData) throws RemoteException, Exception {
        if (TraceMgr.getCutoffLevel() >= 6) {
            TraceMgr.trace((Object)this, "Initializing browser specific props...", 6);
            TraceMgr.trace(this, "Browser detected as " + AgentInitData.getBrowserName(data.browserID) + ", version = " + data.browserVersion);
        }
        ClientAgentManager.setMyAgent(Thread.currentThread(), this);
        this.initData = data;
        this.setRequestData(requestData);
        this.csrfToken = (String)requestData.getParams().get("csrfToken");
        if (data.agentsCount >= AjaxSwingSecurityManager.CONNECTIONS_LIMIT) {
            throw new AjaxSwingException("The maximum allowed number of concurrent clients has been reached. Please contact CreamTec at <A HREF=\"http://creamtec.com\">http://creamtec.com</A> to upgrade your edition of AjaxSwing", false);
        }
        this.pageRenderer = (AbstractDocumentRenderer)DocumentRendererFactory.getInstance().createDocumentRenderer(this);
        this.setHTMLPage((AbstractDocument)this.pageRenderer.createDocument());
        if (this.initData != null) {
            if (this.initData.getErrorMessage() != null) {
                this.page.getRenderContext().errorMessage = this.initData.getErrorMessage();
                this.page.getRenderContext().errorMessageTitle = this.initData.getErrorMessageTitle();
                this.page.getRenderContext().errorMessageAutoRefreshText = this.initData.getErrorMessageAutoRefreshText();
                this.page.getRenderContext().errorRefreshTime = this.initData.getErrorRefreshTime();
                this.initData.setErrorMessage(null);
            }
            this.setClientSize(this.initData.clientWidth, this.initData.clientHeight);
            if (TraceMgr.getCutoffLevel() > 9) {
                TraceMgr.trace(this, "Deflated size = " + this.initData.clientWidth + ": " + this.initData.clientHeight);
            }
        }
        this.getUIManager().resizeWindows();
        TraceMgr.trace((Object)this, "Initialization browser complete", 6);
    }

    public void setClientSize(int width, int height) {
        this.initData.clientWidth = width;
        this.initData.clientHeight = height;
    }

    public void initProperties(String appName) throws RemoteException, Exception {
        AjaxSwingPropertiesManager bcm = AjaxSwingPropertiesManager.getInstance();
        this.props = bcm.getAppProperties(appName);
        String loggedKey = "__properties_logged__";
        if (TraceMgr.getCutoffLevel() >= 6 && this.props.getProperty(loggedKey) == null) {
            TraceMgr.trace("APPLICATION PROPERTIES for " + appName + ":", 6);
            this.props.put(loggedKey, "true");
            Enumeration<Object> i = this.props.keys();
            while (i.hasMoreElements()) {
                String key = (String)i.nextElement();
                TraceMgr.trace(key + " = " + this.props.getProperty(key));
            }
        }
        this.startClassName = this.props.getProperty("agent.appStartClass");
        if (this.startClassName == null) {
            throw new AjaxSwingException("Failed to initialize client agent - application start class is not speicfied");
        }
        String appParams = this.props.getProperty("agent.appParams");
        appParams = StringUtilities.replaceParameters(appParams, System.getProperties());
        this.cmdArgs = ClientAgent.getCmdLineParams(appParams);
        this.requestTimeout = this.props.getIntProperty("agent.requestTimeout", 60) * 1000;
        this.initClassLoader();
        String requestFilterClass = this.props.getProperty("agent.requestFilterClass");
        if (requestFilterClass != null) {
            TraceMgr.trace(this, "Loading request filter class " + requestFilterClass);
            Class<?> cls = this.getClassLoader().loadClass(requestFilterClass);
            Object requestFilter = cls.newInstance();
            if (requestFilter instanceof AgentRequestFilter) {
                this.requestFilter.setDelegate((AgentRequestFilter)requestFilter);
            } else {
                TraceMgr.trace(this, "ERROR: agent request filter class " + requestFilterClass + " does not implement interface AgentRequestFilter");
            }
        }
        int updateInterval = this.getProps().getIntProperty("router.updateInterval", 0);
        this.setUpdateBrowserInterval(updateInterval);
    }

    @Override
    public void shutdown() {
        TraceMgr.trace((Object)this, "Shutdown request received", 6);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ClientAgent.this.doShutdown();
            }
        }).start();
        TraceMgr.trace((Object)this, "Shutdown request processed", 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doShutdown() {
        TraceMgr.trace((Object)this, "Shutdown started...", 4);
        ClientAgentManager.setMyAgent(Thread.currentThread(), this);
        if (this.isApplet()) {
            this.applet.stop();
            this.applet.destroy();
        }
        if (this.initData != null) {
            this.getUIManager().shutdown();
            this.repaintManager.shutdown();
            try {
                Thread.currentThread();
                Thread.sleep(100L);
                this.waitTillEventQueueIsEmpty();
            }
            catch (Exception exception) {
                // empty catch block
            }
            TraceMgr.trace(this, "Shutdown UIManager");
            ClientAgent clientAgent = this;
            synchronized (clientAgent) {
                if (this.eventQueue != null) {
                    this.eventQueue.shutdown();
                }
                TraceMgr.trace(this, "Stopped dispatching");
                if (this.eventQueue != null) {
                    ClientAgentManager.clearMyAgent(SafeAWTHelper.getDispatchThread(this.eventQueue));
                }
            }
            ClientAgentManager.clearMyAgent(Thread.currentThread());
            if (Thread.currentThread().getThreadGroup() instanceof AjaxSwingThreadGroup) {
                ((AjaxSwingThreadGroup)Thread.currentThread().getThreadGroup()).setClientAgent(null);
            }
            if (this.blockedThreads.size() > 0) {
                TraceMgr.trace((Object)this, "Shutting down blocked threads...", 6);
            }
            for (int i = 0; i < this.blockedThreads.size(); ++i) {
                AjaxSwingThread thread = (AjaxSwingThread)this.blockedThreads.get(i);
                thread.shutdown();
            }
            TraceMgr.trace((Object)this, "Shutting down thread group...", 6);
            this.threadGroup.shutdown();
        }
        this.cleanupTempFiles();
        if (this.getHTMLPage() != null) {
            this.getHTMLPage().reset(true);
        }
        this.blockedThreads.clear();
        TraceMgr.trace((Object)this, "Shutdown complete", 4);
    }

    public boolean allowExit() {
        return this.allowExit;
    }

    public void exit() {
        this.exited = true;
        if (!this.allowExit()) {
            TraceMgr.trace((Object)this, "Exit attempt intercepted", 6);
            throw new AccessControlException("", new RuntimePermission("exitVM"));
        }
    }

    public void setAllowExit(boolean allow) {
        this.allowExit = allow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AjaxSwingEventQueue getEventQueue() {
        ClientAgent clientAgent = this;
        synchronized (clientAgent) {
            return this.eventQueue;
        }
    }

    public int getBrowserID() {
        if (this.initData == null) {
            throw new Error("Client has not been properly initialized (init method has not been called)");
        }
        return this.initData.browserID;
    }

    public boolean isBrowserIE() {
        return this.getBrowserID() == 2;
    }

    public float getBrowserVersion() {
        if (this.initData == null) {
            throw new Error("Client has not been properly initialized (init method has not been called)");
        }
        return this.initData.browserVersion;
    }

    protected void waitTillEventQueueIsEmpty() throws InterruptedException {
        EventQueue eventQueue;
        int retries = 0;
        EventQueue eventQueue2 = eventQueue = this.schedulingEventQueue != null ? this.schedulingEventQueue : this.getEventQueue();
        while (eventQueue != null && eventQueue.peekEvent() != null && retries++ < 50) {
            Thread.sleep(100L);
        }
        Thread.yield();
    }

    public List getWindowsForRendering() throws Exception {
        List windows = this.getUIManager().getTopWindows();
        this.getHTMLPage().getRenderContext().blockedWindows.clear();
        if (this.getHTMLPage().isPartialUpdateAllowed()) {
            boolean modalDialogOpen = false;
            Dialog modalDialog = null;
            for (int i = windows.size() - 1; i >= 0; --i) {
                Window window = (Window)windows.get(i);
                if (modalDialogOpen && !this.ownsWindow(modalDialog, window)) {
                    Integer hash = new Integer(window.hashCode());
                    this.getHTMLPage().getRenderContext().blockedWindows.put(hash, hash);
                    windows.remove(i);
                    continue;
                }
                if (!(window instanceof Dialog) || !((Dialog)window).isModal()) continue;
                modalDialog = (Dialog)window;
                modalDialogOpen = true;
            }
        }
        return windows;
    }

    private boolean ownsWindow(Window parent, Window child) {
        Window[] owned;
        if (parent != null && child != null && (owned = parent.getOwnedWindows()) != null) {
            for (int i = 0; i < owned.length; ++i) {
                if (owned[i] == child) {
                    return true;
                }
                if (!this.ownsWindow(owned[i], child)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void runApp(boolean wait) throws AjaxSwingException, RemoteException {
        try {
            this.initClient(wait, null);
        }
        catch (AjaxSwingException x) {
            throw x;
        }
        catch (ThreadDeath x) {
            TraceMgr.trace((Object)this, "***Thread death***", 1);
            throw x;
        }
        catch (Throwable x) {
            throw new AjaxSwingException("Failed to run application", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClient(boolean waitForApp, String appParams) throws Throwable {
        if (!this.running) {
            this.running = true;
            TraceMgr.trace((Object)this, "Initializing the client, wait = " + waitForApp, 1);
            this.setException(null);
            AjaxSwingThread thread = this.getAjaxSwingThreadGroup().allocateThread();
            if (appParams != null) {
                this.cmdArgs = ClientAgent.getCmdLineParams(appParams);
            }
            if (this.getProps().getBooleanProperty("agent.forceJvmLocale", Boolean.FALSE) && !this.initData.inProcess) {
                Locale.setDefault(this.getUserLocale());
                JComponent.setDefaultLocale(this.getUserLocale());
            }
            RepaintManager.setCurrentManager(this.getRepaintManager());
            if (waitForApp) {
                String preloadWaitForComponent = this.getProps().getProperty("router.preloadWaitForComponent", "");
                Object object = thread.getFlag();
                synchronized (object) {
                    block28: {
                        thread.runMethod(this, this, "doRun");
                        if (preloadWaitForComponent.length() == 0) {
                            int waitStep = 10000;
                            try {
                                boolean windowPresent;
                                int waitingCount;
                                thread.getFlag().wait(waitingCount);
                                boolean bl = windowPresent = !this.getUIManager().getTopWindows().isEmpty();
                                for (waitingCount = 5000; thread.isRunning() && !windowPresent && waitingCount < this.requestTimeout * 2; waitingCount += waitStep) {
                                    TraceMgr.trace((Object)this, "Waiting for window... [" + waitingCount / 1000 + "] sec.", 6);
                                    thread.getFlag().wait(waitStep);
                                    windowPresent = !this.getUIManager().getTopWindows().isEmpty();
                                }
                                if (!windowPresent && thread.isRunning() && !thread.isBlocked()) {
                                    throw new AjaxSwingException("Critical error, initialization timed out after " + this.requestTimeout * 2 / 1000 + " seconds. Check your application code for deadlocks and race conditions or switch to stand alone emulation mode.");
                                }
                            }
                            catch (InterruptedException exception) {
                                if (TraceMgr.getCutoffLevel() == 1) {
                                    TraceMgr.trace(this.appName + " initialization interrupted", 1);
                                    break block28;
                                }
                                TraceMgr.trace(this.appName + " initialization interrupted", exception, 6);
                            }
                        } else {
                            int tryCount;
                            Class<?> preloadWaitForComponentType = Class.forName(preloadWaitForComponent);
                            for (tryCount = 20; tryCount > 0; --tryCount) {
                                thread.getFlag().wait(5000L);
                                try {
                                    Window w = this.uiManager.getWindowInFocus();
                                    Component comp = this.getComponentFromTree(w, preloadWaitForComponentType);
                                    if (comp == null) continue;
                                    break;
                                }
                                catch (AjaxSwingException ajaxSwingException) {
                                    // empty catch block
                                }
                            }
                            if (tryCount == 0) {
                                throw new AjaxSwingException("Critical error, initialization timed out after 100 seconds waiting for " + preloadWaitForComponent + ". Check your application code for deadlocks and race conditions or switch to stand alone emulation mode.");
                            }
                        }
                    }
                }
            }
            thread.runMethod(this, this, "doRun");
            if (this.exception != null) {
                throw this.exception;
            }
            Object object = this.getOperationLock();
            synchronized (object) {
                if (this.isOperationActive()) {
                    TraceMgr.trace((Object)this, "Waiting for client operation...", 6);
                    this.getOperationLock().wait(this.requestTimeout);
                    if (this.isOperationActive()) {
                        throw new AjaxSwingException("Critical error, operation timed out after " + this.requestTimeout * 2 / 1000 + " seconds. Check your application code for deadlocks and race conditions or switch to stand alone emulation mode.");
                    }
                }
            }
            if (this.exception != null) {
                throw this.exception;
            }
            TraceMgr.trace((Object)this, "Initialization of client complete", 1);
        } else {
            if (this.getHTMLPage() == null) {
                TraceMgr.trace((Object)this, "WARNING: HTMLPage object not initialized", 6);
                Thread.sleep(1000L);
            }
            if (this.getHTMLPage() != null) {
                this.getHTMLPage().reset(false);
            }
        }
    }

    private Component getComponentFromTree(Container c, Class type) {
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component comp2;
            Component comp = c.getComponent(i);
            if (type.isInstance(comp)) {
                return comp;
            }
            if (!(comp instanceof Container) || (comp2 = this.getComponentFromTree((Container)comp, type)) == null) continue;
            return comp2;
        }
        return null;
    }

    public AjaxSwingRepaintManager getRepaintManager() {
        return this.repaintManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() {
        try {
            TraceMgr.trace((Object)this, "doRun", 6);
            ClientAgent.installExitTrap();
            ClientAgent clientAgent = this;
            synchronized (clientAgent) {
                if (this.eventQueue == null) {
                    System.out.println("EventQueue initialized ");
                    this.eventQueue = new AjaxSwingEventQueue(this);
                    AWTHelper.initDispatchThread((EventQueue)this.eventQueue);
                }
                if (this.schedulingEventQueue == null) {
                    this.schedulingEventQueue = new SchedulingEventQueue();
                    Toolkit.getDefaultToolkit().getSystemEventQueue().push(this.schedulingEventQueue);
                }
            }
            SafeAWTHelper.setPrimeThread(this.getEventQueue(), this.getAjaxSwingThreadGroup().getPrimeThread());
            ClientAgentManager.setMyAgent(SafeAWTHelper.getDispatchThread(this.eventQueue), this);
            TraceMgr.trace(this, "Loading start class " + this.startClassName);
            Class<?> startupClass = null;
            startupClass = this.getClassLoader() != null ? this.getClassLoader().loadClass(this.startClassName) : Class.forName(this.startClassName);
            if (!this.getProps().getBooleanProperty("agent.allowLFChange", true) && !AjaxSwingUIManager.LFInstalled) {
                this.getUIManager().installLFTrap();
            }
            if (initLock != null) {
                Object object = initLock;
                synchronized (object) {
                    initLock = null;
                    this.loadAndRun(startupClass);
                }
            } else {
                this.loadAndRun(startupClass);
            }
            this.waitTillEventQueueIsEmpty();
        }
        catch (Throwable x) {
            TraceMgr.trace((Object)this, TraceMgr.getExceptionText("Failed to load and run class " + this.startClassName, x), 1);
            this.setException(x);
        }
    }

    protected void loadAndRun(Class startupClass) throws Exception {
        try {
            boolean emulate = true;
            if (emulate) {
                this.markThreadCount();
                Class[] paramTypes = new Class[]{this.cmdArgs.getClass()};
                Method main = startupClass.getMethod("main", paramTypes);
                RepaintManager.setCurrentManager(this.getRepaintManager());
                boolean runAsApplet = this.getProps().getBooleanProperty("agent.runAsApplet", false);
                if (runAsApplet && Applet.class.isAssignableFrom(startupClass)) {
                    this.doRunApplet(startupClass);
                } else {
                    UIManager.put("swing.boldMetal", Boolean.FALSE);
                    TraceMgr.trace(this, "Invoking main function with parameters...");
                    this.getSession().put("clientAgent.mainInvoke", Boolean.TRUE);
                    main.invoke(null, new Object[]{this.cmdArgs});
                    this.getSession().put("clientAgent.mainInvoke", Boolean.FALSE);
                    TraceMgr.trace(this, "Main finished");
                }
            }
        }
        catch (IllegalAccessException x1) {
            throw new AjaxSwingException("Application error, class " + startupClass.getName() + " is not accessible (make sure it is declared public)", x1);
        }
        catch (NoSuchMethodException x1) {
            if (Applet.class.isAssignableFrom(startupClass)) {
                this.doRunApplet(startupClass);
            }
            throw new AjaxSwingException("Invalid startup class " + this.startClassName + ", it should either have a main function or be an applet", x1);
        }
    }

    protected void doRunApplet(Class startupClass) throws Exception {
        TraceMgr.trace(this, "doRunApplet");
        this.applet = (Applet)startupClass.newInstance();
        this.applet.setStub(AjaxSwingAppletStub.getInstance());
        AjaxSwingAppletFrame frame = new AjaxSwingAppletFrame(this, this.applet);
        frame.setVisible(true);
        this.applet.init();
        this.applet.start();
    }

    public AbstractDocument getHTMLPage() {
        return this.page;
    }

    public AbstractDocument getHTMLPageWait() {
        if (this.getHTMLPage() == null) {
            TraceMgr.trace((Object)this, "WARNING: HTMLPage object not initialized", 6);
            for (int i = 0; i < 25; ++i) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.getHTMLPage() != null) break;
            }
        }
        return this.page;
    }

    public void setHTMLPage(AbstractDocument page) throws Exception {
        this.page = page;
        page.setClientAgent(this);
    }

    protected static String[] getCmdLineParams(String cmdLine) {
        if (cmdLine == null) {
            return new String[0];
        }
        ArrayList<String> params = new ArrayList<String>(3);
        int mode = TRIM;
        int paramBegin = 0;
        for (int i = 0; i < cmdLine.length(); ++i) {
            if (cmdLine.charAt(i) == ' ' || cmdLine.charAt(i) == '\t') {
                if (mode == TRIM) {
                    paramBegin = i;
                    continue;
                }
                if (mode != PARAM) continue;
                params.add(cmdLine.substring(paramBegin, i));
                mode = TRIM;
                continue;
            }
            if (cmdLine.charAt(i) == '\"') {
                if (mode == TRIM) {
                    mode = QUOTED_PARAM;
                    paramBegin = i + 1;
                    continue;
                }
                if (mode != QUOTED_PARAM || i + 1 != cmdLine.length() && cmdLine.charAt(i + 1) != ' ') continue;
                params.add(cmdLine.substring(paramBegin, i));
                mode = TRIM;
                continue;
            }
            if (mode != TRIM) continue;
            mode = PARAM;
            paramBegin = i;
        }
        if (mode != TRIM) {
            params.add(cmdLine.substring(paramBegin));
        }
        String[] ret = new String[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            ret[i] = (String)params.get(i);
        }
        return ret;
    }

    public boolean isRunning() {
        return this.running;
    }

    public AjaxSwingUIManager getUIManager() {
        return this.uiManager;
    }

    public SchedulingEventQueue getSchedulingEventQueue() {
        return this.schedulingEventQueue;
    }

    public static ClientAgent getCurrentInstance() {
        ThreadGroup[] groups;
        ThreadGroup group;
        Thread thread = Thread.currentThread();
        ClientAgent agent = ClientAgentManager.getMyAgent(thread);
        if (agent != null) {
            return agent;
        }
        for (group = thread.getThreadGroup(); group != null && !(group instanceof AjaxSwingThreadGroup); group = group.getParent()) {
        }
        if (group != null) {
            return ((AjaxSwingThreadGroup)group).getClientAgent();
        }
        EventQueue queue = SafeAWTHelper.getEventQueue(thread);
        if (queue instanceof AjaxSwingEventQueue) {
            return ((AjaxSwingEventQueue)queue).getClientAgent();
        }
        group = thread.getThreadGroup();
        if (group != null && (groups = LangHelper.getThreadGroups(group)) != null) {
            for (int i = 0; i < groups.length; ++i) {
                if (!(groups[i] instanceof AjaxSwingThreadGroup)) continue;
                return ((AjaxSwingThreadGroup)groups[i]).getClientAgent();
            }
        }
        Integer key = new Integer(thread.hashCode());
        if (TraceMgr.getTraceLevel(ClientAgent.class) >= 10 && !failedThreads.containsKey(key)) {
            failedThreads.put(key, key);
            TraceMgr.trace("Failed to find current instance of client agent, Thread = " + thread, 3);
            TraceMgr.trace("  Group =  " + thread.getThreadGroup(), 3);
            TraceMgr.trace("  Thread class = " + thread.getClass().getCanonicalName(), new RuntimeException("Stack trace:"), 3);
            Thread.dumpStack();
            Thread.dumpStack();
        }
        throw new Error("WARNING: unable to find the current instance of client agent. This can be due to multithreading in the GUI application. Consider using ClientAgentManager.setMyAgent()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlockedThread(AjaxSwingThread thread) {
        List list = this.blockedThreads;
        synchronized (list) {
            TraceMgr.trace((Object)this, "Adding blocked thread " + thread + ", size = " + this.blockedThreads.size(), 6);
            this.blockedThreads.add(thread);
            this.isNewWindowShown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBlockedThread(AjaxSwingThread thread) {
        List list = this.blockedThreads;
        synchronized (list) {
            this.blockedThreads.remove(thread);
            TraceMgr.trace((Object)this, "Removed blocked thread " + thread + ", size = " + this.blockedThreads.size(), 6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForBlockedThreads(Object[] blockedThreads) throws Throwable {
        TraceMgr.trace((Object)this, "waitForBlockedThreads, size = " + blockedThreads.length, 6);
        for (int i = 0; i < blockedThreads.length; ++i) {
            AjaxSwingThread thread = (AjaxSwingThread)blockedThreads[i];
            Object object = thread.getFlag();
            synchronized (object) {
                if (thread.isRunning() && !thread.isBlocked()) {
                    TraceMgr.trace(this, "Found running blocked thread, waiting for = " + thread);
                    thread.getFlag().wait(this.requestTimeout);
                }
            }
            if (thread.isRunning() && !thread.isBlocked()) {
                TraceMgr.trace("WARNING: Timed out while waiting for a blocked thread. If the application is not functioning as expected, increase the agent.requestTimeout value or  simplify multi-threading in the application");
            }
            if (this.getException() == null) continue;
            throw this.getException();
        }
    }

    public boolean isRequestActive() {
        return this.requestActive;
    }

    public boolean isOperationActive() {
        return this.operationCounter > 0;
    }

    public boolean isApplet() {
        return this.applet != null;
    }

    public Object getOperationLock() {
        return this.operationLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginOperation() {
        TraceMgr.trace((Object)this, "beginOperation", 4);
        Object object = this.getOperationLock();
        synchronized (object) {
            ++this.operationCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endOperation() {
        this.endOperationOnModalDialog = false;
        TraceMgr.trace((Object)this, "endOperation", 4);
        Object object = this.getOperationLock();
        synchronized (object) {
            if (this.operationCounter > 0) {
                --this.operationCounter;
            }
            if (this.operationCounter == 0) {
                TraceMgr.trace(this, "endOperation - notifying");
                this.getOperationLock().notify();
            }
        }
    }

    public void endOperation(boolean endsOnModalDialog) {
        if (endsOnModalDialog) {
            TraceMgr.trace((Object)this, "endOperation on modal dialog", 4);
            this.endOperationOnModalDialog = true;
        } else {
            this.endOperation();
        }
    }

    public boolean getEndOperationOnModalDialog() {
        return this.endOperationOnModalDialog;
    }

    public AbstractDocumentRenderer getPageRenderer() {
        return this.pageRenderer;
    }

    public WindowUpdater getWindowUpdater() {
        return this.windowUpdater;
    }

    @Override
    public AjaxSwingProperties getProps() {
        return this.props;
    }

    public AgentInitData getInitData() {
        return this.initData;
    }

    @Override
    public List getTempFiles() {
        return this.tempFiles;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public static boolean isToolkitInstalled() {
        return toolkitInstalled;
    }

    public static boolean isGraphicsEnvironmentPropertiesInstalled() {
        return graphicsEnvironmentPropertiesInstalled;
    }

    public static synchronized void installGraphicsEnvironmentProperties(AjaxSwingProperties props, Object traceObject) {
        if (!graphicsEnvironmentPropertiesInstalled) {
            TraceMgr.trace("Installing graphicsEnvironmentProperties Installing...", 5);
            String defaultToolkit = System.getProperty("awt.toolkit", "sun.awt.motif.MToolkit");
            TraceMgr.trace("os.name = " + System.getProperty("os.name"), 3);
            TraceMgr.trace("os.version = " + System.getProperty("os.version"), 3);
            TraceMgr.trace("java.version = " + System.getProperty("java.version"), 3);
            TraceMgr.trace("ajaxswing.version = " + VersionHelper.getAjaxSwingVersion());
            VersionHelper.init(true);
            TraceMgr.trace("ajaxswing.version.jdk = " + VersionHelper.SUPPORTED_JDK_VERSION);
            TraceMgr.trace("java.awt.graphicsenv = " + System.getProperty("java.awt.graphicsenv"), 3);
            if (props.getBooleanProperty("agent.usePlatformGraphicsEnvironment", false)) {
                if (traceObject != null) {
                    TraceMgr.trace(traceObject, "Using platform graphics environment");
                } else {
                    TraceMgr.trace("Using platform graphics environment");
                }
            } else {
                System.setProperty("java.awt.graphicsenv", AjaxSwingGraphicsEnvironment.getClassName());
            }
            if (GraphicsEnvironment.isHeadless()) {
                System.setProperty("java.awt.graphicsenv", AjaxSwingHeadlessGraphicsEnvironment.getClassName());
            }
            System.setProperty("awt.nativeDoubleBuffering", "true");
            System.setProperty("swing.volatileImageBufferEnabled", "false");
            TraceMgr.trace("awt.toolkit = " + defaultToolkit, 3);
            AjaxSwingToolkit.setDelegateToolkitClassName(defaultToolkit);
            String toolkitClassName = VersionHelper.getToolkitClassName();
            TraceMgr.trace("AjaxSwing Toolkit Class name = " + toolkitClassName, 3);
            if (toolkitClassName == null) {
                throw new Error("AjaxSwing initialization error, unable to determine toolkit class");
            }
            System.setProperty("awt.toolkit", toolkitClassName);
            Field headlessField = null;
            if (!System.getProperty("os.name").toLowerCase().contains("windows")) {
                TraceMgr.trace("for headless unix environments ensure xvfb is running", 2);
            }
            if (GraphicsEnvironment.isHeadless()) {
                TraceMgr.trace("Headless Environment detected", 3);
                try {
                    headlessField = Window.class.getDeclaredField("beforeFirstWindowShown");
                    headlessField.setAccessible(true);
                    ((AtomicBoolean)headlessField.get(null)).getAndSet(false);
                }
                catch (Exception e) {
                    TraceMgr.trace("Override beforeFirstWindowShown for Window failed", e, 5);
                }
            }
            if (!Toolkit.getDefaultToolkit().getClass().getName().equals(toolkitClassName)) {
                throw new Error("AjaxSwing initialization error, toolkit class already defined as " + Toolkit.getDefaultToolkit().getClass().getName() + ". Add -Dawt.toolkit=" + toolkitClassName + " command switch for java");
            }
            graphicsEnvironmentPropertiesInstalled = true;
            TraceMgr.trace("Installed graphicsEnvironmentProperties", 5);
        }
    }

    public synchronized void installToolkit() {
        if (!toolkitInstalled) {
            TraceMgr.trace("Installing toolkit...", 5);
            ClientAgent.installGraphicsEnvironmentProperties(this.getProps(), this);
            AppProperties licenseProps = AjaxSwingSecurityManager.initLicense(true);
            LicenseManager.initInstance(licenseProps);
            this.repaintManager = new AjaxSwingRepaintManager(this);
            toolkitInstalled = true;
            TraceMgr.trace("Installed toolkit", 5);
        }
    }

    public static void installExitTrap() {
        try {
            if (!(System.getSecurityManager() instanceof AjaxSwingSecurityManager)) {
                int sleepTime = AjaxSwingPropertiesManager.getInstance().getAppProperties("default").getIntProperty("router.preloadAppSleepTime", 2);
                Thread.currentThread();
                Thread.sleep(sleepTime * 1000);
                AjaxSwingSecurityManager sm = new AjaxSwingSecurityManager();
                System.setSecurityManager(sm);
            }
        }
        catch (Throwable x) {
            TraceMgr.trace("*** WARNING: Failed to install a security manager. Calling System.exit() froma client code may shut down JVM. Consider using stand alone emulation mode for AjaxSwing", x);
        }
    }

    public Throwable getException() {
        return this.exception;
    }

    public HttpRequestData getRequestData() {
        return this.requestData;
    }

    public void setRequestData(HttpRequestData data) {
        this.requestData = data;
    }

    public HttpResponseData getResponseData() {
        return this.responseData;
    }

    public void setResponseData(HttpResponseData httpResponseData) {
        this.responseData = httpResponseData;
    }

    public AgentRequestFilter getRequestFilter() {
        return this.requestFilter;
    }

    protected void cleanupTempFiles() {
        for (int i = 0; i < this.getTempFiles().size(); ++i) {
            File parent;
            String fileName = (String)this.getTempFiles().get(i);
            File file = new File(fileName);
            if (!file.exists() || !ClientAgent.shouldDeleteTempFile(file)) continue;
            TraceMgr.trace((Object)this, "Removing temporay file " + fileName, 6);
            if (!file.delete()) {
                TraceMgr.trace(this, "Failed to remove temporary file " + fileName);
            }
            if (!String.valueOf(this.getClientId()).equals(file.getParentFile().getName()) || !(parent = file.getParentFile()).isDirectory() || parent.list().length != 0) continue;
            parent.delete();
        }
    }

    public AjaxSwingThreadGroup getAjaxSwingThreadGroup() {
        return this.threadGroup;
    }

    public void setException(Throwable x) {
        InvocationTargetException invX;
        if (x instanceof InvocationTargetException && (invX = (InvocationTargetException)x).getTargetException() != null) {
            x = invX.getTargetException();
        }
        this.exception = x;
    }

    public HashMap getSession() {
        return this.session;
    }

    public String getAppName() {
        return this.appName;
    }

    public int getClientId() {
        return this.initData.clientId;
    }

    public Dimension getMaximumWindowSize(Window window) {
        if (this.getInitData() == null) {
            return Toolkit.getDefaultToolkit().getScreenSize();
        }
        int width = this.getInitData().clientWidth;
        int height = this.getInitData().clientHeight;
        boolean undecorated = false;
        JRootPane pane = SwingUtilities.getRootPane(window);
        if (window instanceof Frame && ((Frame)window).isUndecorated()) {
            undecorated = true;
        }
        if (pane != null) {
            undecorated = pane.getWindowDecorationStyle() == 0;
        }
        if (!undecorated) {
            height -= 24;
            width -= 4;
            height -= 4;
        }
        return new Dimension(width, height);
    }

    public String getWindowProperty(String windowTitle, String key) {
        String value;
        windowTitle = NameUtils.titleToKey(windowTitle);
        StringBuffer buffer = new StringBuffer(windowTitle.length() + 30);
        buffer.append("window.*.");
        buffer.append(key);
        String completeKey = buffer.toString();
        String property = buffer.toString();
        if (TraceMgr.getCutoffLevel() >= 9) {
            TraceMgr.trace((Object)this, "Checking configuration for property " + property, 9);
        }
        if ((value = (String)this.getProps().get(property)) != null) {
            value.trim();
        } else {
            buffer.delete(0, buffer.length());
            buffer.append(windowTitle);
            buffer.append(".");
            buffer.append(key);
            completeKey = buffer.toString();
            value = (String)this.getProps().get(completeKey);
            if (value != null) {
                value.trim();
            }
        }
        return value;
    }

    public int getWindowProperty(String windowTitle, String key, int defaultValue) {
        String value = this.getWindowProperty(windowTitle, key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    public String getComponentProperty(Object component, String property) {
        return this.getProps().getComponentProperty(component, property);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public boolean shouldUpdateBrowser() {
        return this.updateBrowser;
    }

    public void setUpdateBrowser(boolean updateBrowser) {
        TraceMgr.trace(this, "setUpdateBrowser: " + updateBrowser);
        this.updateBrowser = updateBrowser;
    }

    public int getUpdateBrowserInterval() {
        return this.updateBrowserInterval;
    }

    public void setUpdateBrowserInterval(int newUpdateInterval) {
        int sessionPingInterval = this.getProps().getSessionPingSeconds();
        if (newUpdateInterval == 0 && sessionPingInterval != 0) {
            newUpdateInterval = sessionPingInterval;
        }
        this.updateBrowserInterval = newUpdateInterval;
        TraceMgr.trace((Object)this, "Set update interval to " + this.updateBrowserInterval, 6);
    }

    @Override
    public boolean isDownloadAllowed(String downloadFileName) throws RemoteException {
        return this.getSession().get("download." + downloadFileName) != null;
    }

    public void allowDownload(String downloadFileName) {
        if (!this.getSession().containsValue(downloadFileName)) {
            this.getSession().put("download." + downloadFileName, downloadFileName);
        }
    }

    @Override
    public void denyDownload(String downloadFileName) {
        if (this.getSession() != null && this.getSession().containsKey(downloadFileName)) {
            this.getSession().remove("download." + downloadFileName);
        }
    }

    @Override
    public void denyDownload(File file) {
        String downloadFileName = this.getShortFileName(file.getAbsolutePath());
        this.denyDownload(downloadFileName);
    }

    public String getShortFileName(String downloadFileName) {
        int lastSeparator = downloadFileName.lastIndexOf(File.separator);
        int clientId = downloadFileName.lastIndexOf(File.separator + this.getClientId() + File.separator);
        int n = lastSeparator = clientId == -1 ? lastSeparator : clientId;
        if (lastSeparator != -1) {
            downloadFileName = downloadFileName.substring(lastSeparator + 1);
        }
        return downloadFileName;
    }

    public void print(byte[] pdfFile) {
        Random r = new Random();
        String name = String.valueOf(r.nextInt(32000)) + ".pdf";
        String fileName = this.getInitData().getTempDirPath() + name;
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            fos.write(pdfFile);
            fos.flush();
            fos.close();
            this.getTempFiles().add(fileName);
            StringBuffer buffer = new StringBuffer(100);
            buffer.append("\nprintPdf(\"");
            buffer.append(name);
            buffer.append("\");\n");
            this.scriptToAppend = buffer.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getAppendJavaScript() {
        return this.scriptToAppend;
    }

    public void clearAppendJavaScript() {
        this.scriptToAppend = null;
    }

    public void appendJavaScript(String javaScript) {
        this.scriptToAppend = this.scriptToAppend == null ? javaScript : this.scriptToAppend + "\n" + javaScript;
    }

    @Override
    public void setSessionTimeout(long seconds) {
        this.sessionTimeout = seconds;
    }

    @Override
    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void addURLParamHandler(URLParameterHandler handler, String paramKey) {
        Object handlers = this.paramsHandlers.get(paramKey);
        if (handlers == null) {
            handlers = new ArrayList();
        }
        ((ArrayList)handlers).add(handler);
        this.paramsHandlers.put(paramKey, handlers);
    }

    public void removeURLParamHandler(URLParameterHandler handler, String paramKey) {
        Object handlers = this.paramsHandlers.get(paramKey);
        if (handlers == null) {
            return;
        }
        ((ArrayList)handlers).remove(handler);
        if (handlers != null && ((ArrayList)handlers).size() == 0) {
            this.paramsHandlers.put(paramKey, handlers);
        } else {
            this.paramsHandlers.put(paramKey, handlers);
        }
    }

    public void addKeepAliveEventHandler(KeepAliveEventHandler handler) {
        if (this.keepAliveEventHandlers == null) {
            this.keepAliveEventHandlers = new ArrayList<KeepAliveEventHandler>();
        }
        this.keepAliveEventHandlers.add(handler);
    }

    public void removeKeepAliveEventHandler(KeepAliveEventHandler handler) {
        if (this.keepAliveEventHandlers != null) {
            this.keepAliveEventHandlers.remove(handler);
        }
    }

    public KeepAliveEvent getLastKeepAliveEvent() {
        return this.lastKeepAliveEvent;
    }

    public void addFastSubmitHandler(FastSubmitHandler handler, String paramKey) {
        Object handlers = this.fastSubmitHandlers.get(paramKey);
        if (handlers == null) {
            handlers = new ArrayList();
        }
        if (!((ArrayList)handlers).contains(handler)) {
            ((ArrayList)handlers).add(handler);
        }
        this.fastSubmitHandlers.put(paramKey, handlers);
    }

    public void removeFastSubmitHandler(FastSubmitHandler handler, String paramKey) {
        Object handlers = this.fastSubmitHandlers.get(paramKey);
        if (handlers == null) {
            return;
        }
        ((ArrayList)handlers).remove(handler);
        if (handlers != null && ((ArrayList)handlers).size() == 0) {
            this.fastSubmitHandlers.put(paramKey, handlers);
        } else {
            this.fastSubmitHandlers.put(paramKey, handlers);
        }
    }

    protected void markThreadCount() {
        this.markedThreadCount = LangHelper.getThreadCount(this.threadGroup);
        if (TraceMgr.getCutoffLevel() >= 5) {
            TraceMgr.trace(this, "Marked thread count = " + this.markedThreadCount);
        }
    }

    public void monitorAsynchronousUpdates() {
        int duration = this.getProps().getIntProperty("agent.monitorAsynchronousUpdates.duration", 0);
        if (duration > 0) {
            int interval = this.getProps().getIntProperty("agent.monitorAsynchronousUpdates.interval", 2);
            this.monitorAsynchronousUpdates(duration, interval);
        }
    }

    public void monitorAsynchronousUpdates(int duration, int interval) {
        if (TraceMgr.getCutoffLevel() >= 4) {
            TraceMgr.trace((Object)this, "Scheduling update checks for duration " + duration + " with interval " + interval, 4);
        }
        int updateChecks = duration / interval + 1;
        if (this.updateBrowserChecks == 0) {
            this.savedUpdateBrowserInterval = this.updateBrowserInterval;
        }
        this.setUpdateBrowserInterval(interval);
        this.updateBrowserChecks = updateChecks;
    }

    public void checkAndMonitorAsynchronousUpdates() {
        int currentThreadCount = LangHelper.getThreadCount(this.threadGroup);
        if (TraceMgr.getCutoffLevel() >= 5) {
            TraceMgr.trace(this, "Marked thread count = " + this.markedThreadCount + ", current count = " + currentThreadCount);
        }
        if (currentThreadCount != this.markedThreadCount) {
            this.monitorAsynchronousUpdates();
        }
    }

    public int getTimeZoneCurrentOffset() {
        if (this.initData == null) {
            return TimeZone.getDefault().getOffset(new Date().getTime());
        }
        return this.initData.gmtOffest;
    }

    public int getTimeZoneRawOffset() {
        if (this.initData == null) {
            return TimeZone.getDefault().getRawOffset() / 1000 / 60;
        }
        return this.initData.gmtTimeZone.getRawOffset() / 1000 / 60;
    }

    public boolean getTimeZoneUseDaylight() {
        if (this.initData == null) {
            return TimeZone.getDefault().useDaylightTime();
        }
        return this.initData.gmtHasDaylight;
    }

    public TimeZone getTimeZone() {
        if (this.initData == null) {
            return TimeZone.getDefault();
        }
        return this.initData.gmtTimeZone == null ? TimeZone.getDefault() : this.initData.gmtTimeZone;
    }

    @Override
    public String getExitPage() {
        return this.exitPage;
    }

    @Override
    public void setExitPage(String pageName) {
        this.exitPage = pageName;
    }

    @Override
    public Locale getUserLocale() {
        return this.currentLocale;
    }

    @Override
    public void setUserLocale(Locale currentLocale) {
        this.currentLocale = currentLocale;
    }

    @Override
    public String getBrowserLocale() {
        return this.browserLocale;
    }

    @Override
    public void setBrowserLocale(String browserLocale) {
        this.browserLocale = browserLocale;
    }

    private static boolean shouldDeleteTempFile(File file) {
        try {
            AjaxSwingProperties props = AjaxSwingPropertiesManager.getInstance().getAppProperties("default");
            if ("afterTime".equals(props.getProperty("agent.cleanupTempFiles", "session"))) {
                long startFromSize = props.getIntProperty("agent.cleanupTempFiles.smallerThan", 1024);
                if (file.length() < (startFromSize *= 1024L)) {
                    return true;
                }
                long timeToDelete = props.getIntProperty("agent.cleanupTempFiles.afterTime", 24);
                timeToDelete = timeToDelete * 1000L * 60L * 60L;
                return new Date().getTime() - file.lastModified() >= timeToDelete;
            }
            return true;
        }
        catch (Exception ex) {
            TraceMgr.trace("Error in shouldDeleteTempFile", ex);
            return false;
        }
    }

    public void setFocusChangeAllowed(boolean allowed) {
        this.focusChangeAllowed = allowed;
    }

    public boolean isFocusChangeAllowed(Component component) {
        return this.focusChangeAllowed;
    }

    @Override
    public String getCsrfToken() {
        return this.csrfToken;
    }

    public KeyboardFocusManager getFocusManager() {
        return this.agentFocusManager;
    }

    public void setFocusManager(KeyboardFocusManager focusManager) {
        this.agentFocusManager = focusManager;
    }

    public MenuSelectionManager getMenuSelectionManager() {
        return this.menuSelectionManager;
    }

    public void addDownloadFileName(String filename) {
        this.downloadFileNames.put(filename, System.currentTimeMillis());
    }

    @Override
    public void removeDownloadFileName(String filename) {
        if (this.downloadFileNames != null && this.downloadFileNames.containsKey(filename)) {
            this.downloadFileNames.remove(filename);
        }
    }

    public Map getDownloadFileNames() {
        return this.downloadFileNames;
    }

    public String getUrlForOpenInNewTab() {
        return this.urlForOpenInNewTab;
    }

    public void openInNewTab(String urlForOpenInNewTab) {
        this.urlForOpenInNewTab = urlForOpenInNewTab;
    }

    public void clearUrlForOpenInNewTab() {
        this.urlForOpenInNewTab = null;
    }

    public Object getMouseGrabber() {
        return this.mouseGrabber;
    }

    public void setMouseGrabber(Object mouseGrabber) {
        this.mouseGrabber = mouseGrabber;
    }

    @Override
    public void setFontCalibrationData(String allCalibrationData) {
        String coef;
        String fontSize;
        String fontName;
        String[] data;
        String[] fontCalibrationData = allCalibrationData.split("::");
        for (String font : fontCalibrationData[0].split(";")) {
            data = font.split(",");
            fontName = data[0];
            fontSize = data[1];
            coef = data[2];
            if (!this.calibrationCoefs.containsKey(fontName)) {
                this.calibrationCoefs.put(fontName, new HashMap());
            }
            this.calibrationCoefs.get(fontName).put(fontSize, coef);
        }
        for (String font : fontCalibrationData[1].split(";")) {
            data = font.split(",");
            fontName = data[0];
            fontSize = data[1];
            coef = data[2];
            if (!this.calibrationCoefsCapital.containsKey(fontName)) {
                this.calibrationCoefsCapital.put(fontName, new HashMap());
            }
            this.calibrationCoefsCapital.get(fontName).put(fontSize, coef);
        }
    }

    @Override
    public double getFontCalibrationData(String fontName, int fontSize, boolean isCapital) {
        String coef;
        Map<String, Map<String, String>> coefs;
        fontName = fontName.toLowerCase().replace(" ", "");
        Map<String, Map<String, String>> map = coefs = isCapital ? this.calibrationCoefsCapital : this.calibrationCoefs;
        if (coefs.containsKey(fontName) && (coef = coefs.get(fontName).get(String.valueOf(fontSize))) != null && coef.length() > 0 && coef.trim().length() > 0) {
            return Double.valueOf(coef);
        }
        return 1.0;
    }

    static {
        failedThreads = new HashMap();
        initLock = new InitLock();
        TRIM = 0;
        PARAM = 1;
        QUOTED_PARAM = 2;
    }

    public static class InitLock {
    }

    public static class OperationLock {
    }

    public static class RequestLock {
    }
}

