/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.core;

import com.creamtec.ajaxswing.core.AjaxSwingThread;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.ClientAgentManager;
import com.creamtec.core.TraceMgr;
import java.util.Stack;

public class AjaxSwingThreadGroup
extends ThreadGroup {
    private ClientAgent clientAgent;
    private static int instances = 0;
    private AjaxSwingThread primeThread;
    private Stack threads = new Stack();

    public AjaxSwingThreadGroup(ClientAgent agent) {
        super("AjaxSwingThreadGroup" + ++instances);
        this.setClientAgent(agent);
    }

    public ClientAgent getClientAgent() {
        return this.clientAgent;
    }

    public void setClientAgent(ClientAgent agent) {
        this.clientAgent = agent;
    }

    public AjaxSwingThread getPrimeThread() {
        return this.primeThread;
    }

    public void setPrimeThread(AjaxSwingThread thread) {
        if (TraceMgr.getCutoffLevel() >= 6) {
            TraceMgr.trace(this, "setPrimeThread to " + thread);
        }
        this.primeThread = thread;
    }

    public synchronized AjaxSwingThread allocateThread() {
        AjaxSwingThread thread = null;
        thread = !this.threads.empty() ? (AjaxSwingThread)this.threads.pop() : new AjaxSwingThread(this);
        return thread;
    }

    public synchronized void releaseThread(Thread thread) {
        this.threads.push(thread);
    }

    public void shutdown() {
        TraceMgr.trace(this, "Shutting down, threads in stack = " + this.threads.size());
        while (!this.threads.empty()) {
            AjaxSwingThread thread = (AjaxSwingThread)this.threads.pop();
            ClientAgentManager.clearMyAgent(thread);
            thread.resetData();
            thread.shutdown();
        }
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception x) {
            TraceMgr.trace((Object)this, "Unexpected interrupt", (Throwable)x);
        }
        this.clientAgent = null;
        this.primeThread = null;
        this.stop();
    }
}

