/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.core;

import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.ajaxswing.core.AjaxSwingThreadGroup;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.HttpRequestData;
import com.creamtec.ajaxswing.core.SafeAWTHelper;
import com.creamtec.ajaxswing.rendering.AbstractDocument;
import com.creamtec.core.TraceMgr;
import java.lang.reflect.Method;
import javax.swing.RepaintManager;

public class AjaxSwingThread
extends Thread {
    private int blockedCount = 0;
    private boolean running = false;
    private Object flag = new ThreadFlag();
    private int operation;
    private String methodName;
    private Object object;
    private AbstractDocument page;
    private HttpRequestData requestData;
    private boolean keepRunning = true;
    public static final int VOID_METHOD_VOID = 0;
    public static final int EMULATE_REQUEST = 1;

    public AjaxSwingThread(AjaxSwingThreadGroup group) {
        super((ThreadGroup)group, (Runnable)null);
        TraceMgr.trace(this, "constructor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.keepRunning) {
            AjaxSwingThread oldPrimeThread = this.getAjaxSwingThreadGroup().getPrimeThread();
            ClassLoader oldContextClassLoader = null;
            try {
                this.getAjaxSwingThreadGroup().setPrimeThread(this);
                ClassLoader agentClassLoader = this.getAjaxSwingThreadGroup().getClientAgent().getClassLoader();
                if (agentClassLoader != null) {
                    this.setContextClassLoader(agentClassLoader);
                }
                if (this.getClientAgent().getEventQueue() != null) {
                    SafeAWTHelper.setPrimeThread(this.getClientAgent().getEventQueue(), this);
                    if (agentClassLoader != null) {
                        oldContextClassLoader = SafeAWTHelper.getDispatchThread(this.getClientAgent().getEventQueue()).getContextClassLoader();
                        SafeAWTHelper.getDispatchThread(this.getClientAgent().getEventQueue()).setContextClassLoader(agentClassLoader);
                    }
                }
                RepaintManager.setCurrentManager(this.getClientAgent().getRepaintManager());
                switch (this.operation) {
                    case 0: {
                        this.doVoidMethodVoid();
                    }
                }
                if (oldContextClassLoader != null && this.getClientAgent() != null && this.getClientAgent().getEventQueue() != null) {
                    SafeAWTHelper.getDispatchThread(this.getClientAgent().getEventQueue()).setContextClassLoader(oldContextClassLoader);
                }
            }
            catch (Throwable x) {
                try {
                    if (x instanceof ThreadDeath) {
                        this.raiseFlag();
                        this.keepRunning = false;
                        throw (ThreadDeath)x;
                    }
                    ClientAgent agent = this.getClientAgent();
                    if (agent != null) {
                        agent.setException(x);
                    } else {
                        TraceMgr.trace("Thread chrashed", x);
                    }
                    if (oldContextClassLoader != null && this.getClientAgent() != null && this.getClientAgent().getEventQueue() != null) {
                        SafeAWTHelper.getDispatchThread(this.getClientAgent().getEventQueue()).setContextClassLoader(oldContextClassLoader);
                    }
                }
                catch (Throwable throwable) {
                    if (oldContextClassLoader != null && this.getClientAgent() != null && this.getClientAgent().getEventQueue() != null) {
                        SafeAWTHelper.getDispatchThread(this.getClientAgent().getEventQueue()).setContextClassLoader(oldContextClassLoader);
                    }
                    throw throwable;
                }
            }
            this.getAjaxSwingThreadGroup().setPrimeThread(oldPrimeThread);
            if (this.getClientAgent() != null && this.getClientAgent().getEventQueue() != null) {
                SafeAWTHelper.setPrimeThread(this.getClientAgent().getEventQueue(), oldPrimeThread);
            }
            this.running = false;
            TraceMgr.trace((Object)this, "running = false, raising flag...", 6);
            this.raiseFlag();
            this.getAjaxSwingThreadGroup().releaseThread(this);
            this.resetData();
            if (!this.keepRunning) continue;
            AjaxSwingThread ajaxSwingThread = this;
            synchronized (ajaxSwingThread) {
                try {
                    this.wait();
                    this.running = true;
                    TraceMgr.trace((Object)this, "running = true", 6);
                }
                catch (Exception x) {
                    break;
                }
            }
        }
    }

    public void runMethod(ClientAgent clientAgent, Object object, String methodName) throws Exception {
        if (this.isRunning()) {
            TraceMgr.trace((Object)this, "This thread = " + this.toString() + ", currentThread = " + Thread.currentThread().toString(), 1);
            Thread.currentThread();
            Thread.dumpStack();
            throw new AjaxSwingException("Internal error in runMethod, the thread is already running");
        }
        this.operation = 0;
        this.object = object;
        this.methodName = methodName;
        this.execute();
    }

    public void emulateRequest(AbstractDocument page, HttpRequestData data) throws Exception {
        if (this.isRunning()) {
            TraceMgr.trace((Object)this, "This thread = " + this.toString() + ", currentThread = " + Thread.currentThread().toString(), 1);
            Thread.currentThread();
            Thread.dumpStack();
            throw new AjaxSwingException("Internal error in emulateRequest, the thread is already running");
        }
        TraceMgr.trace(this, "emulateRequest on " + this.getName());
        this.operation = 1;
        this.page = page;
        this.requestData = data;
        this.execute();
    }

    private synchronized void execute() {
        this.running = true;
        if (this.isAlive()) {
            this.notifyAll();
        } else {
            this.start();
        }
    }

    private final void doVoidMethodVoid() throws Exception {
        if (TraceMgr.getCutoffLevel() > 5) {
            TraceMgr.trace((Object)this, "->" + this + " do void method " + this.methodName, 6);
        }
        Method method = this.object.getClass().getMethod(this.methodName, null);
        method.invoke(this.object, null);
        if (TraceMgr.getCutoffLevel() > 5) {
            TraceMgr.trace((Object)this, "<-" + this + " do void finished", 6);
        }
    }

    public void setBlocked(boolean blocked) {
        if (TraceMgr.getCutoffLevel() > 4) {
            TraceMgr.trace(this, "setBlocked = " + blocked + ", this = " + this + ", count = " + this.blockedCount);
        }
        ClientAgent clientAgent = this.getClientAgent();
        if (blocked) {
            ++this.blockedCount;
            if (this.blockedCount == 1 && clientAgent != null) {
                this.getClientAgent().addBlockedThread(this);
            }
            this.raiseFlag();
        } else {
            if (this.blockedCount > 0) {
                --this.blockedCount;
            }
            if (this.blockedCount == 0 && clientAgent != null) {
                this.getClientAgent().removeBlockedThread(this);
            }
        }
        if (TraceMgr.getCutoffLevel() > 4) {
            TraceMgr.trace(this, "setBlocked = " + blocked + " returned");
        }
    }

    public boolean isBlocked() {
        return this.blockedCount > 0;
    }

    public boolean isRunning() {
        return this.running;
    }

    public Object getFlag() {
        return this.flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseFlag() {
        TraceMgr.trace(this, "raiseFlag");
        Object object = this.getFlag();
        synchronized (object) {
            this.getFlag().notifyAll();
        }
        TraceMgr.trace(this, "raiseFlag returned");
    }

    public ClientAgent getClientAgent() {
        return this.getThreadGroup() != null ? ((AjaxSwingThreadGroup)this.getThreadGroup()).getClientAgent() : null;
    }

    public void resetData() {
        this.object = null;
        this.page = null;
        this.requestData = null;
        this.setBlocked(false);
    }

    @Override
    public String toString() {
        return "AjaxSwing" + super.toString();
    }

    public AjaxSwingThreadGroup getAjaxSwingThreadGroup() {
        return (AjaxSwingThreadGroup)super.getThreadGroup();
    }

    public void shutdown() {
        TraceMgr.trace(this, "Shutting down thread " + this.toString());
        this.keepRunning = false;
        this.interrupt();
    }

    public static class ThreadFlag {
    }
}

